/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.usecases.ws.thredds.engine.impl;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.gcube.usecases.ws.thredds.engine.impl.ProcessDescriptor;
import org.gcube.usecases.ws.thredds.engine.impl.ProcessStatus;
import org.gcube.usecases.ws.thredds.engine.impl.WorkspaceFolderManager;
import org.gcube.usecases.ws.thredds.faults.InternalException;
import org.gcube.usecases.ws.thredds.faults.WorkspaceInteractionException;
import org.gcube.usecases.ws.thredds.faults.WorkspaceNotSynchedException;
import org.gcube.usecases.ws.thredds.model.SyncOperationCallBack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Process {
    private static final Logger log = LoggerFactory.getLogger(Process.class);
    private ProcessDescriptor descriptor;
    private ProcessStatus status;
    private String processId = UUID.randomUUID().toString();
    private String folderId;
    private WorkspaceFolderManager manager;
    private List<SyncOperationCallBack> toInvokeCallbacks = new CopyOnWriteArrayList<SyncOperationCallBack>();

    public Process(String folderId) throws WorkspaceInteractionException, InternalException {
        log.debug("Created Process with id {} ", (Object)this.processId);
        this.folderId = folderId;
        this.manager = new WorkspaceFolderManager(folderId);
        this.manager.lock(this.processId);
    }

    public void startProcess() {
    }

    public void addCallBack(SyncOperationCallBack toAddCallback) {
        this.toInvokeCallbacks.add(toAddCallback);
        log.debug("Added callback for process {}. Current callback size is {}", (Object)this.processId, (Object)this.toInvokeCallbacks.size());
    }

    public ProcessDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void onStep() {
    }

    public void cancel() {
    }

    public void cleanup() throws WorkspaceNotSynchedException, WorkspaceInteractionException, InternalException {
        this.manager.unlock(this.processId);
    }

    protected void finalize() throws Throwable {
        try {
            this.cleanup();
        }
        catch (Throwable t) {
            log.warn("Exception while trying to cleanup {} ", (Object)this);
        }
    }
}

