/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.contrib.dualwrites;

import com.google.common.util.concurrent.ListenableFuture;
import com.netflix.astyanax.AstyanaxConfiguration;
import com.netflix.astyanax.ColumnMutation;
import com.netflix.astyanax.Execution;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.SerializerPackage;
import com.netflix.astyanax.connectionpool.ConnectionPool;
import com.netflix.astyanax.connectionpool.Operation;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.TokenRange;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.OperationException;
import com.netflix.astyanax.contrib.dualwrites.DualKeyspaceMetadata;
import com.netflix.astyanax.contrib.dualwrites.DualWritesColumnMutation;
import com.netflix.astyanax.contrib.dualwrites.DualWritesCqlStatement;
import com.netflix.astyanax.contrib.dualwrites.DualWritesMutationBatch;
import com.netflix.astyanax.contrib.dualwrites.DualWritesStrategy;
import com.netflix.astyanax.contrib.dualwrites.DualWritesUpdateListener;
import com.netflix.astyanax.contrib.dualwrites.WriteMetadata;
import com.netflix.astyanax.cql.CqlStatement;
import com.netflix.astyanax.ddl.KeyspaceDefinition;
import com.netflix.astyanax.ddl.SchemaChangeResult;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.partitioner.Partitioner;
import com.netflix.astyanax.query.ColumnFamilyQuery;
import com.netflix.astyanax.retry.RetryPolicy;
import com.netflix.astyanax.serializers.UnknownComparatorException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DualWritesKeyspace
implements Keyspace,
DualWritesUpdateListener {
    private static final Logger Logger = LoggerFactory.getLogger(DualWritesKeyspace.class);
    private final AtomicReference<KeyspacePair> ksPair = new AtomicReference<Object>(null);
    private final AtomicBoolean dualWritesEnabled = new AtomicBoolean(false);
    private final DualWritesStrategy executionStrategy;

    public DualWritesKeyspace(DualKeyspaceMetadata dualKeyspaceSetup, Keyspace primaryKS, Keyspace secondaryKS, DualWritesStrategy execStrategy) {
        this.ksPair.set(new KeyspacePair(dualKeyspaceSetup, primaryKS, secondaryKS));
        this.executionStrategy = execStrategy;
    }

    private Keyspace getPrimaryKS() {
        return this.ksPair.get().getPrimaryKS();
    }

    public DualKeyspaceMetadata getDualKeyspaceMetadata() {
        return this.ksPair.get().getDualKSMetadata();
    }

    public AstyanaxConfiguration getConfig() {
        return this.getPrimaryKS().getConfig();
    }

    public String getKeyspaceName() {
        return this.getPrimaryKS().getKeyspaceName();
    }

    public Partitioner getPartitioner() throws ConnectionException {
        return this.getPrimaryKS().getPartitioner();
    }

    public String describePartitioner() throws ConnectionException {
        return this.getPrimaryKS().describePartitioner();
    }

    public List<TokenRange> describeRing() throws ConnectionException {
        return this.getPrimaryKS().describeRing();
    }

    public List<TokenRange> describeRing(String dc) throws ConnectionException {
        return this.getPrimaryKS().describeRing(dc);
    }

    public List<TokenRange> describeRing(String dc, String rack) throws ConnectionException {
        return this.getPrimaryKS().describeRing(dc, rack);
    }

    public List<TokenRange> describeRing(boolean cached) throws ConnectionException {
        return this.getPrimaryKS().describeRing(cached);
    }

    public KeyspaceDefinition describeKeyspace() throws ConnectionException {
        return this.getPrimaryKS().describeKeyspace();
    }

    public Properties getKeyspaceProperties() throws ConnectionException {
        return this.getPrimaryKS().getKeyspaceProperties();
    }

    public Properties getColumnFamilyProperties(String columnFamily) throws ConnectionException {
        return this.getPrimaryKS().getColumnFamilyProperties(columnFamily);
    }

    public SerializerPackage getSerializerPackage(String cfName, boolean ignoreErrors) throws ConnectionException, UnknownComparatorException {
        return this.getPrimaryKS().getSerializerPackage(cfName, ignoreErrors);
    }

    public MutationBatch prepareMutationBatch() {
        if (this.dualWritesEnabled.get()) {
            KeyspacePair pair = this.ksPair.get();
            return new DualWritesMutationBatch(pair.getDualKSMetadata(), pair.getPrimaryKS().prepareMutationBatch(), pair.getSecondaryKS().prepareMutationBatch(), this.executionStrategy);
        }
        return this.getPrimaryKS().prepareMutationBatch();
    }

    public <K, C> ColumnFamilyQuery<K, C> prepareQuery(ColumnFamily<K, C> cf) {
        return this.getPrimaryKS().prepareQuery(cf);
    }

    public <K, C> ColumnMutation prepareColumnMutation(ColumnFamily<K, C> columnFamily, K rowKey, C column) {
        KeyspacePair pair = this.ksPair.get();
        if (this.dualWritesEnabled.get()) {
            WriteMetadata md = new WriteMetadata(pair.getDualKSMetadata(), columnFamily.getName(), rowKey.toString());
            return new DualWritesColumnMutation(md, pair.getPrimaryKS().prepareColumnMutation(columnFamily, rowKey, column), pair.getSecondaryKS().prepareColumnMutation(columnFamily, rowKey, column), this.executionStrategy);
        }
        return pair.getPrimaryKS().prepareColumnMutation(columnFamily, rowKey, column);
    }

    public <K, C> OperationResult<Void> truncateColumnFamily(final ColumnFamily<K, C> columnFamily) throws OperationException, ConnectionException {
        return this.execDualKeyspaceOperation(new KeyspaceOperation<Void>(){

            @Override
            public OperationResult<Void> exec(Keyspace ks) throws ConnectionException {
                return ks.truncateColumnFamily(columnFamily);
            }
        });
    }

    public OperationResult<Void> truncateColumnFamily(final String columnFamily) throws ConnectionException {
        return this.execDualKeyspaceOperation(new KeyspaceOperation<Void>(){

            @Override
            public OperationResult<Void> exec(Keyspace ks) throws ConnectionException {
                return ks.truncateColumnFamily(columnFamily);
            }
        });
    }

    public OperationResult<Void> testOperation(final Operation<?, ?> operation) throws ConnectionException {
        return this.execDualKeyspaceOperation(new KeyspaceOperation<Void>(){

            @Override
            public OperationResult<Void> exec(Keyspace ks) throws ConnectionException {
                return ks.testOperation(operation);
            }
        });
    }

    public OperationResult<Void> testOperation(final Operation<?, ?> operation, RetryPolicy retry) throws ConnectionException {
        return this.execDualKeyspaceOperation(new KeyspaceOperation<Void>(){

            @Override
            public OperationResult<Void> exec(Keyspace ks) throws ConnectionException {
                return ks.testOperation(operation);
            }
        });
    }

    public <K, C> OperationResult<SchemaChangeResult> createColumnFamily(final ColumnFamily<K, C> columnFamily, final Map<String, Object> options) throws ConnectionException {
        return this.execDualKeyspaceOperation(new KeyspaceOperation<SchemaChangeResult>(){

            @Override
            public OperationResult<SchemaChangeResult> exec(Keyspace ks) throws ConnectionException {
                return ks.createColumnFamily(columnFamily, options);
            }
        });
    }

    public OperationResult<SchemaChangeResult> createColumnFamily(final Properties props) throws ConnectionException {
        return this.execDualKeyspaceOperation(new KeyspaceOperation<SchemaChangeResult>(){

            @Override
            public OperationResult<SchemaChangeResult> exec(Keyspace ks) throws ConnectionException {
                return ks.createColumnFamily(props);
            }
        });
    }

    public OperationResult<SchemaChangeResult> createColumnFamily(final Map<String, Object> options) throws ConnectionException {
        return this.execDualKeyspaceOperation(new KeyspaceOperation<SchemaChangeResult>(){

            @Override
            public OperationResult<SchemaChangeResult> exec(Keyspace ks) throws ConnectionException {
                return ks.createColumnFamily(options);
            }
        });
    }

    public <K, C> OperationResult<SchemaChangeResult> updateColumnFamily(final ColumnFamily<K, C> columnFamily, final Map<String, Object> options) throws ConnectionException {
        return this.execDualKeyspaceOperation(new KeyspaceOperation<SchemaChangeResult>(){

            @Override
            public OperationResult<SchemaChangeResult> exec(Keyspace ks) throws ConnectionException {
                return ks.updateColumnFamily(columnFamily, options);
            }
        });
    }

    public OperationResult<SchemaChangeResult> updateColumnFamily(final Properties props) throws ConnectionException {
        return this.execDualKeyspaceOperation(new KeyspaceOperation<SchemaChangeResult>(){

            @Override
            public OperationResult<SchemaChangeResult> exec(Keyspace ks) throws ConnectionException {
                return ks.updateColumnFamily(props);
            }
        });
    }

    public OperationResult<SchemaChangeResult> updateColumnFamily(final Map<String, Object> options) throws ConnectionException {
        return this.execDualKeyspaceOperation(new KeyspaceOperation<SchemaChangeResult>(){

            @Override
            public OperationResult<SchemaChangeResult> exec(Keyspace ks) throws ConnectionException {
                return ks.updateColumnFamily(options);
            }
        });
    }

    public OperationResult<SchemaChangeResult> dropColumnFamily(final String columnFamilyName) throws ConnectionException {
        return this.execDualKeyspaceOperation(new KeyspaceOperation<SchemaChangeResult>(){

            @Override
            public OperationResult<SchemaChangeResult> exec(Keyspace ks) throws ConnectionException {
                return ks.dropColumnFamily(columnFamilyName);
            }
        });
    }

    public <K, C> OperationResult<SchemaChangeResult> dropColumnFamily(final ColumnFamily<K, C> columnFamily) throws ConnectionException {
        return this.execDualKeyspaceOperation(new KeyspaceOperation<SchemaChangeResult>(){

            @Override
            public OperationResult<SchemaChangeResult> exec(Keyspace ks) throws ConnectionException {
                return ks.dropColumnFamily(columnFamily);
            }
        });
    }

    public OperationResult<SchemaChangeResult> createKeyspace(final Map<String, Object> options) throws ConnectionException {
        return this.execDualKeyspaceOperation(new KeyspaceOperation<SchemaChangeResult>(){

            @Override
            public OperationResult<SchemaChangeResult> exec(Keyspace ks) throws ConnectionException {
                return ks.createKeyspace(options);
            }
        });
    }

    public OperationResult<SchemaChangeResult> createKeyspaceIfNotExists(final Map<String, Object> options) throws ConnectionException {
        return this.execDualKeyspaceOperation(new KeyspaceOperation<SchemaChangeResult>(){

            @Override
            public OperationResult<SchemaChangeResult> exec(Keyspace ks) throws ConnectionException {
                return ks.createKeyspaceIfNotExists(options);
            }
        });
    }

    public OperationResult<SchemaChangeResult> createKeyspace(final Properties properties) throws ConnectionException {
        return this.execDualKeyspaceOperation(new KeyspaceOperation<SchemaChangeResult>(){

            @Override
            public OperationResult<SchemaChangeResult> exec(Keyspace ks) throws ConnectionException {
                return ks.createKeyspace(properties);
            }
        });
    }

    public OperationResult<SchemaChangeResult> createKeyspaceIfNotExists(final Properties properties) throws ConnectionException {
        return this.execDualKeyspaceOperation(new KeyspaceOperation<SchemaChangeResult>(){

            @Override
            public OperationResult<SchemaChangeResult> exec(Keyspace ks) throws ConnectionException {
                return ks.createKeyspaceIfNotExists(properties);
            }
        });
    }

    public OperationResult<SchemaChangeResult> createKeyspace(final Map<String, Object> options, final Map<ColumnFamily, Map<String, Object>> cfs) throws ConnectionException {
        return this.execDualKeyspaceOperation(new KeyspaceOperation<SchemaChangeResult>(){

            @Override
            public OperationResult<SchemaChangeResult> exec(Keyspace ks) throws ConnectionException {
                return ks.createKeyspace(options, cfs);
            }
        });
    }

    public OperationResult<SchemaChangeResult> createKeyspaceIfNotExists(final Map<String, Object> options, final Map<ColumnFamily, Map<String, Object>> cfs) throws ConnectionException {
        return this.execDualKeyspaceOperation(new KeyspaceOperation<SchemaChangeResult>(){

            @Override
            public OperationResult<SchemaChangeResult> exec(Keyspace ks) throws ConnectionException {
                return ks.createKeyspaceIfNotExists(options, cfs);
            }
        });
    }

    public OperationResult<SchemaChangeResult> updateKeyspace(final Map<String, Object> options) throws ConnectionException {
        return this.execDualKeyspaceOperation(new KeyspaceOperation<SchemaChangeResult>(){

            @Override
            public OperationResult<SchemaChangeResult> exec(Keyspace ks) throws ConnectionException {
                return ks.updateKeyspace(options);
            }
        });
    }

    public OperationResult<SchemaChangeResult> updateKeyspace(final Properties props) throws ConnectionException {
        return this.execDualKeyspaceOperation(new KeyspaceOperation<SchemaChangeResult>(){

            @Override
            public OperationResult<SchemaChangeResult> exec(Keyspace ks) throws ConnectionException {
                return ks.updateKeyspace(props);
            }
        });
    }

    public OperationResult<SchemaChangeResult> dropKeyspace() throws ConnectionException {
        return this.execDualKeyspaceOperation(new KeyspaceOperation<SchemaChangeResult>(){

            @Override
            public OperationResult<SchemaChangeResult> exec(Keyspace ks) throws ConnectionException {
                return ks.dropKeyspace();
            }
        });
    }

    public Map<String, List<String>> describeSchemaVersions() throws ConnectionException {
        return this.getPrimaryKS().describeSchemaVersions();
    }

    public CqlStatement prepareCqlStatement() {
        KeyspacePair pair = this.ksPair.get();
        CqlStatement primaryStmt = pair.getPrimaryKS().prepareCqlStatement();
        CqlStatement secondaryStmt = pair.getSecondaryKS().prepareCqlStatement();
        return new DualWritesCqlStatement(primaryStmt, secondaryStmt, this.executionStrategy, pair.getDualKSMetadata());
    }

    public ConnectionPool<?> getConnectionPool() throws ConnectionException {
        return this.getPrimaryKS().getConnectionPool();
    }

    @Override
    public void dualWritesEnabled() {
        Logger.info("ENABLING dual writes for dual keyspace setup: " + this.ksPair.get().getDualKSMetadata());
        this.dualWritesEnabled.set(true);
    }

    @Override
    public void dualWritesDisabled() {
        Logger.info("DISABLING dual writes for dual keyspace setup: " + this.ksPair.get().getDualKSMetadata());
        this.dualWritesEnabled.set(false);
    }

    @Override
    public void flipPrimaryAndSecondary() {
        DualKeyspaceMetadata currentKeyspaceSetup;
        DualKeyspaceMetadata newDualKeyspaceSetup;
        KeyspacePair newPair;
        KeyspacePair currentPair = this.ksPair.get();
        boolean success = this.ksPair.compareAndSet(currentPair, newPair = new KeyspacePair(newDualKeyspaceSetup = new DualKeyspaceMetadata((currentKeyspaceSetup = currentPair.getDualKSMetadata()).getSecondaryCluster(), currentKeyspaceSetup.getSecondaryKeyspaceName(), currentKeyspaceSetup.getPrimaryCluster(), currentKeyspaceSetup.getPrimaryKeyspaceName()), currentPair.getSecondaryKS(), currentPair.getPrimaryKS()));
        if (success) {
            Logger.info("Successfully flipped to new dual keyspace setup" + this.ksPair.get().getDualKSMetadata());
        } else {
            Logger.info("Could not flip keyspace pair: " + currentPair + " to new pair: " + newPair);
        }
    }

    private <R> OperationResult<R> execDualKeyspaceOperation(final KeyspaceOperation<R> ksOperation) throws ConnectionException {
        final KeyspacePair pair = this.ksPair.get();
        SimpleSyncExec exec1 = new SimpleSyncExec<R>(){

            public OperationResult<R> execute() throws ConnectionException {
                return ksOperation.exec(pair.getPrimaryKS());
            }
        };
        SimpleSyncExec exec2 = new SimpleSyncExec<R>(){

            public OperationResult<R> execute() throws ConnectionException {
                return ksOperation.exec(pair.getSecondaryKS());
            }
        };
        WriteMetadata writeMd = new WriteMetadata(pair.getDualKSMetadata(), null, null);
        return this.executionStrategy.wrapExecutions(exec1, exec2, Collections.singletonList(writeMd)).execute();
    }

    private static interface KeyspaceOperation<R> {
        public OperationResult<R> exec(Keyspace var1) throws ConnectionException;
    }

    private abstract class SimpleSyncExec<R>
    implements Execution<R> {
        private SimpleSyncExec() {
        }

        public ListenableFuture<OperationResult<R>> executeAsync() throws ConnectionException {
            throw new RuntimeException("executeAsync not implemented for SimpleSyncExec");
        }
    }

    private class KeyspacePair {
        private final DualKeyspaceMetadata dualKeyspaceMetadata;
        private final Keyspace ksPrimary;
        private final Keyspace ksSecondary;

        private KeyspacePair(DualKeyspaceMetadata dualKeyspaceSetup, Keyspace pKS, Keyspace sKS) {
            this.dualKeyspaceMetadata = dualKeyspaceSetup;
            this.ksPrimary = pKS;
            this.ksSecondary = sKS;
        }

        private Keyspace getPrimaryKS() {
            return this.ksPrimary;
        }

        private Keyspace getSecondaryKS() {
            return this.ksSecondary;
        }

        private DualKeyspaceMetadata getDualKSMetadata() {
            return this.dualKeyspaceMetadata;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.ksPrimary == null ? 0 : this.ksPrimary.hashCode());
            result = 31 * result + (this.ksSecondary == null ? 0 : this.ksSecondary.hashCode());
            result = 31 * result + (this.dualKeyspaceMetadata == null ? 0 : this.dualKeyspaceMetadata.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyspacePair other = (KeyspacePair)obj;
            boolean equals = true;
            equals &= this.ksPrimary == null ? other.ksPrimary == null : this.ksPrimary.equals(other.ksPrimary);
            equals &= this.ksSecondary == null ? other.ksSecondary == null : this.ksSecondary.equals(other.ksSecondary);
            return equals &= this.dualKeyspaceMetadata == null ? other.dualKeyspaceMetadata == null : this.dualKeyspaceMetadata.equals(other.dualKeyspaceMetadata);
        }
    }
}

