/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.contrib.dualwrites;

import com.netflix.astyanax.AstyanaxConfiguration;
import com.netflix.astyanax.AstyanaxContext;
import com.netflix.astyanax.AstyanaxTypeFactory;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.connectionpool.NodeDiscoveryType;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.impl.ConnectionPoolConfigurationImpl;
import com.netflix.astyanax.connectionpool.impl.ConnectionPoolType;
import com.netflix.astyanax.contrib.dualwrites.BestEffortSecondaryWriteStrategy;
import com.netflix.astyanax.contrib.dualwrites.DualKeyspaceMetadata;
import com.netflix.astyanax.contrib.dualwrites.DualWritesKeyspace;
import com.netflix.astyanax.contrib.dualwrites.FailedWritesLogger;
import com.netflix.astyanax.contrib.dualwrites.LogBasedFailedWritesLogger;
import com.netflix.astyanax.impl.AstyanaxConfigurationImpl;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.serializers.IntegerSerializer;
import com.netflix.astyanax.serializers.LongSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.thrift.ThriftFamilyFactory;

public class DualWritesDemo {
    final String cluster1 = "cass_dualwrites_source";
    final String ks1 = "dualwritessrc";
    final String seed1 = "";
    final String cluster2 = "cass_dualwrites_dest";
    final String ks2 = "dualwritessrc";
    final String seed2 = "";
    final ColumnFamily<Integer, Long> CF_DUAL_WRITES = ColumnFamily.newColumnFamily((String)"foobar", (Serializer)IntegerSerializer.get(), (Serializer)LongSerializer.get(), (Serializer)StringSerializer.get());
    AstyanaxContext<Keyspace> ctx1;
    Keyspace keyspace1;
    AstyanaxContext<Keyspace> ctx2;
    Keyspace keyspace2;
    DualWritesKeyspace dualKeyspace = null;
    FailedWritesLogger logger = new LogBasedFailedWritesLogger();
    BestEffortSecondaryWriteStrategy execStrategy = new BestEffortSecondaryWriteStrategy(this.logger);

    public DualWritesDemo() {
        this.ctx1 = this.getKeyspaceContext("dualwritessrc", "");
        this.keyspace1 = (Keyspace)this.ctx1.getClient();
        this.ctx2 = this.getKeyspaceContext("dualwritessrc", "");
        this.keyspace2 = (Keyspace)this.ctx2.getClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        try {
            this.ctx1 = this.getKeyspaceContext("dualwritessrc", "");
            this.keyspace1 = (Keyspace)this.ctx1.getClient();
            this.ctx1.start();
            this.ctx2 = this.getKeyspaceContext("dualwritessrc", "");
            this.keyspace2 = (Keyspace)this.ctx2.getClient();
            this.ctx2.start();
            Thread.sleep(100L);
            this.logger.init();
            DualKeyspaceMetadata dualKeyspaceSetup = new DualKeyspaceMetadata("cass_dualwrites_source", "dualwritessrc", "cass_dualwrites_dest", "dualwritessrc");
            this.dualKeyspace = new DualWritesKeyspace(dualKeyspaceSetup, this.keyspace1, this.keyspace2, this.execStrategy);
            this.addRowToKS(this.dualKeyspace, 1, 0, 10);
            this.verifyPresent(this.keyspace1, 1);
            this.verifyNotPresent(this.keyspace2, 1);
            this.dualKeyspace.dualWritesEnabled();
            this.addRowToKS(this.dualKeyspace, 2, 0, 10);
            this.verifyPresent(this.keyspace1, 2);
            this.verifyPresent(this.keyspace2, 2);
            this.dualKeyspace.dualWritesDisabled();
            this.addRowToKS(this.dualKeyspace, 3, 0, 10);
            this.verifyPresent(this.keyspace1, 3);
            this.verifyNotPresent(this.keyspace2, 3);
            this.dualKeyspace.flipPrimaryAndSecondary();
            this.addRowToKS(this.dualKeyspace, 4, 0, 10);
            this.verifyNotPresent(this.keyspace1, 4);
            this.verifyPresent(this.keyspace2, 4);
            this.dualKeyspace.dualWritesEnabled();
            this.addRowToKS(this.dualKeyspace, 5, 0, 10);
            this.verifyPresent(this.keyspace1, 5);
            this.verifyPresent(this.keyspace2, 5);
            this.dualKeyspace.dualWritesDisabled();
            this.addRowToKS(this.dualKeyspace, 6, 0, 10);
            this.verifyNotPresent(this.keyspace1, 6);
            this.verifyPresent(this.keyspace2, 6);
            this.dualKeyspace.flipPrimaryAndSecondary();
            this.addRowToKS(this.dualKeyspace, 7, 0, 10);
            this.verifyPresent(this.keyspace1, 7);
            this.verifyNotPresent(this.keyspace2, 7);
            this.dualKeyspace.dualWritesEnabled();
            this.addRowToKS(this.dualKeyspace, 8, 0, 10);
            this.verifyPresent(this.keyspace1, 8);
            this.verifyPresent(this.keyspace2, 8);
            this.deleteRowFromKS(this.dualKeyspace, 1, 2, 3, 4, 5, 6, 7, 8);
            this.verifyNotPresent(this.keyspace1, 1, 2, 3, 4, 5, 6, 7, 8);
            this.verifyNotPresent(this.keyspace2, 1, 2, 3, 4, 5, 6, 7, 8);
        }
        finally {
            if (this.ctx1 != null) {
                this.ctx1.shutdown();
            }
            if (this.ctx2 != null) {
                this.ctx2.shutdown();
            }
        }
    }

    private void addRowToKS(Keyspace ks, int rowKey, int start, int end) throws ConnectionException {
        MutationBatch mb = ks.prepareMutationBatch();
        for (long i = (long)start; i < (long)end; ++i) {
            mb.withRow(this.CF_DUAL_WRITES, (Object)rowKey).putColumn((Object)i, "foo");
        }
        mb.execute();
    }

    private void deleteRowFromKS(Keyspace ks, int ... rowKeys) throws ConnectionException {
        MutationBatch mb = ks.prepareMutationBatch();
        for (int rowKey : rowKeys) {
            mb.withRow(this.CF_DUAL_WRITES, (Object)rowKey).delete();
        }
        mb.execute();
    }

    private AstyanaxContext<Keyspace> getKeyspaceContext(String ks, String seedHost) {
        AstyanaxContext ctx = new AstyanaxContext.Builder().forKeyspace(ks).withConnectionPoolConfiguration((ConnectionPoolConfiguration)new ConnectionPoolConfigurationImpl("myCPConfig-" + ks).setSeeds(seedHost).setPort(7102)).withAstyanaxConfiguration((AstyanaxConfiguration)new AstyanaxConfigurationImpl().setDefaultReadConsistencyLevel(ConsistencyLevel.CL_LOCAL_QUORUM).setConnectionPoolType(ConnectionPoolType.TOKEN_AWARE).setDiscoveryType(NodeDiscoveryType.RING_DESCRIBE)).buildKeyspace((AstyanaxTypeFactory)ThriftFamilyFactory.getInstance());
        return ctx;
    }

    private void verifyPresent(Keyspace ks, int rowKey) throws ConnectionException {
        ColumnList result = (ColumnList)ks.prepareQuery(this.CF_DUAL_WRITES).getRow((Object)rowKey).execute().getResult();
        if (result.isEmpty()) {
            throw new RuntimeException("Row: " + rowKey + " missing from keysapce: " + ks.getKeyspaceName());
        }
        System.out.println("Verified Row: " + rowKey + " present in ks: " + ks.getKeyspaceName());
    }

    private void verifyNotPresent(Keyspace ks, int rowKey) throws ConnectionException {
        ColumnList result = (ColumnList)ks.prepareQuery(this.CF_DUAL_WRITES).getRow((Object)rowKey).execute().getResult();
        if (!result.isEmpty()) {
            throw new RuntimeException("Row: " + rowKey + " present in keysapce: " + ks.getKeyspaceName());
        }
        System.out.println("Verified Row: " + rowKey + " NOT present in ks: " + ks.getKeyspaceName());
    }

    private void verifyNotPresent(Keyspace ks, int ... rowKeys) throws ConnectionException {
        for (int rowKey : rowKeys) {
            this.verifyNotPresent(ks, rowKey);
        }
    }

    public static void main(String[] args) {
        try {
            new DualWritesDemo().run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

