/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.contrib.dualwrites;

import com.google.common.util.concurrent.ListenableFuture;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.contrib.dualwrites.DualKeyspaceMetadata;
import com.netflix.astyanax.contrib.dualwrites.DualWritesCqlPreparedStatement;
import com.netflix.astyanax.contrib.dualwrites.DualWritesStrategy;
import com.netflix.astyanax.contrib.dualwrites.WriteMetadata;
import com.netflix.astyanax.cql.CqlPreparedStatement;
import com.netflix.astyanax.cql.CqlStatement;
import com.netflix.astyanax.cql.CqlStatementResult;
import com.netflix.astyanax.model.ConsistencyLevel;
import java.util.Collection;
import java.util.Collections;

public class DualWritesCqlStatement
implements CqlStatement {
    private final CqlStatement primary;
    private final CqlStatement secondary;
    private final DualWritesStrategy execStrategy;
    private final DualKeyspaceMetadata ksMd;

    public DualWritesCqlStatement(CqlStatement primaryCql, CqlStatement secondarycql, DualWritesStrategy strategy, DualKeyspaceMetadata keyspaceMd) {
        this.primary = primaryCql;
        this.secondary = secondarycql;
        this.execStrategy = strategy;
        this.ksMd = keyspaceMd;
    }

    public CqlStatement withConsistencyLevel(ConsistencyLevel cl) {
        this.primary.withConsistencyLevel(cl);
        this.secondary.withConsistencyLevel(cl);
        return this;
    }

    public CqlStatement withCql(String cql) {
        this.primary.withCql(cql);
        this.secondary.withCql(cql);
        return this;
    }

    public CqlPreparedStatement asPreparedStatement() {
        CqlPreparedStatement pstmtPrimary = this.primary.asPreparedStatement();
        CqlPreparedStatement pstmtSecondary = this.primary.asPreparedStatement();
        return new DualWritesCqlPreparedStatement(pstmtPrimary, pstmtSecondary, this.execStrategy, this.ksMd);
    }

    public OperationResult<CqlStatementResult> execute() throws ConnectionException {
        WriteMetadata writeMd = new WriteMetadata(this.ksMd, null, null);
        return this.execStrategy.wrapExecutions(this.primary, this.secondary, (Collection<WriteMetadata>)Collections.singletonList(writeMd)).execute();
    }

    public ListenableFuture<OperationResult<CqlStatementResult>> executeAsync() throws ConnectionException {
        WriteMetadata writeMd = new WriteMetadata(this.ksMd, null, null);
        return this.execStrategy.wrapExecutions(this.primary, this.secondary, (Collection<WriteMetadata>)Collections.singletonList(writeMd)).executeAsync();
    }
}

