/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.contrib.dualwrites;

import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.model.ColumnPath;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.UUID;

public class DualWritesColumnListMutation<C>
implements ColumnListMutation<C> {
    private final ColumnListMutation<C> primary;
    private final ColumnListMutation<C> secondary;

    public DualWritesColumnListMutation(ColumnListMutation<C> primaryClm, ColumnListMutation<C> secondaryClm) {
        this.primary = primaryClm;
        this.secondary = secondaryClm;
    }

    public <V> ColumnListMutation<C> putColumn(C columnName, V value, Serializer<V> valueSerializer, Integer ttl) {
        this.primary.putColumn(columnName, value, valueSerializer, ttl);
        this.secondary.putColumn(columnName, value, valueSerializer, ttl);
        return this;
    }

    public <V> ColumnListMutation<C> putColumnIfNotNull(C columnName, V value, Serializer<V> valueSerializer, Integer ttl) {
        this.primary.putColumnIfNotNull(columnName, value, valueSerializer, ttl);
        this.secondary.putColumnIfNotNull(columnName, value, valueSerializer, ttl);
        return this;
    }

    public <SC> ColumnListMutation<SC> withSuperColumn(ColumnPath<SC> superColumnPath) {
        throw new RuntimeException("Not Implemented");
    }

    public ColumnListMutation<C> putColumn(C columnName, String value, Integer ttl) {
        this.primary.putColumn(columnName, value, ttl);
        this.secondary.putColumn(columnName, value, ttl);
        return this;
    }

    public ColumnListMutation<C> putColumn(C columnName, String value) {
        this.primary.putColumn(columnName, value);
        this.secondary.putColumn(columnName, value);
        return this;
    }

    public ColumnListMutation<C> putColumnIfNotNull(C columnName, String value, Integer ttl) {
        this.primary.putColumnIfNotNull(columnName, value, ttl);
        this.secondary.putColumnIfNotNull(columnName, value, ttl);
        return this;
    }

    public ColumnListMutation<C> putColumnIfNotNull(C columnName, String value) {
        this.primary.putColumnIfNotNull(columnName, value);
        this.secondary.putColumnIfNotNull(columnName, value);
        return this;
    }

    public ColumnListMutation<C> putCompressedColumn(C columnName, String value, Integer ttl) {
        this.primary.putCompressedColumn(columnName, value, ttl);
        this.secondary.putCompressedColumn(columnName, value, ttl);
        return this;
    }

    public ColumnListMutation<C> putCompressedColumn(C columnName, String value) {
        this.primary.putCompressedColumn(columnName, value);
        this.secondary.putCompressedColumn(columnName, value);
        return this;
    }

    public ColumnListMutation<C> putCompressedColumnIfNotNull(C columnName, String value, Integer ttl) {
        this.primary.putCompressedColumnIfNotNull(columnName, value, ttl);
        this.secondary.putCompressedColumnIfNotNull(columnName, value, ttl);
        return this;
    }

    public ColumnListMutation<C> putCompressedColumnIfNotNull(C columnName, String value) {
        this.primary.putCompressedColumnIfNotNull(columnName, value);
        this.secondary.putCompressedColumnIfNotNull(columnName, value);
        return this;
    }

    public ColumnListMutation<C> putColumn(C columnName, byte[] value, Integer ttl) {
        this.primary.putColumn(columnName, value, ttl);
        this.secondary.putColumn(columnName, value, ttl);
        return this;
    }

    public ColumnListMutation<C> putColumn(C columnName, byte[] value) {
        this.primary.putColumn(columnName, value);
        this.secondary.putColumn(columnName, value);
        return this;
    }

    public ColumnListMutation<C> putColumnIfNotNull(C columnName, byte[] value, Integer ttl) {
        this.primary.putColumnIfNotNull(columnName, value, ttl);
        this.secondary.putColumnIfNotNull(columnName, value, ttl);
        return this;
    }

    public ColumnListMutation<C> putColumnIfNotNull(C columnName, byte[] value) {
        this.primary.putColumnIfNotNull(columnName, value);
        this.secondary.putColumnIfNotNull(columnName, value);
        return this;
    }

    public ColumnListMutation<C> putColumn(C columnName, byte value, Integer ttl) {
        this.primary.putColumn(columnName, value, ttl);
        this.secondary.putColumn(columnName, value, ttl);
        return this;
    }

    public ColumnListMutation<C> putColumn(C columnName, byte value) {
        this.primary.putColumn(columnName, value);
        this.secondary.putColumn(columnName, value);
        return this;
    }

    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Byte value, Integer ttl) {
        this.primary.putColumnIfNotNull(columnName, value, ttl);
        this.secondary.putColumnIfNotNull(columnName, value, ttl);
        return this;
    }

    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Byte value) {
        this.primary.putColumnIfNotNull(columnName, value);
        this.secondary.putColumnIfNotNull(columnName, value);
        return this;
    }

    public ColumnListMutation<C> putColumn(C columnName, short value, Integer ttl) {
        this.primary.putColumn(columnName, value, ttl);
        this.secondary.putColumn(columnName, value, ttl);
        return this;
    }

    public ColumnListMutation<C> putColumn(C columnName, short value) {
        this.primary.putColumn(columnName, value);
        this.secondary.putColumn(columnName, value);
        return this;
    }

    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Short value, Integer ttl) {
        this.primary.putColumnIfNotNull(columnName, value, ttl);
        this.secondary.putColumnIfNotNull(columnName, value, ttl);
        return this;
    }

    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Short value) {
        this.primary.putColumnIfNotNull(columnName, value);
        this.secondary.putColumnIfNotNull(columnName, value);
        return this;
    }

    public ColumnListMutation<C> putColumn(C columnName, int value, Integer ttl) {
        this.primary.putColumn(columnName, value, ttl);
        this.secondary.putColumn(columnName, value, ttl);
        return this;
    }

    public ColumnListMutation<C> putColumn(C columnName, int value) {
        this.primary.putColumn(columnName, value);
        this.secondary.putColumn(columnName, value);
        return this;
    }

    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Integer value, Integer ttl) {
        this.primary.putColumnIfNotNull(columnName, value, ttl);
        this.secondary.putColumnIfNotNull(columnName, value, ttl);
        return this;
    }

    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Integer value) {
        this.primary.putColumnIfNotNull(columnName, value);
        this.secondary.putColumnIfNotNull(columnName, value);
        return this;
    }

    public ColumnListMutation<C> putColumn(C columnName, long value, Integer ttl) {
        this.primary.putColumn(columnName, value, ttl);
        this.secondary.putColumn(columnName, value, ttl);
        return this;
    }

    public ColumnListMutation<C> putColumn(C columnName, long value) {
        this.primary.putColumn(columnName, value);
        this.secondary.putColumn(columnName, value);
        return this;
    }

    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Long value, Integer ttl) {
        this.primary.putColumnIfNotNull(columnName, value, ttl);
        this.secondary.putColumnIfNotNull(columnName, value, ttl);
        return this;
    }

    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Long value) {
        this.primary.putColumnIfNotNull(columnName, value);
        this.secondary.putColumnIfNotNull(columnName, value);
        return this;
    }

    public ColumnListMutation<C> putColumn(C columnName, boolean value, Integer ttl) {
        this.primary.putColumn(columnName, value, ttl);
        this.secondary.putColumn(columnName, value, ttl);
        return this;
    }

    public ColumnListMutation<C> putColumn(C columnName, boolean value) {
        this.primary.putColumn(columnName, value);
        this.secondary.putColumn(columnName, value);
        return this;
    }

    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Boolean value, Integer ttl) {
        this.primary.putColumnIfNotNull(columnName, value, ttl);
        this.secondary.putColumnIfNotNull(columnName, value, ttl);
        return this;
    }

    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Boolean value) {
        this.primary.putColumnIfNotNull(columnName, value);
        this.secondary.putColumnIfNotNull(columnName, value);
        return this;
    }

    public ColumnListMutation<C> putColumn(C columnName, ByteBuffer value, Integer ttl) {
        this.primary.putColumn(columnName, value, ttl);
        this.secondary.putColumn(columnName, value, ttl);
        return this;
    }

    public ColumnListMutation<C> putColumn(C columnName, ByteBuffer value) {
        this.primary.putColumn(columnName, value);
        this.secondary.putColumn(columnName, value);
        return this;
    }

    public ColumnListMutation<C> putColumnIfNotNull(C columnName, ByteBuffer value, Integer ttl) {
        this.primary.putColumnIfNotNull(columnName, value, ttl);
        this.secondary.putColumnIfNotNull(columnName, value, ttl);
        return this;
    }

    public ColumnListMutation<C> putColumnIfNotNull(C columnName, ByteBuffer value) {
        this.primary.putColumnIfNotNull(columnName, value);
        this.secondary.putColumnIfNotNull(columnName, value);
        return this;
    }

    public ColumnListMutation<C> putColumn(C columnName, Date value, Integer ttl) {
        this.primary.putColumn(columnName, value, ttl);
        this.secondary.putColumn(columnName, value, ttl);
        return this;
    }

    public ColumnListMutation<C> putColumn(C columnName, Date value) {
        this.primary.putColumn(columnName, value);
        this.secondary.putColumn(columnName, value);
        return this;
    }

    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Date value, Integer ttl) {
        this.primary.putColumnIfNotNull(columnName, value, ttl);
        this.secondary.putColumnIfNotNull(columnName, value, ttl);
        return this;
    }

    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Date value) {
        this.primary.putColumnIfNotNull(columnName, value);
        this.secondary.putColumnIfNotNull(columnName, value);
        return this;
    }

    public ColumnListMutation<C> putColumn(C columnName, float value, Integer ttl) {
        this.primary.putColumn(columnName, value, ttl);
        this.secondary.putColumn(columnName, value, ttl);
        return this;
    }

    public ColumnListMutation<C> putColumn(C columnName, float value) {
        this.primary.putColumn(columnName, value);
        this.secondary.putColumn(columnName, value);
        return this;
    }

    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Float value, Integer ttl) {
        this.primary.putColumnIfNotNull(columnName, value, ttl);
        this.secondary.putColumnIfNotNull(columnName, value, ttl);
        return this;
    }

    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Float value) {
        this.primary.putColumnIfNotNull(columnName, value);
        this.secondary.putColumnIfNotNull(columnName, value);
        return this;
    }

    public ColumnListMutation<C> putColumn(C columnName, double value, Integer ttl) {
        this.primary.putColumn(columnName, value, ttl);
        this.secondary.putColumn(columnName, value, ttl);
        return this;
    }

    public ColumnListMutation<C> putColumn(C columnName, double value) {
        this.primary.putColumn(columnName, value);
        this.secondary.putColumn(columnName, value);
        return this;
    }

    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Double value, Integer ttl) {
        this.primary.putColumnIfNotNull(columnName, value, ttl);
        this.secondary.putColumnIfNotNull(columnName, value, ttl);
        return this;
    }

    public ColumnListMutation<C> putColumnIfNotNull(C columnName, Double value) {
        this.primary.putColumnIfNotNull(columnName, value);
        this.secondary.putColumnIfNotNull(columnName, value);
        return this;
    }

    public ColumnListMutation<C> putColumn(C columnName, UUID value, Integer ttl) {
        this.primary.putColumn(columnName, value, ttl);
        this.secondary.putColumn(columnName, value, ttl);
        return this;
    }

    public ColumnListMutation<C> putColumn(C columnName, UUID value) {
        this.primary.putColumn(columnName, value);
        this.secondary.putColumn(columnName, value);
        return this;
    }

    public ColumnListMutation<C> putColumnIfNotNull(C columnName, UUID value, Integer ttl) {
        this.primary.putColumnIfNotNull(columnName, value, ttl);
        this.secondary.putColumnIfNotNull(columnName, value, ttl);
        return this;
    }

    public ColumnListMutation<C> putColumnIfNotNull(C columnName, UUID value) {
        this.primary.putColumnIfNotNull(columnName, value);
        this.secondary.putColumnIfNotNull(columnName, value);
        return this;
    }

    public ColumnListMutation<C> putEmptyColumn(C columnName, Integer ttl) {
        this.primary.putEmptyColumn(columnName, ttl);
        this.secondary.putEmptyColumn(columnName, ttl);
        return this;
    }

    public ColumnListMutation<C> putEmptyColumn(C columnName) {
        this.primary.putEmptyColumn(columnName);
        this.secondary.putEmptyColumn(columnName);
        return this;
    }

    public ColumnListMutation<C> incrementCounterColumn(C columnName, long amount) {
        this.primary.incrementCounterColumn(columnName, amount);
        this.secondary.incrementCounterColumn(columnName, amount);
        return this;
    }

    public ColumnListMutation<C> deleteColumn(C columnName) {
        this.primary.deleteColumn(columnName);
        this.secondary.deleteColumn(columnName);
        return this;
    }

    public ColumnListMutation<C> setTimestamp(long timestamp) {
        this.primary.setTimestamp(timestamp);
        this.secondary.setTimestamp(timestamp);
        return this;
    }

    public ColumnListMutation<C> delete() {
        this.primary.delete();
        this.secondary.delete();
        return this;
    }

    public ColumnListMutation<C> setDefaultTtl(Integer ttl) {
        this.primary.setDefaultTtl(ttl);
        this.secondary.setDefaultTtl(ttl);
        return this;
    }
}

