/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.contrib.dualwrites;

import com.google.common.util.concurrent.ListenableFuture;
import com.netflix.astyanax.Execution;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.contrib.dualwrites.DualWritesStrategy;
import com.netflix.astyanax.contrib.dualwrites.FailedWritesLogger;
import com.netflix.astyanax.contrib.dualwrites.WriteMetadata;
import java.util.Collection;

public class BestEffortSecondaryWriteStrategy
implements DualWritesStrategy {
    private final FailedWritesLogger failedWritesLogger;

    public BestEffortSecondaryWriteStrategy(FailedWritesLogger logger) {
        this.failedWritesLogger = logger;
    }

    @Override
    public <R> Execution<R> wrapExecutions(final Execution<R> primary, final Execution<R> secondary, final Collection<WriteMetadata> writeMetadata) {
        return new Execution<R>(){

            public OperationResult<R> execute() throws ConnectionException {
                OperationResult result;
                block3: {
                    result = primary.execute();
                    try {
                        secondary.execute();
                    }
                    catch (ConnectionException e) {
                        if (BestEffortSecondaryWriteStrategy.this.failedWritesLogger == null) break block3;
                        for (WriteMetadata writeMD : writeMetadata) {
                            BestEffortSecondaryWriteStrategy.this.failedWritesLogger.logFailedWrite(writeMD);
                        }
                    }
                }
                return result;
            }

            public ListenableFuture<OperationResult<R>> executeAsync() throws ConnectionException {
                throw new RuntimeException("Cannot chain async primary and secondary executions");
            }
        };
    }

    @Override
    public FailedWritesLogger getFailedWritesLogger() {
        return this.failedWritesLogger;
    }
}

