/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.bkdtree;

import java.io.IOException;
import org.apache.lucene.bkdtree.BKDTreeDocValuesConsumer;
import org.apache.lucene.bkdtree.BKDTreeDocValuesProducer;
import org.apache.lucene.bkdtree.BKDTreeWriter;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.lucene54.Lucene54DocValuesFormat;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;

public class BKDTreeDocValuesFormat
extends DocValuesFormat {
    static final String DATA_CODEC_NAME = "BKDData";
    static final int DATA_VERSION_START = 0;
    static final int DATA_VERSION_CURRENT = 0;
    static final String DATA_EXTENSION = "kdd";
    static final String META_CODEC_NAME = "BKDMeta";
    static final int META_VERSION_START = 0;
    static final int META_VERSION_CURRENT = 0;
    static final String META_EXTENSION = "kdm";
    private final int maxPointsInLeafNode;
    private final int maxPointsSortInHeap;
    private final DocValuesFormat delegate = new Lucene54DocValuesFormat();

    public BKDTreeDocValuesFormat() {
        this(1024, 131072);
    }

    public BKDTreeDocValuesFormat(int maxPointsInLeafNode, int maxPointsSortInHeap) {
        super("BKDTree");
        BKDTreeWriter.verifyParams(maxPointsInLeafNode, maxPointsSortInHeap);
        this.maxPointsInLeafNode = maxPointsInLeafNode;
        this.maxPointsSortInHeap = maxPointsSortInHeap;
    }

    public DocValuesConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        return new BKDTreeDocValuesConsumer(this.delegate.fieldsConsumer(state), state, this.maxPointsInLeafNode, this.maxPointsSortInHeap);
    }

    public DocValuesProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new BKDTreeDocValuesProducer(this.delegate.fieldsProducer(state), state);
    }
}

