/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.sru.search.adapter.service;

import com.google.common.io.Resources;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.gcube.rest.commons.filter.IResourceFilter;
import org.gcube.rest.commons.resourceawareservice.resources.ResourceFactory;
import org.gcube.rest.commons.resourcefile.IResourceFileUtils;
import org.gcube.rest.resourceawareservice.ResourceAwareService;
import org.gcube.rest.resourceawareservice.exceptions.ResourceAwareServiceException;
import org.gcube.rest.resourceawareservice.exceptions.ResourceNotFoundException;
import org.gcube.rest.resourcemanager.publisher.ResourcePublisher;
import org.gcube.search.SearchClient2;
import org.gcube.search.exceptions.SearchClientException;
import org.gcube.search.sru.search.adapter.commons.apis.SruSearchAdapterServiceAPI;
import org.gcube.search.sru.search.adapter.commons.resources.SruSearchAdapterResource;
import org.gcube.search.sru.search.adapter.service.ResponseObj;
import org.gcube.search.sru.search.adapter.service.SruSearchAdapterExplain;
import org.gcube.search.sru.search.adapter.service.helpers.QueryParserHelper;
import org.gcube.search.sru.search.adapter.service.helpers.RecordConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@Singleton
public class SruSearchAdapterService
extends ResourceAwareService<SruSearchAdapterResource>
implements SruSearchAdapterServiceAPI {
    QueryParserHelper queryParserHelper = new QueryParserHelper();
    RecordConverter recordConverer = new RecordConverter();
    boolean splitLists;
    boolean includeNonDC;
    int defaultRecordsNum = 0;
    static final Logger logger = LoggerFactory.getLogger(SruSearchAdapterService.class);
    private String scope;

    @Inject
    public SruSearchAdapterService(ResourceFactory<SruSearchAdapterResource> factory, ResourcePublisher<SruSearchAdapterResource> publisher, IResourceFilter<SruSearchAdapterResource> resourceFilter, IResourceFileUtils<SruSearchAdapterResource> resourceFileUtils) throws ResourceAwareServiceException {
        super(factory, publisher, resourceFilter, resourceFileUtils);
        logger.info("SruSearchAdapterService initialized");
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setSplitLists(boolean splitLists) {
        this.splitLists = splitLists;
    }

    public void setIncludeNonDC(boolean includeNonDC) {
        this.includeNonDC = includeNonDC;
    }

    public void setRecordsNum(int defaultRecordsNum) {
        this.defaultRecordsNum = defaultRecordsNum;
    }

    public String getScope() {
        return this.scope;
    }

    public String getResourceClass() {
        return "SruSearchAdapterResources";
    }

    public String getResourceNamePref() {
        return "SruSearchAdapterResource";
    }

    public Response ping() {
        return Response.ok().entity((Object)"pong").build();
    }

    public Response get(String scope, String resourceID, String operation, Float version, String recordPacking, String query, Integer maximumRecords, String recordSchema) {
        logger.info("---------------------------------------");
        logger.info("operation       : " + operation);
        logger.info("version         : " + version);
        logger.info("recordPacking   : " + recordPacking);
        logger.info("query           : " + query);
        logger.info("maximumRecords  : " + maximumRecords);
        logger.info("recordSchema    : " + recordSchema);
        SruSearchAdapterResource resource = null;
        SearchClient2 searchClient = null;
        try {
            resource = (SruSearchAdapterResource)this.getResource(resourceID);
            searchClient = new SearchClient2.Builder().endpoint(resource.getSearchSystemEndpoint()).scope(resource.getScope()).build();
            logger.info("initialized search client at : " + searchClient.getEndpoint() + " " + searchClient.getScope());
        }
        catch (ResourceNotFoundException e) {
            logger.warn("error while getting resource", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ResponseObj("Resource with ID : " + resourceID + " not found")).build();
        }
        catch (SearchClientException e) {
            logger.warn("error while initializing search client", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ResponseObj("Resource with ID : " + resourceID + " not found")).build();
        }
        return this.getResponse(searchClient, scope, operation, version, recordPacking, query, maximumRecords, recordSchema);
    }

    public Response get(String operation, Float version, String recordPacking, String query, Integer maximumRecords, String recordSchema) {
        logger.info("---------------------------------------");
        logger.info("operation       : " + operation);
        logger.info("version         : " + version);
        logger.info("recordPacking   : " + recordPacking);
        logger.info("query           : " + query);
        logger.info("maximumRecords  : " + maximumRecords);
        logger.info("recordSchema    : " + recordSchema);
        SearchClient2 searchClient = null;
        try {
            searchClient = new SearchClient2.Builder().scope(this.scope).build();
        }
        catch (SearchClientException e) {
            logger.warn("error while initializing search client", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return this.getResponse(searchClient, this.scope, operation, version, recordPacking, query, maximumRecords, recordSchema);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Response getResponse(SearchClient2 searchClient, String scope, String operation, Float version, String recordPacking, String query, Integer maximumRecords, String recordSchema) {
        block12: {
            if (operation == null || operation.equalsIgnoreCase("explain")) {
                fields = searchClient.getSearchableFields();
                collections = searchClient.getCollections();
                explain = SruSearchAdapterExplain.createExplain((Map)collections, (Map)fields, (String)this.getHostname(), (Integer)this.getPort(), (Boolean)this.includeNonDC, (int)this.defaultRecordsNum);
                return Response.ok().entity((Object)explain.getExplainXML()).build();
            }
            if (!operation.equalsIgnoreCase("searchRetrieve")) ** GOTO lbl44
            if (version != null && (double)version.floatValue() >= 1.2) {
                msg = SruSearchAdapterService.diagnostics((Integer)5, (String)"Unsupported version", (String)"1.1");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ResponseObj(msg)).build();
            }
            if (maximumRecords != null && maximumRecords < 0) {
                msg = SruSearchAdapterService.diagnostics((Integer)6, (String)"unsupported parameter value", (String)maximumRecords.toString());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ResponseObj(msg)).build();
            }
            if (query != null) break block12;
            msg = SruSearchAdapterService.diagnostics((Integer)7, (String)"Mandatory parameter not supplied", (String)"query");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ResponseObj(msg)).build();
            {
                catch (Exception e) {
                    SruSearchAdapterService.logger.error("error while executing operation", (Throwable)e);
                    return Response.serverError().entity((Object)new ResponseObj("Internal server error")).build();
                }
            }
        }
        try {
            queryPart = URLDecoder.decode(query, "UTF-8");
            SruSearchAdapterService.logger.info("query received : " + queryPart);
            fieldsMapping = searchClient.getFieldsMapping();
            queryString = this.queryParserHelper.replaceFields(queryPart, fieldsMapping);
            SruSearchAdapterService.logger.info("query after field replacement : " + queryString);
            queryString = queryString + " project *";
            SruSearchAdapterService.logger.info("Query = " + queryString);
            results = searchClient.queryAndRead(queryString, null, Boolean.valueOf(true));
            resultsSize = results.size();
            if (maximumRecords == null) {
                maximumRecords = this.defaultRecordsNum;
            }
            if (maximumRecords != null && maximumRecords > 0 && results.size() > maximumRecords) {
                results = results.subList(0, maximumRecords);
            }
            resultsString = this.recordConverer.convertRecordsToSru(Long.valueOf(resultsSize), (List)results, this.splitLists);
            return Response.ok().entity((Object)resultsString).build();
        }
        catch (SearchClientException e) {
            SruSearchAdapterService.logger.error("Search client error", (Throwable)e);
            return Response.serverError().entity((Object)SruSearchAdapterService.diagnostics((Integer)10, (String)"Search client error", (String)query)).build();
            catch (Exception e) {
                SruSearchAdapterService.logger.error("Query syntax error", (Throwable)e);
                return Response.serverError().entity((Object)SruSearchAdapterService.diagnostics((Integer)10, (String)"Query syntax error", (String)query)).build();
            }
lbl44:
            // 1 sources

            if (operation.equalsIgnoreCase("scan")) {
                return Response.ok().entity((Object)SruSearchAdapterService.scan()).build();
            }
            return Response.serverError().entity((Object)SruSearchAdapterService.diagnostics((Integer)10, (String)"unknown operation requested", (String)query)).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getHostname() {
        Properties properties = new Properties();
        try (InputStream is = Resources.getResource((String)"deploy.properties").openStream();){
            properties.load(is);
            String string = properties.getProperty("hostname");
            return string;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not load property file  : deploy.properties");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Integer getPort() {
        Properties properties = new Properties();
        try (InputStream is = Resources.getResource((String)"deploy.properties").openStream();){
            properties.load(is);
            Integer n = Integer.valueOf(properties.getProperty("port"));
            return n;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not load property file  : deploy.properties");
        }
    }

    static String diagnostics(Integer code, String message, String details) {
        String xml = "<?xml version=\"1.0\"?>\n\t<diagnostics>\n\t\t<diagnostic xmlns=\"http://www.loc.gov/zing/srw/diagnostic/\">\n\t\t\t<uri>info:srw/diagnostic/1/" + code + "</uri>\n" + "\t\t\t<message>" + message + "</message>\n" + "\t\t\t<details>" + details + "</details>\n" + "\t\t</diagnostic>\n" + "\t</diagnostics>\n";
        return xml;
    }

    static String scan() {
        String xml = "<?xml version=\"1.0\"?><zs:scanResponse xmlns:zs=\"http://www.loc.gov/zing/srw/\">\t<zs:version>1.1</zs:version>\t<zs:diagnostics xmlns=\"http://www.loc.gov/zing/srw/diagnostic/\">\t\t<diagnostic>\t\t\t<uri>info:srw/diagnostic/1/4</uri>\t\t\t<message>Unsupported operation</message>\t\t\t<details>scan</details>\t\t</diagnostic>\t</zs:diagnostics></zs:scanResponse>";
        return xml;
    }
}

