/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.sru.consumer.client;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.gcube.rest.commons.helpers.ResponseUtils;
import org.gcube.rest.commons.helpers.ResultReader;
import org.gcube.search.sru.consumer.client.exception.SruConsumerClientException;
import org.gcube.search.sru.consumer.client.inject.SruConsumerClientModule;
import org.gcube.search.sru.consumer.common.apis.SruConsumerServiceAPI;
import org.gcube.search.sru.consumer.common.discoverer.SruConsumerDiscovererAPI;
import org.gcube.search.sru.consumer.common.resources.SruConsumerResource;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SruConsumerClient {
    private static Gson gson = new Gson();
    private String endpoint;
    private String resourceID;
    private String collectionID;
    private final String scope;
    private static final Logger logger = LoggerFactory.getLogger(SruConsumerClient.class);

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getResourceID() {
        return this.resourceID;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public String getScope() {
        return this.scope;
    }

    SruConsumerClient(Builder builder) throws SruConsumerClientException {
        this.endpoint = builder.endpoint;
        this.scope = builder.scope;
        this.resourceID = builder.resourceID;
        this.collectionID = builder.collectionID;
        SruConsumerDiscovererAPI discoverer = builder.discoverer;
        if (discoverer == null) {
            Injector injector = Guice.createInjector((Module[])new Module[]{new SruConsumerClientModule()});
            discoverer = (SruConsumerDiscovererAPI)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<SruConsumerDiscovererAPI<SruConsumerResource>>(){}));
        }
        if (builder.skipInitialize && this.scope != null && this.endpoint != null && this.resourceID != null) {
            logger.info("requested to skip the initialize part");
        } else {
            this.initialize((SruConsumerDiscovererAPI<SruConsumerResource>)discoverer);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initialize(SruConsumerDiscovererAPI<SruConsumerResource> discoverer) throws SruConsumerClientException {
        boolean found = false;
        try {
            Map SruConsumerNodes = discoverer.discoverSruConsumerNodes(this.scope, this.collectionID);
            logger.info("running instances for sru consumer service : " + SruConsumerNodes);
            ArrayList endpoints = Lists.newArrayList(SruConsumerNodes.keySet());
            if (this.endpoint != null) {
                if (!endpoints.contains(this.endpoint)) {
                    throw new SruConsumerClientException("could not initialize random client. given endpoint : " + this.endpoint + " found endpoints : " + endpoints);
                }
                endpoints = Lists.newArrayList((Object[])new String[]{this.endpoint});
            } else {
                Collections.shuffle(endpoints);
            }
            for (String endpoint : endpoints) {
                ArrayList resources;
                block11: {
                    if (SruConsumerNodes.get(endpoint) == null || ((Set)SruConsumerNodes.get(endpoint)).size() <= 0) continue;
                    resources = Lists.newArrayList((Iterable)((Iterable)SruConsumerNodes.get(endpoint)));
                    if (this.resourceID != null) {
                        if (resources.contains(this.resourceID)) {
                            resources = Lists.newArrayList((Object[])new String[]{this.resourceID});
                            break block11;
                        } else {
                            logger.info("resource : " + this.resourceID + " not in : " + resources + " of " + endpoint);
                            continue;
                        }
                    }
                    Collections.shuffle(resources);
                }
                this.resourceID = (String)resources.get(0);
                this.endpoint = endpoint;
                found = true;
                break;
            }
            logger.info("Initialized at : " + this.endpoint + " , " + this.resourceID);
        }
        catch (Exception e) {
            logger.error("could not initialize random client", (Throwable)e);
            throw new SruConsumerClientException("could not initialize random client", e);
        }
        if (found) {
            return;
        }
        if (this.resourceID != null) {
            throw new SruConsumerClientException("could not initialize random client. given resourceID : " + this.resourceID);
        }
        throw new SruConsumerClientException("could not initialize random client");
    }

    private static SruConsumerServiceAPI getSruConsumerServiceProxy(String endpoint) throws SruConsumerClientException {
        ResteasyClient client = null;
        ResteasyWebTarget target = null;
        SruConsumerServiceAPI simple = null;
        logger.info("getting proxy from index factory service...");
        try {
            client = new ResteasyClientBuilder().build();
            target = client.target(endpoint);
            simple = (SruConsumerServiceAPI)target.proxy(SruConsumerServiceAPI.class);
        }
        catch (Exception e) {
            logger.error("Client could not connect to endpoint : " + endpoint, (Throwable)e);
            throw new SruConsumerClientException("Client could not connect to endpoint : " + endpoint, e);
        }
        logger.info("getting proxy from sru factory service...OK");
        return simple;
    }

    public String query(String query, Long maxRecords) throws SruConsumerClientException {
        return this.query(query, maxRecords, true);
    }

    public String query(String query, Long maxRecords, Boolean useRR) throws SruConsumerClientException {
        logger.info("calling query with parameters. query : " + query + " , maxRecords : " + maxRecords + ", useRR : " + useRR);
        logger.info(" ~> endpoint : " + this.endpoint + ", resourceID : " + this.resourceID + ", scope : " + this.scope);
        Response response = SruConsumerClient.getSruConsumerServiceProxy(this.endpoint).query(this.scope, this.resourceID, query, maxRecords, Boolean.valueOf(false), useRR);
        logger.info("queryAndRead returned");
        try {
            ResponseUtils.checkResponse((Response)response, (String)"query");
        }
        catch (Exception e) {
            throw new SruConsumerClientException(e);
        }
        String json = (String)response.readEntity(String.class);
        response.close();
        Map resp = (Map)gson.fromJson(json, new TypeToken<Map<String, String>>(){}.getType());
        return (String)resp.get("grslocator");
    }

    public String query(String query) throws SruConsumerClientException {
        return this.query(query, null);
    }

    public List<Map<String, String>> queryAndRead(String query) throws SruConsumerClientException {
        return this.queryAndRead(query, null, true);
    }

    public List<Map<String, String>> queryAndRead(String query, Boolean useRR) throws SruConsumerClientException {
        return this.queryAndRead(query, null, useRR);
    }

    public List<Map<String, String>> queryAndRead(String query, Long maxRecords, Boolean useRR) throws SruConsumerClientException {
        logger.info("calling queryAndRead with parameters. query : " + query + " , maxRecords : " + maxRecords + " , useRR : " + useRR);
        logger.info(" ~> endpoint : " + this.endpoint + ", resourceID : " + this.resourceID + ", scope : " + this.scope);
        Response response = SruConsumerClient.getSruConsumerServiceProxy(this.endpoint).query(this.scope, this.resourceID, query, maxRecords, Boolean.valueOf(true), useRR);
        logger.info("queryAndRead returned");
        try {
            ResponseUtils.checkResponse((Response)response, (String)"queryAndRead");
        }
        catch (Exception e) {
            throw new SruConsumerClientException(e);
        }
        String json = (String)response.readEntity(String.class);
        response.close();
        try {
            List resp = (List)gson.fromJson(json, new TypeToken<List<Map<String, String>>>(){}.getType());
            return resp;
        }
        catch (Exception e) {
            logger.error("Unable to convert response to list of maps of strings : " + json);
            throw new SruConsumerClientException("Unable to convert response to list of maps of strings " + json, e);
        }
    }

    public List<Map<String, String>> queryAndReadClientSide(String query) throws SruConsumerClientException {
        return this.queryAndReadClientSide(query, null, true);
    }

    public List<Map<String, String>> queryAndReadClientSide(String query, Long maxResults, Boolean useRR) throws SruConsumerClientException {
        logger.info("calling queryAndReadClientSide with parameters. query : " + query + ", maxResults : " + maxResults + " , useRR : " + useRR);
        logger.info(" ~> endpoint : " + this.endpoint + ", resourceID : " + this.resourceID + ", scope : " + this.scope);
        String grsLocator = this.query(query, maxResults, useRR);
        logger.info("queryAndReadClientSide returned : " + grsLocator);
        try {
            List results = ResultReader.resultSetToRecords((String)grsLocator);
            return results;
        }
        catch (Exception e) {
            logger.error("could not read results from the grs2 locator : " + grsLocator, (Throwable)e);
            throw new SruConsumerClientException("could not read results from the grs2 locator : " + grsLocator, e);
        }
    }

    public String explain() throws SruConsumerClientException {
        logger.info("calling explain with parameters. none");
        logger.info(" ~> endpoint : " + this.endpoint + ", resourceID : " + this.resourceID + ", scope : " + this.scope);
        Response response = SruConsumerClient.getSruConsumerServiceProxy(this.endpoint).explain(this.scope, this.resourceID);
        logger.info("explain returned");
        try {
            ResponseUtils.checkResponse((Response)response, (String)"explain");
        }
        catch (Exception e) {
            throw new SruConsumerClientException(e);
        }
        String xml = (String)response.readEntity(String.class);
        response.close();
        return xml;
    }

    public static class Builder {
        private String endpoint;
        private String resourceID;
        private String collectionID;
        private String scope;
        private boolean skipInitialize = false;
        private final SruConsumerDiscovererAPI<SruConsumerResource> discoverer;

        public Builder() {
            this.discoverer = null;
        }

        @Inject
        public Builder(SruConsumerDiscovererAPI<SruConsumerResource> discoverer) {
            this.discoverer = discoverer;
        }

        public Builder endpoint(String endpoint) {
            if (endpoint.endsWith("/")) {
                endpoint = endpoint.substring(0, endpoint.length() - 1);
            }
            this.endpoint = endpoint;
            return this;
        }

        public Builder resourceID(String resourceID) {
            this.resourceID = resourceID;
            return this;
        }

        public Builder collectionID(String collectionID) {
            this.collectionID = collectionID;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public Builder skipInitialize(boolean skipInitialize) {
            this.skipInitialize = skipInitialize;
            return this;
        }

        public SruConsumerClient build() throws SruConsumerClientException {
            return new SruConsumerClient(this);
        }
    }
}

