/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.gmerge;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.gmerge.FirstAvailableGradualScanDispatcher;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.gmerge.GradualLocatorReader;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.gmerge.SynchFinished;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.EventEntry;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.ReaderHolder;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.ReaderScan;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.RecordBufferEntry;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import java.net.URI;
import java.util.LinkedList;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradualMergeWorker
extends Thread {
    private Logger log = LoggerFactory.getLogger((String)GradualMergeWorker.class.getName());
    private Vector<ReaderHolder> readers = null;
    private RecordWriter<Record> writer = null;
    private Object synchWriterInit = new Object();
    private Object synchDispatcher;
    private String uid = null;
    private long timeout;
    private TimeUnit timeUnit;
    private int count = 0;
    private long firststop = 0L;
    private GradualLocatorReader inputRetriever;
    private SynchFinished synchFinished = new SynchFinished();
    private StatsContainer stats;
    private Object synchMergingStart;

    public GradualMergeWorker(Vector<ReaderHolder> readers, StatsContainer stats, long timeout, TimeUnit timeUnit, String uid, GradualLocatorReader inputRetriever, Object synchDispatcher, Object synchMergingStart) {
        this.readers = readers;
        this.stats = stats;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.uid = uid;
        this.inputRetriever = inputRetriever;
        this.synchDispatcher = synchDispatcher;
        this.synchMergingStart = synchMergingStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName(GradualMergeWorker.class.getName());
        long start = System.currentTimeMillis();
        long closestop = System.currentTimeMillis();
        this.setName("Merge Worker");
        ArrayBlockingQueue<RecordBufferEntry> recs = null;
        try {
            int capacity = 100;
            this.log.info("Queue capacity for " + this.uid + " is " + capacity);
            recs = new ArrayBlockingQueue<RecordBufferEntry>(capacity);
            Vector<ReaderScan> scan = new Vector<ReaderScan>(this.readers.size());
            FirstAvailableGradualScanDispatcher dispatcher = new FirstAvailableGradualScanDispatcher(scan, this.readers, recs, new LinkedList<EventEntry>(), this.uid, this.synchDispatcher, this.synchWriterInit, this.synchFinished);
            dispatcher.start();
            Object object = this.synchWriterInit;
            synchronized (object) {
                while (scan.size() == 0 && !this.synchFinished.isFinished()) {
                    this.synchWriterInit.wait();
                }
            }
            boolean finished = false;
            long waitTime = 10L;
            while (!finished) {
                int i;
                RecordBufferEntry rbEntry;
                if (this.count == 0) {
                    this.firststop = System.currentTimeMillis();
                    this.stats.timeToFirstInput(this.firststop - start);
                    this.log.debug("First stop: " + (this.firststop - start));
                }
                if ((rbEntry = (RecordBufferEntry)recs.poll(waitTime < 500L ? waitTime : 500L, TimeUnit.MILLISECONDS)) != null) {
                    waitTime = 10L;
                    Record rec = rbEntry.record;
                    if (this.writer == null) {
                        for (i = 0; i < this.readers.size(); ++i) {
                            ReaderHolder reader = this.readers.get(i);
                            if (reader.getWaitingForInit()) continue;
                            RecordDefinition[] recordDefinitions = reader.getReader().getRecordDefinitions();
                            this.writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), recordDefinitions, RecordWriter.DefaultBufferCapacity, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor, this.timeout, this.timeUnit);
                            Object object2 = this.synchMergingStart;
                            synchronized (object2) {
                                this.synchMergingStart.notify();
                                break;
                            }
                        }
                    }
                    if (this.writer.getStatus() == IBuffer.Status.Close || this.writer.getStatus() == IBuffer.Status.Dispose) {
                        this.log.info("Consumer side of " + this.uid + " stopped consumption. Notifying all " + this.readers.size() + " readers to stop.");
                        for (i = 0; i < this.readers.size(); ++i) {
                            this.readers.get(i).setFinished(true);
                            try {
                                this.readers.get(i).getReader().close();
                                continue;
                            }
                            catch (GRS2ReaderException re) {
                                this.log.warn("Could not close reader #" + i);
                            }
                        }
                        recs.clear();
                        break;
                    }
                    if (!this.writer.importRecord(rec, 0, this.timeout, this.timeUnit)) {
                        if (this.writer.getStatus() != IBuffer.Status.Open) break;
                        this.log.warn("Writer of " + this.uid + " has timed out");
                        break;
                    }
                    ++this.count;
                    continue;
                }
                if (this.inputRetriever.hasFinished()) {
                    int count = 0;
                    for (i = 0; i < scan.size(); ++i) {
                        if (this.readers.get(i).hasFinished()) continue;
                        ++count;
                    }
                    if (count == 0) {
                        finished = true;
                    }
                }
                waitTime *= 2L;
            }
            this.synchFinished.setFinished(true);
            closestop = System.currentTimeMillis();
            InterruptedException ex = null;
            for (int i = 0; i < scan.size(); ++i) {
                do {
                    try {
                        scan.get(i).join();
                        ex = null;
                    }
                    catch (InterruptedException e) {
                        ex = e;
                    }
                } while (ex != null);
            }
        }
        catch (Exception e) {
            this.log.error("Could not complete background merging for " + this.uid + ". Closing", (Throwable)e);
        }
        finally {
            recs.clear();
            for (int i = 0; i < this.readers.size(); ++i) {
                this.readers.get(i).setFinished(true);
                try {
                    if (this.readers.get(i).getReader().getStatus() == IBuffer.Status.Dispose) continue;
                    this.readers.get(i).getReader().close();
                    continue;
                }
                catch (Exception e) {
                    this.log.warn("Could not close reader #" + i);
                }
            }
            try {
                if (this.writer != null) {
                    this.writer.close();
                }
            }
            catch (Exception e2) {}
            Object object = this.synchDispatcher;
            synchronized (object) {
                this.synchDispatcher.notify();
            }
            object = this.synchWriterInit;
            synchronized (object) {
                this.synchWriterInit.notify();
            }
            this.log.info("MERGE OPERATOR " + this.uid + ":\nProduced first result in " + (this.firststop - start) + " milliseconds\n" + "Produced last result in " + (closestop - start) + " milliseconds\n" + "Produced " + this.count + " records\n" + "Production rate was " + (float)this.count / (float)(closestop - start) * 1000.0f + " records per second");
        }
    }

    public URI getWriterLocator() {
        if (this.writer == null) {
            return null;
        }
        try {
            return this.writer.getLocator();
        }
        catch (GRS2WriterException e) {
            return null;
        }
    }
}

