package org.gcube.opensearch.client.library.stubs;

import static org.gcube.opensearch.client.library.util.OpenSearchDataSourceCLConstants.porttypeLN;
import static org.gcube.opensearch.client.library.util.OpenSearchDataSourceCLConstants.porttypeNS;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;

import org.gcube.opensearch.client.library.beans.Types.AddProvidersParams;
import org.gcube.opensearch.client.library.beans.Types.AddProvidersResponse;
import org.gcube.opensearch.client.library.beans.Types.Destroy;
import org.gcube.opensearch.client.library.beans.Types.RefreshCache;
import org.gcube.opensearch.client.library.beans.Types.RefreshCacheResponse;

@WebService(name = porttypeLN, targetNamespace = porttypeNS)
public interface OpenSearchDataSourceStub {
	
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	String query(String query);
	
	@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
	RefreshCacheResponse refreshCache(RefreshCache req);
	
	@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
	AddProvidersResponse addProviders(AddProvidersParams req);

	@WebMethod(operationName = "Destroy")
	@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
	public void destroy(@WebParam(name = "Destroy", targetNamespace = "http://docs.oasis-open.org/wsrf/2004/06/wsrf-WS-ResourceLifetime-1.2-draft-01.xsd") Destroy destroy);

	
}
