package org.gcube.opensearch.client.library.proxies;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.opensearch.client.library.beans.Types.CreateResourceParams;
import org.gcube.opensearch.client.library.beans.Types.CreateResourceResponse;
import org.gcube.opensearch.client.library.exceptions.OpenSearchDataSourceException;
import org.gcube.opensearch.client.library.stubs.OpenSearchDataSourceFactoryStub;

public class OpenSearchDataSourceFactoryCLDefaultProxy implements OpenSearchDataSourceFactoryCLProxyI {

	private final ProxyDelegate<OpenSearchDataSourceFactoryStub> delegate;

	public OpenSearchDataSourceFactoryCLDefaultProxy(ProxyDelegate<OpenSearchDataSourceFactoryStub> config) {
		this.delegate = config;
	}

	@Override
	public CreateResourceResponse createResource(final CreateResourceParams createResource) throws OpenSearchDataSourceException {
		Call<OpenSearchDataSourceFactoryStub, CreateResourceResponse> call = new Call<OpenSearchDataSourceFactoryStub, CreateResourceResponse>() {
			@Override
			public CreateResourceResponse call(OpenSearchDataSourceFactoryStub endpoint) throws Exception {
				return endpoint.createResource(createResource);
			}
		};
		try {
			CreateResourceResponse response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new OpenSearchDataSourceException(e);
		}
	}
}
