package org.gcube.opensearch.client.library.proxies;

import java.net.URI;

import org.gcube.common.clients.fw.queries.StatefulQuery;
import org.gcube.opensearch.client.library.util.OpenSearchDataSourceCLConstants;

public class SourceQueryBuilder {

	private final StatefulQuery query;
	
	private String adaptorID;
	
	public SourceQueryBuilder(StatefulQuery query) {
		query.addNamespace("ns1",URI.create(OpenSearchDataSourceCLConstants.NAMESPACE));
		this.query=query;
	}

	public SourceQueryBuilder withAdaptorID(String adaptorID) {
		this.adaptorID = adaptorID;
		return this;
	}

	public StatefulQuery build() {
		if (adaptorID!=null)
			query.addCondition("$resource/SourceKey/text() eq '" + adaptorID + "'");
		return query;
	}

}
