/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.testing;

import gr.uoa.di.madgik.commons.server.ConnectionManagerConfig;
import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.UnaryOp;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.datasource.DataSourceOp;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.testing.GRS2Printer;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.transform.ScriptOp;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gcube.common.scope.api.ScopeProvider;

public class TestDataSource {
    public static void main(String[] args) throws Exception {
        TCPConnectionManager.Init((ConnectionManagerConfig)new ConnectionManagerConfig("localhost", new ArrayList(), true));
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
        ScopeProvider.instance.set("/gcube/devNext");
        URI uri = TestDataSource.testJDBCSource();
        HashMap<String, String> operatorParameters = new HashMap<String, String>();
        operatorParameters.put("script", "python /home/jgerbe/Desktop/script.py");
        operatorParameters.put("schema", "[a, b , c]");
        uri = new UnaryOp(ScriptOp.class.getName(), uri, operatorParameters, new StatsContainer()).compute();
        Thread.sleep(2000L);
        GRS2Printer.print(uri, 6);
        GRS2Printer.compute();
    }

    public static URI testPathSource() throws Exception {
        String inputType = "PATH";
        String inputValue = "/home/jgerbe/Desktop/input.dat.10";
        HashMap<String, String> inputParameters = new HashMap<String, String>();
        inputParameters.put("filterMask", "[1, 0, 2]");
        inputParameters.put("delimiter", "\t");
        DataSourceOp ds = new DataSourceOp(inputType, inputValue, (Map<String, String>)inputParameters);
        URI uri = ds.compute();
        return uri;
    }

    public static URI testFTPSource() throws Exception {
        String inputType = "FTP";
        String inputValue = "ftp://giannis:aplagiaftp@meteora.di.uoa.gr/testArea/src";
        HashMap<String, String> inputParameters = new HashMap<String, String>();
        DataSourceOp ds = new DataSourceOp(inputType, inputValue, (Map<String, String>)inputParameters);
        URI uri = ds.compute();
        return uri;
    }

    public static URI testTMSource() throws Exception {
        String inputType = "TM";
        String inputValue = "d686c177-8d4c-4947-b85a-f6e8ef65620e";
        HashMap<String, String> inputParameters = new HashMap<String, String>();
        inputParameters.put("GCubeActionScope", "/gcube/devNext");
        DataSourceOp ds = new DataSourceOp(inputType, inputValue, (Map<String, String>)inputParameters);
        URI uri = ds.compute();
        return uri;
    }

    public static URI testJDBCSource() throws Exception {
        String queryString = new String("jdbc:postgresql://meteora.di.uoa.gr:5432/dellstore2?user=postgres&password=aplagiadb/SELECT+*+FROM+spdtrees");
        String inputType = "JDBC";
        String inputValue = queryString;
        HashMap<String, String> inputParameters = new HashMap<String, String>();
        DataSourceOp ds = new DataSourceOp(inputType, inputValue, (Map<String, String>)inputParameters);
        URI uri = ds.compute();
        return uri;
    }

    public static String inputStreamToString(InputStream inputStream) throws IOException {
        InputStream in = inputStream;
        InputStreamReader is = new InputStreamReader(in);
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(is);
        String read = br.readLine();
        while (read != null) {
            sb.append(read);
            read = br.readLine();
        }
        return sb.toString();
    }
}

