package org.gcube.vremanagement.softwaregateway.client;

import java.rmi.RemoteException;

import javax.xml.rpc.ServiceException;

import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI.MalformedURIException;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScope.MalformedScopeExpressionException;
import org.gcube.vremanagement.softwaregateway.stubs.AccessPortType;
import org.gcube.vremanagement.softwaregateway.stubs.SACoordinates;
import org.gcube.vremanagement.softwaregateway.stubs.service.AccessServiceAddressingLocator;

public class GetSALocationClient {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		for (int i=0; i<args.length;i++) 
			System.out.println("param N." +i + ": " + args[i]);
		
		if(args.length != 7 ){
			System.out.println("Usage:");
			System.out.println("\tjava  GetSALocationClient   SoftwareGatewayEPR  scope  ServiceName   ServiceClass   ServiceVersion   PackageName   PackageVersion\n\n");
			System.out.println("Example:");
			System.out.println("\tjava  GetSALocationClient  http://node2.d.d4science.research-infrastructures.eu:9001/wsrf/services/gcube/vremanagement/softwaregateway/Access  /gcube/devsec sn sc sv pn pv  \n\n");
			return;
		}
		EndpointReferenceType endpoint = new EndpointReferenceType();
		try {
			endpoint.setAddress(new AttributedURI(args[0]));
		} catch (MalformedURIException e) {
			e.printStackTrace();
			return;
		}
		
		AccessPortType stub;

		try {
			stub = new AccessServiceAddressingLocator().getAccessPortTypePort(endpoint);
		} catch (ServiceException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return;
		}
		try {
			stub=GCUBERemotePortTypeContext.getProxy(stub,GCUBEScope.getScope(args[1]));
		} catch (MalformedScopeExpressionException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
			return;
		}
		
		String serviceClass=args[2];
		String serviceName=args[3];
		String serviceVersion=args[4];
		String packageName=args[5];
		String packageVersion=args[6];

		SACoordinates pc=new SACoordinates();
		pc.setPackageName(packageName);
		pc.setPackageVersion(packageVersion);
		pc.setServiceClass(serviceClass);
		pc.setServiceName(serviceName);
		pc.setServiceVersion(serviceVersion);
		String url=null;
		try {
			url = stub.getSALocation(pc);
		} catch (GCUBEFault e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RemoteException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		System.out.println("Remote url: \n"+url);

	}

}
