/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.HttpsURL;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.webdav.lib.Ace;
import org.apache.webdav.lib.Lock;
import org.apache.webdav.lib.Property;
import org.apache.webdav.lib.PropertyName;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.Subscription;
import org.apache.webdav.lib.WebdavResources;
import org.apache.webdav.lib.WebdavSession;
import org.apache.webdav.lib.WebdavState;
import org.apache.webdav.lib.methods.AclMethod;
import org.apache.webdav.lib.methods.AclReportMethod;
import org.apache.webdav.lib.methods.BindMethod;
import org.apache.webdav.lib.methods.CheckinMethod;
import org.apache.webdav.lib.methods.CheckoutMethod;
import org.apache.webdav.lib.methods.CopyMethod;
import org.apache.webdav.lib.methods.DeleteMethod;
import org.apache.webdav.lib.methods.LabelMethod;
import org.apache.webdav.lib.methods.LockMethod;
import org.apache.webdav.lib.methods.MkWorkspaceMethod;
import org.apache.webdav.lib.methods.MkcolMethod;
import org.apache.webdav.lib.methods.MoveMethod;
import org.apache.webdav.lib.methods.OptionsMethod;
import org.apache.webdav.lib.methods.PollMethod;
import org.apache.webdav.lib.methods.PropFindMethod;
import org.apache.webdav.lib.methods.PropPatchMethod;
import org.apache.webdav.lib.methods.RebindMethod;
import org.apache.webdav.lib.methods.ReportMethod;
import org.apache.webdav.lib.methods.SubscribeMethod;
import org.apache.webdav.lib.methods.UnbindMethod;
import org.apache.webdav.lib.methods.UncheckoutMethod;
import org.apache.webdav.lib.methods.UnlockMethod;
import org.apache.webdav.lib.methods.UnsubscribeMethod;
import org.apache.webdav.lib.methods.UpdateMethod;
import org.apache.webdav.lib.methods.VersionControlMethod;
import org.apache.webdav.lib.properties.AclProperty;
import org.apache.webdav.lib.properties.LockDiscoveryProperty;
import org.apache.webdav.lib.properties.PrincipalCollectionSetProperty;
import org.apache.webdav.lib.properties.ResourceTypeProperty;
import org.apache.webdav.lib.util.DOMUtils;
import org.apache.webdav.lib.util.WebdavStatus;

public class WebdavResource
extends WebdavSession {
    public static final String DISPLAYNAME = "displayname";
    public static final String GETCONTENTLANGUAGE = "getcontentlanguage";
    public static final String GETCONTENTLENGTH = "getcontentlength";
    public static final String GETLASTMODIFIED = "getlastmodified";
    public static final String CREATIONDATE = "creationdate";
    public static final String RESOURCETYPE = "resourcetype";
    public static final String SOURCE = "source";
    public static final String GETCONTENTTYPE = "getcontenttype";
    public static final String GETETAG = "getetag";
    public static final String ISHIDDEN = "ishidden";
    public static final String ISCOLLECTION = "iscollection";
    public static final String SUPPORTEDLOCK = "supportedlock";
    public static final String LOCKDISCOVERY = "lockdiscovery";
    public static final int NOACTION = 1;
    public static final int NAME = 2;
    public static final int BASIC = 3;
    public static final int DEFAULT = 4;
    public static final int ALL = 5;
    public static final int OPTIONS_WORKSPACE = 8;
    public static final int OPTIONS_VERSION_HISTORY = 9;
    public static final int LABEL_SET = 10;
    public static final int LABEL_REMOVE = 11;
    public static final int LABEL_ADD = 12;
    public static final String defaultOwner = "Slide";
    public static final String TRUE = "1";
    public static final String FALSE = "0";
    public static final SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.sss'Z'", Locale.US)};
    protected static final TimeZone gmtZone = TimeZone.getTimeZone("GMT");
    protected HttpURL httpURL;
    protected WebdavResources childResources = new WebdavResources();
    protected static int defaultAction;
    protected static int defaultDepth;
    protected static String tempDirForGet;
    protected static boolean useDiskForGet;
    protected boolean thisResource;
    protected Enumeration allowedMethods;
    protected Enumeration davCapabilities;
    protected boolean exists;
    protected boolean overwrite;
    protected int latestStatusCode;
    protected String latestStatusMessage = "";
    protected String displayName = "";
    protected long getContentLength;
    protected String getContentType = "";
    protected ResourceTypeProperty resourceType;
    protected long getLastModified;
    protected long creationDate;
    protected String getEtag = "";
    protected String owner = null;
    protected boolean isHidden;
    protected boolean isCollection;
    protected String supportedLock = "";
    protected LockDiscoveryProperty lockDiscovery;
    protected boolean followRedirects = false;

    protected WebdavResource() {
    }

    protected WebdavResource(HttpClient client) {
        this.client = client;
    }

    public WebdavResource(HttpURL httpURL, Credentials credentials, int action, int depth) throws HttpException, IOException {
        this.setCredentials(credentials);
        this.setHttpURL(httpURL, action, depth);
    }

    public WebdavResource(HttpURL httpURL, int action, int depth) throws HttpException, IOException {
        this.setHttpURL(httpURL, action, depth);
    }

    public WebdavResource(HttpURL httpURL, int action, int depth, boolean followRedirects) throws HttpException, IOException {
        this.setFollowRedirects(this.followRedirects);
        this.setHttpURL(httpURL, action, depth);
    }

    public WebdavResource(HttpURL httpURL, int depth) throws HttpException, IOException {
        this.setHttpURL(httpURL, defaultAction, depth);
    }

    public WebdavResource(HttpURL httpURL, int depth, boolean followRedirects) throws HttpException, IOException {
        this.setFollowRedirects(followRedirects);
        this.setHttpURL(httpURL, defaultAction, depth);
    }

    public WebdavResource(HttpURL httpURL) throws HttpException, IOException {
        this.setHttpURL(httpURL);
    }

    public WebdavResource(HttpURL httpURL, boolean followRedirects) throws HttpException, IOException {
        this.setFollowRedirects(followRedirects);
        this.setHttpURL(httpURL);
    }

    public WebdavResource(HttpURL httpURL, String proxyHost, int proxyPort) throws HttpException, IOException {
        this.setProxy(proxyHost, proxyPort);
        this.setHttpURL(httpURL);
    }

    public WebdavResource(HttpURL httpURL, String proxyHost, int proxyPort, boolean followRedirects) throws HttpException, IOException {
        this.setFollowRedirects(followRedirects);
        this.setProxy(proxyHost, proxyPort);
        this.setHttpURL(httpURL);
    }

    public WebdavResource(HttpURL httpURL, String proxyHost, int proxyPort, Credentials proxyCredentials) throws HttpException, IOException {
        this.setProxy(proxyHost, proxyPort);
        this.setProxyCredentials(proxyCredentials);
        this.setHttpURL(httpURL);
    }

    public WebdavResource(HttpURL httpURL, String proxyHost, int proxyPort, Credentials proxyCredentials, boolean followRedirects) throws HttpException, IOException {
        this.setFollowRedirects(followRedirects);
        this.setProxy(proxyHost, proxyPort);
        this.setProxyCredentials(proxyCredentials);
        this.setHttpURL(httpURL);
    }

    public WebdavResource(String escapedHttpURL) throws HttpException, IOException {
        this.setHttpURL(escapedHttpURL);
    }

    public WebdavResource(String escapedHttpURL, boolean followRedirects) throws HttpException, IOException {
        this.setFollowRedirects(followRedirects);
        this.setHttpURL(escapedHttpURL);
    }

    public WebdavResource(String escapedHttpURL, Credentials credentials) throws HttpException, IOException {
        this.setCredentials(credentials);
        this.setHttpURL(escapedHttpURL);
    }

    public WebdavResource(String escapedHttpURL, Credentials credentials, boolean followRedirects) throws HttpException, IOException {
        this.setFollowRedirects(followRedirects);
        this.setCredentials(credentials);
        this.setHttpURL(escapedHttpURL);
    }

    public WebdavResource(String escapedHttpURL, String proxyHost, int proxyPort) throws HttpException, IOException {
        this.setProxy(proxyHost, proxyPort);
        this.setHttpURL(escapedHttpURL);
    }

    public WebdavResource(String escapedHttpURL, String proxyHost, int proxyPort, Credentials proxyCredentials) throws HttpException, IOException {
        this.setProxy(proxyHost, proxyPort);
        this.setProxyCredentials(proxyCredentials);
        this.setHttpURL(escapedHttpURL);
    }

    public WebdavResource(HttpURL httpURL, String additionalPath) throws HttpException, IOException {
        this.setHttpURL(httpURL, additionalPath);
    }

    public WebdavResource(HttpURL httpURL, String additionalPath, boolean followRedirects) throws HttpException, IOException {
        this.setFollowRedirects(followRedirects);
        this.setHttpURL(httpURL, additionalPath);
    }

    protected void generateTransactionHeader(HttpMethod method) {
        if (this.client == null || method == null) {
            return;
        }
        WebdavState state = (WebdavState)this.client.getState();
        String txHandle = state.getTransactionHandle();
        if (txHandle != null) {
            method.setRequestHeader("Transaction", "<" + txHandle + ">");
        }
    }

    protected void generateIfHeader(HttpMethod method) {
        if (this.client == null) {
            return;
        }
        if (method == null) {
            return;
        }
        WebdavState state = (WebdavState)this.client.getState();
        String[] lockTokens = state.getAllLocks(method.getPath());
        if (lockTokens.length == 0) {
            return;
        }
        StringBuffer ifHeaderValue = new StringBuffer();
        for (int i = 0; i < lockTokens.length; ++i) {
            ifHeaderValue.append("(<").append(lockTokens[i]).append(">) ");
        }
        method.setRequestHeader("If", ifHeaderValue.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date parseDate(String dateValue) {
        Date date = null;
        for (int i = 0; date == null && i < formats.length; ++i) {
            try {
                SimpleDateFormat simpleDateFormat = formats[i];
                synchronized (simpleDateFormat) {
                    date = formats[i].parse(dateValue);
                    continue;
                }
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        return date;
    }

    protected void setNameProperties(int depth) throws HttpException, IOException {
        Vector<String> properties = new Vector<String>();
        properties.addElement(DISPLAYNAME);
        this.setNamedProp(depth, properties);
    }

    protected void setBasicProperties(int depth) throws HttpException, IOException {
        Vector<String> properties = new Vector<String>();
        properties.addElement(DISPLAYNAME);
        properties.addElement(GETCONTENTLENGTH);
        properties.addElement(GETCONTENTTYPE);
        properties.addElement(RESOURCETYPE);
        properties.addElement(GETLASTMODIFIED);
        properties.addElement(LOCKDISCOVERY);
        this.setNamedProp(depth, properties);
    }

    protected void setDefaultProperties(int depth) throws HttpException, IOException {
        Vector<String> properties = new Vector<String>();
        properties.addElement(CREATIONDATE);
        properties.addElement(DISPLAYNAME);
        properties.addElement(GETCONTENTLANGUAGE);
        properties.addElement(GETCONTENTLENGTH);
        properties.addElement(GETCONTENTTYPE);
        properties.addElement(GETETAG);
        properties.addElement(GETLASTMODIFIED);
        properties.addElement(LOCKDISCOVERY);
        properties.addElement(RESOURCETYPE);
        properties.addElement(SOURCE);
        properties.addElement(SUPPORTEDLOCK);
        this.setNamedProp(depth, properties);
    }

    protected void setNamedProp(int depth, Vector propertyNames) throws HttpException, IOException {
        Enumeration responses = this.propfindMethod(depth, propertyNames);
        this.setWebdavProperties(responses);
    }

    protected void setAllProp(int depth) throws HttpException, IOException {
        Enumeration responses = this.propfindMethod(depth);
        this.setWebdavProperties(responses);
    }

    protected void setWebdavProperties(Enumeration responses) throws HttpException, IOException {
        this.childResources.removeAll();
        while (responses.hasMoreElements()) {
            ResponseEntity response = (ResponseEntity)responses.nextElement();
            boolean itself = false;
            String href = response.getHref();
            if (!href.startsWith("/")) {
                href = URIUtil.getPath(href);
            }
            href = WebdavResource.decodeMarks(href);
            String httpURLPath = this.httpURL.getPath();
            String escapedHref = URIUtil.decode(href);
            int lenDiff = escapedHref.length() - httpURLPath.length();
            int compareLen = 0;
            if (lenDiff == -1 && !escapedHref.endsWith("/")) {
                compareLen = escapedHref.length();
                lenDiff = 0;
            } else if (lenDiff == 1 && !httpURLPath.endsWith("/")) {
                compareLen = httpURLPath.length();
                lenDiff = 0;
            }
            if (lenDiff == 0 && (compareLen == 0 && httpURLPath.equals(escapedHref) || httpURLPath.regionMatches(0, escapedHref, 0, compareLen))) {
                if (response.getStatusCode() > 0) {
                    this.setStatusCode(response.getStatusCode());
                }
                this.setExistence(true);
                itself = true;
            }
            WebdavResource workingResource = null;
            if (itself) {
                workingResource = this;
            } else {
                workingResource = this.createWebdavResource(this.client);
                workingResource.setDebug(this.debug);
            }
            workingResource.setLockDiscovery(null);
            Enumeration properties = response.getProperties();
            while (properties.hasMoreElements()) {
                Property property = (Property)properties.nextElement();
                workingResource.processProperty(property);
            }
            String displayName = workingResource.getDisplayName();
            if (displayName == null || displayName.trim().equals("")) {
                displayName = WebdavResource.getName(href);
            }
            if (!itself) {
                String myURI = this.httpURL.getEscapedURI();
                char[] childURI = (myURI + (myURI.endsWith("/") ? "" : "/") + URIUtil.getName(href)).toCharArray();
                HttpURL childURL = this.httpURL instanceof HttpsURL ? new HttpsURL(childURI) : new HttpURL(childURI);
                childURL.setRawAuthority(this.httpURL.getRawAuthority());
                workingResource.setHttpURL(childURL, 1, defaultDepth);
                workingResource.setExistence(true);
                workingResource.setOverwrite(this.getOverwrite());
            }
            workingResource.setDisplayName(displayName);
            if (itself) continue;
            this.childResources.addResource(workingResource);
        }
    }

    public static void setDefaultAction(int action) {
        defaultAction = action;
    }

    public static int getDefaultAction() {
        return defaultAction;
    }

    public static void setDefaultDepth(int depth) {
        defaultDepth = depth;
    }

    public static int getDefaultDepth() {
        return defaultDepth;
    }

    public static void setGetTempDir(String tempDir) {
        tempDirForGet = tempDir;
    }

    public static String getGetTempDir() {
        return tempDirForGet;
    }

    public static void setGetUseDisk(boolean useDisk) {
    }

    public static boolean getGetUseDisk() {
        return false;
    }

    public void setFollowRedirects(boolean value) {
        this.followRedirects = value;
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    protected synchronized boolean isTheClient() throws URIException {
        boolean userMatches;
        HostConfiguration hostConfig = this.client.getHostConfiguration();
        Credentials creds = this.client.getState().getCredentials(null, hostConfig.getHost());
        String userName = null;
        String password = null;
        if (creds instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials upc = (UsernamePasswordCredentials)creds;
            userName = upc.getUserName();
            password = upc.getPassword();
        }
        String ref = this.httpURL.getUser();
        boolean bl = userName != null ? userName.equals(ref) : (userMatches = ref == null);
        if (!userMatches) {
            return false;
        }
        ref = this.httpURL.getPassword();
        userMatches = password != null ? password.equals(ref) : ref == null;
        if (userMatches) {
            return this.httpURL.getHost().equalsIgnoreCase(hostConfig.getHost()) && this.httpURL.getPort() == hostConfig.getProtocol().resolvePort(hostConfig.getPort());
        }
        return false;
    }

    protected void setClient() throws IOException {
        this.setClient(this.httpURL);
    }

    protected synchronized void setClient(HttpURL httpURL) throws IOException {
        if (this.client == null) {
            this.client = this.getSessionInstance(httpURL);
        } else if (!this.isTheClient()) {
            this.closeSession();
            this.client = this.getSessionInstance(httpURL);
        }
    }

    public void setHttpURL(HttpURL httpURL, int action, int depth) throws HttpException, IOException {
        this.httpURL = httpURL;
        this.setClient(httpURL);
        this.setExistence(false);
        this.setProperties(action, depth);
    }

    public void setHttpURL(HttpURL httpURL, int depth) throws HttpException, IOException {
        this.setHttpURL(httpURL, defaultAction, depth);
    }

    public void setHttpURL(HttpURL httpURL, String additionalPath, int action, int depth) throws HttpException, IOException {
        this.setHttpURL(httpURL instanceof HttpsURL ? new HttpsURL((HttpsURL)httpURL, additionalPath) : new HttpURL(httpURL, additionalPath), action, depth);
    }

    public void setHttpURL(HttpURL httpURL, String additionalPath, int action) throws HttpException, IOException {
        this.setHttpURL(httpURL instanceof HttpsURL ? new HttpsURL((HttpsURL)httpURL, additionalPath) : new HttpURL(httpURL, additionalPath), action, defaultDepth);
    }

    public void setHttpURL(HttpURL httpURL, String additionalPath) throws HttpException, IOException {
        this.setHttpURL(httpURL instanceof HttpsURL ? new HttpsURL((HttpsURL)httpURL, additionalPath) : new HttpURL(httpURL, additionalPath), defaultAction, defaultDepth);
    }

    public void setHttpURL(HttpURL httpURL) throws HttpException, IOException {
        this.setHttpURL(httpURL, defaultDepth);
    }

    public void setHttpURL(String escapedHttpURL) throws HttpException, IOException {
        this.setHttpURL(escapedHttpURL.startsWith("https") ? new HttpsURL(escapedHttpURL) : new HttpURL(escapedHttpURL));
    }

    public HttpURL getHttpURL() {
        return this.httpURL;
    }

    public HttpURL getHttpURLExceptForUserInfo() throws URIException {
        return this.httpURL instanceof HttpsURL ? new HttpsURL(this.httpURL.getRawURI()) : new HttpURL(this.httpURL.getRawURI());
    }

    public void setPath(String path) throws HttpException, IOException {
        this.httpURL.setPath(path);
        this.setHttpURL(this.httpURL);
    }

    public String getPath() {
        try {
            return this.httpURL.getPath();
        }
        catch (URIException e) {
            return this.httpURL.getEscapedPath();
        }
    }

    public String getName() {
        return WebdavResource.getName(this.httpURL.getEscapedPath());
    }

    public String getHost() throws URIException {
        return this.httpURL.getHost();
    }

    public void setUserInfo(String userName, String password) throws HttpException, IOException {
        this.httpURL.setUserinfo(userName, password);
        this.setHttpURL(this.httpURL);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    protected void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public long getGetContentLength() {
        return this.getContentLength;
    }

    protected void setGetContentLength(long getContentLength) {
        this.getContentLength = getContentLength;
    }

    protected void setGetContentLength(String getContentLength) {
        try {
            this.getContentLength = Long.parseLong(getContentLength);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public ResourceTypeProperty getResourceType() {
        return this.resourceType;
    }

    protected void setResourceType(ResourceTypeProperty resourceType) {
        this.resourceType = resourceType;
    }

    public boolean isCollection() {
        if (this.getResourceType() == null) {
            return false;
        }
        return this.getResourceType().isCollection();
    }

    public String getGetContentType() {
        return this.getContentType;
    }

    protected void setGetContentType(String getContentType) {
        this.getContentType = getContentType;
    }

    public void setContentType(String contentType) {
        this.getContentType = contentType;
    }

    public long getGetLastModified() {
        return this.getLastModified;
    }

    protected void setGetLastModified(long getLastModified) {
        this.getLastModified = getLastModified;
    }

    protected void setGetLastModified(String getLastModified) {
        Date date = this.parseDate(getLastModified);
        if (date != null) {
            this.getLastModified = date.getTime();
        }
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    protected void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    protected void setCreationDate(String creationDate) {
        Date date = this.parseDate(creationDate);
        if (date != null) {
            this.creationDate = date.getTime();
        }
    }

    public String getGetEtag() {
        return this.getEtag;
    }

    protected void setGetEtag(String getEtag) {
        this.getEtag = getEtag;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getSupportedLock() {
        return this.supportedLock;
    }

    protected void setSupportedLock(String supportedLock) {
        this.supportedLock = supportedLock;
    }

    public LockDiscoveryProperty getLockDiscovery() {
        return this.lockDiscovery;
    }

    protected void setLockDiscovery(LockDiscoveryProperty lockDiscovery) {
        this.lockDiscovery = lockDiscovery;
    }

    public Enumeration getActiveLockOwners() {
        if (this.lockDiscovery == null) {
            return null;
        }
        Lock[] activeLocks = this.lockDiscovery.getActiveLocks();
        if (activeLocks == null) {
            return null;
        }
        Vector<String> buff = new Vector<String>();
        int count = activeLocks.length;
        for (int i = 0; i < count; ++i) {
            buff.addElement(activeLocks[i].getOwner());
        }
        return buff.elements();
    }

    public boolean isLocked() {
        if (this.lockDiscovery == null) {
            return false;
        }
        Lock[] activeLocks = this.lockDiscovery.getActiveLocks();
        if (activeLocks == null) {
            return false;
        }
        for (int i = 0; i < activeLocks.length; ++i) {
            if (activeLocks[i].getLockType() != 0) continue;
            return true;
        }
        return false;
    }

    public boolean getIsHidden() {
        return this.isHidden;
    }

    protected void setIsHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    protected void setIsHidden(String isHidden) {
        this.isHidden = isHidden.equals(TRUE);
    }

    public boolean getIsCollection() {
        return this.isCollection;
    }

    protected void setIsCollection(boolean isCollection) {
        this.isCollection = isCollection;
    }

    protected void setIsCollection(String isCollection) {
        this.isCollection = isCollection.equals(TRUE);
    }

    public void setProperties(int action, int depth) throws HttpException, IOException {
        switch (action) {
            case 2: {
                this.setNameProperties(depth);
                break;
            }
            case 3: {
                this.setBasicProperties(depth);
                break;
            }
            case 4: {
                this.setDefaultProperties(depth);
                break;
            }
            case 5: {
                this.setAllProp(depth);
                break;
            }
        }
    }

    public void setProperties(int depth) throws HttpException, IOException {
        this.setProperties(defaultAction, depth);
    }

    protected void refresh() throws HttpException, IOException {
        int latestStatusCode = this.latestStatusCode;
        String latestStatusMessage = this.latestStatusMessage;
        this.setProperties(0);
        this.latestStatusCode = latestStatusCode;
        this.latestStatusMessage = latestStatusMessage;
    }

    public boolean exists() {
        return this.getExistence();
    }

    protected void setExistence(boolean exists) {
        this.exists = exists;
    }

    public boolean getExistence() {
        return this.exists;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public void close() throws IOException {
        this.closeSession();
    }

    public String getStatusMessage() {
        return this.latestStatusMessage;
    }

    public int getStatusCode() {
        return this.latestStatusCode;
    }

    protected void setStatusCode(int statusCode) {
        this.setStatusCode(statusCode, null);
    }

    protected void setStatusCode(int statusCode, String message) {
        this.latestStatusCode = statusCode;
        this.latestStatusMessage = WebdavStatus.getStatusText(statusCode) + " (" + statusCode + ")" + (message == null ? "" : message);
    }

    public Enumeration getAllowedMethods() {
        return this.allowedMethods;
    }

    public Enumeration getDavCapabilities() {
        return this.davCapabilities;
    }

    public WebdavResources getChildResources() throws HttpException, IOException {
        this.setProperties(1);
        return this.childResources;
    }

    public WebdavResource[] listWebdavResources() throws HttpException, IOException {
        return this.getChildResources().listResources();
    }

    public String[] list() {
        try {
            this.setNameProperties(1);
        }
        catch (IOException e) {
            return null;
        }
        Enumeration hrefs = this.childResources.getResourceNames();
        Vector<String> hrefList = new Vector<String>();
        while (hrefs.hasMoreElements()) {
            hrefList.addElement((String)hrefs.nextElement());
        }
        int num = hrefList.size();
        String[] pathnames = new String[num];
        for (int i = 0; i < num; ++i) {
            pathnames[i] = (String)hrefList.elementAt(i);
        }
        return pathnames;
    }

    public Vector listBasic() throws HttpException, IOException {
        this.setBasicProperties(1);
        Enumeration hrefs = this.childResources.getResourceNames();
        Vector<String[]> hrefList = new Vector<String[]>();
        while (hrefs.hasMoreElements()) {
            try {
                String resourceName = (String)hrefs.nextElement();
                WebdavResource currentResource = this.childResources.getResource(resourceName);
                String[] longFormat = new String[5];
                longFormat[0] = currentResource.getDisplayName();
                long length = currentResource.getGetContentLength();
                longFormat[1] = new Long(length).toString();
                ResourceTypeProperty resourceTypeProperty = currentResource.getResourceType();
                String getContentType = currentResource.getGetContentType();
                longFormat[2] = resourceTypeProperty.isCollection() ? "COLLECTION" : getContentType;
                Date date = new Date(currentResource.getGetLastModified());
                longFormat[3] = date == null ? "-- -- ----" : DateFormat.getDateTimeInstance().format(date);
                hrefList.addElement(longFormat);
                longFormat[4] = currentResource.getName();
            }
            catch (Exception e) {
                if (this.debug <= 0) continue;
                e.printStackTrace();
            }
        }
        return hrefList;
    }

    public void setEncodeURLs(boolean encodeURLs) {
    }

    public HttpClient retrieveSessionInstance() throws IOException {
        this.setClient();
        return this.client;
    }

    public int executeHttpRequestMethod(HttpClient client, HttpMethod method) throws IOException, HttpException {
        client.executeMethod(method);
        return method.getStatusCode();
    }

    public boolean aclMethod(String path, Ace[] aces) throws HttpException, IOException {
        this.setClient();
        AclMethod method = new AclMethod(URIUtil.encodePath(path));
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(method);
        for (int i = 0; i < aces.length; ++i) {
            Ace ace = aces[i];
            method.addAce(ace);
        }
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public AclProperty aclfindMethod() throws HttpException, IOException {
        this.thisResource = true;
        return this.aclfindMethod(this.httpURL.getPath());
    }

    public AclProperty aclfindMethod(String path) throws HttpException, IOException {
        this.setClient();
        AclProperty acl = null;
        Vector<String> properties = new Vector<String>();
        properties.addElement("acl");
        PropFindMethod method = new PropFindMethod(URIUtil.encodePath(path), 0, properties.elements());
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(method);
        this.client.executeMethod(method);
        Enumeration responses = method.getResponses();
        if (responses.hasMoreElements()) {
            ResponseEntity response = (ResponseEntity)responses.nextElement();
            String href = response.getHref();
            if (this.thisResource && response.getStatusCode() > 0) {
                this.setStatusCode(response.getStatusCode());
            }
            this.thisResource = false;
            Enumeration responseProperties = method.getResponseProperties(href);
            while (responseProperties.hasMoreElements()) {
                Property property = (Property)responseProperties.nextElement();
                if (!(property instanceof AclProperty)) continue;
                acl = (AclProperty)property;
            }
        }
        return acl;
    }

    public PrincipalCollectionSetProperty principalCollectionSetFindMethod() throws HttpException, IOException {
        this.thisResource = true;
        return this.principalCollectionSetFindMethod(this.httpURL.getPath());
    }

    public PrincipalCollectionSetProperty principalCollectionSetFindMethod(String path) throws HttpException, IOException {
        this.setClient();
        PrincipalCollectionSetProperty set = null;
        Vector<String> properties = new Vector<String>();
        properties.addElement("principal-collection-set");
        PropFindMethod method = new PropFindMethod(URIUtil.encodePath(path), 0, properties.elements());
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(method);
        this.client.executeMethod(method);
        Enumeration responses = method.getResponses();
        if (responses.hasMoreElements()) {
            ResponseEntity response = (ResponseEntity)responses.nextElement();
            String href = response.getHref();
            if (this.thisResource && response.getStatusCode() > 0) {
                this.setStatusCode(response.getStatusCode());
            }
            this.thisResource = false;
            Enumeration responseProperties = method.getResponseProperties(href);
            while (responseProperties.hasMoreElements()) {
                Property property = (Property)responseProperties.nextElement();
                if (!(property instanceof PrincipalCollectionSetProperty)) continue;
                set = (PrincipalCollectionSetProperty)property;
            }
        }
        return set;
    }

    public LockDiscoveryProperty lockDiscoveryPropertyFindMethod() throws HttpException, IOException {
        this.thisResource = true;
        return this.lockDiscoveryPropertyFindMethod(this.httpURL.getPath());
    }

    public LockDiscoveryProperty lockDiscoveryPropertyFindMethod(String path) throws HttpException, IOException {
        this.setClient();
        LockDiscoveryProperty set = null;
        Vector<String> properties = new Vector<String>();
        properties.addElement(LOCKDISCOVERY);
        PropFindMethod method = new PropFindMethod(URIUtil.encodePath(path), 0, properties.elements());
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(method);
        this.client.executeMethod(method);
        Enumeration responses = method.getResponses();
        if (responses.hasMoreElements()) {
            ResponseEntity response = (ResponseEntity)responses.nextElement();
            String href = response.getHref();
            if (this.thisResource && response.getStatusCode() > 0) {
                this.setStatusCode(response.getStatusCode());
            }
            this.thisResource = false;
            Enumeration responseProperties = method.getResponseProperties(href);
            while (responseProperties.hasMoreElements()) {
                Property property = (Property)responseProperties.nextElement();
                if (!(property instanceof LockDiscoveryProperty)) continue;
                set = (LockDiscoveryProperty)property;
            }
        }
        return set;
    }

    public InputStream getMethodData() throws HttpException, IOException {
        return this.getMethodData(this.httpURL.getPathQuery());
    }

    public InputStream getMethodData(String path) throws HttpException, IOException {
        this.setClient();
        GetMethod method = new GetMethod(URIUtil.encodePathQuery(path));
        this.generateTransactionHeader(method);
        this.client.executeMethod(method);
        int statusCode = method.getStatusLine().getStatusCode();
        this.setStatusCode(statusCode);
        if (statusCode >= 200 && statusCode < 300) {
            return method.getResponseBodyAsStream();
        }
        throw new IOException("Couldn't get file");
    }

    public String getMethodDataAsString() throws HttpException, IOException {
        return this.getMethodDataAsString(this.httpURL.getPathQuery());
    }

    public String getMethodDataAsString(String path) throws HttpException, IOException {
        this.setClient();
        GetMethod method = new GetMethod(URIUtil.encodePathQuery(path));
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        this.setStatusCode(statusCode);
        return method.getResponseBodyAsString();
    }

    public boolean getMethod(File file) throws HttpException, IOException {
        return this.getMethod(this.httpURL.getPathQuery(), file);
    }

    public boolean getMethod(String path, File file) throws HttpException, IOException {
        this.setClient();
        GetMethod method = new GetMethod(URIUtil.encodePathQuery(path));
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        this.setStatusCode(statusCode);
        if (statusCode >= 200 && statusCode < 300) {
            int bytesRead;
            InputStream inStream = method.getResponseBodyAsStream();
            FileOutputStream fos = new FileOutputStream(file);
            byte[] buffer = new byte[65535];
            while ((bytesRead = inStream.read(buffer)) >= 0) {
                fos.write(buffer, 0, bytesRead);
            }
            inStream.close();
            fos.close();
            return true;
        }
        return false;
    }

    public boolean putMethod(byte[] data) throws HttpException, IOException {
        boolean result = this.putMethod(this.httpURL.getPathQuery(), data);
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean putMethod(String path, byte[] data) throws HttpException, IOException {
        this.setClient();
        PutMethod method = new PutMethod(URIUtil.encodePathQuery(path));
        this.generateIfHeader(method);
        if (this.getGetContentType() != null && !this.getGetContentType().equals("")) {
            method.setRequestHeader("Content-Type", this.getGetContentType());
        }
        method.setRequestHeader("Content-Length", String.valueOf(data.length));
        method.setRequestBody(new ByteArrayInputStream(data));
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean putMethod(InputStream is) throws HttpException, IOException {
        return this.putMethod(this.httpURL.getPathQuery(), is);
    }

    public boolean putMethod(String path, InputStream is) throws HttpException, IOException {
        this.setClient();
        PutMethod method = new PutMethod(URIUtil.encodePathQuery(path));
        this.generateIfHeader(method);
        if (this.getGetContentType() != null && !this.getGetContentType().equals("")) {
            method.setRequestHeader("Content-Type", this.getGetContentType());
        }
        method.setRequestContentLength(-1);
        method.setRequestBody(is);
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean putMethod(String data) throws HttpException, IOException {
        boolean result = this.putMethod(this.httpURL.getPathQuery(), data);
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean putMethod(String path, String data) throws HttpException, IOException {
        this.setClient();
        PutMethod method = new PutMethod(URIUtil.encodePathQuery(path));
        this.generateIfHeader(method);
        if (this.getGetContentType() != null && !this.getGetContentType().equals("")) {
            method.setRequestHeader("Content-Type", this.getGetContentType());
        }
        method.setRequestBody(data);
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean putMethod(File file) throws HttpException, IOException {
        boolean result = this.putMethod(this.httpURL.getPathQuery(), file);
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean putMethod(String path, File file) throws HttpException, IOException {
        long fileLength;
        this.setClient();
        PutMethod method = new PutMethod(URIUtil.encodePathQuery(path));
        this.generateIfHeader(method);
        if (this.getGetContentType() != null && !this.getGetContentType().equals("")) {
            method.setRequestHeader("Content-Type", this.getGetContentType());
        }
        method.setRequestContentLength((fileLength = file.length()) <= Integer.MAX_VALUE ? (int)fileLength : -1);
        method.setRequestBody(new FileInputStream(file));
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean putMethod(URL url) throws HttpException, IOException {
        boolean result = this.putMethod(this.httpURL.getPathQuery(), url);
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean putMethod(String path, URL url) throws HttpException, IOException {
        this.setClient();
        PutMethod method = new PutMethod(URIUtil.encodePathQuery(path));
        this.generateIfHeader(method);
        if (this.getGetContentType() != null && !this.getGetContentType().equals("")) {
            method.setRequestHeader("Content-Type", this.getGetContentType());
        }
        method.setRequestBody(url.openStream());
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean optionsMethod() throws HttpException, IOException {
        return this.optionsMethod(this.httpURL.getPath());
    }

    public boolean optionsMethod(String path) throws HttpException, IOException {
        this.setClient();
        OptionsMethod method = path.trim().equals("*") ? new OptionsMethod("*") : new OptionsMethod(URIUtil.encodePath(path));
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        this.setStatusCode(statusCode);
        if (statusCode >= 200 && statusCode < 300) {
            this.allowedMethods = method.getAllowedMethods();
            this.davCapabilities = method.getDavCapabilities();
            return true;
        }
        return false;
    }

    public boolean optionsMethod(String path, String aMethod) throws HttpException, IOException {
        if (aMethod != null && this.optionsMethod(path)) {
            while (this.allowedMethods.hasMoreElements()) {
                if (!aMethod.equalsIgnoreCase((String)this.allowedMethods.nextElement())) continue;
                return true;
            }
        }
        return false;
    }

    public Enumeration optionsMethod(HttpURL httpURL) throws HttpException, IOException {
        HttpClient client = this.getSessionInstance(httpURL, true);
        OptionsMethod method = new OptionsMethod(httpURL.getEscapedPath());
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(method);
        client.executeMethod(method);
        Vector options = new Vector();
        int statusCode = method.getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            Enumeration allowedMethods = method.getAllowedMethods();
            while (allowedMethods.hasMoreElements()) {
                options.addElement(allowedMethods.nextElement());
            }
            Enumeration davCapabilities = method.getDavCapabilities();
            while (davCapabilities.hasMoreElements()) {
                options.addElement(davCapabilities.nextElement());
            }
            Enumeration responses = method.getResponses();
            if (responses.hasMoreElements()) {
                ResponseEntity response = (ResponseEntity)responses.nextElement();
                Enumeration workspaces = response.getWorkspaces();
                String sResult = "";
                while (workspaces.hasMoreElements()) {
                    sResult = sResult + workspaces.nextElement().toString();
                }
                Enumeration histories = response.getHistories();
                while (histories.hasMoreElements()) {
                    sResult = sResult + histories.nextElement().toString();
                }
                if (this.thisResource && response.getStatusCode() > 0) {
                    this.setStatusCode(response.getStatusCode());
                }
                this.thisResource = false;
                options.addElement(sResult);
            }
        }
        return options.elements();
    }

    public Enumeration optionsMethod(HttpURL httpURL, int type) throws HttpException, IOException {
        Enumeration responses;
        HttpClient client = this.getSessionInstance(httpURL, true);
        OptionsMethod method = new OptionsMethod(httpURL.getEscapedPath(), type);
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(method);
        client.executeMethod(method);
        Vector<String> options = new Vector<String>();
        int statusCode = method.getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300 && (responses = method.getResponses()).hasMoreElements()) {
            ResponseEntity response = (ResponseEntity)responses.nextElement();
            if (type == 8) {
                Enumeration workspaces = response.getWorkspaces();
                while (workspaces.hasMoreElements()) {
                    options.add(workspaces.nextElement().toString());
                }
            } else if (type == 9) {
                Enumeration histories = response.getHistories();
                while (histories.hasMoreElements()) {
                    options.add(histories.nextElement().toString());
                }
            }
            if (this.thisResource && response.getStatusCode() > 0) {
                this.setStatusCode(response.getStatusCode());
            }
            this.thisResource = false;
        }
        return options.elements();
    }

    public Enumeration optionsMethod(String path, int type) throws HttpException, IOException {
        Enumeration responses;
        this.setClient();
        OptionsMethod method = new OptionsMethod(URIUtil.encodePath(path), type);
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(method);
        this.client.executeMethod(method);
        Vector<String> options = new Vector<String>();
        int statusCode = method.getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300 && (responses = method.getResponses()).hasMoreElements()) {
            ResponseEntity response = (ResponseEntity)responses.nextElement();
            if (type == 8) {
                Enumeration workspaces = response.getWorkspaces();
                while (workspaces.hasMoreElements()) {
                    options.add(workspaces.nextElement().toString());
                }
            } else if (type == 9) {
                Enumeration histories = response.getHistories();
                while (histories.hasMoreElements()) {
                    options.add(histories.nextElement().toString());
                }
            }
            if (this.thisResource && response.getStatusCode() > 0) {
                this.setStatusCode(response.getStatusCode());
            }
            this.thisResource = false;
        }
        return options.elements();
    }

    public boolean labelMethod(String labelname, int type) throws HttpException, IOException {
        return this.labelMethod(this.httpURL.getPath(), labelname, type);
    }

    public boolean labelMethod(String path, String labelname, int type) throws HttpException, IOException {
        int labeltype = 0;
        switch (type) {
            case 10: {
                labeltype = 1;
                break;
            }
            case 11: {
                labeltype = 3;
                break;
            }
            case 12: {
                labeltype = 2;
            }
        }
        this.setClient();
        LabelMethod method = new LabelMethod(URIUtil.encodePath(path), labeltype, labelname);
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public Enumeration reportMethod(HttpURL httpURL, int depth) throws HttpException, IOException {
        this.setClient();
        ReportMethod method = new ReportMethod(httpURL.getEscapedPath(), depth);
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(method);
        this.client.executeMethod(method);
        Vector<String> results = new Vector<String>();
        Enumeration responses = method.getResponses();
        while (responses.hasMoreElements()) {
            String href;
            ResponseEntity response = (ResponseEntity)responses.nextElement();
            String sResult = href = response.getHref();
            if (this.thisResource && response.getStatusCode() > 0) {
                this.setStatusCode(response.getStatusCode());
            }
            this.thisResource = false;
            Enumeration responseProperties = method.getResponseProperties(href);
            while (responseProperties.hasMoreElements()) {
                Property property = (Property)responseProperties.nextElement();
                sResult = sResult + "\n" + property.getName() + ":\t" + DOMUtils.getTextValue(property.getElement());
            }
            results.addElement(sResult);
        }
        return results.elements();
    }

    public Enumeration reportMethod(HttpURL httpURL, Vector properties) throws HttpException, IOException {
        this.setClient();
        ReportMethod method = new ReportMethod(httpURL.getEscapedPath(), 0, properties.elements());
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(method);
        this.client.executeMethod(method);
        return method.getResponses();
    }

    public Enumeration reportMethod(HttpURL httpURL, Vector properties, int depth) throws HttpException, IOException {
        this.setClient();
        ReportMethod method = new ReportMethod(httpURL.getEscapedPath(), depth, properties.elements());
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(method);
        this.client.executeMethod(method);
        Vector<String> results = new Vector<String>();
        Enumeration responses = method.getResponses();
        while (responses.hasMoreElements()) {
            String href;
            ResponseEntity response = (ResponseEntity)responses.nextElement();
            String sResult = href = response.getHref();
            if (this.thisResource && response.getStatusCode() > 0) {
                this.setStatusCode(response.getStatusCode());
            }
            this.thisResource = false;
            Enumeration responseProperties = method.getResponseProperties(href);
            while (responseProperties.hasMoreElements()) {
                Property property = (Property)responseProperties.nextElement();
                sResult = sResult + "\n" + property.getName() + ":\t" + DOMUtils.getTextValue(property.getElement());
            }
            results.addElement(sResult);
        }
        return results.elements();
    }

    public Enumeration reportMethod(HttpURL httpURL, Vector properties, Vector histUri, int depth) throws HttpException, IOException {
        this.setClient();
        ReportMethod method = new ReportMethod(httpURL.getEscapedPath(), depth, properties.elements(), histUri.elements());
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(method);
        this.client.executeMethod(method);
        Vector<String> results = new Vector<String>();
        Enumeration responses = method.getResponses();
        while (responses.hasMoreElements()) {
            String href;
            ResponseEntity response = (ResponseEntity)responses.nextElement();
            String sResult = href = response.getHref();
            if (this.thisResource && response.getStatusCode() > 0) {
                this.setStatusCode(response.getStatusCode());
            }
            this.thisResource = false;
            Enumeration responseProperties = method.getResponseProperties(href);
            while (responseProperties.hasMoreElements()) {
                Property property = (Property)responseProperties.nextElement();
                sResult = sResult + "\n" + property.getName() + ":\t" + DOMUtils.getTextValue(property.getElement());
            }
            results.addElement(sResult);
        }
        return results.elements();
    }

    public Enumeration reportMethod(HttpURL httpURL, String sQuery, int depth) throws HttpException, IOException {
        this.setClient();
        ReportMethod method = new ReportMethod(httpURL.getEscapedPath(), depth, sQuery);
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(method);
        this.client.executeMethod(method);
        Vector<String> results = new Vector<String>();
        Enumeration responses = method.getResponses();
        while (responses.hasMoreElements()) {
            ResponseEntity response = (ResponseEntity)responses.nextElement();
            if (this.thisResource && response.getStatusCode() > 0) {
                this.setStatusCode(response.getStatusCode());
            }
            this.thisResource = false;
            String sResult = response.toString();
            results.addElement(sResult);
        }
        return results.elements();
    }

    public Enumeration propfindMethod(int depth) throws HttpException, IOException {
        this.thisResource = true;
        return this.propfindMethod(this.httpURL.getPath(), depth);
    }

    public Enumeration propfindMethod(String path, int depth) throws HttpException, IOException {
        this.setClient();
        PropFindMethod method = new PropFindMethod(URIUtil.encodePath(path), depth);
        method.setDebug(this.debug);
        this.generateTransactionHeader(method);
        int status = this.client.executeMethod(method);
        if (this.thisResource) {
            this.setStatusCode(status);
        }
        if (status != 207 && status != 200) {
            HttpException ex = new HttpException();
            ex.setReasonCode(status);
            throw ex;
        }
        this.thisResource = false;
        return method.getResponses();
    }

    public Enumeration propfindMethod(int depth, Vector properties) throws HttpException, IOException {
        this.thisResource = true;
        return this.propfindMethod(this.httpURL.getPath(), depth, properties);
    }

    public Enumeration propfindMethod(String path, int depth, Vector properties) throws HttpException, IOException {
        this.setClient();
        PropFindMethod method = new PropFindMethod(URIUtil.encodePath(path), depth, properties.elements());
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(method);
        int status = this.client.executeMethod(method);
        if (this.thisResource) {
            this.setStatusCode(method.getStatusLine().getStatusCode());
        }
        if (status != 207 && status != 200) {
            HttpException ex = new HttpException();
            ex.setReasonCode(status);
            throw ex;
        }
        this.thisResource = false;
        return method.getResponses();
    }

    public Enumeration propfindMethod(String propertyName) throws HttpException, IOException {
        Vector<String> property = new Vector<String>();
        property.addElement(propertyName);
        this.thisResource = true;
        return this.propfindMethod(this.httpURL.getPath(), property);
    }

    public Enumeration propfindMethod(String path, String propertyName) throws HttpException, IOException {
        Vector<String> property = new Vector<String>();
        property.addElement(propertyName);
        this.thisResource = false;
        return this.propfindMethod(path, property);
    }

    public Enumeration propfindMethod(Vector properties) throws HttpException, IOException {
        this.thisResource = true;
        return this.propfindMethod(this.httpURL.getPath(), properties);
    }

    public Enumeration propfindMethod(String path, Vector properties) throws HttpException, IOException {
        this.setClient();
        PropFindMethod method = new PropFindMethod(URIUtil.encodePath(path), 0, properties.elements());
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(method);
        int status = this.client.executeMethod(method);
        if (status != 207 && status != 200) {
            HttpException ex = new HttpException();
            ex.setReasonCode(status);
            throw ex;
        }
        Vector<String> results = new Vector<String>();
        Enumeration responses = method.getResponses();
        if (responses.hasMoreElements()) {
            ResponseEntity response = (ResponseEntity)responses.nextElement();
            String href = response.getHref();
            if (this.thisResource && response.getStatusCode() > 0) {
                this.setStatusCode(response.getStatusCode());
            }
            this.thisResource = false;
            Enumeration responseProperties = method.getResponseProperties(href);
            while (responseProperties.hasMoreElements()) {
                Property property = (Property)responseProperties.nextElement();
                results.addElement(property.getPropertyAsString());
            }
        }
        return results.elements();
    }

    public boolean proppatchMethod(String propertyName, String propertyValue) throws HttpException, IOException {
        boolean result = this.proppatchMethod(this.httpURL.getPath(), propertyName, propertyValue, true);
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean proppatchMethod(String propertyName, String propertyValue, boolean action) throws HttpException, IOException {
        boolean result = this.proppatchMethod(this.httpURL.getPath(), propertyName, propertyValue, action);
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean proppatchMethod(PropertyName propertyName, String propertyValue) throws HttpException, IOException {
        boolean result = this.proppatchMethod(this.httpURL.getPath(), propertyName, propertyValue, true);
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean proppatchMethod(PropertyName propertyName, String propertyValue, boolean action) throws HttpException, IOException {
        boolean result = this.proppatchMethod(this.httpURL.getPath(), propertyName, propertyValue, action);
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean proppatchMethod(String path, String propertyName, String propertyValue) throws HttpException, IOException {
        Hashtable<String, String> property = new Hashtable<String, String>();
        property.put(propertyName, propertyValue);
        return this.proppatchMethod(path, property, true);
    }

    public boolean proppatchMethod(String path, String propertyName, String propertyValue, boolean action) throws HttpException, IOException {
        Hashtable<String, String> property = new Hashtable<String, String>();
        property.put(propertyName, propertyValue);
        return this.proppatchMethod(path, property, action);
    }

    public boolean proppatchMethod(String path, PropertyName propertyName, String propertyValue) throws HttpException, IOException {
        Hashtable<PropertyName, String> property = new Hashtable<PropertyName, String>();
        property.put(propertyName, propertyValue);
        return this.proppatchMethod(path, property, true);
    }

    public boolean proppatchMethod(String path, PropertyName propertyName, String propertyValue, boolean action) throws HttpException, IOException {
        Hashtable<PropertyName, String> property = new Hashtable<PropertyName, String>();
        property.put(propertyName, propertyValue);
        return this.proppatchMethod(path, property, action);
    }

    public boolean proppatchMethod(Hashtable properties) throws HttpException, IOException {
        boolean result = this.proppatchMethod(this.httpURL.getPath(), properties, true);
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean proppatchMethod(Hashtable properties, boolean action) throws HttpException, IOException {
        boolean result = this.proppatchMethod(this.httpURL.getPath(), properties, action);
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean proppatchMethod(String path, Hashtable properties) throws HttpException, IOException {
        return this.proppatchMethod(path, properties, true);
    }

    public boolean proppatchMethod(String path, Hashtable properties, boolean action) throws HttpException, IOException {
        this.setClient();
        PropPatchMethod method = new PropPatchMethod(URIUtil.encodePath(path));
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(method);
        Enumeration names = properties.keys();
        boolean hasSomething = false;
        if (names.hasMoreElements()) {
            hasSomething = true;
        }
        while (names.hasMoreElements()) {
            String name;
            Object item = names.nextElement();
            if (item instanceof String) {
                name = (String)item;
                String value = (String)properties.get(item);
                if (action) {
                    method.addPropertyToSet(name, value);
                    continue;
                }
                method.addPropertyToRemove(name);
                continue;
            }
            if (!(item instanceof PropertyName)) continue;
            name = ((PropertyName)item).getLocalName();
            String namespaceURI = ((PropertyName)item).getNamespaceURI();
            String value = (String)properties.get(item);
            if (action) {
                method.addPropertyToSet(name, value, null, namespaceURI);
                continue;
            }
            method.addPropertyToRemove(name, null, namespaceURI);
        }
        if (hasSomething) {
            this.generateTransactionHeader(method);
            int statusCode = this.client.executeMethod(method);
            this.setStatusCode(statusCode);
            if (statusCode >= 200 && statusCode < 300) {
                return true;
            }
        }
        return false;
    }

    public boolean headMethod() throws HttpException, IOException {
        return this.headMethod(this.httpURL.getPathQuery());
    }

    public boolean headMethod(String path) throws HttpException, IOException {
        this.setClient();
        HeadMethod method = new HeadMethod(URIUtil.encodePathQuery(path));
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean deleteMethod() throws HttpException, IOException {
        boolean result = this.deleteMethod(this.httpURL.getPath());
        if (result) {
            this.setExistence(false);
        }
        return result;
    }

    public boolean deleteMethod(String path) throws HttpException, IOException {
        this.setClient();
        DeleteMethod method = new DeleteMethod(URIUtil.encodePath(path));
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(method);
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean moveMethod(String destination) throws HttpException, IOException {
        boolean result = this.moveMethod(this.httpURL.getPath(), destination);
        if (result) {
            this.httpURL.setPath(destination);
            this.refresh();
        }
        return result;
    }

    public boolean moveMethod(String source, String destination) throws HttpException, IOException {
        this.setClient();
        MoveMethod method = new MoveMethod(URIUtil.encodePath(source), URIUtil.encodePath(destination));
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(method);
        method.setOverwrite(this.overwrite);
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean copyMethod(String destination) throws HttpException, IOException {
        boolean result = this.copyMethod(this.httpURL.getPath(), destination);
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean copyMethod(String source, String destination) throws HttpException, IOException {
        this.setClient();
        CopyMethod method = new CopyMethod(URIUtil.encodePath(source), URIUtil.encodePath(destination));
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(method);
        method.setOverwrite(this.overwrite);
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean mkcolMethod() throws HttpException, IOException {
        boolean result = this.mkcolMethod(this.httpURL.getPath());
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean mkcolMethod(String path) throws HttpException, IOException {
        this.setClient();
        MkcolMethod method = new MkcolMethod(URIUtil.encodePath(path));
        this.generateIfHeader(method);
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean lockMethod() throws HttpException, IOException {
        String owner = this.httpURL.getUser() != null ? this.httpURL.getUser() : defaultOwner;
        boolean result = this.lockMethod(this.httpURL.getPath(), owner, 120);
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean lockMethod(String owner, int timeout) throws HttpException, IOException {
        boolean result = this.lockMethod(this.httpURL.getPath(), owner, timeout);
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean lockMethod(String path) throws HttpException, IOException {
        String owner = this.httpURL.getUser() != null ? this.httpURL.getUser() : defaultOwner;
        return this.lockMethod(path, owner, 120);
    }

    public boolean lockMethod(String path, String owner, int timeout) throws HttpException, IOException {
        return this.lockMethod(path, owner, timeout, (short)0);
    }

    public boolean lockMethod(String path, String owner, int timeout, short lockType) throws HttpException, IOException {
        return this.lockMethod(path, owner, timeout, lockType, Integer.MAX_VALUE);
    }

    public boolean lockMethod(String path, String owner, int timeout, short lockType, int depth) throws HttpException, IOException {
        this.setClient();
        if (owner == null) {
            owner = this.httpURL.getUser() != null ? this.httpURL.getUser() : defaultOwner;
        }
        LockMethod method = new LockMethod(URIUtil.encodePath(path), owner, lockType, timeout);
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        method.setDepth(depth);
        this.generateIfHeader(method);
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        String lock = method.getLockToken();
        WebdavState state = (WebdavState)this.client.getState();
        if (state != null) {
            state.addLock(path, lock);
        }
        this.owner = method.getOwner();
        this.setStatusCode(statusCode, lock);
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean lockMethod(String owner, short timeout) throws HttpException, IOException {
        return this.lockMethod(owner, (int)timeout);
    }

    public boolean lockMethod(String path, String owner, short timeout) throws HttpException, IOException {
        return this.lockMethod(path, owner, (int)timeout);
    }

    public boolean startTransaction(String owner, int timeout) throws IOException {
        String path = this.httpURL.getPath();
        this.setClient();
        if (owner == null) {
            owner = this.httpURL.getUser() != null ? this.httpURL.getUser() : defaultOwner;
        }
        LockMethod method = new LockMethod(path, owner, timeout, true);
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(method);
        int statusCode = this.client.executeMethod(method);
        String txHandle = method.getLockToken();
        WebdavState state = (WebdavState)this.client.getState();
        if (state != null) {
            state.setTransactionHandle(txHandle);
        }
        this.owner = method.getOwner();
        this.setStatusCode(statusCode, txHandle);
        return statusCode >= 200 && statusCode < 300;
    }

    public String getTransactionHandle() throws IOException {
        this.setClient();
        WebdavState state = (WebdavState)this.client.getState();
        if (state == null) {
            return null;
        }
        String txHandle = state.getTransactionHandle();
        return txHandle;
    }

    public boolean commitTransaction() throws IOException {
        String path = this.httpURL.getPath();
        return this.endTransaction(path, 1);
    }

    public boolean abortTransaction() throws IOException {
        String path = this.httpURL.getPath();
        return this.endTransaction(path, 0);
    }

    protected boolean endTransaction(String path, int transactionStatus) throws IOException {
        this.setClient();
        WebdavState state = (WebdavState)this.client.getState();
        if (state == null) {
            return false;
        }
        String txHandle = state.getTransactionHandle();
        if (txHandle == null) {
            return false;
        }
        UnlockMethod method = new UnlockMethod(path, txHandle, transactionStatus);
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(method);
        int statusCode = this.client.executeMethod(method);
        this.setStatusCode(statusCode);
        if (statusCode >= 200 && statusCode < 300) {
            state.setTransactionHandle(null);
            return true;
        }
        return false;
    }

    public boolean unlockMethod() throws HttpException, IOException {
        String owner = this.httpURL.getUser() != null ? this.httpURL.getUser() : defaultOwner;
        boolean result = this.unlockMethod(this.httpURL.getPath(), owner);
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean unlockMethod(String path) throws HttpException, IOException {
        String owner = this.httpURL.getUser() != null ? this.httpURL.getUser() : defaultOwner;
        return this.unlockMethod(path, owner);
    }

    public boolean unlockMethod(String path, String owner) throws HttpException, IOException {
        this.setClient();
        if (owner == null) {
            owner = this.httpURL.getUser() != null ? this.httpURL.getUser() : defaultOwner;
        }
        WebdavState state = (WebdavState)this.client.getState();
        String lock = (state = this.discoverLock(owner, path, state)).getLock(path);
        if (lock == null) {
            return false;
        }
        UnlockMethod method = new UnlockMethod(URIUtil.encodePath(path));
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(method);
        this.generateTransactionHeader(method);
        method.setLockToken(lock);
        int statusCode = this.client.executeMethod(method);
        this.setStatusCode(statusCode);
        if (statusCode >= 200 && statusCode < 300) {
            state.removeLocks(path);
            return true;
        }
        return false;
    }

    public void discoverOwnLocks() throws HttpException, IOException {
        this.setClient();
        String owner = this.httpURL.getUser() != null ? this.httpURL.getUser() : defaultOwner;
        WebdavState state = (WebdavState)this.client.getState();
        state = this.discoverLock(owner, this.httpURL.getPath(), state);
        this.client.setState(state);
    }

    public void discoverOwnLocks(String owner) throws HttpException, IOException {
        this.setClient();
        WebdavState state = (WebdavState)this.client.getState();
        state = this.discoverLock(owner, this.httpURL.getPath(), state);
        this.client.setState(state);
    }

    protected WebdavState discoverLock(String owner, String path, WebdavState state) {
        try {
            this.lockDiscovery = this.lockDiscoveryPropertyFindMethod(path);
        }
        catch (Exception e) {
            return state;
        }
        if (this.lockDiscovery == null) {
            return state;
        }
        Lock[] activeLocks = this.lockDiscovery.getActiveLocks();
        if (activeLocks == null) {
            return state;
        }
        for (int i = 0; i < activeLocks.length; ++i) {
            String activeLockOwner = activeLocks[i].getOwner();
            if (!activeLockOwner.equals(owner)) continue;
            String locktoken = activeLocks[i].getLockToken();
            state.addLock(path, locktoken);
        }
        return state;
    }

    public boolean updateMethod(String target) throws HttpException, IOException {
        return this.updateMethod(this.httpURL.getPath(), target);
    }

    public boolean updateMethod(String path, String target) throws HttpException, IOException {
        this.setClient();
        UpdateMethod method = new UpdateMethod(URIUtil.encodePath(path), URIUtil.encodePath(target));
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(method);
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean versionControlMethod(String path) throws HttpException, IOException {
        this.setClient();
        VersionControlMethod method = new VersionControlMethod(URIUtil.encodePath(path));
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(method);
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean versionControlMethod(String path, String target) throws HttpException, IOException {
        this.setClient();
        VersionControlMethod method = new VersionControlMethod(URIUtil.encodePath(path), URIUtil.encodePath(target));
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(method);
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean mkWorkspaceMethod() throws HttpException, IOException {
        boolean result = this.mkWorkspaceMethod(this.httpURL.getPath());
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean mkWorkspaceMethod(String path) throws HttpException, IOException {
        this.setClient();
        MkWorkspaceMethod method = new MkWorkspaceMethod(URIUtil.encodePath(path));
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(method);
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public int compareToWebdavResource(WebdavResource another) {
        try {
            int anotherPort;
            HttpURL anotherUrl = another.getHttpURL();
            String thisHost = this.httpURL.getHost();
            String anotherHost = anotherUrl.getHost();
            if (!thisHost.equalsIgnoreCase(anotherHost)) {
                return thisHost.compareTo(anotherHost);
            }
            int thisPort = this.httpURL.getPort();
            if (thisPort != (anotherPort = anotherUrl.getPort())) {
                return thisPort < anotherPort ? -1 : 1;
            }
            boolean thisCollection = this.isCollection();
            boolean anotherCollection = another.isCollection();
            if (thisCollection && !anotherCollection) {
                return -1;
            }
            if (anotherCollection && !thisCollection) {
                return 1;
            }
            String thisPath = this.httpURL.getPathQuery();
            String anotherPath = anotherUrl.getPathQuery();
            return thisPath.compareTo(anotherPath);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int compareTo(Object another) {
        if (another != null && another instanceof WebdavResource) {
            return this.compareToWebdavResource((WebdavResource)another);
        }
        String thisUrl = this.toString();
        String anotherUrl = another.toString();
        return thisUrl.compareTo(anotherUrl);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof WebdavResource) {
            return this.compareTo(obj) == 0;
        }
        return false;
    }

    public String toString() {
        return this.httpURL.toString();
    }

    public boolean checkinMethod() throws HttpException, IOException {
        return this.checkinMethod(this.httpURL.getPath());
    }

    public boolean checkinMethod(String path) throws HttpException, IOException {
        this.setClient();
        CheckinMethod method = new CheckinMethod(URIUtil.encodePath(path));
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(method);
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean checkoutMethod() throws HttpException, IOException {
        return this.checkoutMethod(this.httpURL.getPath());
    }

    public boolean checkoutMethod(String path) throws HttpException, IOException {
        this.setClient();
        CheckoutMethod method = new CheckoutMethod(URIUtil.encodePath(path));
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(method);
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean uncheckoutMethod() throws HttpException, IOException {
        return this.uncheckoutMethod(this.httpURL.getPath());
    }

    public boolean uncheckoutMethod(String path) throws HttpException, IOException {
        this.setClient();
        UncheckoutMethod method = new UncheckoutMethod(URIUtil.encodePath(path));
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(method);
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    protected WebdavResource createWebdavResource(HttpClient client) {
        WebdavResource resource = new WebdavResource(client);
        resource.setProxy(this.proxyHost, this.proxyPort);
        resource.setProxyCredentials(this.proxyCredentials);
        return resource;
    }

    protected void processProperty(Property property) {
        if (property.getLocalName().equals(DISPLAYNAME)) {
            this.displayName = property.getPropertyAsString();
        } else if (property.getLocalName().equals(GETCONTENTLENGTH)) {
            String getContentLength = property.getPropertyAsString();
            this.setGetContentLength(getContentLength);
        } else if (property.getLocalName().equals(RESOURCETYPE)) {
            ResourceTypeProperty resourceType = (ResourceTypeProperty)property;
            this.setResourceType(resourceType);
        } else if (property.getLocalName().equals(GETCONTENTTYPE)) {
            String getContentType = property.getPropertyAsString();
            this.setGetContentType(getContentType);
        } else if (property.getLocalName().equals(GETLASTMODIFIED)) {
            String getLastModified = property.getPropertyAsString();
            this.setGetLastModified(getLastModified);
        } else if (property.getLocalName().equals(CREATIONDATE)) {
            String creationDate = property.getPropertyAsString();
            this.setCreationDate(creationDate);
        } else if (property.getLocalName().equals(GETETAG)) {
            String getEtag = property.getPropertyAsString();
            this.setGetEtag(getEtag);
        } else if (property.getLocalName().equals(ISHIDDEN)) {
            String isHidden = property.getPropertyAsString();
            this.setIsHidden(isHidden);
        } else if (property.getLocalName().equals(ISCOLLECTION)) {
            String isCollection = property.getPropertyAsString();
            this.setIsCollection(isCollection);
        } else if (property.getLocalName().equals(SUPPORTEDLOCK)) {
            String supportedLock = property.getPropertyAsString();
            this.setSupportedLock(supportedLock);
        } else if (property.getLocalName().equals(LOCKDISCOVERY)) {
            LockDiscoveryProperty lockDiscovery = (LockDiscoveryProperty)property;
            this.setLockDiscovery(lockDiscovery);
        }
    }

    public Enumeration aclReportMethod(String path, Collection properties, int reportType) throws HttpException, IOException {
        this.setClient();
        AclReportMethod method = new AclReportMethod(URIUtil.encodePath(path), properties, Integer.MAX_VALUE, reportType);
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(method);
        int status = this.client.executeMethod(method);
        if (this.thisResource) {
            this.setStatusCode(method.getStatusLine().getStatusCode());
        }
        if (status != 207 && status != 200) {
            HttpException ex = new HttpException();
            ex.setReasonCode(status);
            throw ex;
        }
        this.thisResource = false;
        return method.getResponses();
    }

    public boolean bindMethod(String newBinding) throws HttpException, IOException {
        return this.bindMethod(this.httpURL.getPath(), newBinding);
    }

    public boolean bindMethod(String existingBinding, String newBinding) throws HttpException, IOException {
        this.setClient();
        BindMethod method = new BindMethod(URIUtil.encodePath(existingBinding), URIUtil.encodePath(newBinding));
        method.setDebug(this.debug);
        method.setOverwrite(this.overwrite);
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean unbindMethod() throws HttpException, IOException {
        boolean result = this.unbindMethod(this.httpURL.getPath());
        if (result) {
            this.setExistence(false);
        }
        return result;
    }

    public boolean unbindMethod(String binding) throws HttpException, IOException {
        this.setClient();
        UnbindMethod method = new UnbindMethod(URIUtil.encodePath(binding));
        method.setDebug(this.debug);
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean rebindMethod(String newBinding) throws HttpException, IOException {
        boolean result = this.rebindMethod(this.httpURL.getPath(), newBinding);
        if (result) {
            this.httpURL.setPath(newBinding);
            this.refresh();
        }
        return result;
    }

    public boolean rebindMethod(String existingBinding, String newBinding) throws HttpException, IOException {
        this.setClient();
        RebindMethod method = new RebindMethod(URIUtil.encodePath(existingBinding), URIUtil.encodePath(newBinding));
        method.setDebug(this.debug);
        method.setOverwrite(this.overwrite);
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        this.setStatusCode(statusCode);
        return statusCode >= 200 && statusCode < 300;
    }

    public Subscription subscribeMethod(String path, String notificationType, String callback, long notificationDelay, int depth, long lifetime) throws HttpException, IOException {
        this.setClient();
        SubscribeMethod method = new SubscribeMethod(path);
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        method.setCallback(callback);
        method.setDepth(depth);
        method.setSubsciptionLifetime(lifetime);
        method.setNotificationType(notificationType);
        method.setNotificationDelay(notificationDelay);
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        if (statusCode == 200) {
            return new Subscription(path, method.getResponsedSubscriptionId(), method.getCallback(), method.getResponsedSubscriptionLifetime(), method.getResponsedContentLocation(), method.getNotificationType());
        }
        return null;
    }

    public boolean subscribeMethod(String path, int subscriptionId) throws HttpException, IOException {
        this.setClient();
        SubscribeMethod method = new SubscribeMethod(path);
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        method.setSubscriptionId(subscriptionId);
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        return statusCode == 200;
    }

    public boolean subscribeMethod(Subscription subscription) throws HttpException, IOException {
        return this.subscribeMethod(subscription.getPath(), subscription.getId());
    }

    public boolean unsubscribeMethod(String path, int subscriptionId) throws HttpException, IOException {
        this.setClient();
        UnsubscribeMethod method = new UnsubscribeMethod(path);
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        method.addSubscriptionId(subscriptionId);
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        return statusCode == 200;
    }

    public boolean unsubscribeMethod(Subscription subscription) throws HttpException, IOException {
        return this.unsubscribeMethod(subscription.getPath(), subscription.getId());
    }

    public boolean pollMethod(String contentLocation, int subscriptionId) throws HttpException, IOException {
        this.setClient();
        PollMethod method = new PollMethod(contentLocation);
        method.setDebug(this.debug);
        method.setFollowRedirects(this.followRedirects);
        method.addSubscriptionId(subscriptionId);
        this.generateTransactionHeader(method);
        int statusCode = this.client.executeMethod(method);
        if (statusCode == 207) {
            return method.getSubscriptionsWithEvents().size() > 0;
        }
        return false;
    }

    public boolean pollMethod(Subscription subscription) throws HttpException, IOException {
        return this.pollMethod(subscription.getContentLocation(), subscription.getId());
    }

    private static String getName(String uri) {
        String escapedName = URIUtil.getName(uri.endsWith("/") ? uri.substring(0, uri.length() - 1) : uri);
        try {
            return URIUtil.decode(escapedName);
        }
        catch (URIException e) {
            return escapedName;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String decodeMarks(String input) {
        char[] sequence = input.toCharArray();
        StringBuffer decoded = new StringBuffer(sequence.length);
        int i = 0;
        while (true) {
            block23: {
                block22: {
                    if (i >= sequence.length) {
                        return decoded.toString();
                    }
                    if (sequence[i] != '%' || i >= sequence.length - 2) break block22;
                    switch (sequence[i + 1]) {
                        case '2': {
                            switch (sequence[i + 2]) {
                                case 'D': 
                                case 'd': {
                                    decoded.append('-');
                                    i += 2;
                                    break block23;
                                }
                                case 'E': 
                                case 'e': {
                                    decoded.append('.');
                                    i += 2;
                                    break block23;
                                }
                                case '1': {
                                    decoded.append('!');
                                    i += 2;
                                    break block23;
                                }
                                case 'A': 
                                case 'a': {
                                    decoded.append('*');
                                    i += 2;
                                    break block23;
                                }
                                case '7': {
                                    decoded.append('\'');
                                    i += 2;
                                    break block23;
                                }
                                case '8': {
                                    decoded.append('(');
                                    i += 2;
                                    break block23;
                                }
                                case '9': {
                                    decoded.append(')');
                                    i += 2;
                                    break block23;
                                }
                            }
                            break;
                        }
                        case '5': {
                            switch (sequence[i + 2]) {
                                case 'F': 
                                case 'f': {
                                    decoded.append('_');
                                    i += 2;
                                    break block23;
                                }
                            }
                            break;
                        }
                        case '7': {
                            switch (sequence[i + 2]) {
                                case 'E': 
                                case 'e': {
                                    decoded.append('~');
                                    i += 2;
                                    break block23;
                                }
                            }
                        }
                    }
                }
                decoded.append(sequence[i]);
            }
            ++i;
        }
    }

    static {
        for (int i = 0; i < formats.length; ++i) {
            formats[i].setTimeZone(gmtZone);
        }
        defaultAction = 3;
        defaultDepth = 0;
        useDiskForGet = true;
    }
}

