/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.webdav;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.webdav.lib.WebdavResource;

public class CorrectedWebdavResource
extends WebdavResource {
    private Map headers = new HashMap();

    public CorrectedWebdavResource(HttpURL url) throws IOException {
        super(url);
        this.setFollowRedirects(true);
    }

    public void setHeaders(Map headers) {
        this.headers = headers;
    }

    public Map getHeaders() {
        return this.headers;
    }

    protected void generateAdditionalHeaders(HttpMethod method) {
        Iterator iterator = this.getHeaders().keySet().iterator();
        while (iterator.hasNext()) {
            String header = (String)iterator.next();
            method.setRequestHeader(header, (String)this.getHeaders().get(header));
        }
    }

    public InputStream getMethodData(String path) throws IOException {
        this.setClient();
        GetMethod method = new GetMethod(URIUtil.encodePathQuery(path));
        method.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(method);
        this.generateAdditionalHeaders(method);
        this.client.executeMethod(method);
        int statusCode = method.getStatusLine().getStatusCode();
        this.setStatusCode(statusCode);
        if (this.isHttpSuccess(statusCode)) {
            boolean isGZipped;
            Header contentEncoding = method.getResponseHeader("Content-Encoding");
            boolean bl = isGZipped = contentEncoding == null ? false : "gzip".equalsIgnoreCase(contentEncoding.getValue());
            if (isGZipped) {
                return new GZIPInputStream(method.getResponseBodyAsStream());
            }
            return method.getResponseBodyAsStream();
        }
        throw new IOException("Couldn't get file");
    }

    public void addRequestHeader(String header, String value) {
        this.getHeaders().put(header, value);
    }

    public boolean putMethod(String path, InputStream inputStream, int contentLength) throws IOException {
        this.setClient();
        PutMethod method = new PutMethod(URIUtil.encodePathQuery(path));
        method.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(method);
        if (this.getGetContentType() != null && !this.getGetContentType().equals("")) {
            method.setRequestHeader("Content-Type", this.getGetContentType());
        }
        method.setRequestContentLength(contentLength);
        method.setRequestBody(inputStream);
        this.generateTransactionHeader(method);
        this.generateAdditionalHeaders(method);
        int statusCode = this.client.executeMethod(method);
        this.setStatusCode(statusCode);
        return this.isHttpSuccess(statusCode);
    }

    private boolean isHttpSuccess(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }
}

