/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.realm;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Plugin;
import org.apache.maven.realm.MavenRealmManager;
import org.apache.maven.realm.RealmManagementException;
import org.apache.maven.realm.RealmScanningUtils;
import org.apache.maven.realm.RealmUtils;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.codehaus.plexus.component.discovery.DefaultComponentDiscoverer;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentRepositoryException;
import org.codehaus.plexus.logging.Logger;

public class DefaultMavenRealmManager
implements MavenRealmManager {
    private Map pluginArtifacts = new HashMap();
    private Set managedRealmIds = new HashSet();
    private final ClassWorld world;
    private final PlexusContainer container;
    private final Logger logger;

    public DefaultMavenRealmManager(PlexusContainer container, Logger logger) {
        this.world = container.getContainerRealm().getWorld();
        this.container = container;
        this.logger = logger;
    }

    public void clear() {
        HashSet realms = new HashSet(this.world.getRealms());
        Iterator it = realms.iterator();
        while (it.hasNext()) {
            ClassRealm realm = (ClassRealm)it.next();
            String id = realm.getId();
            if (!this.managedRealmIds.contains(id)) continue;
            try {
                this.logger.debug("disposing managed ClassRealm with id: " + id);
                this.world.disposeRealm(id);
                this.logger.debug("dissociating all components from managed ClassRealm with id: " + id);
                this.container.removeComponentRealm(realm);
            }
            catch (NoSuchRealmException noSuchRealmException) {
            }
            catch (PlexusContainerException e) {
                this.logger.debug("Error while dissociating: " + e.getMessage(), e);
            }
        }
        this.managedRealmIds.clear();
        this.pluginArtifacts.clear();
    }

    public boolean hasExtensionRealm(Artifact extensionArtifact) {
        String id = RealmUtils.createExtensionRealmId(extensionArtifact);
        try {
            return this.world.getRealm(id) != null;
        }
        catch (NoSuchRealmException noSuchRealmException) {
            return false;
        }
    }

    public ClassRealm createExtensionRealm(Artifact extensionArtifact, Collection artifacts) throws RealmManagementException {
        ClassRealm realm;
        String id = RealmUtils.createExtensionRealmId(extensionArtifact);
        try {
            realm = this.container.getContainerRealm().createChildRealm(id);
            this.managedRealmIds.add(id);
        }
        catch (DuplicateRealmException e) {
            throw new RealmManagementException(id, "Extension realm: " + id + " already exists.", e);
        }
        this.populateRealm(id, realm, extensionArtifact, artifacts);
        return realm;
    }

    public void importExtensionsIntoProjectRealm(String projectGroupId, String projectArtifactId, String projectVersion, Artifact extensionArtifact) throws RealmManagementException {
        String extensionRealmId = RealmUtils.createExtensionRealmId(extensionArtifact);
        if (extensionArtifact.getFile() == null) {
            throw new RealmManagementException(extensionRealmId, "Cannot import project extensions; extension artifact has no associated file that can be scanned for extension components (extension: " + extensionArtifact.getId() + ")");
        }
        DefaultComponentDiscoverer discoverer = new DefaultComponentDiscoverer();
        discoverer.setManager(RealmScanningUtils.getDummyComponentDiscovererManager());
        List componentSetDescriptors = RealmScanningUtils.scanForComponentSetDescriptors(extensionArtifact, discoverer, this.container.getContext(), extensionRealmId);
        ClassRealm realm = this.getProjectRealm(projectGroupId, projectArtifactId, projectVersion, true);
        Iterator it = componentSetDescriptors.iterator();
        while (it.hasNext()) {
            ComponentSetDescriptor compSet = (ComponentSetDescriptor)it.next();
            Iterator compIt = compSet.getComponents().iterator();
            while (compIt.hasNext()) {
                ComponentDescriptor comp = (ComponentDescriptor)compIt.next();
                String implementation = comp.getImplementation();
                try {
                    this.logger.debug("Importing: " + implementation + "\nwith role: " + comp.getRole() + "\nand hint: " + comp.getRoleHint() + "\nfrom extension realm: " + extensionRealmId + "\nto project realm: " + realm.getId());
                    realm.importFrom(extensionRealmId, implementation);
                    comp.setRealmId(realm.getId());
                    this.container.addComponentDescriptor(comp);
                }
                catch (NoSuchRealmException e) {
                    throw new RealmManagementException(extensionRealmId, "Failed to create import for component: " + implementation + " from extension realm: " + extensionRealmId + " to project realm: " + realm.getId(), e);
                }
                catch (ComponentRepositoryException e) {
                    String projectId = RealmUtils.createProjectId(projectGroupId, projectArtifactId, projectVersion);
                    throw new RealmManagementException(extensionRealmId, "Unable to discover components from imports to project: " + projectId + " from extension artifact: " + extensionArtifact.getId(), e);
                }
            }
        }
    }

    public ClassRealm getProjectRealm(String projectGroupId, String projectArtifactId, String projectVersion) {
        return this.getProjectRealm(projectGroupId, projectArtifactId, projectVersion, false);
    }

    private ClassRealm getProjectRealm(String projectGroupId, String projectArtifactId, String projectVersion, boolean create) {
        ClassRealm realm;
        block4: {
            String id = RealmUtils.createProjectId(projectGroupId, projectArtifactId, projectVersion);
            realm = null;
            try {
                realm = this.world.getRealm(id);
            }
            catch (NoSuchRealmException noSuchRealmException) {
                if (!create) break block4;
                try {
                    realm = this.container.getContainerRealm().createChildRealm(id);
                    this.managedRealmIds.add(id);
                }
                catch (DuplicateRealmException duplicateRealmException) {}
            }
        }
        return realm;
    }

    public ClassRealm getPluginRealm(Plugin plugin) {
        String id = RealmUtils.createPluginRealmId(plugin);
        this.logger.debug("Retrieving realm for plugin with id: " + id);
        try {
            return this.world.getRealm(id);
        }
        catch (NoSuchRealmException noSuchRealmException) {
            return null;
        }
    }

    public void disposePluginRealm(Plugin plugin) {
        String id = RealmUtils.createPluginRealmId(plugin);
        this.logger.debug("Disposing realm for plugin with id: " + id);
        try {
            this.world.disposeRealm(id);
        }
        catch (NoSuchRealmException noSuchRealmException) {
            this.logger.debug("Plugin realm: " + id + " didn't exist in ClassWorld instance.");
        }
        this.managedRealmIds.remove(id);
        this.pluginArtifacts.remove(id);
    }

    public ClassRealm createPluginRealm(Plugin plugin, Artifact pluginArtifact, Collection artifacts) throws RealmManagementException {
        ClassRealm realm;
        String id = RealmUtils.createPluginRealmId(plugin);
        this.logger.debug("Creating realm for plugin with id: " + id);
        try {
            realm = this.world.newRealm(id);
            this.managedRealmIds.add(id);
        }
        catch (DuplicateRealmException e) {
            throw new RealmManagementException(id, "Plugin realm: " + id + " already exists.", e);
        }
        this.populateRealm(id, realm, pluginArtifact, artifacts);
        this.logger.debug("Saving artifacts:\n\n" + artifacts + "\n\nfor plugin: " + id);
        this.pluginArtifacts.put(id, artifacts);
        return realm;
    }

    private void populateRealm(String id, ClassRealm realm, Artifact mainArtifact, Collection artifacts) throws RealmManagementException {
        if (!artifacts.contains(mainArtifact)) {
            try {
                realm.addURL(mainArtifact.getFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RealmManagementException(id, mainArtifact, "Invalid URL for artifact file: " + mainArtifact.getFile() + " to be used in realm: " + id + ".", e);
            }
        }
        Iterator it = artifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            try {
                realm.addURL(artifact.getFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RealmManagementException(id, artifact, "Invalid URL for artifact file: " + artifact.getFile() + " to be used in realm: " + id + ".", e);
            }
        }
    }

    public List getPluginArtifacts(Plugin plugin) {
        String id = RealmUtils.createPluginRealmId(plugin);
        this.logger.debug("Getting artifacts used in realm for plugin with id: " + id);
        Collection artifacts = (Collection)this.pluginArtifacts.get(id);
        if (artifacts != null) {
            this.logger.debug("Returning artifacts:\n\n" + artifacts + "\n\nfor plugin: " + id);
            return new ArrayList(artifacts);
        }
        this.logger.debug("Found no artifacts for plugin: " + id);
        return null;
    }

    public void setPluginArtifacts(Plugin plugin, Collection artifacts) {
        String id = RealmUtils.createPluginRealmId(plugin);
        this.logger.debug("Setting artifact collection for plugin with id: " + id + " to:\n\n" + artifacts);
        this.pluginArtifacts.put(id, artifacts);
    }
}

