/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.workspace;

import java.io.File;
import java.net.URI;
import java.util.Map;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.build.model.ModelAndFile;
import org.apache.maven.project.workspace.ProjectWorkspace;
import org.apache.maven.workspace.MavenWorkspaceStore;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;

public class DefaultProjectWorkspace
implements ProjectWorkspace,
LogEnabled {
    private MavenWorkspaceStore workspaceStore;

    public DefaultProjectWorkspace() {
    }

    protected DefaultProjectWorkspace(MavenWorkspaceStore workspaceStore) {
        this.workspaceStore = workspaceStore;
    }

    public ModelAndFile getModelAndFile(String groupId, String artifactId, String version) {
        Map cache = this.workspaceStore.getWorkspaceCache("maven:project:modelAndFile:GAV");
        String key = this.createCacheKey(groupId, artifactId, version);
        return (ModelAndFile)cache.get(key);
    }

    public ModelAndFile getModelAndFile(File modelFile) {
        Map cache = this.workspaceStore.getWorkspaceCache("maven:project:modelAndFile:file");
        Object pathKey = this.resolvePathKey(modelFile);
        return (ModelAndFile)cache.get(pathKey);
    }

    private Object resolvePathKey(File file) {
        if (file == null) {
            return null;
        }
        URI path = file.toURI().normalize();
        return path;
    }

    public MavenProject getProject(File projectFile) {
        Map cache = this.workspaceStore.getWorkspaceCache("maven:project:project:file");
        Object pathKey = this.resolvePathKey(projectFile);
        return (MavenProject)cache.get(pathKey);
    }

    public MavenProject getProject(String groupId, String artifactId, String version) {
        Map cache = this.workspaceStore.getWorkspaceCache("maven:project:project:GAV");
        String key = this.createCacheKey(groupId, artifactId, version);
        return (MavenProject)cache.get(key);
    }

    public void storeModelAndFile(ModelAndFile modelAndFile) {
        Map cache = this.workspaceStore.getWorkspaceCache("maven:project:modelAndFile:file");
        Object pathKey = this.resolvePathKey(modelAndFile.getFile());
        cache.put(pathKey, modelAndFile);
        cache = this.workspaceStore.getWorkspaceCache("maven:project:modelAndFile:GAV");
        Model model = modelAndFile.getModel();
        String key = this.createCacheKey(model.getGroupId(), model.getArtifactId(), model.getVersion());
        cache.put(key, modelAndFile);
    }

    public void storeProjectByFile(MavenProject project) {
        if (project.getFile() == null) {
            return;
        }
        Map cache = this.workspaceStore.getWorkspaceCache("maven:project:project:file");
        Object pathKey = this.resolvePathKey(project.getFile());
        cache.put(pathKey, project);
    }

    public void storeProjectByCoordinate(MavenProject project) {
        Map cache = this.workspaceStore.getWorkspaceCache("maven:project:project:GAV");
        String key = this.createCacheKey(project.getGroupId(), project.getArtifactId(), project.getVersion());
        cache.put(key, project);
    }

    private String createCacheKey(String groupId, String artifactId, String version) {
        return String.valueOf(groupId) + ":" + artifactId + ":" + version;
    }

    public void enableLogging(Logger logger) {
    }
}

