/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.build.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.MavenTools;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.profiles.activation.DefaultProfileActivationContext;
import org.apache.maven.profiles.activation.ProfileActivationContext;
import org.apache.maven.profiles.build.ProfileAdvisor;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.aspect.PBEDerivativeReporterAspect;
import org.apache.maven.project.aspect.ProjectArtifactErrorReporterAspect;
import org.apache.maven.project.aspect.ProjectCacheAspect;
import org.apache.maven.project.aspect.ProjectIOErrorReporterAspect;
import org.apache.maven.project.build.model.DefaultModelLineage;
import org.apache.maven.project.build.model.ModelAndFile;
import org.apache.maven.project.build.model.ModelLineage;
import org.apache.maven.project.build.model.ModelLineageBuilder;
import org.apache.maven.project.workspace.ProjectWorkspace;
import org.aspectj.runtime.internal.AroundClosure;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultModelLineageBuilder
implements ModelLineageBuilder,
LogEnabled {
    public static final String ROLE_HINT = "default";
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    private MavenTools mavenTools;
    private ProfileAdvisor profileAdvisor;
    private ProjectWorkspace projectWorkspace;
    private Logger logger;

    public DefaultModelLineageBuilder() {
    }

    public DefaultModelLineageBuilder(ArtifactResolver resolver, ArtifactFactory artifactFactory) {
        this.artifactResolver = resolver;
        this.artifactFactory = artifactFactory;
    }

    public ModelLineage buildModelLineage(File pom, ArtifactRepository localRepository, List remoteRepositories, ProfileManager profileManager, boolean allowStubs, boolean validProfilesXmlLocation) throws ProjectBuildingException {
        DefaultModelLineage lineage = new DefaultModelLineage();
        List currentRemoteRepositories = remoteRepositories == null ? new ArrayList() : new ArrayList(remoteRepositories);
        File file = pom;
        DefaultModelLineageBuilder defaultModelLineageBuilder = this;
        boolean bl = validProfilesXmlLocation;
        File file2 = pom;
        Model model = DefaultModelLineageBuilder.readModel_aroundBody1$advice(this, defaultModelLineageBuilder, file, ProjectCacheAspect.aspectOf(), file, this, null);
        ModelAndFile current = DefaultModelLineageBuilder.init$_aroundBody3$advice(this, model, file2, bl, ProjectCacheAspect.aspectOf(), model, file2, this, null);
        do {
            if (lineage.size() == 0) {
                lineage.setOrigin(current.getModel(), current.getFile(), currentRemoteRepositories, current.isValidProfilesXmlLocation());
                continue;
            }
            lineage.addParent(current.getModel(), current.getFile(), currentRemoteRepositories, current.isValidProfilesXmlLocation());
        } while ((current = this.resolveParentPom(current, currentRemoteRepositories = this.updateRepositorySet(current.getModel(), currentRemoteRepositories, current.getFile(), profileManager, current.isValidProfilesXmlLocation()), localRepository, allowStubs)) != null);
        return lineage;
    }

    public void resumeBuildingModelLineage(ModelLineage lineage, ArtifactRepository localRepository, ProfileManager profileManager, boolean allowStubs) throws ProjectBuildingException {
        if (lineage.size() == 0) {
            throw new ProjectBuildingException("unknown", "Cannot resume a ModelLineage that doesn't contain at least one Model instance.");
        }
        List currentRemoteRepositories = lineage.getDeepestAncestorArtifactRepositoryList();
        if (currentRemoteRepositories == null) {
            currentRemoteRepositories = new ArrayList();
        }
        ModelAndFile current = new ModelAndFile(lineage.getDeepestAncestorModel(), lineage.getDeepestAncestorFile(), lineage.isDeepestAncestorUsingProfilesXml());
        current = this.resolveParentPom(current, currentRemoteRepositories, localRepository, allowStubs);
        while (current != null) {
            lineage.addParent(current.getModel(), current.getFile(), currentRemoteRepositories, current.isValidProfilesXmlLocation());
            currentRemoteRepositories = this.updateRepositorySet(current.getModel(), currentRemoteRepositories, current.getFile(), profileManager, current.isValidProfilesXmlLocation());
            current = this.resolveParentPom(current, currentRemoteRepositories, localRepository, allowStubs);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Model readModel(File file) throws ProjectBuildingException {
        File file2 = file;
        Object[] objectArray = new Object[]{file2};
        ProjectIOErrorReporterAspect.ajc$cflowStack$3.push(objectArray);
        try {
            Model model;
            File pomFile;
            if (pomFile.isDirectory()) {
                pomFile = new File(pomFile, "pom.xml");
            }
            XmlStreamReader reader = null;
            try {
                try {
                    reader = ReaderFactory.newXmlReader(pomFile);
                    model = new MavenXpp3Reader().read(reader);
                }
                catch (IOException e) {
                    IOException iOException = e;
                    File file3 = pomFile;
                    String string = "Failed to read model from: " + pomFile;
                    String string2 = "unknown";
                    if (ProjectIOErrorReporterAspect.ajc$cflowStack$3.isValid() && ProjectIOErrorReporterAspect.ajc$cflowStack$4.isValid()) {
                        ProjectIOErrorReporterAspect.aspectOf().ajc$before$org_apache_maven_project_aspect_ProjectIOErrorReporterAspect$4$35fd0ac6((ModelAndFile)ProjectIOErrorReporterAspect.ajc$cflowStack$4.get(0), (File)ProjectIOErrorReporterAspect.ajc$cflowStack$3.get(0), iOException);
                    }
                    if (!ProjectIOErrorReporterAspect.ajc$cflowStack$3.isValid()) throw new ProjectBuildingException(string2, string, file3, iOException);
                    if (ProjectIOErrorReporterAspect.ajc$cflowCounter$5.isValid()) throw new ProjectBuildingException(string2, string, file3, iOException);
                    ProjectIOErrorReporterAspect.aspectOf().ajc$before$org_apache_maven_project_aspect_ProjectIOErrorReporterAspect$6$b9cf7859((File)ProjectIOErrorReporterAspect.ajc$cflowStack$3.get(0), iOException);
                    throw new ProjectBuildingException(string2, string, file3, iOException);
                }
                catch (XmlPullParserException e) {
                    XmlPullParserException xmlPullParserException = e;
                    File file4 = pomFile;
                    String string = "Failed to parse model from: " + pomFile;
                    String string3 = "unknown";
                    if (ProjectIOErrorReporterAspect.ajc$cflowStack$2.isValid() && ProjectIOErrorReporterAspect.ajc$cflowStack$3.isValid()) {
                        ProjectIOErrorReporterAspect.aspectOf().ajc$before$org_apache_maven_project_aspect_ProjectIOErrorReporterAspect$3$fadd25ea((ModelAndFile)ProjectIOErrorReporterAspect.ajc$cflowStack$2.get(0), (File)ProjectIOErrorReporterAspect.ajc$cflowStack$3.get(0), xmlPullParserException);
                    }
                    if (!ProjectIOErrorReporterAspect.ajc$cflowStack$3.isValid()) throw new ProjectBuildingException(string3, string, file4, xmlPullParserException);
                    if (ProjectIOErrorReporterAspect.ajc$cflowCounter$5.isValid()) throw new ProjectBuildingException(string3, string, file4, xmlPullParserException);
                    ProjectIOErrorReporterAspect.aspectOf().ajc$before$org_apache_maven_project_aspect_ProjectIOErrorReporterAspect$5$4dc6227d((File)ProjectIOErrorReporterAspect.ajc$cflowStack$3.get(0), xmlPullParserException);
                    throw new ProjectBuildingException(string3, string, file4, xmlPullParserException);
                }
            }
            catch (Throwable throwable) {
                Object var5_17 = null;
                IOUtil.close(reader);
                throw throwable;
            }
            {
                Object var5_18 = null;
            }
            IOUtil.close(reader);
            Model model2 = model;
            return model2;
        }
        finally {
            ProjectIOErrorReporterAspect.ajc$cflowStack$3.pop();
        }
    }

    /*
     * WARNING - void declaration
     */
    private List updateRepositorySet(Model model, List list, File file, ProfileManager profileManager, boolean bl) throws ProjectBuildingException {
        ArrayList arrayList;
        Model model2 = model;
        List list2 = list;
        File file2 = file;
        ProfileManager profileManager2 = profileManager;
        boolean bl2 = bl;
        Object[] objectArray = new Object[]{model2, file2};
        PBEDerivativeReporterAspect.ajc$cflowStack$1.push(objectArray);
        try {
            void pomFile;
            void model3;
            List repositories = model3.getRepositories();
            File projectDir = pomFile == null ? null : pomFile.getParentFile();
            LinkedHashSet artifactRepositories = null;
            if (repositories != null) {
                try {
                    void useProfilesXml;
                    void externalProfileManager;
                    void oldArtifactRepositories;
                    void lastRemoteRepos = oldArtifactRepositories;
                    List remoteRepos = this.mavenTools.buildArtifactRepositories(repositories);
                    this.loadActiveProfileRepositories(remoteRepos, (Model)model3, (ProfileManager)externalProfileManager, projectDir, (boolean)useProfilesXml);
                    artifactRepositories = new LinkedHashSet(remoteRepos.size() + oldArtifactRepositories.size());
                    artifactRepositories.addAll(remoteRepos);
                    artifactRepositories.addAll(lastRemoteRepos);
                }
                catch (InvalidRepositoryException e) {
                    throw new ProjectBuildingException(model3.getId(), "Failed to create ArtifactRepository list for: " + pomFile, (File)pomFile, e);
                }
            }
            arrayList = new ArrayList(artifactRepositories);
        }
        finally {
            PBEDerivativeReporterAspect.ajc$cflowStack$1.pop();
        }
        return arrayList;
    }

    private void loadActiveProfileRepositories(List repositories, Model model, ProfileManager profileManager, File pomFile, boolean useProfilesXml) throws ProjectBuildingException {
        this.getLogger().debug("Grabbing profile-injected repositories for: " + model.getId());
        ProfileActivationContext context = profileManager != null ? profileManager.getProfileActivationContext() : new DefaultProfileActivationContext(System.getProperties(), false);
        LinkedHashSet profileRepos = this.profileAdvisor.getArtifactRepositoriesFromActiveProfiles(model, pomFile, profileManager);
        this.getLogger().debug("Got external-profile repositories: " + profileRepos);
        LinkedHashSet pomProfileRepos = this.profileAdvisor.getArtifactRepositoriesFromActiveProfiles(model, pomFile, useProfilesXml, context);
        this.getLogger().debug("Got pom-profile repositories: " + pomProfileRepos);
        profileRepos.addAll(pomProfileRepos);
        if (!profileRepos.isEmpty()) {
            repositories.addAll(profileRepos);
        }
    }

    private ModelAndFile resolveParentPom(ModelAndFile modelAndFile, List list, ArtifactRepository artifactRepository, boolean bl) throws ProjectBuildingException {
        ModelAndFile modelAndFile2;
        ModelAndFile modelAndFile3 = modelAndFile;
        List list2 = list;
        ArtifactRepository artifactRepository2 = artifactRepository;
        boolean bl2 = bl;
        ProjectIOErrorReporterAspect.ajc$cflowCounter$5.inc();
        try {
            ModelAndFile modelAndFile4;
            Object[] objectArray = new Object[]{modelAndFile3};
            ProjectIOErrorReporterAspect.ajc$cflowStack$4.push(objectArray);
            try {
                modelAndFile4 = DefaultModelLineageBuilder.resolveParentPom_aroundBody5$advice(this, modelAndFile3, list2, artifactRepository2, bl2, ProjectCacheAspect.aspectOf(), modelAndFile3, this, null);
            }
            finally {
                ProjectIOErrorReporterAspect.ajc$cflowStack$4.pop();
            }
            modelAndFile2 = modelAndFile4;
        }
        finally {
            ProjectIOErrorReporterAspect.ajc$cflowCounter$5.dec();
        }
        return modelAndFile2;
    }

    private void validateParentDeclaration(Parent modelParent, Model model) throws ProjectBuildingException {
        if (StringUtils.isEmpty(modelParent.getGroupId())) {
            throw new ProjectBuildingException(model.getId(), "Missing groupId element from parent element");
        }
        if (StringUtils.isEmpty(modelParent.getArtifactId())) {
            throw new ProjectBuildingException(model.getId(), "Missing artifactId element from parent element");
        }
        if (modelParent.getGroupId().equals(model.getGroupId()) && modelParent.getArtifactId().equals(model.getArtifactId())) {
            throw new ProjectBuildingException(model.getId(), "Parent element is a duplicate of the current project ");
        }
        if (StringUtils.isEmpty(modelParent.getVersion())) {
            throw new ProjectBuildingException(model.getId(), "Missing version element from parent element");
        }
    }

    /*
     * WARNING - void declaration
     */
    private File resolveParentFromRepositories(Parent parent, ArtifactRepository artifactRepository, List list, String string, File file) throws ProjectBuildingException {
        File file2;
        Parent parent2 = parent;
        ArtifactRepository artifactRepository2 = artifactRepository;
        List list2 = list;
        String string2 = string;
        File file3 = file;
        Object[] objectArray = new Object[]{parent2, artifactRepository2, list2, string2, file3};
        ProjectArtifactErrorReporterAspect.ajc$cflowStack$0.push(objectArray);
        try {
            void childId;
            void childPomFile;
            void modelParent;
            Artifact parentPomArtifact = this.artifactFactory.createBuildArtifact(modelParent.getGroupId(), modelParent.getArtifactId(), modelParent.getVersion(), "pom");
            try {
                void localRepository;
                void remoteRepositories;
                this.artifactResolver.resolve(parentPomArtifact, (List)remoteRepositories, (ArtifactRepository)localRepository);
            }
            catch (ArtifactResolutionException e) {
                ArtifactResolutionException artifactResolutionException = e;
                void var9_16 = childPomFile;
                String string3 = "Failed to resolve parent POM: " + modelParent.getId();
                void var11_18 = childId;
                if (ProjectArtifactErrorReporterAspect.ajc$cflowStack$0.isValid()) {
                    ProjectArtifactErrorReporterAspect.aspectOf().ajc$before$org_apache_maven_project_aspect_ProjectArtifactErrorReporterAspect$2$d5e5d2ca((Parent)ProjectArtifactErrorReporterAspect.ajc$cflowStack$0.get(0), (ArtifactRepository)ProjectArtifactErrorReporterAspect.ajc$cflowStack$0.get(1), (List)ProjectArtifactErrorReporterAspect.ajc$cflowStack$0.get(2), (String)ProjectArtifactErrorReporterAspect.ajc$cflowStack$0.get(3), (File)ProjectArtifactErrorReporterAspect.ajc$cflowStack$0.get(4), artifactResolutionException);
                }
                throw new ProjectBuildingException((String)var11_18, string3, (File)var9_16, artifactResolutionException);
            }
            catch (ArtifactNotFoundException e) {
                ArtifactNotFoundException artifactNotFoundException = e;
                void var13_20 = childPomFile;
                String string4 = "Cannot find artifact for parent POM: " + modelParent.getId();
                void var15_22 = childId;
                if (ProjectArtifactErrorReporterAspect.ajc$cflowStack$0.isValid()) {
                    ProjectArtifactErrorReporterAspect.aspectOf().ajc$before$org_apache_maven_project_aspect_ProjectArtifactErrorReporterAspect$1$24380a87((Parent)ProjectArtifactErrorReporterAspect.ajc$cflowStack$0.get(0), (ArtifactRepository)ProjectArtifactErrorReporterAspect.ajc$cflowStack$0.get(1), (List)ProjectArtifactErrorReporterAspect.ajc$cflowStack$0.get(2), (String)ProjectArtifactErrorReporterAspect.ajc$cflowStack$0.get(3), (File)ProjectArtifactErrorReporterAspect.ajc$cflowStack$0.get(4), artifactNotFoundException);
                }
                throw new ProjectBuildingException((String)var15_22, string4, (File)var13_20, artifactNotFoundException);
            }
            file2 = parentPomArtifact.isResolved() ? parentPomArtifact.getFile() : null;
        }
        finally {
            ProjectArtifactErrorReporterAspect.ajc$cflowStack$0.pop();
        }
        return file2;
    }

    private File resolveParentWithRelativePath(Parent modelParent, File modelPomFile) throws ProjectBuildingException {
        String relativePath = modelParent.getRelativePath();
        File modelDir = modelPomFile.getParentFile();
        File parentPomFile = new File(modelDir, relativePath);
        if (parentPomFile.isDirectory()) {
            parentPomFile = new File(parentPomFile, "pom.xml");
        }
        if (parentPomFile.exists()) {
            boolean versionsMatch;
            Model parentModel = this.readModel(parentPomFile);
            boolean groupsMatch = parentModel.getGroupId() == null || parentModel.getGroupId().equals(modelParent.getGroupId());
            boolean bl = versionsMatch = parentModel.getVersion() == null || parentModel.getVersion().equals(modelParent.getVersion());
            if (groupsMatch && versionsMatch && parentModel.getArtifactId().equals(modelParent.getArtifactId())) {
                return parentPomFile;
            }
        }
        return null;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new ConsoleLogger(0, "DefaultModelLineageBuilder:internal");
        }
        return this.logger;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public static /* synthetic */ void ajc$privFieldSet$org_apache_maven_project_aspect_ProjectCacheAspect$org_apache_maven_project_build_model_DefaultModelLineageBuilder$projectWorkspace(DefaultModelLineageBuilder defaultModelLineageBuilder, ProjectWorkspace projectWorkspace) {
        defaultModelLineageBuilder.projectWorkspace = projectWorkspace;
    }

    public static /* synthetic */ void ajc$privFieldSet$org_apache_maven_project_aspect_ProjectCacheAspect$org_apache_maven_project_build_model_DefaultModelLineageBuilder$logger(DefaultModelLineageBuilder defaultModelLineageBuilder, Logger logger) {
        defaultModelLineageBuilder.logger = logger;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Model readModel_aroundBody1$advice(DefaultModelLineageBuilder this_, DefaultModelLineageBuilder pomFile, File builder, ProjectCacheAspect ajc_aroundClosure, File file, DefaultModelLineageBuilder defaultModelLineageBuilder, AroundClosure aroundClosure) {
        void cached;
        defaultModelLineageBuilder.logger.debug("Checking cache for model-and-file instance for pom in file: " + file);
        ModelAndFile modelAndFile = defaultModelLineageBuilder.projectWorkspace.getModelAndFile(file);
        if (modelAndFile != null) {
            defaultModelLineageBuilder.logger.debug("Returning cached pom instance.");
            return modelAndFile.getModel();
        }
        defaultModelLineageBuilder.logger.debug("Allowing readModel(..) to proceed for pom in file: " + cached);
        AroundClosure aroundClosure2 = aroundClosure;
        DefaultModelLineageBuilder defaultModelLineageBuilder2 = defaultModelLineageBuilder;
        void var10_10 = cached;
        return pomFile.readModel((File)var10_10);
    }

    private static final /* synthetic */ ModelAndFile init$_aroundBody2(DefaultModelLineageBuilder defaultModelLineageBuilder, Model model, File file, boolean bl) {
        return new ModelAndFile(model, file, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ ModelAndFile init$_aroundBody3$advice(DefaultModelLineageBuilder this_, Model model, File pomFile, boolean builder, ProjectCacheAspect ajc_aroundClosure, Model model2, File file, DefaultModelLineageBuilder defaultModelLineageBuilder, AroundClosure aroundClosure) {
        defaultModelLineageBuilder.logger.debug("Checking cache for model-and-file instance for file: " + file);
        ModelAndFile modelAndFile = defaultModelLineageBuilder.projectWorkspace.getModelAndFile(file);
        if (modelAndFile == null) {
            void cached;
            defaultModelLineageBuilder.logger.debug("Allowing construction to proceed for model-and-file with model: " + cached.getId() + " and file: " + file);
            AroundClosure aroundClosure2 = aroundClosure;
            DefaultModelLineageBuilder defaultModelLineageBuilder2 = defaultModelLineageBuilder;
            File file2 = file;
            void var13_13 = cached;
            modelAndFile = DefaultModelLineageBuilder.init$_aroundBody2(defaultModelLineageBuilder2, (Model)var13_13, file2, builder);
            defaultModelLineageBuilder.logger.debug("Storing: " + modelAndFile);
            defaultModelLineageBuilder.projectWorkspace.storeModelAndFile(modelAndFile);
        } else {
            defaultModelLineageBuilder.logger.debug("Returning cached model-and-file instance.");
        }
        return modelAndFile;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ ModelAndFile resolveParentPom_aroundBody4(DefaultModelLineageBuilder defaultModelLineageBuilder, ModelAndFile modelAndFile, List list, ArtifactRepository artifactRepository, boolean bl) {
        ModelAndFile modelAndFile2;
        Object[] objectArray = new Object[]{modelAndFile};
        ProjectIOErrorReporterAspect.ajc$cflowStack$2.push(objectArray);
        try {
            void child;
            Model model = child.getModel();
            File modelPomFile = child.getFile();
            Parent modelParent = model.getParent();
            ModelAndFile result = null;
            if (modelParent != null) {
                void allowStubs;
                this.validateParentDeclaration(modelParent, model);
                File parentPomFile = null;
                if (modelPomFile != null) {
                    parentPomFile = this.resolveParentWithRelativePath(modelParent, modelPomFile);
                }
                boolean isResolved = false;
                if (parentPomFile == null) {
                    try {
                        void localRepository;
                        void remoteRepositories;
                        this.getLogger().debug("Attempting to resolve parent POM: " + modelParent.getId() + " using repositories:\n" + StringUtils.join(remoteRepositories.iterator(), "\n"));
                        parentPomFile = this.resolveParentFromRepositories(modelParent, (ArtifactRepository)localRepository, (List)remoteRepositories, model.getId(), modelPomFile);
                        isResolved = true;
                    }
                    catch (ProjectBuildingException e) {
                        if (allowStubs != false) {
                            this.getLogger().debug("DISREGARDING the error encountered while resolving artifact for: " + modelParent.getId() + ", building a stub model in its place.", e);
                            parentPomFile = null;
                        }
                        throw e;
                    }
                }
                if (parentPomFile == null) {
                    if (allowStubs != false) {
                        this.getLogger().warn("Cannot find parent POM: " + modelParent.getId() + " for child: " + model.getId() + ". Using stub model instead.");
                        Model parent = new Model();
                        parent.setGroupId(modelParent.getGroupId());
                        parent.setArtifactId(modelParent.getArtifactId());
                        parent.setVersion(modelParent.getVersion());
                        result = new ModelAndFile(parent, parentPomFile, false);
                    } else {
                        this.getLogger().error("Cannot find parent POM: " + modelParent.getId());
                    }
                } else {
                    Model parent = this.readModel(parentPomFile);
                    result = new ModelAndFile(parent, parentPomFile, !isResolved);
                }
            }
            modelAndFile2 = result;
        }
        finally {
            ProjectIOErrorReporterAspect.ajc$cflowStack$2.pop();
        }
        return modelAndFile2;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ ModelAndFile resolveParentPom_aroundBody5$advice(DefaultModelLineageBuilder this_, ModelAndFile child, List builder, ArtifactRepository ajc_aroundClosure, boolean bl, ProjectCacheAspect projectCacheAspect, ModelAndFile modelAndFile, DefaultModelLineageBuilder defaultModelLineageBuilder, AroundClosure aroundClosure) {
        Model model = modelAndFile.getModel();
        Parent parent = model.getParent();
        ModelAndFile modelAndFile2 = null;
        if (!(parent == null || StringUtils.isEmpty(parent.getGroupId()) || StringUtils.isEmpty(parent.getArtifactId()) || StringUtils.isEmpty(parent.getVersion()))) {
            void key;
            void parentRef;
            String string = parentRef.ajc$privMethod$org_apache_maven_project_aspect_ProjectCacheAspect$org_apache_maven_project_aspect_ProjectCacheAspect$createCacheKey(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
            ((DefaultModelLineageBuilder)key).logger.debug("Checking cache for parent model-and-file instance: " + string);
            modelAndFile2 = ((DefaultModelLineageBuilder)key).projectWorkspace.getModelAndFile(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
            if (modelAndFile2 == null) {
                void childModel;
                void parent2;
                ((DefaultModelLineageBuilder)key).logger.debug("Allowing parent-model resolution to proceed for: " + string + " (child is: " + model.getId() + ")");
                AroundClosure aroundClosure2 = aroundClosure;
                void var14_14 = key;
                void var15_15 = parent2;
                modelAndFile2 = DefaultModelLineageBuilder.resolveParentPom_aroundBody4((DefaultModelLineageBuilder)var14_14, (ModelAndFile)var15_15, builder, ajc_aroundClosure, (boolean)childModel);
                if (modelAndFile2 != null) {
                    ((DefaultModelLineageBuilder)key).logger.debug("Caching parent model-and-file under: " + string + " and file: " + modelAndFile2.getFile() + " (child is: " + model.getId() + ")");
                    ((DefaultModelLineageBuilder)key).projectWorkspace.storeModelAndFile(modelAndFile2);
                }
            } else {
                ((DefaultModelLineageBuilder)key).logger.debug("Returning cached instance.");
            }
        }
        return modelAndFile2;
    }
}

