/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.MavenTools;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactStatus;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.UnknownRepositoryLayoutException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.ManagedVersionMap;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Repository;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.profiles.MavenProfilesBuilder;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.profiles.activation.DefaultProfileActivationContext;
import org.apache.maven.profiles.activation.ProfileActivationContext;
import org.apache.maven.profiles.activation.ProfileActivationException;
import org.apache.maven.profiles.build.ProfileAdvisor;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.InvalidProjectVersionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.MavenProjectBuildingResult;
import org.apache.maven.project.ModelUtils;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.aspect.PBEDerivativeReporterAspect;
import org.apache.maven.project.aspect.ProjectCacheAspect;
import org.apache.maven.project.aspect.ProjectIOErrorReporterAspect;
import org.apache.maven.project.build.model.DefaultModelLineage;
import org.apache.maven.project.build.model.ModelLineageBuilder;
import org.apache.maven.project.build.model.ModelLineageIterator;
import org.apache.maven.project.inheritance.ModelInheritanceAssembler;
import org.apache.maven.project.injection.ModelDefaultsInjector;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.project.interpolation.ModelInterpolator;
import org.apache.maven.project.path.PathTranslator;
import org.apache.maven.project.validation.ModelValidationResult;
import org.apache.maven.project.validation.ModelValidator;
import org.apache.maven.project.workspace.ProjectWorkspace;
import org.aspectj.runtime.internal.AroundClosure;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultMavenProjectBuilder
implements MavenProjectBuilder,
Initializable,
LogEnabled {
    protected MavenProfilesBuilder profilesBuilder;
    protected ArtifactResolver artifactResolver;
    protected ArtifactMetadataSource artifactMetadataSource;
    private ArtifactFactory artifactFactory;
    private ModelInheritanceAssembler modelInheritanceAssembler;
    private ModelValidator validator;
    private MavenXpp3Reader modelReader;
    private PathTranslator pathTranslator;
    private ModelDefaultsInjector modelDefaultsInjector;
    private ModelInterpolator modelInterpolator;
    private ModelLineageBuilder modelLineageBuilder;
    private ProfileAdvisor profileAdvisor;
    private MavenTools mavenTools;
    private ProjectWorkspace projectWorkspace;
    private Map processedProjectCache = new HashMap();
    public static final String MAVEN_MODEL_VERSION = "4.0.0";
    private Logger logger;
    private Model superModel;
    static /* synthetic */ Class class$0;

    public void initialize() {
        this.modelReader = new MavenXpp3Reader();
    }

    public MavenProject build(File projectDescriptor, ArtifactRepository localRepository, ProfileManager profileManager) throws ProjectBuildingException {
        return this.buildFromSourceFileInternal(projectDescriptor, localRepository, profileManager);
    }

    public MavenProject buildFromRepository(Artifact artifact, List list, ArtifactRepository artifactRepository, boolean bl) throws ProjectBuildingException {
        Artifact artifact2 = artifact;
        List list2 = list;
        ArtifactRepository artifactRepository2 = artifactRepository;
        boolean bl2 = bl;
        return DefaultMavenProjectBuilder.buildFromRepository_aroundBody1$advice(this, artifact2, list2, artifactRepository2, bl2, ProjectCacheAspect.aspectOf(), artifact2, this, null);
    }

    public MavenProject buildFromRepository(Artifact artifact, List list, ArtifactRepository artifactRepository) throws ProjectBuildingException {
        Artifact artifact2 = artifact;
        List list2 = list;
        ArtifactRepository artifactRepository2 = artifactRepository;
        return DefaultMavenProjectBuilder.buildFromRepository_aroundBody3$advice(this, artifact2, list2, artifactRepository2, ProjectCacheAspect.aspectOf(), artifact2, this, null);
    }

    public MavenProject buildStandaloneSuperProject() throws ProjectBuildingException {
        return this.buildStandaloneSuperProject(null);
    }

    public MavenProject buildStandaloneSuperProject(ProfileManager profileManager) throws ProjectBuildingException {
        Model superModel = this.getSuperModel();
        superModel.setGroupId("org.apache.maven");
        superModel.setArtifactId("super-pom");
        superModel.setVersion("2.1");
        superModel = ModelUtils.cloneModel(superModel);
        ArrayList activeProfiles = new ArrayList();
        if (profileManager != null) {
            List activated = this.profileAdvisor.applyActivatedProfiles(superModel, null, false, profileManager.getProfileActivationContext());
            if (!activated.isEmpty()) {
                activeProfiles.addAll(activated);
            }
            if (!(activated = this.profileAdvisor.applyActivatedExternalProfiles(superModel, null, profileManager)).isEmpty()) {
                activeProfiles.addAll(activated);
            }
        }
        MavenProject project = new MavenProject(superModel);
        String projectId = this.safeVersionlessKey("org.apache.maven", "super-pom");
        project.setManagedVersionMap(this.createManagedVersionMap(projectId, superModel.getDependencyManagement(), null));
        this.getLogger().debug("Activated the following profiles for standalone super-pom: " + activeProfiles);
        project.setActiveProfiles(activeProfiles);
        try {
            this.processProjectLogic(project, null, true);
            project.setRemoteArtifactRepositories(this.mavenTools.buildArtifactRepositories(superModel.getRepositories()));
            project.setPluginArtifactRepositories(this.mavenTools.buildArtifactRepositories(superModel.getRepositories()));
        }
        catch (InvalidRepositoryException e) {
            throw new ProjectBuildingException("org.apache.maven:super-pom", "Maven super-POM contains an invalid repository!", e);
        }
        catch (ModelInterpolationException e) {
            throw new ProjectBuildingException("org.apache.maven:super-pom", "Maven super-POM contains an invalid expressions!", e);
        }
        project.setOriginalModel(superModel);
        project.setExecutionRoot(true);
        return project;
    }

    public MavenProject buildWithDependencies(File projectDescriptor, ArtifactRepository localRepository, ProfileManager profileManager) throws ProjectBuildingException {
        return this.buildProjectWithDependencies(projectDescriptor, localRepository, profileManager).getProject();
    }

    public MavenProjectBuildingResult buildProjectWithDependencies(File projectDescriptor, ArtifactRepository localRepository, ProfileManager profileManager) throws ProjectBuildingException {
        MavenProject project = this.build(projectDescriptor, localRepository, profileManager);
        Artifact projectArtifact = project.getArtifact();
        String projectId = this.safeVersionlessKey(project.getGroupId(), project.getArtifactId());
        Map managedVersions = project.getManagedVersionMap();
        try {
            project.setDependencyArtifacts(project.createArtifacts(this.artifactFactory, null, null));
        }
        catch (InvalidDependencyVersionException e) {
            throw new ProjectBuildingException(projectId, "Unable to build project due to an invalid dependency version: " + e.getMessage(), projectDescriptor, e);
        }
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(projectArtifact).setArtifactDependencies(project.getDependencyArtifacts()).setLocalRepository(localRepository).setRemoteRepostories(project.getRemoteArtifactRepositories()).setManagedVersionMap(managedVersions).setMetadataSource(this.artifactMetadataSource);
        ArtifactResolutionResult result = this.artifactResolver.resolve(request);
        project.setArtifacts(result.getArtifacts());
        return new MavenProjectBuildingResult(project, result);
    }

    /*
     * WARNING - void declaration
     */
    private Map createManagedVersionMap(String string, DependencyManagement dependencyManagement, File file) throws ProjectBuildingException {
        String string2 = string;
        DependencyManagement dependencyManagement2 = dependencyManagement;
        File file2 = file;
        try {
            List deps;
            void dependencyManagement3;
            Map map = null;
            if (dependencyManagement3 != null && (deps = dependencyManagement3.getDependencies()) != null && deps.size() > 0) {
                void projectId;
                map = new ManagedVersionMap(map);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Adding managed dependencies for " + (String)projectId);
                }
                Iterator i = dependencyManagement3.getDependencies().iterator();
                while (i.hasNext()) {
                    Dependency d = (Dependency)i.next();
                    try {
                        VersionRange versionRange = VersionRange.createFromVersionSpec(d.getVersion());
                        Artifact artifact = this.artifactFactory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope(), d.isOptional());
                        if (Artifact.SCOPE_SYSTEM.equals(d.getScope()) && d.getSystemPath() != null) {
                            artifact.setFile(new File(d.getSystemPath()));
                        }
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("  " + artifact);
                        }
                        if (d.getExclusions() != null && !d.getExclusions().isEmpty()) {
                            ArrayList<String> exclusions = new ArrayList<String>();
                            Iterator j = d.getExclusions().iterator();
                            while (j.hasNext()) {
                                Exclusion e = (Exclusion)j.next();
                                exclusions.add(String.valueOf(e.getGroupId()) + ":" + e.getArtifactId());
                            }
                            ExcludesArtifactFilter eaf = new ExcludesArtifactFilter(exclusions);
                            artifact.setDependencyFilter(eaf);
                        } else {
                            artifact.setDependencyFilter(null);
                        }
                        map.put(d.getManagementKey(), artifact);
                    }
                    catch (InvalidVersionSpecificationException e) {
                        void pomFile;
                        throw new InvalidDependencyVersionException((String)projectId, d, (File)pomFile, e);
                    }
                }
            } else if (map == null) {
                map = Collections.EMPTY_MAP;
            }
            return map;
        }
        catch (ProjectBuildingException projectBuildingException) {
            if (PBEDerivativeReporterAspect.ajc$cflowCounter$2.isValid()) {
                PBEDerivativeReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$9$8ca2645c(file2, projectBuildingException);
            }
            throw projectBuildingException;
        }
    }

    private MavenProject buildFromSourceFileInternal(File file, ArtifactRepository artifactRepository, ProfileManager profileManager) throws ProjectBuildingException {
        File file2 = file;
        ArtifactRepository artifactRepository2 = artifactRepository;
        ProfileManager profileManager2 = profileManager;
        return DefaultMavenProjectBuilder.buildFromSourceFileInternal_aroundBody5$advice(this, file2, artifactRepository2, profileManager2, ProjectCacheAspect.aspectOf(), file2, this, null);
    }

    private Model findModelFromRepository(Artifact artifact, List remoteArtifactRepositories, ArtifactRepository localRepository) throws ProjectBuildingException {
        Model model;
        Artifact projectArtifact;
        String projectId = this.safeVersionlessKey(artifact.getGroupId(), artifact.getArtifactId());
        remoteArtifactRepositories = this.normalizeToArtifactRepositories(remoteArtifactRepositories, projectId);
        if ("pom".equals(artifact.getType())) {
            projectArtifact = artifact;
        } else {
            this.getLogger().warn("Attempting to build MavenProject instance for Artifact (" + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ") of type: " + artifact.getType() + "; constructing POM artifact instead.");
            projectArtifact = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope());
        }
        try {
            this.artifactResolver.resolve(projectArtifact, remoteArtifactRepositories, localRepository);
            File file = projectArtifact.getFile();
            model = this.readModel(projectId, file, true);
            String downloadUrl = null;
            ArtifactStatus status = ArtifactStatus.NONE;
            DistributionManagement distributionManagement = model.getDistributionManagement();
            if (distributionManagement != null) {
                downloadUrl = distributionManagement.getDownloadUrl();
                status = ArtifactStatus.valueOf(distributionManagement.getStatus());
            }
            this.checkStatusAndUpdate(projectArtifact, status, file, remoteArtifactRepositories, localRepository);
            if (downloadUrl != null) {
                projectArtifact.setDownloadUrl(downloadUrl);
            } else {
                projectArtifact.setDownloadUrl(model.getUrl());
            }
        }
        catch (ArtifactResolutionException e) {
            throw new ProjectBuildingException(projectId, "Error getting POM for '" + projectId + "' from the repository: " + e.getMessage(), e);
        }
        catch (ArtifactNotFoundException e) {
            throw new ProjectBuildingException(projectId, "POM '" + projectId + "' not found in repository: " + e.getMessage(), e);
        }
        return model;
    }

    private List normalizeToArtifactRepositories(List remoteArtifactRepositories, String projectId) throws ProjectBuildingException {
        ArrayList normalized = new ArrayList(remoteArtifactRepositories.size());
        boolean normalizationNeeded = false;
        Iterator it = remoteArtifactRepositories.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (item instanceof ArtifactRepository) {
                normalized.add(item);
                continue;
            }
            if (item instanceof Repository) {
                Repository repo = (Repository)item;
                try {
                    item = this.mavenTools.buildArtifactRepository(repo);
                    normalized.add(item);
                    normalizationNeeded = true;
                    continue;
                }
                catch (UnknownRepositoryLayoutException e) {
                    throw new ProjectBuildingException(projectId, "Error building artifact repository for id: " + repo.getId(), e);
                }
            }
            throw new ProjectBuildingException(projectId, "Error building artifact repository from non-repository information item: " + item);
        }
        if (normalizationNeeded) {
            return normalized;
        }
        return remoteArtifactRepositories;
    }

    private void checkStatusAndUpdate(Artifact projectArtifact, ArtifactStatus status, File file, List remoteArtifactRepositories, ArtifactRepository localRepository) throws ArtifactNotFoundException {
        if (!projectArtifact.isSnapshot() && status.compareTo(ArtifactStatus.DEPLOYED) < 0) {
            ArtifactRepositoryPolicy policy = new ArtifactRepositoryPolicy();
            policy.setUpdatePolicy("never");
            if (policy.checkOutOfDate(new Date(file.lastModified()))) {
                this.getLogger().info(String.valueOf(projectArtifact.getArtifactId()) + ": updating metadata due to status of '" + status + "'");
                try {
                    projectArtifact.setResolved(false);
                    this.artifactResolver.resolveAlways(projectArtifact, remoteArtifactRepositories, localRepository);
                }
                catch (ArtifactResolutionException e) {
                    this.getLogger().warn("Error updating POM - using existing version");
                    this.getLogger().debug("Cause", e);
                }
                catch (ArtifactNotFoundException e) {
                    this.getLogger().warn("Error updating POM - not found. Removing local copy.");
                    this.getLogger().debug("Cause", e);
                    file.delete();
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private MavenProject buildInternal(Model model, ArtifactRepository artifactRepository, List list, File file, ProfileManager profileManager, boolean bl, boolean bl2, boolean bl3) throws ProjectBuildingException {
        MavenProject mavenProject;
        PBEDerivativeReporterAspect.ajc$cflowCounter$2.inc();
        try {
            MavenProject mavenProject2;
            try {
                MavenProject mavenProject3;
                PBEDerivativeReporterAspect.ajc$cflowCounter$3.inc();
                try {
                    DependencyManagement dependencyManagement;
                    void fromSourceTree;
                    MavenProject project;
                    void strict;
                    void localRepository;
                    void parentSearchRepositories;
                    void validProfilesXmlLocation;
                    ProfileActivationContext profileActivationContext;
                    void projectDescriptor;
                    void externalProfileManager;
                    void model2;
                    Model superModel = this.getSuperModel();
                    MavenProject superProject = new MavenProject(superModel);
                    String projectId = this.safeVersionlessKey(model2.getGroupId(), model2.getArtifactId());
                    if (externalProfileManager != null) {
                        try {
                            externalProfileManager.getActiveProfiles();
                        }
                        catch (ProfileActivationException e) {
                            throw new ProjectBuildingException(projectId, "Failed to activate external profiles.", (File)projectDescriptor, e);
                        }
                        profileActivationContext = externalProfileManager.getProfileActivationContext();
                    } else {
                        profileActivationContext = new DefaultProfileActivationContext(System.getProperties(), false);
                    }
                    LinkedHashSet activeInSuperPom = new LinkedHashSet();
                    List activated = this.profileAdvisor.applyActivatedProfiles(superModel, (File)projectDescriptor, (boolean)validProfilesXmlLocation, profileActivationContext);
                    if (!activated.isEmpty()) {
                        activeInSuperPom.addAll(activated);
                    }
                    if (!(activated = this.profileAdvisor.applyActivatedExternalProfiles(superModel, (File)projectDescriptor, (ProfileManager)externalProfileManager)).isEmpty()) {
                        activeInSuperPom.addAll(activated);
                    }
                    superProject.setActiveProfiles(activated);
                    LinkedList lineage = new LinkedList();
                    LinkedHashSet aggregatedRemoteWagonRepositories = this.collectInitialRepositories((Model)model2, superModel, (List)parentSearchRepositories, (File)projectDescriptor, (boolean)validProfilesXmlLocation, profileActivationContext);
                    Model originalModel = ModelUtils.cloneModel((Model)model2);
                    try {
                        project = this.assembleLineage((Model)model2, lineage, (ArtifactRepository)localRepository, (File)projectDescriptor, aggregatedRemoteWagonRepositories, (ProfileManager)externalProfileManager, (boolean)strict, (boolean)validProfilesXmlLocation);
                    }
                    catch (InvalidRepositoryException e) {
                        throw new ProjectBuildingException(projectId, e.getMessage(), e);
                    }
                    project.setOriginalModel(originalModel);
                    MavenProject previousProject = superProject;
                    Model previous = superProject.getModel();
                    Iterator i = lineage.iterator();
                    while (i.hasNext()) {
                        MavenProject currentProject = (MavenProject)i.next();
                        Model current = currentProject.getModel();
                        String pathAdjustment = null;
                        try {
                            pathAdjustment = previousProject.getModulePathAdjustment(currentProject);
                        }
                        catch (IOException e) {
                            this.getLogger().debug("Cannot determine whether " + currentProject.getId() + " is a module of " + previousProject.getId() + ". Reason: " + e.getMessage(), e);
                        }
                        this.modelInheritanceAssembler.assembleModelInheritance(current, previous, pathAdjustment);
                        previous = current;
                        previousProject = currentProject;
                    }
                    ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>(aggregatedRemoteWagonRepositories);
                    List superRepositories = this.buildArtifactRepositories(superModel);
                    Iterator i2 = superRepositories.iterator();
                    while (i2.hasNext()) {
                        ArtifactRepository repository = (ArtifactRepository)i2.next();
                        if (repositories.contains(repository)) continue;
                        repositories.add(repository);
                    }
                    ModelUtils.mergeDuplicatePluginDefinitions(project.getModel().getBuild());
                    this.mergeManagedDependencies(project.getModel(), (ArtifactRepository)localRepository, repositories);
                    try {
                        project = this.processProjectLogic(project, (File)projectDescriptor, (boolean)strict);
                    }
                    catch (ModelInterpolationException e) {
                        throw new InvalidProjectModelException(projectId, e.getMessage(), (File)projectDescriptor, e);
                    }
                    catch (InvalidRepositoryException e) {
                        throw new InvalidProjectModelException(projectId, e.getMessage(), (File)projectDescriptor, e);
                    }
                    if (fromSourceTree != false) {
                        Build build = project.getBuild();
                        project.addScriptSourceRoot(build.getScriptSourceDirectory());
                        this.getLogger().debug("Aligning project: " + project.getId() + " to base directory: " + projectDescriptor.getParentFile());
                        this.pathTranslator.alignToBaseDirectory(project.getModel(), projectDescriptor.getParentFile());
                        project.addCompileSourceRoot(build.getSourceDirectory());
                        project.addTestCompileSourceRoot(build.getTestSourceDirectory());
                        project.setFile((File)projectDescriptor);
                    }
                    MavenProject mavenProject4 = project;
                    try {
                        dependencyManagement = mavenProject4.getDependencyManagement();
                    }
                    finally {
                        if (PBEDerivativeReporterAspect.ajc$cflowCounter$2.isValid() && !PBEDerivativeReporterAspect.ajc$cflowCounter$3.isValid()) {
                            PBEDerivativeReporterAspect.aspectOf().ajc$after$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$7$96d9e7ca(mavenProject4);
                        }
                    }
                    project.setManagedVersionMap(this.createManagedVersionMap(projectId, dependencyManagement, (File)projectDescriptor));
                    mavenProject3 = project;
                }
                finally {
                    PBEDerivativeReporterAspect.ajc$cflowCounter$3.dec();
                }
                mavenProject2 = mavenProject3;
            }
            finally {
                PBEDerivativeReporterAspect.aspectOf().ajc$after$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$8$50df3e15();
            }
            mavenProject = mavenProject2;
        }
        finally {
            PBEDerivativeReporterAspect.ajc$cflowCounter$2.dec();
        }
        return mavenProject;
    }

    private LinkedHashSet collectInitialRepositories(Model model, Model superModel, List parentSearchRepositories, File pomFile, boolean validProfilesXmlLocation, ProfileActivationContext profileActivationContext) throws ProjectBuildingException {
        LinkedHashSet collected = new LinkedHashSet();
        this.collectInitialRepositoriesFromModel(collected, model, pomFile, validProfilesXmlLocation, profileActivationContext);
        this.collectInitialRepositoriesFromModel(collected, superModel, null, validProfilesXmlLocation, profileActivationContext);
        if (parentSearchRepositories != null && !parentSearchRepositories.isEmpty()) {
            collected.addAll(parentSearchRepositories);
        }
        return collected;
    }

    private void collectInitialRepositoriesFromModel(LinkedHashSet collected, Model model, File pomFile, boolean validProfilesXmlLocation, ProfileActivationContext profileActivationContext) throws ProjectBuildingException {
        List modelRepos;
        LinkedHashSet reposFromProfiles = this.profileAdvisor.getArtifactRepositoriesFromActiveProfiles(model, pomFile, validProfilesXmlLocation, profileActivationContext);
        if (reposFromProfiles != null && !reposFromProfiles.isEmpty()) {
            collected.addAll(reposFromProfiles);
        }
        if ((modelRepos = model.getRepositories()) != null && !modelRepos.isEmpty()) {
            try {
                collected.addAll(this.mavenTools.buildArtifactRepositories(modelRepos));
            }
            catch (InvalidRepositoryException e) {
                throw new ProjectBuildingException(this.safeVersionlessKey(model.getGroupId(), model.getArtifactId()), "Failed to construct ArtifactRepository instances for repositories declared in: " + model.getId(), e);
            }
        }
    }

    private String safeVersionlessKey(String groupId, String artifactId) {
        String aid;
        String gid = groupId;
        if (StringUtils.isEmpty(gid)) {
            gid = "unknown";
        }
        if (StringUtils.isEmpty(aid = artifactId)) {
            aid = "unknown";
        }
        return ArtifactUtils.versionlessKey(gid, aid);
    }

    private List buildArtifactRepositories(Model model) throws ProjectBuildingException {
        try {
            return this.mavenTools.buildArtifactRepositories(model.getRepositories());
        }
        catch (InvalidRepositoryException e) {
            String projectId = this.safeVersionlessKey(model.getGroupId(), model.getArtifactId());
            throw new ProjectBuildingException(projectId, e.getMessage(), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private MavenProject processProjectLogic(MavenProject mavenProject, File file, boolean bl) throws ProjectBuildingException, ModelInterpolationException, InvalidRepositoryException {
        MavenProject mavenProject2;
        MavenProject mavenProject3 = mavenProject;
        File file2 = file;
        boolean bl2 = bl;
        Object[] objectArray = new Object[]{mavenProject3, file2};
        PBEDerivativeReporterAspect.ajc$cflowStack$0.push(objectArray);
        try {
            try {
                Set set;
                Set set2;
                Set set3;
                void strict;
                void pomFile;
                MavenProject project;
                Model model = project.getModel();
                List activeProfiles = project.getActiveProfiles();
                HashMap<Object, Object> context = new HashMap<Object, Object>(System.getProperties());
                if (pomFile != null) {
                    context.put("basedir", pomFile.getParentFile().getAbsolutePath());
                }
                context.put("build.directory", null);
                context.put("build.outputDirectory", null);
                context.put("build.testOutputDirectory", null);
                context.put("build.sourceDirectory", null);
                context.put("build.testSourceDirectory", null);
                model = this.modelInterpolator.interpolate(model, context, (boolean)strict);
                this.modelDefaultsInjector.injectDefaults(model);
                MavenProject parentProject = project.getParent();
                Model originalModel = project.getOriginalModel();
                Artifact parentArtifact = project.getParentArtifact();
                project = new MavenProject(model);
                project.setOriginalModel(originalModel);
                project.setActiveProfiles(activeProfiles);
                Artifact projectArtifact = this.artifactFactory.createBuildArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), project.getPackaging());
                project.setArtifact(projectArtifact);
                DistributionManagement dm = model.getDistributionManagement();
                if (dm != null) {
                    ArtifactRepository artifactRepository;
                    DeploymentRepository deploymentRepository = dm.getRepository();
                    try {
                        artifactRepository = this.mavenTools.buildDeploymentArtifactRepository(deploymentRepository);
                    }
                    catch (UnknownRepositoryLayoutException unknownRepositoryLayoutException) {
                        if (PBEDerivativeReporterAspect.ajc$cflowStack$0.isValid()) {
                            PBEDerivativeReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$1$c9ecf671((MavenProject)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(0), (File)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(1), deploymentRepository, unknownRepositoryLayoutException);
                        }
                        throw unknownRepositoryLayoutException;
                    }
                    ArtifactRepository repo = artifactRepository;
                    project.setReleaseArtifactRepository(repo);
                    if (dm.getSnapshotRepository() != null) {
                        ArtifactRepository artifactRepository2;
                        DeploymentRepository deploymentRepository2 = dm.getSnapshotRepository();
                        try {
                            artifactRepository2 = this.mavenTools.buildDeploymentArtifactRepository(deploymentRepository2);
                        }
                        catch (UnknownRepositoryLayoutException unknownRepositoryLayoutException) {
                            if (PBEDerivativeReporterAspect.ajc$cflowStack$0.isValid()) {
                                PBEDerivativeReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$1$c9ecf671((MavenProject)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(0), (File)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(1), deploymentRepository2, unknownRepositoryLayoutException);
                            }
                            throw unknownRepositoryLayoutException;
                        }
                        repo = artifactRepository2;
                        project.setSnapshotArtifactRepository(repo);
                    }
                }
                project.setParent(parentProject);
                if (parentProject != null) {
                    project.setParentArtifact(parentArtifact);
                }
                this.validateModel(model, (File)pomFile);
                try {
                    project.setRemoteArtifactRepositories(this.mavenTools.buildArtifactRepositories(model.getRepositories()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String projectId = this.safeVersionlessKey(model.getGroupId(), model.getArtifactId());
                try {
                    set3 = this.createPluginArtifacts(projectId, project.getBuildPlugins(), (File)pomFile);
                }
                catch (ProjectBuildingException projectBuildingException) {
                    if (PBEDerivativeReporterAspect.ajc$cflowStack$0.isValid()) {
                        PBEDerivativeReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$5$75526fa3((MavenProject)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(0), (File)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(1), projectBuildingException);
                    }
                    throw projectBuildingException;
                }
                project.setPluginArtifacts(set3);
                try {
                    set2 = this.createReportArtifacts(projectId, project.getReportPlugins(), (File)pomFile);
                }
                catch (ProjectBuildingException projectBuildingException) {
                    if (PBEDerivativeReporterAspect.ajc$cflowStack$0.isValid()) {
                        PBEDerivativeReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$5$75526fa3((MavenProject)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(0), (File)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(1), projectBuildingException);
                    }
                    throw projectBuildingException;
                }
                project.setReportArtifacts(set2);
                try {
                    set = this.createExtensionArtifacts(projectId, project.getBuildExtensions(), (File)pomFile);
                }
                catch (ProjectBuildingException projectBuildingException) {
                    if (PBEDerivativeReporterAspect.ajc$cflowStack$0.isValid()) {
                        PBEDerivativeReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$5$75526fa3((MavenProject)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(0), (File)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(1), projectBuildingException);
                    }
                    throw projectBuildingException;
                }
                project.setExtensionArtifacts(set);
                mavenProject2 = project;
            }
            catch (ModelInterpolationException modelInterpolationException) {
                PBEDerivativeReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$4$d0ee7141(mavenProject3, file2, modelInterpolationException);
                throw modelInterpolationException;
            }
        }
        finally {
            PBEDerivativeReporterAspect.ajc$cflowStack$0.pop();
        }
        return mavenProject2;
    }

    private void validateModel(Model model, File pomFile) throws InvalidProjectModelException {
        try {
            ModelValidationResult validationResult = this.validator.validate(model);
            String projectId = this.safeVersionlessKey(model.getGroupId(), model.getArtifactId());
            if (validationResult.getMessageCount() > 0) {
                throw new InvalidProjectModelException(projectId, "Failed to validate POM", pomFile, validationResult);
            }
            return;
        }
        catch (InvalidProjectModelException invalidProjectModelException) {
            if (PBEDerivativeReporterAspect.ajc$cflowStack$0.isValid()) {
                PBEDerivativeReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$6$a894ddb((MavenProject)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(0), (File)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(1), invalidProjectModelException);
            }
            throw invalidProjectModelException;
        }
    }

    private MavenProject assembleLineage(Model model, LinkedList lineage, ArtifactRepository localRepository, File pomFile, Set aggregatedRemoteWagonRepositories, ProfileManager externalProfileManager, boolean strict, boolean validProfilesXmlLocation) throws ProjectBuildingException, InvalidRepositoryException {
        DefaultModelLineage modelLineage = new DefaultModelLineage();
        modelLineage.setOrigin(model, pomFile, new ArrayList(aggregatedRemoteWagonRepositories), validProfilesXmlLocation);
        this.modelLineageBuilder.resumeBuildingModelLineage(modelLineage, localRepository, externalProfileManager, !strict);
        ProfileActivationContext profileActivationContext = externalProfileManager != null ? externalProfileManager.getProfileActivationContext() : new DefaultProfileActivationContext(System.getProperties(), false);
        MavenProject lastProject = null;
        ModelLineageIterator it = modelLineage.lineageIterator();
        while (it.hasNext()) {
            Model currentModel = (Model)it.next();
            File currentPom = it.getPOMFile();
            MavenProject project = new MavenProject(currentModel);
            project.setFile(currentPom);
            if (lastProject != null) {
                lastProject.setParent(project);
                project = lastProject.getParent();
                lastProject.setParentArtifact(this.artifactFactory.createParentArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion()));
            }
            project.setActiveProfiles(this.profileAdvisor.applyActivatedProfiles(project.getModel(), project.getFile(), validProfilesXmlLocation, profileActivationContext));
            lineage.addFirst(project);
            lastProject = project;
        }
        MavenProject result = (MavenProject)lineage.getLast();
        if (externalProfileManager != null) {
            LinkedHashSet active = new LinkedHashSet();
            List existingActiveProfiles = result.getActiveProfiles();
            if (existingActiveProfiles != null && !existingActiveProfiles.isEmpty()) {
                active.addAll(existingActiveProfiles);
            }
            this.profileAdvisor.applyActivatedExternalProfiles(result.getModel(), pomFile, externalProfileManager);
        }
        return result;
    }

    private void mergeManagedDependencies(Model model, ArtifactRepository localRepository, List parentSearchRepositories) throws ProjectBuildingException {
        DependencyManagement modelDepMgmt = model.getDependencyManagement();
        if (modelDepMgmt != null) {
            TreeMap<String, Dependency> depsMap = new TreeMap<String, Dependency>();
            Iterator iter = modelDepMgmt.getDependencies().iterator();
            boolean doInclude = false;
            while (iter.hasNext()) {
                Dependency dep = (Dependency)iter.next();
                depsMap.put(dep.getManagementKey(), dep);
                if (!dep.getType().equals("pom")) continue;
                doInclude = true;
            }
            TreeMap<String, Dependency> newDeps = new TreeMap<String, Dependency>((Map<String, Dependency>)depsMap);
            iter = modelDepMgmt.getDependencies().iterator();
            if (doInclude) {
                while (iter.hasNext()) {
                    DependencyManagement dependencyManagement;
                    MavenProject project;
                    Dependency dep = (Dependency)iter.next();
                    if (!dep.getType().equals("pom")) continue;
                    Artifact artifact = this.artifactFactory.createProjectArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getScope());
                    MavenProject mavenProject = project = this.buildFromRepository(artifact, parentSearchRepositories, localRepository, false);
                    try {
                        dependencyManagement = mavenProject.getDependencyManagement();
                    }
                    finally {
                        if (PBEDerivativeReporterAspect.ajc$cflowCounter$2.isValid() && !PBEDerivativeReporterAspect.ajc$cflowCounter$3.isValid()) {
                            PBEDerivativeReporterAspect.aspectOf().ajc$after$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$7$96d9e7ca(mavenProject);
                        }
                    }
                    DependencyManagement depMgmt = dependencyManagement;
                    if (depMgmt == null) continue;
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Importing managed dependencies for " + dep.toString());
                    }
                    Iterator it = depMgmt.getDependencies().iterator();
                    while (it.hasNext()) {
                        Dependency includedDep = (Dependency)it.next();
                        String key = includedDep.getManagementKey();
                        if (newDeps.containsKey(key)) continue;
                        newDeps.put(includedDep.getManagementKey(), includedDep);
                    }
                    newDeps.remove(dep.getManagementKey());
                }
                ArrayList deps = new ArrayList(newDeps.values());
                modelDepMgmt.setDependencies(deps);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Model readModel(String string, File file, boolean bl) throws ProjectBuildingException {
        String string2 = string;
        File file2 = file;
        boolean bl2 = bl;
        Object[] objectArray = new Object[]{string2, file2};
        ProjectIOErrorReporterAspect.ajc$cflowStack$0.push(objectArray);
        try {
            Model model;
            ProjectIOErrorReporterAspect.ajc$cflowCounter$1.inc();
            try {
                XmlStreamReader reader = null;
                try {
                    void projectId;
                    void file3;
                    try {
                        reader = ReaderFactory.newXmlReader((File)file3);
                        String modelSource = IOUtil.toString(reader);
                        this.checkModelVersion(modelSource, (String)projectId, (File)file3);
                        StringReader sReader = new StringReader(modelSource);
                        try {
                            void strict;
                            Model model2 = this.modelReader.read(sReader, (boolean)strict);
                            Object var8_14 = null;
                            IOUtil.close(reader);
                            model = model2;
                        }
                        catch (XmlPullParserException e) {
                            throw new InvalidProjectModelException((String)projectId, "Parse error reading POM. Reason: " + e.getMessage(), (File)file3, e);
                        }
                    }
                    catch (FileNotFoundException e) {
                        FileNotFoundException fileNotFoundException = e;
                        void var12_19 = file3;
                        String string3 = "Could not find the model file '" + file3.getAbsolutePath() + "'.";
                        void var14_21 = projectId;
                        if (!ProjectIOErrorReporterAspect.ajc$cflowStack$0.isValid()) throw new ProjectBuildingException((String)var14_21, string3, (File)var12_19, (IOException)fileNotFoundException);
                        if (ProjectIOErrorReporterAspect.ajc$cflowCounter$1.isValid()) throw new ProjectBuildingException((String)var14_21, string3, (File)var12_19, (IOException)fileNotFoundException);
                        ProjectIOErrorReporterAspect.aspectOf().ajc$before$org_apache_maven_project_aspect_ProjectIOErrorReporterAspect$2$1878ea4d((String)ProjectIOErrorReporterAspect.ajc$cflowStack$0.get(0), (File)ProjectIOErrorReporterAspect.ajc$cflowStack$0.get(1), fileNotFoundException);
                        throw new ProjectBuildingException((String)var14_21, string3, (File)var12_19, (IOException)fileNotFoundException);
                    }
                    catch (IOException e) {
                        IOException iOException = e;
                        void var16_23 = file3;
                        String string4 = "Failed to build model from file '" + file3.getAbsolutePath() + "'.\nError: '" + e.getLocalizedMessage() + "'";
                        void var18_25 = projectId;
                        if (!ProjectIOErrorReporterAspect.ajc$cflowStack$0.isValid()) throw new ProjectBuildingException((String)var18_25, string4, (File)var16_23, iOException);
                        if (ProjectIOErrorReporterAspect.ajc$cflowCounter$1.isValid()) throw new ProjectBuildingException((String)var18_25, string4, (File)var16_23, iOException);
                        ProjectIOErrorReporterAspect.aspectOf().ajc$before$org_apache_maven_project_aspect_ProjectIOErrorReporterAspect$2$1878ea4d((String)ProjectIOErrorReporterAspect.ajc$cflowStack$0.get(0), (File)ProjectIOErrorReporterAspect.ajc$cflowStack$0.get(1), iOException);
                        throw new ProjectBuildingException((String)var18_25, string4, (File)var16_23, iOException);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_15 = null;
                    IOUtil.close(reader);
                    throw throwable;
                }
            }
            finally {
                ProjectIOErrorReporterAspect.ajc$cflowCounter$1.dec();
            }
            Model model3 = model;
            return model3;
        }
        finally {
            ProjectIOErrorReporterAspect.ajc$cflowStack$0.pop();
        }
    }

    private void checkModelVersion(String modelSource, String projectId, File file) throws InvalidProjectModelException {
        if (modelSource.indexOf("<modelVersion>4.0.0") < 0) {
            throw new InvalidProjectModelException(projectId, "Not a v4.0.0 POM.", file);
        }
    }

    protected Set createPluginArtifacts(String projectId, List plugins, String pomLocation) throws ProjectBuildingException {
        Set set;
        try {
            set = this.createPluginArtifacts(projectId, plugins, new File(pomLocation));
        }
        catch (ProjectBuildingException projectBuildingException) {
            if (PBEDerivativeReporterAspect.ajc$cflowStack$0.isValid()) {
                PBEDerivativeReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$5$75526fa3((MavenProject)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(0), (File)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(1), projectBuildingException);
            }
            throw projectBuildingException;
        }
        return set;
    }

    protected Set createPluginArtifacts(String projectId, List plugins, File pomLocation) throws ProjectBuildingException {
        HashSet<Artifact> pluginArtifacts = new HashSet<Artifact>();
        Iterator i = plugins.iterator();
        while (i.hasNext()) {
            Artifact artifact;
            Plugin p = (Plugin)i.next();
            String version = StringUtils.isEmpty(p.getVersion()) ? "RELEASE" : p.getVersion();
            try {
                artifact = this.artifactFactory.createPluginArtifact(p.getGroupId(), p.getArtifactId(), VersionRange.createFromVersionSpec(version));
            }
            catch (InvalidVersionSpecificationException e) {
                throw new InvalidProjectVersionException(projectId, "Plugin: " + p.getKey(), version, pomLocation, e);
            }
            if (artifact == null) continue;
            pluginArtifacts.add(artifact);
        }
        return pluginArtifacts;
    }

    protected Set createReportArtifacts(String projectId, List reports, String pomLocation) throws ProjectBuildingException {
        Set set;
        try {
            set = this.createReportArtifacts(projectId, reports, new File(pomLocation));
        }
        catch (ProjectBuildingException projectBuildingException) {
            if (PBEDerivativeReporterAspect.ajc$cflowStack$0.isValid()) {
                PBEDerivativeReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$5$75526fa3((MavenProject)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(0), (File)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(1), projectBuildingException);
            }
            throw projectBuildingException;
        }
        return set;
    }

    protected Set createReportArtifacts(String projectId, List reports, File pomLocation) throws ProjectBuildingException {
        HashSet<Artifact> pluginArtifacts = new HashSet<Artifact>();
        if (reports != null) {
            Iterator i = reports.iterator();
            while (i.hasNext()) {
                Artifact artifact;
                ReportPlugin p = (ReportPlugin)i.next();
                String version = StringUtils.isEmpty(p.getVersion()) ? "RELEASE" : p.getVersion();
                try {
                    artifact = this.artifactFactory.createPluginArtifact(p.getGroupId(), p.getArtifactId(), VersionRange.createFromVersionSpec(version));
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new InvalidProjectVersionException(projectId, "Report plugin: " + p.getKey(), version, pomLocation, e);
                }
                if (artifact == null) continue;
                pluginArtifacts.add(artifact);
            }
        }
        return pluginArtifacts;
    }

    protected Set createExtensionArtifacts(String projectId, List extensions, String pomLocation) throws ProjectBuildingException {
        Set set;
        try {
            set = this.createExtensionArtifacts(projectId, extensions, new File(pomLocation));
        }
        catch (ProjectBuildingException projectBuildingException) {
            if (PBEDerivativeReporterAspect.ajc$cflowStack$0.isValid()) {
                PBEDerivativeReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$5$75526fa3((MavenProject)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(0), (File)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(1), projectBuildingException);
            }
            throw projectBuildingException;
        }
        return set;
    }

    protected Set createExtensionArtifacts(String projectId, List extensions, File pomFile) throws ProjectBuildingException {
        HashSet<Artifact> extensionArtifacts = new HashSet<Artifact>();
        if (extensions != null) {
            Iterator i = extensions.iterator();
            while (i.hasNext()) {
                Artifact artifact;
                Extension ext = (Extension)i.next();
                String version = StringUtils.isEmpty(ext.getVersion()) ? "RELEASE" : ext.getVersion();
                try {
                    VersionRange versionRange = VersionRange.createFromVersionSpec(version);
                    artifact = this.artifactFactory.createExtensionArtifact(ext.getGroupId(), ext.getArtifactId(), versionRange);
                }
                catch (InvalidVersionSpecificationException e) {
                    String key = ArtifactUtils.versionlessKey(ext.getGroupId(), ext.getArtifactId());
                    throw new InvalidProjectVersionException(projectId, "Extension: " + key, version, pomFile, e);
                }
                if (artifact == null) continue;
                extensionArtifacts.add(artifact);
            }
        }
        return extensionArtifacts;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Model getSuperModel() throws ProjectBuildingException {
        Model model;
        if (this.superModel != null) {
            return this.superModel;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.apache.maven.project.DefaultMavenProjectBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        URL url = clazz.getResource("pom-4.0.0.xml");
        String projectId = this.safeVersionlessKey("org.apache.maven", "super-pom");
        XmlStreamReader reader = null;
        try {
            try {
                reader = ReaderFactory.newXmlReader(url.openStream());
                String modelSource = IOUtil.toString(reader);
                this.checkModelVersion(modelSource, projectId, null);
                StringReader sReader = new StringReader(modelSource);
                model = this.modelReader.read(sReader, true);
                Object var6_9 = null;
            }
            catch (XmlPullParserException e) {
                throw new InvalidProjectModelException(projectId, "Parse error reading POM. Reason: " + e.getMessage(), e);
            }
            catch (IOException e) {
                IOException iOException = e;
                String string = "Failed build model from URL '" + url.toExternalForm() + "'\nError: '" + e.getLocalizedMessage() + "'";
                String string2 = projectId;
                if (!ProjectIOErrorReporterAspect.ajc$cflowStack$0.isValid()) throw new ProjectBuildingException(string2, string, iOException);
                if (ProjectIOErrorReporterAspect.ajc$cflowCounter$1.isValid()) throw new ProjectBuildingException(string2, string, iOException);
                ProjectIOErrorReporterAspect.aspectOf().ajc$before$org_apache_maven_project_aspect_ProjectIOErrorReporterAspect$2$1878ea4d((String)ProjectIOErrorReporterAspect.ajc$cflowStack$0.get(0), (File)ProjectIOErrorReporterAspect.ajc$cflowStack$0.get(1), iOException);
                throw new ProjectBuildingException(string2, string, iOException);
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            IOUtil.close(reader);
            throw throwable;
        }
        IOUtil.close(reader);
        return model;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public static /* synthetic */ void ajc$privFieldSet$org_apache_maven_project_aspect_ProjectCacheAspect$org_apache_maven_project_DefaultMavenProjectBuilder$projectWorkspace(DefaultMavenProjectBuilder defaultMavenProjectBuilder, ProjectWorkspace projectWorkspace) {
        defaultMavenProjectBuilder.projectWorkspace = projectWorkspace;
    }

    public static /* synthetic */ void ajc$privFieldSet$org_apache_maven_project_aspect_ProjectCacheAspect$org_apache_maven_project_DefaultMavenProjectBuilder$logger(DefaultMavenProjectBuilder defaultMavenProjectBuilder, Logger logger) {
        defaultMavenProjectBuilder.logger = logger;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ MavenProject buildFromRepository_aroundBody1$advice(DefaultMavenProjectBuilder this_, Artifact artifact, List builder, ArtifactRepository ajc_aroundClosure, boolean bl, ProjectCacheAspect projectCacheAspect, Artifact artifact2, DefaultMavenProjectBuilder defaultMavenProjectBuilder, AroundClosure aroundClosure) {
        void skipCache;
        String string = projectCacheAspect.ajc$privMethod$org_apache_maven_project_aspect_ProjectCacheAspect$org_apache_maven_project_aspect_ProjectCacheAspect$createCacheKey(artifact2.getGroupId(), artifact2.getArtifactId(), artifact2.getVersion());
        MavenProject mavenProject = null;
        boolean bl2 = false;
        if (!"LATEST".equals(skipCache.getVersion()) && !"RELEASE".equals(skipCache.getVersion())) {
            defaultMavenProjectBuilder.logger.debug("Checking cache for project (in buildFromRepository): " + string);
            mavenProject = defaultMavenProjectBuilder.projectWorkspace.getProject(skipCache.getGroupId(), skipCache.getArtifactId(), skipCache.getVersion());
        }
        if (mavenProject == null) {
            void key;
            defaultMavenProjectBuilder.logger.debug("Allowing buildFromRepository to proceed for: " + string);
            AroundClosure aroundClosure2 = aroundClosure;
            DefaultMavenProjectBuilder defaultMavenProjectBuilder2 = defaultMavenProjectBuilder;
            void var14_14 = skipCache;
            mavenProject = defaultMavenProjectBuilder2.buildFromRepository((Artifact)var14_14, builder, ajc_aroundClosure);
            if (!bl2) {
                defaultMavenProjectBuilder.logger.debug("Caching result for: " + string + " (also keyed by file: " + mavenProject.getFile() + ")");
                defaultMavenProjectBuilder.projectWorkspace.storeProjectByCoordinate(mavenProject);
                defaultMavenProjectBuilder.projectWorkspace.storeProjectByFile(mavenProject);
            }
        } else {
            defaultMavenProjectBuilder.logger.debug("Returning cached project: " + mavenProject);
        }
        return mavenProject;
    }

    private static final /* synthetic */ MavenProject buildFromRepository_aroundBody2(DefaultMavenProjectBuilder this_, Artifact artifact, List remoteArtifactRepositories, ArtifactRepository localRepository) {
        Model model = this_.findModelFromRepository(artifact, remoteArtifactRepositories, localRepository);
        return this_.buildInternal(model, localRepository, remoteArtifactRepositories, artifact.getFile(), null, false, false, false);
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ MavenProject buildFromRepository_aroundBody3$advice(DefaultMavenProjectBuilder this_, Artifact artifact, List builder, ArtifactRepository ajc_aroundClosure, ProjectCacheAspect projectCacheAspect, Artifact artifact2, DefaultMavenProjectBuilder defaultMavenProjectBuilder, AroundClosure aroundClosure) {
        void skipCache;
        void project;
        String string = projectCacheAspect.ajc$privMethod$org_apache_maven_project_aspect_ProjectCacheAspect$org_apache_maven_project_aspect_ProjectCacheAspect$createCacheKey(artifact2.getGroupId(), artifact2.getArtifactId(), artifact2.getVersion());
        MavenProject mavenProject = null;
        boolean bl = false;
        if (!"LATEST".equals(project.getVersion()) && !"RELEASE".equals(project.getVersion())) {
            ((DefaultMavenProjectBuilder)skipCache).logger.debug("Checking cache for project (in buildFromRepository): " + string);
            mavenProject = ((DefaultMavenProjectBuilder)skipCache).projectWorkspace.getProject(project.getGroupId(), project.getArtifactId(), project.getVersion());
        }
        if (mavenProject == null) {
            ((DefaultMavenProjectBuilder)skipCache).logger.debug("Allowing buildFromRepository to proceed for: " + string);
            AroundClosure aroundClosure2 = aroundClosure;
            void var12_12 = skipCache;
            void var13_13 = project;
            mavenProject = DefaultMavenProjectBuilder.buildFromRepository_aroundBody2((DefaultMavenProjectBuilder)var12_12, (Artifact)var13_13, builder, ajc_aroundClosure);
            if (!bl) {
                ((DefaultMavenProjectBuilder)skipCache).logger.debug("Caching result for: " + string + " (also keyed by file: " + mavenProject.getFile() + ")");
                ((DefaultMavenProjectBuilder)skipCache).projectWorkspace.storeProjectByCoordinate(mavenProject);
                ((DefaultMavenProjectBuilder)skipCache).projectWorkspace.storeProjectByFile(mavenProject);
            }
        } else {
            ((DefaultMavenProjectBuilder)skipCache).logger.debug("Returning cached project: " + mavenProject);
        }
        return mavenProject;
    }

    private static final /* synthetic */ MavenProject buildFromSourceFileInternal_aroundBody4(DefaultMavenProjectBuilder this_, File projectDescriptor, ArtifactRepository localRepository, ProfileManager profileManager) {
        Model model = this_.readModel("unknown", projectDescriptor, true);
        MavenProject project = this_.buildInternal(model, localRepository, this_.buildArtifactRepositories(this_.getSuperModel()), projectDescriptor, profileManager, true, true, true);
        return project;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ MavenProject buildFromSourceFileInternal_aroundBody5$advice(DefaultMavenProjectBuilder this_, File pomFile, ArtifactRepository builder, ProfileManager ajc_aroundClosure, ProjectCacheAspect projectCacheAspect, File file, DefaultMavenProjectBuilder defaultMavenProjectBuilder, AroundClosure aroundClosure) {
        defaultMavenProjectBuilder.logger.debug("Checking cache-hit on project (in build*): " + file);
        MavenProject mavenProject = defaultMavenProjectBuilder.projectWorkspace.getProject(file);
        if (mavenProject == null) {
            void key;
            void project;
            defaultMavenProjectBuilder.logger.debug("Allowing project-build to proceed for: " + file);
            AroundClosure aroundClosure2 = aroundClosure;
            DefaultMavenProjectBuilder defaultMavenProjectBuilder2 = defaultMavenProjectBuilder;
            File file2 = file;
            mavenProject = DefaultMavenProjectBuilder.buildFromSourceFileInternal_aroundBody4(defaultMavenProjectBuilder2, file2, builder, ajc_aroundClosure);
            String string = project.ajc$privMethod$org_apache_maven_project_aspect_ProjectCacheAspect$org_apache_maven_project_aspect_ProjectCacheAspect$createCacheKey(mavenProject.getGroupId(), mavenProject.getArtifactId(), mavenProject.getVersion());
            defaultMavenProjectBuilder.logger.debug("Caching result for: " + string + " (also keyed by file: " + key + ")");
            defaultMavenProjectBuilder.projectWorkspace.storeProjectByFile(mavenProject);
            defaultMavenProjectBuilder.projectWorkspace.storeProjectByCoordinate(mavenProject);
        } else {
            defaultMavenProjectBuilder.logger.debug("Returning cached project: " + mavenProject);
        }
        defaultMavenProjectBuilder.logger.debug("Project: " + mavenProject.getId() + " has basedir: " + mavenProject.getBasedir());
        return mavenProject;
    }
}

