/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.profiles.build;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.MavenTools;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.MavenProfilesBuilder;
import org.apache.maven.profiles.Profile;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.profiles.ProfilesConversionUtils;
import org.apache.maven.profiles.ProfilesRoot;
import org.apache.maven.profiles.activation.ProfileActivationContext;
import org.apache.maven.profiles.activation.ProfileActivationException;
import org.apache.maven.profiles.build.ProfileAdvisor;
import org.apache.maven.profiles.injection.ProfileInjector;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.aspect.ProfileErrorReporterAspect;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultProfileAdvisor
implements ProfileAdvisor,
LogEnabled,
Contextualizable {
    public static final String ROLE_HINT = "default";
    private MavenTools mavenTools;
    private MavenProfilesBuilder profilesBuilder;
    private ProfileInjector profileInjector;
    private PlexusContainer container;
    private Logger logger;

    public List applyActivatedProfiles(Model model, File pomFile, boolean useProfilesXml, ProfileActivationContext activationContext) throws ProjectBuildingException {
        this.logger.debug("Building profile manager for model: " + model.getId() + " with pom file: " + pomFile);
        ProfileManager profileManager = this.buildProfileManager(model, pomFile, useProfilesXml, activationContext);
        return this.applyActivatedProfiles(model, pomFile, profileManager);
    }

    public List applyActivatedExternalProfiles(Model model, File projectDir, ProfileManager externalProfileManager) throws ProjectBuildingException {
        if (externalProfileManager == null) {
            return Collections.EMPTY_LIST;
        }
        this.logger.debug("Building profile manager for model: " + model.getId() + " with external profile manager including profiles: " + externalProfileManager.getProfilesById());
        return this.applyActivatedProfiles(model, projectDir, externalProfileManager);
    }

    /*
     * WARNING - void declaration
     */
    private List applyActivatedProfiles(Model model, File file, ProfileManager profileManager) throws ProjectBuildingException {
        List list;
        Model model2 = model;
        File file2 = file;
        ProfileManager profileManager2 = profileManager;
        Object[] objectArray = new Object[]{model2, file2};
        ProfileErrorReporterAspect.ajc$cflowStack$0.push(objectArray);
        try {
            List activeProfiles;
            void profileManager3;
            if (profileManager3 != null) {
                void model3;
                try {
                    activeProfiles = profileManager3.getActiveProfiles((Model)model3);
                }
                catch (ProfileActivationException e) {
                    void pomFile;
                    String artifactId;
                    String groupId = model3.getGroupId();
                    if (groupId == null) {
                        groupId = "unknown";
                    }
                    if ((artifactId = model3.getArtifactId()) == null) {
                        artifactId = "unknown";
                    }
                    String projectId = ArtifactUtils.versionlessKey(groupId, artifactId);
                    throw new ProjectBuildingException(projectId, e.getMessage(), (File)pomFile, e);
                }
                Iterator it = activeProfiles.iterator();
                while (it.hasNext()) {
                    org.apache.maven.model.Profile profile = (org.apache.maven.model.Profile)it.next();
                    this.profileInjector.inject(profile, (Model)model3);
                }
            } else {
                activeProfiles = Collections.EMPTY_LIST;
            }
            list = activeProfiles;
        }
        finally {
            ProfileErrorReporterAspect.ajc$cflowStack$0.pop();
        }
        return list;
    }

    private ProfileManager buildProfileManager(Model model, File pomFile, boolean useProfilesXml, ProfileActivationContext profileActivationContext) throws ProjectBuildingException {
        DefaultProfileManager profileManager = new DefaultProfileManager(this.container, profileActivationContext);
        profileManager.addProfiles(model.getProfiles());
        if (useProfilesXml && pomFile != null) {
            this.loadExternalProjectProfiles(profileManager, model, pomFile);
        }
        return profileManager;
    }

    /*
     * WARNING - void declaration
     */
    public LinkedHashSet getArtifactRepositoriesFromActiveProfiles(Model model, File file, ProfileManager profileManager) throws ProjectBuildingException {
        LinkedHashSet linkedHashSet;
        block13: {
            Model model2 = model;
            File file2 = file;
            ProfileManager profileManager2 = profileManager;
            Object[] objectArray = new Object[]{model2, file2};
            ProfileErrorReporterAspect.ajc$cflowStack$2.push(objectArray);
            try {
                List activeExternalProfiles;
                void model3;
                void profileManager3;
                if (profileManager3 == null) {
                    linkedHashSet = new LinkedHashSet();
                    break block13;
                }
                try {
                    activeExternalProfiles = profileManager3.getActiveProfiles((Model)model3);
                }
                catch (ProfileActivationException e) {
                    void pomFile;
                    throw new ProjectBuildingException(model3.getId(), "Failed to compute active profiles for repository aggregation.", (File)pomFile, e);
                }
                LinkedHashSet<ArtifactRepository> remoteRepositories = new LinkedHashSet<ArtifactRepository>();
                Iterator i = activeExternalProfiles.iterator();
                while (i.hasNext()) {
                    org.apache.maven.model.Profile externalProfile = (org.apache.maven.model.Profile)i.next();
                    if (externalProfile.getRepositories() == null) continue;
                    Iterator repoIterator = externalProfile.getRepositories().iterator();
                    while (repoIterator.hasNext()) {
                        ArtifactRepository artifactRepo;
                        Repository mavenRepo = (Repository)repoIterator.next();
                        try {
                            ArtifactRepository artifactRepository;
                            Repository repository = mavenRepo;
                            try {
                                artifactRepository = this.mavenTools.buildArtifactRepository(repository);
                            }
                            catch (InvalidRepositoryException invalidRepositoryException) {
                                if (ProfileErrorReporterAspect.ajc$cflowStack$2.isValid()) {
                                    ProfileErrorReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_ProfileErrorReporterAspect$7$4f6e91e3(repository, (Model)ProfileErrorReporterAspect.ajc$cflowStack$2.get(0), (File)ProfileErrorReporterAspect.ajc$cflowStack$2.get(1), invalidRepositoryException);
                                }
                                throw invalidRepositoryException;
                            }
                            artifactRepo = artifactRepository;
                        }
                        catch (InvalidRepositoryException e) {
                            throw new ProjectBuildingException(model3.getId(), e.getMessage(), e);
                        }
                        remoteRepositories.add(artifactRepo);
                    }
                }
                linkedHashSet = remoteRepositories;
            }
            finally {
                ProfileErrorReporterAspect.ajc$cflowStack$2.pop();
            }
        }
        return linkedHashSet;
    }

    /*
     * WARNING - void declaration
     */
    public LinkedHashSet getArtifactRepositoriesFromActiveProfiles(Model model, File file, boolean bl, ProfileActivationContext profileActivationContext) throws ProjectBuildingException {
        LinkedHashSet linkedHashSet;
        Model model2 = model;
        File file2 = file;
        boolean bl2 = bl;
        ProfileActivationContext profileActivationContext2 = profileActivationContext;
        Object[] objectArray = new Object[]{model2, file2};
        ProfileErrorReporterAspect.ajc$cflowStack$2.push(objectArray);
        try {
            void activationContext;
            void useProfilesXml;
            void pomFile;
            void model3;
            ProfileManager profileManager = this.buildProfileManager((Model)model3, (File)pomFile, (boolean)useProfilesXml, (ProfileActivationContext)activationContext);
            linkedHashSet = this.getArtifactRepositoriesFromActiveProfiles((Model)model3, (File)pomFile, profileManager);
        }
        finally {
            ProfileErrorReporterAspect.ajc$cflowStack$2.pop();
        }
        return linkedHashSet;
    }

    /*
     * WARNING - void declaration
     */
    private void loadExternalProjectProfiles(ProfileManager profileManager, Model model, File file) throws ProjectBuildingException {
        block15: {
            ProfileManager profileManager2 = profileManager;
            Model model2 = model;
            File file2 = file;
            Object[] objectArray = new Object[]{model2, file2};
            ProfileErrorReporterAspect.ajc$cflowStack$3.push(objectArray);
            try {
                void model3;
                void pomFile;
                if (pomFile == null) break block15;
                File projectDir = pomFile.getParentFile();
                try {
                    ProfilesRoot profilesRoot;
                    File file3 = projectDir;
                    try {
                        try {
                            profilesRoot = this.profilesBuilder.buildProfiles(file3);
                        }
                        catch (IOException iOException) {
                            if (ProfileErrorReporterAspect.ajc$cflowStack$3.isValid()) {
                                ProfileErrorReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_ProfileErrorReporterAspect$4$b66fc3f1((Model)ProfileErrorReporterAspect.ajc$cflowStack$3.get(0), (File)ProfileErrorReporterAspect.ajc$cflowStack$3.get(1), file3, iOException);
                            }
                            throw iOException;
                        }
                    }
                    catch (XmlPullParserException xmlPullParserException) {
                        if (ProfileErrorReporterAspect.ajc$cflowStack$3.isValid()) {
                            ProfileErrorReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_ProfileErrorReporterAspect$5$b66fc3f1((Model)ProfileErrorReporterAspect.ajc$cflowStack$3.get(0), (File)ProfileErrorReporterAspect.ajc$cflowStack$3.get(1), file3, xmlPullParserException);
                        }
                        throw xmlPullParserException;
                    }
                    ProfilesRoot root = profilesRoot;
                    if (root != null) {
                        void profileManager3;
                        List active = root.getActiveProfiles();
                        if (active != null && !active.isEmpty()) {
                            ProfileActivationContext ctx = profileManager3.getProfileActivationContext();
                            ctx.setExplicitlyActiveProfileIds(root.getActiveProfiles());
                        }
                        Iterator it = root.getProfiles().iterator();
                        while (it.hasNext()) {
                            Profile rawProfile = (Profile)it.next();
                            org.apache.maven.model.Profile converted = ProfilesConversionUtils.convertFromProfileXmlProfile(rawProfile);
                            profileManager3.addProfile(converted);
                        }
                    }
                }
                catch (IOException e) {
                    throw new ProjectBuildingException(model3.getId(), "Cannot read profiles.xml resource from directory: " + projectDir, (File)pomFile, e);
                }
                catch (XmlPullParserException e) {
                    throw new ProjectBuildingException(model3.getId(), "Cannot parse profiles.xml resource from directory: " + projectDir, (File)pomFile, e);
                }
            }
            finally {
                ProfileErrorReporterAspect.ajc$cflowStack$3.pop();
            }
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get("plexus");
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }
}

