/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.plan;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.apache.maven.errors.LifecycleErrorReporterAspect;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleLoaderException;
import org.apache.maven.lifecycle.LifecycleSpecificationException;
import org.apache.maven.lifecycle.LifecycleUtils;
import org.apache.maven.lifecycle.MojoBindingUtils;
import org.apache.maven.lifecycle.binding.LifecycleBindingManager;
import org.apache.maven.lifecycle.binding.MojoBindingFactory;
import org.apache.maven.lifecycle.model.LifecycleBindings;
import org.apache.maven.lifecycle.model.MojoBinding;
import org.apache.maven.lifecycle.plan.BuildPlan;
import org.apache.maven.lifecycle.plan.BuildPlanner;
import org.apache.maven.lifecycle.plan.LifecyclePlannerException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.loader.PluginLoader;
import org.apache.maven.plugin.loader.PluginLoaderException;
import org.apache.maven.project.MavenProject;
import org.aspectj.runtime.internal.AroundClosure;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;

public class DefaultBuildPlanner
implements BuildPlanner,
LogEnabled {
    private Logger logger;
    private PluginLoader pluginLoader;
    private LifecycleBindingManager lifecycleBindingManager;
    private MojoBindingFactory mojoBindingFactory;

    public void constructInitialProjectBuildPlans(MavenSession session) throws LifecycleLoaderException, LifecycleSpecificationException, LifecyclePlannerException {
        Iterator it = session.getSortedProjects().iterator();
        while (it.hasNext()) {
            MavenProject project = (MavenProject)it.next();
            this.constructInitialProjectBuildPlan(project, session);
        }
    }

    public BuildPlan constructInitialProjectBuildPlan(MavenProject project, MavenSession session) throws LifecycleLoaderException, LifecycleSpecificationException, LifecyclePlannerException {
        BuildPlan plan = session.getBuildPlan(project);
        if (plan == null) {
            plan = this.constructBuildPlan(Collections.EMPTY_LIST, project, session);
            session.setBuildPlan(project, plan);
        }
        return plan;
    }

    public BuildPlan constructBuildPlan(List list, MavenProject mavenProject, MavenSession mavenSession) throws LifecycleLoaderException, LifecycleSpecificationException, LifecyclePlannerException {
        List list2 = list;
        MavenProject mavenProject2 = mavenProject;
        MavenSession mavenSession2 = mavenSession;
        if (LifecycleErrorReporterAspect.ajc$cflowCounter$7.isValid()) {
            return DefaultBuildPlanner.constructBuildPlan_aroundBody1$advice(this, list2, mavenProject2, mavenSession2, LifecycleErrorReporterAspect.aspectOf(), list2, mavenProject2, mavenSession2, null);
        }
        return DefaultBuildPlanner.constructBuildPlan_aroundBody0(this, list2, mavenProject2, mavenSession2);
    }

    private void initializeDirectInvocations(BuildPlan plan, MavenProject project, MavenSession session) throws LifecycleSpecificationException, LifecycleLoaderException {
        List tasks = plan.getTasks();
        Iterator it = tasks.iterator();
        while (it.hasNext()) {
            String task = (String)it.next();
            if (LifecycleUtils.isValidPhaseName(task)) continue;
            MojoBinding binding = this.mojoBindingFactory.parseMojoBinding(task, project, session, true);
            binding.setOrigin("Direct invocation");
            binding.setOriginDescription("Original reference from user: " + task);
            plan.addDirectInvocationBinding(task, binding);
        }
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    private void addForkedLifecycleModifiers(BuildPlan plan, MavenProject project, MavenSession session, LinkedList callStack) throws LifecyclePlannerException, LifecycleSpecificationException, LifecycleLoaderException {
        List planBindings = plan.renderExecutionPlan(new Stack());
        plan.resetExecutionProgress();
        Iterator it = planBindings.iterator();
        while (it.hasNext()) {
            MojoBinding mojoBinding = (MojoBinding)it.next();
            if (plan.isFullyResolved(mojoBinding)) continue;
            this.findForkModifiers(mojoBinding, plan, project, session, callStack);
        }
    }

    private void findForkModifiers(MojoBinding mojoBinding, BuildPlan plan, MavenProject project, MavenSession session, LinkedList callStack) throws LifecyclePlannerException, LifecycleSpecificationException, LifecycleLoaderException {
        PluginDescriptor pluginDescriptor = this.loadPluginDescriptor(mojoBinding, plan, project, session);
        if (pluginDescriptor == null) {
            return;
        }
        MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(mojoBinding.getGoal());
        if (mojoDescriptor == null) {
            throw new LifecyclePlannerException("Mojo: " + mojoBinding.getGoal() + " does not exist in plugin: " + pluginDescriptor.getId() + ".");
        }
        this.findForkModifiers(mojoBinding, pluginDescriptor, plan, project, session, false, callStack);
    }

    private void addReportingLifecycleModifiers(BuildPlan plan, MavenProject project, MavenSession session, LinkedList callStack) throws LifecyclePlannerException, LifecycleSpecificationException, LifecycleLoaderException {
        if (plan.isIncludingReports()) {
            this.logger.debug("Report modifiers are already present in the build plan.");
            return;
        }
        List planBindings = plan.renderExecutionPlan(new Stack());
        plan.resetExecutionProgress();
        Iterator it = planBindings.iterator();
        while (it.hasNext()) {
            MojoBinding mojoBinding = (MojoBinding)it.next();
            if (plan.isFullyResolved(mojoBinding)) {
                this.logger.debug("Skipping report-discovery for mojo: " + MojoBindingUtils.toString(mojoBinding) + "; it is already fully resolved in the build plan.");
                continue;
            }
            PluginDescriptor pluginDescriptor = this.loadPluginDescriptor(mojoBinding, plan, project, session);
            if (pluginDescriptor == null) {
                this.logger.debug("Plugin descriptor not found for mojo: " + MojoBindingUtils.toString(mojoBinding) + "; skipping for report-discovery.");
                continue;
            }
            MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(mojoBinding.getGoal());
            if (mojoDescriptor == null) {
                throw new LifecyclePlannerException("Mojo: " + mojoBinding.getGoal() + " does not exist in plugin: " + pluginDescriptor.getId() + ".");
            }
            if (!mojoDescriptor.isRequiresReports()) continue;
            this.logger.debug("Mojo: " + MojoBindingUtils.toString(mojoBinding) + " requires reports; running report-discovery.");
            List reportBindings = this.lifecycleBindingManager.getReportBindings(project, session);
            if (reportBindings != null) {
                plan.addForkedExecution(mojoBinding, reportBindings);
                Iterator reportBindingIt = reportBindings.iterator();
                while (reportBindingIt.hasNext()) {
                    PluginDescriptor pd;
                    MojoBinding reportBinding = (MojoBinding)reportBindingIt.next();
                    if (plan.isFullyResolved(reportBinding) || (pd = this.loadPluginDescriptor(reportBinding, plan, project, session)) == null) continue;
                    this.findForkModifiers(reportBinding, pd, plan, project, session, true, callStack);
                }
            }
            plan.markAsIncludingReports();
            break;
        }
    }

    private PluginDescriptor loadPluginDescriptor(MojoBinding mojoBinding, BuildPlan plan, MavenProject project, MavenSession session) {
        PluginDescriptor pluginDescriptor = null;
        try {
            pluginDescriptor = this.pluginLoader.loadPlugin(mojoBinding, project, session);
        }
        catch (PluginLoaderException e) {
            String message = "Failed to load plugin: " + MojoBindingUtils.createPluginKey(mojoBinding) + ". Adding to late-bound plugins list.\nReason: " + e.getMessage();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(message, e);
            } else {
                this.logger.warn(message);
            }
            mojoBinding.setLateBound(true);
        }
        return pluginDescriptor;
    }

    private void findForkModifiers(MojoBinding mojoBinding, PluginDescriptor pluginDescriptor, BuildPlan plan, MavenProject project, MavenSession session, boolean includeReportConfig, LinkedList callStack) throws LifecyclePlannerException, LifecycleSpecificationException, LifecycleLoaderException {
        String referencingGoal = mojoBinding.getGoal();
        MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(referencingGoal);
        if (mojoDescriptor == null) {
            throw new LifecyclePlannerException("Cannot find mojo descriptor for: " + referencingGoal + " in plugin: " + pluginDescriptor.getId());
        }
        if (mojoDescriptor.getExecuteGoal() != null) {
            this.recurseSingleMojoFork(mojoBinding, pluginDescriptor, plan, project, includeReportConfig);
        } else if (mojoDescriptor.getExecutePhase() != null) {
            this.recursePhaseMojoFork(mojoBinding, pluginDescriptor, plan, project, session, includeReportConfig, callStack);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void recursePhaseMojoFork(MojoBinding mojoBinding, PluginDescriptor pluginDescriptor, BuildPlan plan, MavenProject project, MavenSession session, boolean includeReportConfig, LinkedList callStack) throws LifecyclePlannerException, LifecycleSpecificationException, LifecycleLoaderException {
        callStack.addFirst(mojoBinding);
        try {
            String referencingGoal = mojoBinding.getGoal();
            MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(referencingGoal);
            String phase = mojoDescriptor.getExecutePhase();
            if (phase == null) {
                Object var15_11 = null;
                callStack.removeFirst();
                return;
            }
            if (!LifecycleUtils.isValidPhaseName(phase)) {
                throw new LifecyclePlannerException("Cannot find lifecycle for phase: " + phase);
            }
            BuildPlan clonedPlan = plan.copy(phase);
            clonedPlan.removeAll(callStack);
            String executeLifecycle = mojoDescriptor.getExecuteLifecycle();
            if (executeLifecycle != null) {
                LifecycleBindings overlayBindings;
                try {
                    overlayBindings = this.lifecycleBindingManager.getPluginLifecycleOverlay(pluginDescriptor, executeLifecycle, project);
                }
                catch (LifecycleLoaderException e) {
                    throw new LifecyclePlannerException("Failed to load overlay lifecycle: " + executeLifecycle + ". Reason: " + e.getMessage(), e);
                }
                clonedPlan.addLifecycleOverlay(overlayBindings);
            }
            plan.addForkedExecution(mojoBinding, clonedPlan);
            this.addForkedLifecycleModifiers(clonedPlan, project, session, callStack);
        }
        catch (Throwable throwable) {
            Object var15_12 = null;
            callStack.removeFirst();
            throw throwable;
        }
        Object var15_13 = null;
        callStack.removeFirst();
    }

    private void recurseSingleMojoFork(MojoBinding mojoBinding, PluginDescriptor pluginDescriptor, BuildPlan plan, MavenProject project, boolean includeReportConfig) throws LifecyclePlannerException, LifecycleSpecificationException, LifecycleLoaderException {
        String referencingGoal = mojoBinding.getGoal();
        MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(referencingGoal);
        String executeGoal = mojoDescriptor.getExecuteGoal();
        if (executeGoal == null) {
            return;
        }
        MojoDescriptor otherDescriptor = pluginDescriptor.getMojo(executeGoal);
        if (otherDescriptor == null) {
            throw new LifecyclePlannerException("Mojo: " + executeGoal + " (referenced by: " + referencingGoal + ") does not exist in plugin: " + pluginDescriptor.getId() + ".");
        }
        MojoBinding binding = this.mojoBindingFactory.createMojoBinding(pluginDescriptor.getGroupId(), pluginDescriptor.getArtifactId(), pluginDescriptor.getVersion(), executeGoal, project);
        binding.setOrigin("Direct forking reference");
        binding.setOriginDescription("Forked from: " + MojoBindingUtils.toString(mojoBinding));
        plan.addForkedExecution(mojoBinding, Collections.singletonList(binding));
    }

    private static final /* synthetic */ BuildPlan constructBuildPlan_aroundBody0(DefaultBuildPlanner this_, List tasks, MavenProject project, MavenSession session) {
        BuildPlan plan = session.getBuildPlan(project);
        if (plan != null) {
            plan = plan.copy(tasks);
        } else {
            LifecycleBindings defaultBindings = this_.lifecycleBindingManager.getDefaultBindings(project);
            LifecycleBindings packagingBindings = this_.lifecycleBindingManager.getBindingsForPackaging(project, session);
            LifecycleBindings projectBindings = this_.lifecycleBindingManager.getProjectCustomBindings(project, session);
            plan = new BuildPlan(packagingBindings, projectBindings, defaultBindings, tasks);
        }
        this_.initializeDirectInvocations(plan, project, session);
        this_.addForkedLifecycleModifiers(plan, project, session, new LinkedList());
        this_.addReportingLifecycleModifiers(plan, project, session, new LinkedList());
        plan.markFullyResolved();
        return plan;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ BuildPlan constructBuildPlan_aroundBody1$advice(DefaultBuildPlanner this_, List tasks, MavenProject project, MavenSession session, LifecycleErrorReporterAspect ajc_aroundClosure, List list, MavenProject mavenProject, MavenSession mavenSession, AroundClosure aroundClosure) {
        void cause;
        try {
            AroundClosure aroundClosure2 = aroundClosure;
            MavenSession mavenSession2 = mavenSession;
            MavenProject mavenProject2 = mavenProject;
            List list2 = list;
            return DefaultBuildPlanner.constructBuildPlan_aroundBody0(this_, list2, mavenProject2, mavenSession2);
        }
        catch (LifecycleLoaderException lifecycleLoaderException) {
            LifecycleErrorReporterAspect.ajc$inlineAccessMethod$org_apache_maven_errors_LifecycleErrorReporterAspect$org_apache_maven_errors_LifecycleErrorReporterAspect$getReporter(ajc_aroundClosure).reportErrorFormulatingBuildPlan((List)cause, mavenProject, mavenSession, lifecycleLoaderException);
            throw lifecycleLoaderException;
        }
        catch (LifecyclePlannerException lifecyclePlannerException) {
            LifecycleErrorReporterAspect.ajc$inlineAccessMethod$org_apache_maven_errors_LifecycleErrorReporterAspect$org_apache_maven_errors_LifecycleErrorReporterAspect$getReporter(ajc_aroundClosure).reportErrorFormulatingBuildPlan((List)cause, mavenProject, mavenSession, lifecyclePlannerException);
            throw lifecyclePlannerException;
        }
        catch (LifecycleSpecificationException lifecycleSpecificationException) {
            LifecycleErrorReporterAspect.ajc$inlineAccessMethod$org_apache_maven_errors_LifecycleErrorReporterAspect$org_apache_maven_errors_LifecycleErrorReporterAspect$getReporter(ajc_aroundClosure).reportErrorFormulatingBuildPlan((List)cause, mavenProject, mavenSession, lifecycleSpecificationException);
            throw lifecycleSpecificationException;
        }
    }
}

