/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.binding;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.maven.lifecycle.LifecycleSpecificationException;
import org.apache.maven.lifecycle.LifecycleUtils;
import org.apache.maven.lifecycle.binding.Lifecycle;
import org.apache.maven.lifecycle.binding.MojoBindingFactory;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;
import org.apache.maven.lifecycle.model.BuildBinding;
import org.apache.maven.lifecycle.model.CleanBinding;
import org.apache.maven.lifecycle.model.LifecycleBindings;
import org.apache.maven.lifecycle.model.MojoBinding;
import org.apache.maven.lifecycle.model.Phase;
import org.apache.maven.lifecycle.model.SiteBinding;

public class LegacyLifecycleMappingParser {
    public static final String ROLE;
    private MojoBindingFactory mojoBindingFactory;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.maven.lifecycle.binding.LegacyLifecycleMappingParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ROLE = clazz.getName();
    }

    public LifecycleBindings parseDefaultMappings(List lifecycles) throws LifecycleSpecificationException {
        LifecycleBindings bindings = new LifecycleBindings();
        bindings.setPackaging("unmatched");
        Iterator it = lifecycles.iterator();
        while (it.hasNext()) {
            Lifecycle lifecycle = (Lifecycle)it.next();
            if ("clean".equals(lifecycle.getId())) {
                bindings.setCleanBinding(this.parseCleanBindings(lifecycle.getDefaultPhases(), Collections.EMPTY_LIST));
                continue;
            }
            if ("site".equals(lifecycle.getId())) {
                bindings.setSiteBinding(this.parseSiteBindings(lifecycle.getDefaultPhases(), Collections.EMPTY_LIST));
                continue;
            }
            if ("default".equals(lifecycle.getId())) {
                bindings.setBuildBinding(this.parseBuildBindings(lifecycle.getDefaultPhases(), Collections.EMPTY_LIST));
                continue;
            }
            throw new LifecycleSpecificationException("Unrecognized lifecycle: " + lifecycle.getId());
        }
        LifecycleUtils.setOrigin(bindings, "default lifecycle");
        return bindings;
    }

    public LifecycleBindings parseMappings(LifecycleMapping mapping, String packaging) throws LifecycleSpecificationException {
        LifecycleBindings bindings = new LifecycleBindings();
        bindings.setPackaging(packaging);
        bindings.setCleanBinding(this.parseCleanBindings(mapping.getPhases("clean"), mapping.getOptionalMojos("clean")));
        bindings.setBuildBinding(this.parseBuildBindings(mapping.getPhases("default"), mapping.getOptionalMojos("default")));
        bindings.setSiteBinding(this.parseSiteBindings(mapping.getPhases("site"), mapping.getOptionalMojos("site")));
        LifecycleUtils.setOrigin(bindings, "packaging: " + packaging);
        return bindings;
    }

    private BuildBinding parseBuildBindings(Map phases, List optionalKeys) throws LifecycleSpecificationException {
        BuildBinding binding = new BuildBinding();
        if (phases != null) {
            binding.setValidate(this.parsePhaseBindings((String)phases.get("validate"), optionalKeys));
            binding.setInitialize(this.parsePhaseBindings((String)phases.get("initialize"), optionalKeys));
            binding.setGenerateSources(this.parsePhaseBindings((String)phases.get("generate-sources"), optionalKeys));
            binding.setProcessSources(this.parsePhaseBindings((String)phases.get("process-sources"), optionalKeys));
            binding.setGenerateResources(this.parsePhaseBindings((String)phases.get("generate-resources"), optionalKeys));
            binding.setProcessResources(this.parsePhaseBindings((String)phases.get("process-resources"), optionalKeys));
            binding.setCompile(this.parsePhaseBindings((String)phases.get("compile"), optionalKeys));
            binding.setProcessClasses(this.parsePhaseBindings((String)phases.get("process-classes"), optionalKeys));
            binding.setGenerateTestSources(this.parsePhaseBindings((String)phases.get("generate-test-sources"), optionalKeys));
            binding.setProcessTestSources(this.parsePhaseBindings((String)phases.get("process-test-sources"), optionalKeys));
            binding.setGenerateTestResources(this.parsePhaseBindings((String)phases.get("generate-test-resources"), optionalKeys));
            binding.setProcessTestResources(this.parsePhaseBindings((String)phases.get("process-test-resources"), optionalKeys));
            binding.setTestCompile(this.parsePhaseBindings((String)phases.get("test-compile"), optionalKeys));
            binding.setProcessTestClasses(this.parsePhaseBindings((String)phases.get("process-test-classes"), optionalKeys));
            binding.setTest(this.parsePhaseBindings((String)phases.get("test"), optionalKeys));
            binding.setPreparePackage(this.parsePhaseBindings((String)phases.get("prepare-package"), optionalKeys));
            binding.setCreatePackage(this.parsePhaseBindings((String)phases.get("package"), optionalKeys));
            binding.setPreIntegrationTest(this.parsePhaseBindings((String)phases.get("pre-integration-test"), optionalKeys));
            binding.setIntegrationTest(this.parsePhaseBindings((String)phases.get("integration-test"), optionalKeys));
            binding.setPostIntegrationTest(this.parsePhaseBindings((String)phases.get("post-integration-test"), optionalKeys));
            binding.setVerify(this.parsePhaseBindings((String)phases.get("verify"), optionalKeys));
            binding.setInstall(this.parsePhaseBindings((String)phases.get("install"), optionalKeys));
            binding.setDeploy(this.parsePhaseBindings((String)phases.get("deploy"), optionalKeys));
        }
        return binding;
    }

    private CleanBinding parseCleanBindings(Map phaseMappings, List optionalKeys) throws LifecycleSpecificationException {
        CleanBinding binding = new CleanBinding();
        if (phaseMappings != null) {
            binding.setPreClean(this.parsePhaseBindings((String)phaseMappings.get("pre-clean"), optionalKeys));
            binding.setClean(this.parsePhaseBindings((String)phaseMappings.get("clean"), optionalKeys));
            binding.setPostClean(this.parsePhaseBindings((String)phaseMappings.get("post-clean"), optionalKeys));
        }
        return binding;
    }

    private Phase parsePhaseBindings(String bindingList, List optionalKeys) throws LifecycleSpecificationException {
        Phase phase = new Phase();
        if (bindingList != null) {
            StringTokenizer tok = new StringTokenizer(bindingList, ",");
            while (tok.hasMoreTokens()) {
                String rawBinding = tok.nextToken().trim();
                MojoBinding binding = this.mojoBindingFactory.parseMojoBinding(rawBinding);
                if (optionalKeys != null && optionalKeys.contains(rawBinding)) {
                    binding.setOptional(true);
                }
                if (binding == null) continue;
                phase.addBinding(binding);
            }
        }
        return phase;
    }

    private SiteBinding parseSiteBindings(Map phases, List optionalKeys) throws LifecycleSpecificationException {
        SiteBinding binding = new SiteBinding();
        if (phases != null) {
            binding.setPreSite(this.parsePhaseBindings((String)phases.get("pre-site"), optionalKeys));
            binding.setSite(this.parsePhaseBindings((String)phases.get("site"), optionalKeys));
            binding.setPostSite(this.parsePhaseBindings((String)phases.get("post-site"), optionalKeys));
            binding.setSiteDeploy(this.parsePhaseBindings((String)phases.get("site-deploy"), optionalKeys));
        }
        return binding;
    }
}

