/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.binding;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.maven.compat.Maven20xCompatAspect;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleBindingLoader;
import org.apache.maven.lifecycle.LifecycleLoaderException;
import org.apache.maven.lifecycle.LifecycleSpecificationException;
import org.apache.maven.lifecycle.LifecycleUtils;
import org.apache.maven.lifecycle.MojoBindingUtils;
import org.apache.maven.lifecycle.NoSuchPhaseException;
import org.apache.maven.lifecycle.binding.BindingUtils;
import org.apache.maven.lifecycle.binding.LegacyLifecycleMappingParser;
import org.apache.maven.lifecycle.binding.LifecycleBindingManager;
import org.apache.maven.lifecycle.binding.MojoBindingFactory;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;
import org.apache.maven.lifecycle.model.LifecycleBindings;
import org.apache.maven.lifecycle.model.MojoBinding;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.lifecycle.Execution;
import org.apache.maven.plugin.lifecycle.Lifecycle;
import org.apache.maven.plugin.lifecycle.Phase;
import org.apache.maven.plugin.loader.PluginLoader;
import org.apache.maven.plugin.loader.PluginLoaderException;
import org.apache.maven.project.MavenProject;
import org.aspectj.runtime.internal.AroundClosure;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultLifecycleBindingManager
implements LifecycleBindingManager,
LogEnabled,
Contextualizable {
    private Map bindingsByPackaging;
    private Map legacyMappingsByPackaging;
    private PluginLoader pluginLoader;
    private MojoBindingFactory mojoBindingFactory;
    private LegacyLifecycleMappingParser legacyLifecycleMappingParser;
    private Logger logger;
    private List lifecycles;
    private List defaultReports;
    private PlexusContainer container;
    static /* synthetic */ Class class$0;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LifecycleBindings getBindingsForPackaging(MavenProject project, MavenSession session) throws LifecycleLoaderException, LifecycleSpecificationException {
        String packaging = project.getPackaging();
        LifecycleBindings bindings = null;
        ClassRealm projectRealm = session.getRealmManager().getProjectRealm(project.getGroupId(), project.getArtifactId(), project.getVersion());
        ClassRealm oldRealm = this.container.setLookupRealm(projectRealm);
        try {
            LifecycleMapping mapping;
            LifecycleBindingLoader loader = (LifecycleBindingLoader)this.bindingsByPackaging.get(packaging);
            if (loader != null) {
                bindings = loader.getBindings();
            }
            if (bindings == null && (mapping = (LifecycleMapping)this.legacyMappingsByPackaging.get(packaging)) != null) {
                bindings = this.legacyLifecycleMappingParser.parseMappings(mapping, packaging);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.container.setLookupRealm(oldRealm);
            throw throwable;
        }
        {
            Object var9_11 = null;
            this.container.setLookupRealm(oldRealm);
        }
        if (bindings != null) {
            BindingUtils.injectProjectConfiguration(bindings, project);
        }
        if (bindings != null) return bindings;
        return this.getDefaultBindings(project);
    }

    public LifecycleBindings getDefaultBindings(MavenProject project) throws LifecycleSpecificationException {
        LifecycleBindings bindings = this.legacyLifecycleMappingParser.parseDefaultMappings(this.lifecycles);
        BindingUtils.injectProjectConfiguration(bindings, project);
        return bindings;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public LifecycleBindings getProjectCustomBindings(MavenProject project, MavenSession session) throws LifecycleLoaderException, LifecycleSpecificationException {
        LifecycleBindings bindings = new LifecycleBindings();
        bindings.setPackaging(project.getPackaging());
        List plugins = project.getBuildPlugins();
        if (plugins != null) {
            Iterator it = plugins.iterator();
            while (it.hasNext()) {
                Plugin plugin = (Plugin)it.next();
                BindingUtils.injectPluginManagementInfo(plugin, project);
                PluginDescriptor pluginDescriptor = null;
                List executions = plugin.getExecutions();
                if (executions == null) continue;
                Iterator execIt = executions.iterator();
                while (execIt.hasNext()) {
                    PluginExecution execution = (PluginExecution)execIt.next();
                    List goals = execution.getGoals();
                    if (goals == null || goals.isEmpty()) continue;
                    Iterator goalIterator = goals.iterator();
                    while (goalIterator.hasNext()) {
                        String goal = (String)goalIterator.next();
                        if (goal == null) {
                            this.logger.warn("Execution: " + execution.getId() + " in plugin: " + plugin.getKey() + " in the POM has a null goal.");
                            continue;
                        }
                        MojoBinding mojoBinding = new MojoBinding();
                        mojoBinding.setGroupId(plugin.getGroupId());
                        mojoBinding.setArtifactId(plugin.getArtifactId());
                        mojoBinding.setVersion(plugin.getVersion());
                        mojoBinding.setGoal(goal);
                        mojoBinding.setConfiguration(BindingUtils.mergeConfigurations(plugin, execution));
                        mojoBinding.setExecutionId(execution.getId());
                        mojoBinding.setOrigin("POM");
                        this.logger.debug("Mojo: " + MojoBindingUtils.toString(mojoBinding) + ": determining binding phase.");
                        String phase = execution.getPhase();
                        this.logger.debug("Phase from <execution/> section (merged with outer <plugin/> section) is: " + phase);
                        boolean pluginResolved = false;
                        if (phase == null) {
                            if (pluginDescriptor == null) {
                                try {
                                    pluginDescriptor = this.pluginLoader.loadPlugin(plugin, project, session);
                                    pluginResolved = true;
                                }
                                catch (PluginLoaderException e) {
                                    mojoBinding.setLateBound(true);
                                    String message = "Failed to load plugin descriptor for: " + plugin + ". Assigning this plugin to be resolved again just prior to its execution. " + "NOTE, This may affect assignment of the mojo: " + mojoBinding.getGoal() + " if its default phase (given in the plugin descriptor) is used.";
                                    if (this.logger.isDebugEnabled()) {
                                        this.logger.debug(message, e);
                                    }
                                    this.logger.warn(String.valueOf(message) + " Check debug output (-X) for more information.");
                                }
                            }
                            if (pluginDescriptor != null) {
                                if (pluginDescriptor.getMojos() == null) {
                                    this.logger.error("Somehow, the PluginDescriptor for plugin: " + plugin.getKey() + " contains no mojos. This is highly irregular. Ignoring...");
                                    continue;
                                }
                                MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(goal);
                                phase = mojoDescriptor.getPhase();
                                this.logger.debug("Phase from plugin descriptor: " + mojoDescriptor.getFullGoalName() + " is: " + phase);
                            }
                            if (phase == null) {
                                if (pluginResolved) {
                                    StringBuffer message = new StringBuffer();
                                    message.append("\n\nNo lifecycle phase binding can be found for goal: " + goal);
                                    message.append(",\nspecified as a part of the execution: " + execution.getId());
                                    message.append("in plugin: ");
                                    message.append(pluginDescriptor.getPluginLookupKey());
                                    message.append("\n\nThis plugin was resolved successfully.");
                                    message.append("\nHowever, the mojo metadata it contains does not specify a default lifecycle phase binding.");
                                    message.append("\n\nPlease provide a valid <phase/> specification for execution: ").append(execution.getId()).append("\nin plugin: ").append(plugin.getKey());
                                    message.append("\n\n");
                                    throw new LifecycleSpecificationException(message.toString());
                                }
                                this.logger.debug("Skipping addition to build-plan for goal: " + goal + " in execution: " + execution.getId() + " of plugin: " + plugin.getKey() + " because no phase information was available (either through the mojo descriptor, which is currently missing, or in the POM itself).");
                                continue;
                            }
                        }
                        LifecycleBindings lifecycleBindings = bindings;
                        MojoBinding mojoBinding2 = mojoBinding;
                        String string = phase;
                        DefaultLifecycleBindingManager.addMojoBinding_aroundBody1$advice(this, string, mojoBinding2, lifecycleBindings, Maven20xCompatAspect.aspectOf(), string, mojoBinding2, null);
                    }
                }
            }
        }
        LifecycleUtils.setOrigin(bindings, "POM");
        return bindings;
    }

    public LifecycleBindings getPluginLifecycleOverlay(PluginDescriptor pluginDescriptor, String lifecycleId, MavenProject project) throws LifecycleLoaderException, LifecycleSpecificationException {
        Lifecycle lifecycleOverlay = null;
        try {
            lifecycleOverlay = pluginDescriptor.getLifecycleMapping(lifecycleId);
        }
        catch (IOException e) {
            throw new LifecycleLoaderException("Unable to read lifecycle mapping file: " + e.getMessage(), e);
        }
        catch (XmlPullParserException e) {
            throw new LifecycleLoaderException("Unable to parse lifecycle mapping file: " + e.getMessage(), e);
        }
        if (lifecycleOverlay == null) {
            throw new LifecycleLoaderException("Lifecycle '" + lifecycleId + "' not found in plugin");
        }
        LifecycleBindings bindings = new LifecycleBindings();
        Iterator i = lifecycleOverlay.getPhases().iterator();
        while (i.hasNext()) {
            Phase phase = (Phase)i.next();
            ArrayList<MojoBinding> phaseBindings = new ArrayList<MojoBinding>();
            Iterator j = phase.getExecutions().iterator();
            while (j.hasNext()) {
                Execution exec = (Execution)j.next();
                Iterator k = exec.getGoals().iterator();
                while (k.hasNext()) {
                    MojoBinding binding;
                    String goal = (String)k.next();
                    if (goal.indexOf(":") > 0) {
                        binding = this.mojoBindingFactory.parseMojoBinding(goal, project);
                    } else {
                        binding = new MojoBinding();
                        binding.setGroupId(pluginDescriptor.getGroupId());
                        binding.setArtifactId(pluginDescriptor.getArtifactId());
                        binding.setVersion(pluginDescriptor.getVersion());
                        binding.setGoal(goal);
                    }
                    Xpp3Dom configuration = (Xpp3Dom)exec.getConfiguration();
                    if (phase.getConfiguration() != null) {
                        configuration = Xpp3Dom.mergeXpp3Dom(new Xpp3Dom((Xpp3Dom)phase.getConfiguration()), configuration);
                    }
                    binding.setConfiguration(configuration);
                    binding.setOrigin("Lifecycle mapping");
                    binding.setOriginDescription("Lifecycle overlay: " + lifecycleId);
                    LifecycleBindings lifecycleBindings = bindings;
                    MojoBinding mojoBinding = binding;
                    String string = phase.getId();
                    DefaultLifecycleBindingManager.addMojoBinding_aroundBody3$advice(this, string, mojoBinding, lifecycleBindings, Maven20xCompatAspect.aspectOf(), string, mojoBinding, null);
                    phaseBindings.add(binding);
                }
            }
            if (phase.getConfiguration() == null) continue;
            j = phaseBindings.iterator();
            while (j.hasNext()) {
                MojoBinding binding = (MojoBinding)j.next();
                Xpp3Dom configuration = Xpp3Dom.mergeXpp3Dom(new Xpp3Dom((Xpp3Dom)phase.getConfiguration()), (Xpp3Dom)binding.getConfiguration());
                binding.setConfiguration(configuration);
            }
        }
        return bindings;
    }

    public List getReportBindings(MavenProject project, MavenSession session) throws LifecycleLoaderException, LifecycleSpecificationException {
        if (project.getModel().getReports() != null) {
            this.logger.warn("Plugin contains a <reports/> section: this is IGNORED - please use <reporting/> instead.");
        }
        List reportPlugins = this.getReportPluginsForProject(project);
        ArrayList reports = new ArrayList();
        if (reportPlugins != null) {
            Iterator it = reportPlugins.iterator();
            while (it.hasNext()) {
                ReportPlugin reportPlugin = (ReportPlugin)it.next();
                List reportSets = reportPlugin.getReportSets();
                if (reportSets == null || reportSets.isEmpty()) {
                    reports.addAll(this.getReportsForPlugin(reportPlugin, null, project, session));
                    continue;
                }
                Iterator j = reportSets.iterator();
                while (j.hasNext()) {
                    ReportSet reportSet = (ReportSet)j.next();
                    reports.addAll(this.getReportsForPlugin(reportPlugin, reportSet, project, session));
                }
            }
        }
        return reports;
    }

    private List getReportPluginsForProject(MavenProject project) {
        ArrayList<ReportPlugin> reportPlugins = project.getReportPlugins();
        if (project.getReporting() == null || !project.getReporting().isExcludeDefaults()) {
            reportPlugins = reportPlugins == null ? new ArrayList<ReportPlugin>() : new ArrayList(reportPlugins);
            Iterator i = this.defaultReports.iterator();
            while (i.hasNext()) {
                String report = (String)i.next();
                StringTokenizer tok = new StringTokenizer(report, ":");
                if (tok.countTokens() != 2) {
                    this.logger.warn("Invalid default report ignored: '" + report + "' (must be groupId:artifactId)");
                    continue;
                }
                String groupId = tok.nextToken();
                String artifactId = tok.nextToken();
                boolean found = false;
                Iterator j = reportPlugins.iterator();
                while (j.hasNext() && !found) {
                    ReportPlugin reportPlugin = (ReportPlugin)j.next();
                    if (!reportPlugin.getGroupId().equals(groupId) || !reportPlugin.getArtifactId().equals(artifactId)) continue;
                    found = true;
                }
                if (found) continue;
                ReportPlugin reportPlugin = new ReportPlugin();
                reportPlugin.setGroupId(groupId);
                reportPlugin.setArtifactId(artifactId);
                reportPlugins.add(reportPlugin);
            }
        }
        return reportPlugins;
    }

    private List getReportsForPlugin(ReportPlugin reportPlugin, ReportSet reportSet, MavenProject project, MavenSession session) throws LifecycleLoaderException {
        PluginDescriptor pluginDescriptor;
        try {
            pluginDescriptor = this.pluginLoader.loadReportPlugin(reportPlugin, project, session);
        }
        catch (PluginLoaderException e) {
            throw new LifecycleLoaderException("Failed to load report plugin: " + reportPlugin.getKey() + ". Reason: " + e.getMessage(), e);
        }
        ArrayList<MojoBinding> reports = new ArrayList<MojoBinding>();
        Iterator i = pluginDescriptor.getMojos().iterator();
        while (i.hasNext()) {
            MojoDescriptor mojoDescriptor = (MojoDescriptor)i.next();
            try {
                if (!this.isReport(mojoDescriptor)) {
                    continue;
                }
            }
            catch (ClassNotFoundException e) {
                throw new LifecycleLoaderException("Failed while verifying that mojo: " + mojoDescriptor.getId() + " is a report mojo. Reason: " + e.getMessage(), e);
            }
            if (reportSet != null && !reportSet.getReports().contains(mojoDescriptor.getGoal())) continue;
            String id = null;
            if (reportSet != null) {
                id = reportSet.getId();
            }
            MojoBinding binding = new MojoBinding();
            binding.setGroupId(pluginDescriptor.getGroupId());
            binding.setArtifactId(pluginDescriptor.getArtifactId());
            binding.setVersion(pluginDescriptor.getVersion());
            binding.setGoal(mojoDescriptor.getGoal());
            binding.setExecutionId(id);
            binding.setOrigin("POM");
            BindingUtils.injectProjectConfiguration(binding, project);
            reports.add(binding);
        }
        return reports;
    }

    private boolean isReport(MojoDescriptor mojoDescriptor) throws ClassNotFoundException {
        ClassRealm classRealm = mojoDescriptor.getPluginDescriptor().getClassRealm();
        String impl = mojoDescriptor.getImplementation();
        Class mojoClass = classRealm.loadClass(impl);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.maven.reporting.MavenReport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class reportClass = classRealm.loadClass(clazz.getName());
        return reportClass.isAssignableFrom(mojoClass);
    }

    public void contextualize(Context ctx) throws ContextException {
        this.container = (PlexusContainer)ctx.get("plexus");
    }

    public static /* synthetic */ List ajc$privFieldGet$org_apache_maven_compat_Maven20xCompatAspect$org_apache_maven_lifecycle_binding_DefaultLifecycleBindingManager$lifecycles(DefaultLifecycleBindingManager defaultLifecycleBindingManager) {
        return defaultLifecycleBindingManager.lifecycles;
    }

    public static /* synthetic */ void ajc$privFieldSet$org_apache_maven_compat_Maven20xCompatAspect$org_apache_maven_lifecycle_binding_DefaultLifecycleBindingManager$lifecycles(DefaultLifecycleBindingManager defaultLifecycleBindingManager, List list) {
        defaultLifecycleBindingManager.lifecycles = list;
    }

    private static final /* synthetic */ void addMojoBinding_aroundBody0(DefaultLifecycleBindingManager defaultLifecycleBindingManager, String string, MojoBinding mojoBinding, LifecycleBindings lifecycleBindings) {
        LifecycleUtils.addMojoBinding(string, mojoBinding, lifecycleBindings);
    }

    private static final /* synthetic */ void addMojoBinding_aroundBody1$advice(DefaultLifecycleBindingManager this_, String phase, MojoBinding binding, LifecycleBindings ajc_aroundClosure, Maven20xCompatAspect maven20xCompatAspect, String string, MojoBinding mojoBinding, AroundClosure aroundClosure) {
        try {
            AroundClosure aroundClosure2 = aroundClosure;
            MojoBinding mojoBinding2 = mojoBinding;
            String string2 = string;
            DefaultLifecycleBindingManager.addMojoBinding_aroundBody0(this_, string2, mojoBinding2, ajc_aroundClosure);
        }
        catch (NoSuchPhaseException noSuchPhaseException) {
            Maven20xCompatAspect.ajc$inlineAccessFieldGet$org_apache_maven_compat_Maven20xCompatAspect$org_apache_maven_compat_Maven20xCompatAspect$logger(maven20xCompatAspect).debug("Mojo execution: " + MojoBindingUtils.toString(mojoBinding) + " cannot be attached to lifecycle phase: " + string + "; it does not exist. Ignoring this binding.");
        }
    }

    private static final /* synthetic */ void addMojoBinding_aroundBody2(DefaultLifecycleBindingManager defaultLifecycleBindingManager, String string, MojoBinding mojoBinding, LifecycleBindings lifecycleBindings) {
        LifecycleUtils.addMojoBinding(string, mojoBinding, lifecycleBindings);
    }

    private static final /* synthetic */ void addMojoBinding_aroundBody3$advice(DefaultLifecycleBindingManager this_, String phase, MojoBinding binding, LifecycleBindings ajc_aroundClosure, Maven20xCompatAspect maven20xCompatAspect, String string, MojoBinding mojoBinding, AroundClosure aroundClosure) {
        try {
            AroundClosure aroundClosure2 = aroundClosure;
            MojoBinding mojoBinding2 = mojoBinding;
            String string2 = string;
            DefaultLifecycleBindingManager.addMojoBinding_aroundBody2(this_, string2, mojoBinding2, ajc_aroundClosure);
        }
        catch (NoSuchPhaseException noSuchPhaseException) {
            Maven20xCompatAspect.ajc$inlineAccessFieldGet$org_apache_maven_compat_Maven20xCompatAspect$org_apache_maven_compat_Maven20xCompatAspect$logger(maven20xCompatAspect).debug("Mojo execution: " + MojoBindingUtils.toString(mojoBinding) + " cannot be attached to lifecycle phase: " + string + "; it does not exist. Ignoring this binding.");
        }
    }
}

