/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.binding;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.lifecycle.model.LifecycleBinding;
import org.apache.maven.lifecycle.model.LifecycleBindings;
import org.apache.maven.lifecycle.model.MojoBinding;
import org.apache.maven.lifecycle.model.Phase;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ModelUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

final class BindingUtils {
    BindingUtils() {
    }

    static Map buildPluginMap(MavenProject project) {
        Build build;
        HashMap<String, Plugin> pluginMap = new HashMap<String, Plugin>();
        if (project != null && (build = project.getBuild()) != null) {
            Iterator it = build.getPlugins().iterator();
            while (it.hasNext()) {
                Plugin plugin = (Plugin)it.next();
                pluginMap.put(BindingUtils.createPluginKey(plugin), plugin);
            }
        }
        return pluginMap;
    }

    static Map buildReportPluginMap(MavenProject project) {
        Reporting reporting;
        HashMap<String, ReportPlugin> pluginMap = new HashMap<String, ReportPlugin>();
        if (project != null && (reporting = project.getReporting()) != null) {
            Iterator it = reporting.getPlugins().iterator();
            while (it.hasNext()) {
                ReportPlugin plugin = (ReportPlugin)it.next();
                pluginMap.put(BindingUtils.createPluginKey(plugin.getGroupId(), plugin.getArtifactId()), plugin);
            }
        }
        return pluginMap;
    }

    static Map buildPluginMap(PluginContainer pluginContainer) {
        HashMap<String, Plugin> pluginMap = new HashMap<String, Plugin>();
        if (pluginContainer != null) {
            Iterator it = pluginContainer.getPlugins().iterator();
            while (it.hasNext()) {
                Plugin plugin = (Plugin)it.next();
                pluginMap.put(BindingUtils.createPluginKey(plugin), plugin);
            }
        }
        return pluginMap;
    }

    static String createPluginKey(Plugin plugin) {
        return BindingUtils.createPluginKey(plugin.getGroupId(), plugin.getArtifactId());
    }

    static String createPluginKey(String groupId, String artifactId) {
        return String.valueOf(groupId == null ? PluginDescriptor.getDefaultPluginGroupId() : groupId) + ":" + artifactId;
    }

    static Object mergeConfigurations(ReportPlugin reportPlugin, ReportSet reportSet) {
        if (reportPlugin == null && reportSet == null) {
            return null;
        }
        if (reportSet == null) {
            return reportPlugin.getConfiguration();
        }
        if (reportPlugin == null) {
            return reportSet.getConfiguration();
        }
        return BindingUtils.mergeRawConfigurations(reportSet.getConfiguration(), reportPlugin.getConfiguration());
    }

    static Object mergeConfigurations(Plugin plugin, PluginExecution execution) {
        if (plugin == null && execution == null) {
            return null;
        }
        if (execution == null) {
            return plugin.getConfiguration();
        }
        if (plugin == null) {
            return execution.getConfiguration();
        }
        return BindingUtils.mergeRawConfigurations(execution.getConfiguration(), plugin.getConfiguration());
    }

    static Object mergeRawConfigurations(Object dominant, Object recessive) {
        Xpp3Dom dominantConfig = (Xpp3Dom)dominant;
        Xpp3Dom recessiveConfig = (Xpp3Dom)recessive;
        if (recessiveConfig == null) {
            return dominantConfig;
        }
        if (dominantConfig == null) {
            return recessiveConfig;
        }
        return Xpp3Dom.mergeXpp3Dom(new Xpp3Dom(dominantConfig), recessiveConfig);
    }

    static void injectProjectConfiguration(MojoBinding binding, MavenProject project) {
        String key;
        Map pluginMap = BindingUtils.buildPluginMap(project);
        Plugin plugin = (Plugin)pluginMap.get(key = BindingUtils.createPluginKey(binding.getGroupId(), binding.getArtifactId()));
        if (plugin == null) {
            plugin = new Plugin();
            plugin.setGroupId(binding.getGroupId());
            plugin.setArtifactId(binding.getArtifactId());
            plugin.setVersion(binding.getVersion());
        }
        BindingUtils.injectPluginManagementInfo(plugin, project);
        PluginExecution exec = (PluginExecution)plugin.getExecutionsAsMap().get(binding.getExecutionId());
        Object configuration = BindingUtils.mergeConfigurations(plugin, exec);
        ReportPlugin reportPlugin = (ReportPlugin)BindingUtils.buildReportPluginMap(project).get(key);
        if (reportPlugin != null) {
            Map reportSets = reportPlugin.getReportSetsAsMap();
            ReportSet reportSet = null;
            if (reportSets != null && exec != null) {
                reportSet = (ReportSet)reportSets.get(exec.getId());
            }
            Object reportConfig = BindingUtils.mergeConfigurations(reportPlugin, reportSet);
            configuration = BindingUtils.mergeRawConfigurations(reportConfig, configuration);
        }
        binding.setVersion(plugin.getVersion());
        binding.setConfiguration(configuration);
    }

    static void injectProjectConfiguration(LifecycleBindings bindings, MavenProject project) {
        Map pluginsByVersionlessKey = BindingUtils.buildPluginMap(project);
        Iterator lifecycleIt = bindings.getBindingList().iterator();
        while (lifecycleIt.hasNext()) {
            LifecycleBinding binding = (LifecycleBinding)lifecycleIt.next();
            Iterator phaseIt = binding.getPhasesInOrder().iterator();
            while (phaseIt.hasNext()) {
                Phase phase = (Phase)phaseIt.next();
                Iterator mojoIt = phase.getBindings().iterator();
                while (mojoIt.hasNext()) {
                    MojoBinding mojo = (MojoBinding)mojoIt.next();
                    String pluginKey = BindingUtils.createPluginKey(mojo.getGroupId(), mojo.getArtifactId());
                    Plugin plugin = (Plugin)pluginsByVersionlessKey.get(pluginKey);
                    if (plugin == null) {
                        plugin = new Plugin();
                        plugin.setGroupId(mojo.getGroupId());
                        plugin.setArtifactId(mojo.getArtifactId());
                    }
                    BindingUtils.injectPluginManagementInfo(plugin, project);
                    PluginExecution exec = (PluginExecution)plugin.getExecutionsAsMap().get(mojo.getExecutionId());
                    mojo.setConfiguration(BindingUtils.mergeConfigurations(plugin, exec));
                    mojo.setVersion(plugin.getVersion());
                }
            }
        }
    }

    static void injectPluginManagementInfo(Plugin plugin, MavenProject project) {
        String key;
        if (project == null) {
            return;
        }
        Build build = project.getBuild();
        if (build == null) {
            return;
        }
        PluginManagement plugMgmt = build.getPluginManagement();
        if (plugMgmt == null) {
            return;
        }
        Map plugMgmtMap = BindingUtils.buildPluginMap(plugMgmt);
        Plugin mgmtPlugin = (Plugin)plugMgmtMap.get(key = BindingUtils.createPluginKey(plugin));
        if (mgmtPlugin != null) {
            ModelUtils.mergePluginDefinitions(plugin, mgmtPlugin, false);
        }
    }
}

