/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.maven.artifact.ArtifactScopeEnum;
import org.apache.maven.artifact.resolver.conflict.GraphConflictResolutionException;
import org.apache.maven.artifact.resolver.conflict.GraphConflictResolver;
import org.apache.maven.artifact.resolver.metadata.ArtifactMetadata;
import org.apache.maven.artifact.resolver.metadata.MetadataGraph;
import org.apache.maven.artifact.resolver.metadata.MetadataGraphEdge;
import org.apache.maven.artifact.resolver.metadata.MetadataGraphVertex;
import org.apache.maven.artifact.transform.ClasspathContainer;
import org.apache.maven.artifact.transform.ClasspathTransformation;
import org.apache.maven.artifact.transform.MetadataGraphTransformationException;

public class DefaultClasspathTransformation
implements ClasspathTransformation {
    GraphConflictResolver conflictResolver;

    public ClasspathContainer transform(MetadataGraph dirtyGraph, ArtifactScopeEnum scope, boolean resolve) throws MetadataGraphTransformationException {
        try {
            if (dirtyGraph == null || dirtyGraph.isEmpty()) {
                return null;
            }
            MetadataGraph cleanGraph = this.conflictResolver.resolveConflicts(dirtyGraph, scope);
            if (cleanGraph == null || cleanGraph.isEmpty()) {
                return null;
            }
            ClasspathContainer cpc = new ClasspathContainer(scope);
            if (cleanGraph.isEmptyEdges()) {
                ArtifactMetadata amd = cleanGraph.getEntry().getMd();
                cpc.add(amd);
            } else {
                ClasspathGraphVisitor v = new ClasspathGraphVisitor(cleanGraph, cpc);
                MetadataGraphVertex entry = cleanGraph.getEntry();
                ArtifactMetadata md = entry.getMd();
                v.visit(entry);
            }
            return cpc;
        }
        catch (GraphConflictResolutionException e) {
            throw new MetadataGraphTransformationException(e);
        }
    }

    private class ClasspathGraphVisitor {
        MetadataGraph graph;
        ClasspathContainer cpc;
        List<MetadataGraphVertex> visited;

        protected ClasspathGraphVisitor(MetadataGraph cleanGraph, ClasspathContainer cpc) {
            this.cpc = cpc;
            this.graph = cleanGraph;
            this.visited = new ArrayList<MetadataGraphVertex>(cleanGraph.getVertices().size());
        }

        protected void visit(MetadataGraphVertex node) {
            ArtifactMetadata md = node.getMd();
            if (this.visited.contains(node)) {
                return;
            }
            this.cpc.add(md);
            List<MetadataGraphEdge> exits = this.graph.getExcidentEdges(node);
            if (exits != null && exits.size() > 0) {
                MetadataGraphEdge[] sortedExits = exits.toArray(new MetadataGraphEdge[exits.size()]);
                Arrays.sort(sortedExits, new Comparator<MetadataGraphEdge>(){

                    @Override
                    public int compare(MetadataGraphEdge e1, MetadataGraphEdge e2) {
                        if (e1.getDepth() == e2.getDepth()) {
                            if (e2.getPomOrder() == e1.getPomOrder()) {
                                return e1.getTarget().toString().compareTo(e2.getTarget().toString());
                            }
                            return e2.getPomOrder() - e1.getPomOrder();
                        }
                        return e2.getDepth() - e1.getDepth();
                    }

                    @Override
                    public /* synthetic */ int compare(Object x0, Object x1) {
                        return this.compare((MetadataGraphEdge)x0, (MetadataGraphEdge)x1);
                    }
                });
                MetadataGraphEdge[] arr$ = sortedExits;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    MetadataGraphEdge e = arr$[i$];
                    MetadataGraphVertex targetNode = e.getTarget();
                    targetNode.getMd().setArtifactScope(e.getScope());
                    targetNode.getMd().setWhy(e.getSource().getMd().toString());
                    this.visit(targetNode);
                }
            }
        }
    }
}

