/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver.metadata;

import org.apache.maven.artifact.ArtifactScopeEnum;
import org.apache.maven.artifact.resolver.conflict.GraphConflictResolutionException;
import org.apache.maven.artifact.resolver.conflict.GraphConflictResolver;
import org.apache.maven.artifact.resolver.metadata.MetadataGraph;
import org.apache.maven.artifact.resolver.metadata.MetadataResolutionException;
import org.apache.maven.artifact.resolver.metadata.MetadataResolutionRequestTypeEnum;
import org.apache.maven.artifact.resolver.metadata.MetadataTreeNode;
import org.apache.maven.artifact.transform.ClasspathContainer;
import org.apache.maven.artifact.transform.ClasspathTransformation;
import org.apache.maven.artifact.transform.MetadataGraphTransformationException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public class MetadataResolutionResult {
    MetadataTreeNode treeRoot;
    ClasspathTransformation classpathTransformation;
    GraphConflictResolver conflictResolver;
    static /* synthetic */ Class class$org$apache$maven$artifact$resolver$conflict$GraphConflictResolver;
    static /* synthetic */ Class class$org$apache$maven$artifact$transform$ClasspathTransformation;

    public MetadataResolutionResult() {
    }

    public MetadataResolutionResult(MetadataTreeNode root) {
        this.treeRoot = root;
    }

    public MetadataTreeNode getTree() {
        return this.treeRoot;
    }

    public void setTree(MetadataTreeNode root) {
        this.treeRoot = root;
    }

    public void initTreeProcessing(PlexusContainer plexus) throws ComponentLookupException {
        Class<?> clazz = class$org$apache$maven$artifact$transform$ClasspathTransformation;
        if (clazz == null) {
            clazz = class$org$apache$maven$artifact$transform$ClasspathTransformation = new ClasspathTransformation[0].getClass().getComponentType();
        }
        this.classpathTransformation = (ClasspathTransformation)plexus.lookup(clazz);
        Class<?> clazz2 = class$org$apache$maven$artifact$resolver$conflict$GraphConflictResolver;
        if (clazz2 == null) {
            clazz2 = class$org$apache$maven$artifact$resolver$conflict$GraphConflictResolver = new GraphConflictResolver[0].getClass().getComponentType();
        }
        this.conflictResolver = (GraphConflictResolver)plexus.lookup(clazz2);
    }

    public MetadataGraph getGraph() throws MetadataResolutionException {
        return this.treeRoot == null ? null : new MetadataGraph(this.treeRoot);
    }

    public MetadataGraph getGraph(ArtifactScopeEnum scope) throws MetadataResolutionException, GraphConflictResolutionException {
        if (this.treeRoot == null) {
            return null;
        }
        if (this.conflictResolver == null) {
            return null;
        }
        return this.conflictResolver.resolveConflicts(this.getGraph(), scope);
    }

    public MetadataGraph getGraph(MetadataResolutionRequestTypeEnum requestType) throws MetadataResolutionException, GraphConflictResolutionException {
        if (requestType == null) {
            return null;
        }
        if (this.treeRoot == null) {
            return null;
        }
        if (this.conflictResolver == null) {
            return null;
        }
        if (requestType.equals(MetadataResolutionRequestTypeEnum.classpathCompile)) {
            return this.conflictResolver.resolveConflicts(this.getGraph(), ArtifactScopeEnum.compile);
        }
        if (requestType.equals(MetadataResolutionRequestTypeEnum.classpathRuntime)) {
            return this.conflictResolver.resolveConflicts(this.getGraph(), ArtifactScopeEnum.runtime);
        }
        if (requestType.equals(MetadataResolutionRequestTypeEnum.classpathRuntime)) {
            return this.conflictResolver.resolveConflicts(this.getGraph(), ArtifactScopeEnum.test);
        }
        if (requestType.equals(MetadataResolutionRequestTypeEnum.classpathRuntime)) {
            return this.conflictResolver.resolveConflicts(this.getGraph(), ArtifactScopeEnum.test);
        }
        if (requestType.equals(MetadataResolutionRequestTypeEnum.graph)) {
            return this.getGraph();
        }
        if (requestType.equals(MetadataResolutionRequestTypeEnum.versionedGraph)) {
            return new MetadataGraph(this.getTree(), true, false);
        }
        if (requestType.equals(MetadataResolutionRequestTypeEnum.scopedGraph)) {
            return new MetadataGraph(this.getTree(), true, true);
        }
        return null;
    }

    public ClasspathContainer getClasspath(ArtifactScopeEnum scope) throws MetadataGraphTransformationException, MetadataResolutionException {
        if (this.classpathTransformation == null) {
            return null;
        }
        MetadataGraph dirtyGraph = this.getGraph();
        if (dirtyGraph == null) {
            return null;
        }
        ClasspathContainer cpc = this.classpathTransformation.transform(dirtyGraph, scope, false);
        return cpc;
    }

    public MetadataTreeNode getClasspathTree(ArtifactScopeEnum scope) throws MetadataGraphTransformationException, MetadataResolutionException {
        ClasspathContainer cpc = this.getClasspath(scope);
        if (cpc == null) {
            return null;
        }
        return cpc.getClasspathAsTree();
    }
}

