/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.versioning.VersionRange;

public final class ArtifactUtils {
    private ArtifactUtils() {
    }

    public static boolean isSnapshot(String version) {
        return version != null && (version.toUpperCase().endsWith("SNAPSHOT") || Artifact.VERSION_FILE_PATTERN.matcher(version).matches());
    }

    public static String toSnapshotVersion(String version) {
        Matcher m = Artifact.VERSION_FILE_PATTERN.matcher(version);
        if (m.matches()) {
            return m.group(1) + "-" + "SNAPSHOT";
        }
        return version;
    }

    public static String versionlessKey(Artifact artifact) {
        return ArtifactUtils.versionlessKey(artifact.getGroupId(), artifact.getArtifactId());
    }

    public static String versionlessKey(String groupId, String artifactId) {
        if (groupId == null) {
            throw new NullPointerException("groupId was null");
        }
        if (artifactId == null) {
            throw new NullPointerException("artifactId was null");
        }
        return groupId + ":" + artifactId;
    }

    public static String artifactId(String groupId, String artifactId, String type, String version) {
        return ArtifactUtils.artifactId(groupId, artifactId, type, null, version);
    }

    public static String artifactId(String groupId, String artifactId, String type, String classifier, String baseVersion) {
        return groupId + ":" + artifactId + ":" + type + (classifier != null ? ":" + classifier : "") + ":" + baseVersion;
    }

    public static Map artifactMapByVersionlessId(Collection artifacts) {
        HashMap<String, Artifact> artifactMap = new HashMap<String, Artifact>();
        if (artifacts != null) {
            Iterator it = artifacts.iterator();
            while (it.hasNext()) {
                Artifact artifact = (Artifact)it.next();
                artifactMap.put(ArtifactUtils.versionlessKey(artifact), artifact);
            }
        }
        return artifactMap;
    }

    public static Map artifactMapByArtifactId(Collection artifacts) {
        HashMap<String, Artifact> artifactMap = new HashMap<String, Artifact>();
        if (artifacts != null) {
            Iterator it = artifacts.iterator();
            while (it.hasNext()) {
                Artifact artifact = (Artifact)it.next();
                artifactMap.put(artifact.getId(), artifact);
            }
        }
        return artifactMap;
    }

    public static Artifact copyArtifact(Artifact artifact) {
        VersionRange range = artifact.getVersionRange();
        if (range == null) {
            range = VersionRange.createFromVersion(artifact.getVersion());
        }
        DefaultArtifact clone = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), range.cloneOf(), artifact.getScope(), artifact.getType(), artifact.getClassifier(), artifact.getArtifactHandler(), artifact.isOptional());
        clone.setRelease(artifact.isRelease());
        clone.setResolvedVersion(artifact.getVersion());
        clone.setResolved(artifact.isResolved());
        clone.setFile(artifact.getFile());
        clone.setAvailableVersions(ArtifactUtils.copyList(artifact.getAvailableVersions()));
        clone.setBaseVersion(artifact.getBaseVersion());
        clone.setDependencyFilter(artifact.getDependencyFilter());
        clone.setDependencyTrail(ArtifactUtils.copyList(artifact.getDependencyTrail()));
        clone.setDownloadUrl(artifact.getDownloadUrl());
        clone.setRepository(artifact.getRepository());
        return clone;
    }

    private static List copyList(List original) {
        ArrayList copy = null;
        if (original != null) {
            copy = new ArrayList();
            if (!original.isEmpty()) {
                copy.addAll(original);
            }
        }
        return copy;
    }
}

