/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.interpolation;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.project.interpolation.ModelInterpolator;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.introspection.ReflectionValueExtractor;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class RegexBasedModelInterpolator
extends AbstractLogEnabled
implements ModelInterpolator {
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\$\\{(pom\\.|project\\.|env\\.)?([^}]+)\\}");
    private Properties envars = CommandLineUtils.getSystemEnvVars();

    public Model interpolate(Model model, Map context) throws ModelInterpolationException {
        return this.interpolate(model, context, true);
    }

    public Model interpolate(Model model, Map context, boolean strict) throws ModelInterpolationException {
        StringWriter sWriter = new StringWriter();
        MavenXpp3Writer writer = new MavenXpp3Writer();
        try {
            writer.write(sWriter, model);
        }
        catch (IOException e) {
            throw new ModelInterpolationException("Cannot serialize project model for interpolation.", e);
        }
        String serializedModel = sWriter.toString();
        serializedModel = this.interpolateInternal(serializedModel, model, context);
        StringReader sReader = new StringReader(serializedModel);
        MavenXpp3Reader modelReader = new MavenXpp3Reader();
        try {
            model = modelReader.read(sReader);
        }
        catch (IOException e) {
            throw new ModelInterpolationException("Cannot read project model from interpolating filter of serialized version.", e);
        }
        catch (XmlPullParserException e) {
            throw new ModelInterpolationException("Cannot read project model from interpolating filter of serialized version.", e);
        }
        return model;
    }

    private String interpolateInternal(String src, Model model, Map context) throws ModelInterpolationException {
        Logger logger = this.getLogger();
        boolean isSnapshotModel = (model.getVersion() == null ? (model.getParent() == null ? "" : model.getParent().getVersion()) : model.getVersion()).indexOf("SNAPSHOT") >= 0;
        String result = src;
        Matcher matcher = EXPRESSION_PATTERN.matcher(result);
        while (matcher.find()) {
            boolean isPomExpression;
            String wholeExpr = matcher.group(0);
            String prefix = matcher.group(1);
            String realExpr = matcher.group(2);
            prefix = prefix == null ? "" : prefix;
            Object value = null;
            boolean bl = isPomExpression = "pom.".equals(prefix) || "project.".equals(prefix);
            if (context.get(realExpr) == null && context.containsKey(realExpr)) continue;
            if (isPomExpression) {
                value = RegexBasedModelInterpolator.getValueFromModel(realExpr, model, wholeExpr, logger);
            }
            if (value == null) {
                value = context.get(realExpr);
            }
            if (value == null) {
                value = model.getProperties().getProperty(realExpr);
            }
            if (value == null) {
                value = this.envars.getProperty(realExpr);
            }
            if (value == null && prefix.length() == 0) {
                value = RegexBasedModelInterpolator.getValueFromModel(realExpr, model, wholeExpr, logger);
                if (isSnapshotModel && value != null && logger != null) {
                    logger.debug("Expression: " + wholeExpr + " is missing its prefix. Instead, use ${pom." + realExpr + "} (model: " + model.getId() + ")");
                }
            }
            if (value == null) continue;
            if (StringUtils.replace(value.toString(), "${project.", "${pom.").indexOf(StringUtils.replace(wholeExpr, "${project.", "${pom.")) > -1) {
                throw new ModelInterpolationException(wholeExpr, "Expression value '" + value + "' references itself in '" + model.getId() + "'.");
            }
            result = StringUtils.replace(result, wholeExpr, value.toString());
            matcher.reset(result);
        }
        return result;
    }

    private static Object getValueFromModel(String realExpr, Model model, String wholeExpr, Logger logger) {
        try {
            return ReflectionValueExtractor.evaluate(realExpr, model, false);
        }
        catch (Exception e) {
            if (logger != null) {
                logger.debug("POM interpolation cannot proceed with expression: " + wholeExpr + ". Skipping...", e);
            }
            return null;
        }
    }
}

