/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.artifact;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.metadata.ArtifactMetadata;
import org.apache.maven.artifact.resolver.metadata.MetadataResolution;
import org.apache.maven.artifact.resolver.metadata.MetadataRetrievalException;
import org.apache.maven.artifact.resolver.metadata.MetadataSource;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

public class PomMetadataSource
extends AbstractLogEnabled
implements MetadataSource,
Contextualizable {
    public static final String ROLE_HINT = "default";
    private MavenProjectBuilder mavenProjectBuilder;
    private ArtifactFactory artifactFactory;
    private MavenProject superProject;
    private PlexusContainer container;
    private boolean strictlyEnforceThePresenceOfAValidMavenPOM = true;
    static /* synthetic */ Class class$0;

    public MetadataResolution retrieve(ArtifactMetadata artifactMetadata, ArtifactRepository localRepository, List remoteRepositories) throws MetadataRetrievalException {
        MavenProject project;
        block7: {
            try {
                this.loadProjectBuilder();
            }
            catch (ComponentLookupException e) {
                throw new MetadataRetrievalException("Cannot lookup MavenProjectBuilder component instance: " + e.getMessage(), e);
            }
            project = null;
            Artifact pomArtifact = this.artifactFactory.createProjectArtifact(artifactMetadata.getGroupId(), artifactMetadata.getArtifactId(), artifactMetadata.getVersion());
            try {
                project = this.mavenProjectBuilder.buildFromRepository(pomArtifact, remoteRepositories, localRepository);
                if (pomArtifact.getFile() != null) {
                    artifactMetadata.setArtifactUri(pomArtifact.getFile().toURI().toString());
                }
            }
            catch (InvalidProjectModelException e) {
                artifactMetadata.setError(e.getMessage());
            }
            catch (ProjectBuildingException e) {
                if (!this.strictlyEnforceThePresenceOfAValidMavenPOM) break block7;
                throw new MetadataRetrievalException("Unable to read the metadata file for artifactMetadata '" + artifactMetadata.getDependencyConflictId() + "': " + e.getMessage(), e, artifactMetadata);
            }
        }
        HashSet<ArtifactMetadata> artifacts = new HashSet<ArtifactMetadata>();
        Iterator i = project.getDependencies().iterator();
        while (i.hasNext()) {
            Dependency d = (Dependency)i.next();
            artifacts.add(new ArtifactMetadata(d.getGroupId(), d.getArtifactId(), d.getVersion(), d.getType(), d.getScope(), d.getClassifier(), null, null, false, null));
        }
        artifactMetadata.setDependencies(artifacts);
        return new MetadataResolution(artifactMetadata);
    }

    private void loadProjectBuilder() throws ComponentLookupException {
        if (this.mavenProjectBuilder == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.apache.maven.project.MavenProjectBuilder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.mavenProjectBuilder = (MavenProjectBuilder)this.container.lookup(clazz);
        }
    }

    private List aggregateRepositoryLists(List remoteRepositories, List remoteArtifactRepositories) throws ArtifactMetadataRetrievalException {
        if (this.superProject == null) {
            try {
                this.superProject = this.mavenProjectBuilder.buildStandaloneSuperProject();
            }
            catch (ProjectBuildingException e) {
                throw new ArtifactMetadataRetrievalException("Unable to parse the Maven built-in model: " + e.getMessage(), e);
            }
        }
        ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>();
        repositories.addAll(remoteRepositories);
        Iterator it = this.superProject.getRemoteArtifactRepositories().iterator();
        while (it.hasNext()) {
            ArtifactRepository superRepo = (ArtifactRepository)it.next();
            Iterator aggregatedIterator = repositories.iterator();
            while (aggregatedIterator.hasNext()) {
                ArtifactRepository repo = (ArtifactRepository)aggregatedIterator.next();
                if (!repo.getId().equals(superRepo.getId()) || !repo.getUrl().equals(superRepo.getUrl())) continue;
                aggregatedIterator.remove();
            }
        }
        it = remoteArtifactRepositories.iterator();
        while (it.hasNext()) {
            ArtifactRepository repository = (ArtifactRepository)it.next();
            if (repositories.contains(repository)) continue;
            repositories.add(repository);
        }
        return repositories;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get("plexus");
    }
}

