/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.UnknownRepositoryLayoutException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.codehaus.plexus.PlexusContainer;

public final class ProjectUtils {
    private ProjectUtils() {
    }

    public static List buildArtifactRepositories(List repositories, ArtifactRepositoryFactory artifactRepositoryFactory, PlexusContainer container) throws UnknownRepositoryLayoutException {
        ArrayList<ArtifactRepository> repos = new ArrayList<ArtifactRepository>();
        Iterator i = repositories.iterator();
        while (i.hasNext()) {
            Repository mavenRepo = (Repository)i.next();
            ArtifactRepository artifactRepo = ProjectUtils.buildArtifactRepository(mavenRepo, artifactRepositoryFactory, container);
            if (repos.contains(artifactRepo)) continue;
            repos.add(artifactRepo);
        }
        return repos;
    }

    public static ArtifactRepository buildDeploymentArtifactRepository(DeploymentRepository repo, ArtifactRepositoryFactory artifactRepositoryFactory, PlexusContainer container) throws UnknownRepositoryLayoutException {
        if (repo != null) {
            String id = repo.getId();
            String url = repo.getUrl();
            return artifactRepositoryFactory.createDeploymentArtifactRepository(id, url, repo.getLayout(), repo.isUniqueVersion());
        }
        return null;
    }

    public static ArtifactRepository buildArtifactRepository(Repository repo, ArtifactRepositoryFactory artifactRepositoryFactory, PlexusContainer container) throws UnknownRepositoryLayoutException {
        if (repo != null) {
            String id = repo.getId();
            String url = repo.getUrl();
            ArtifactRepositoryPolicy snapshots = ProjectUtils.buildArtifactRepositoryPolicy(repo.getSnapshots());
            ArtifactRepositoryPolicy releases = ProjectUtils.buildArtifactRepositoryPolicy(repo.getReleases());
            return artifactRepositoryFactory.createArtifactRepository(id, url, repo.getLayout(), snapshots, releases);
        }
        return null;
    }

    private static ArtifactRepositoryPolicy buildArtifactRepositoryPolicy(RepositoryPolicy policy) {
        boolean enabled = true;
        String updatePolicy = null;
        String checksumPolicy = null;
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updatePolicy = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksumPolicy = policy.getChecksumPolicy();
            }
        }
        return new ArtifactRepositoryPolicy(enabled, updatePolicy, checksumPolicy);
    }
}

