/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.profiles.activation;

import java.io.IOException;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.Profile;
import org.apache.maven.profiles.activation.ProfileActivationContext;
import org.apache.maven.profiles.activation.ProfileActivator;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.util.interpolation.MapBasedValueSource;
import org.codehaus.plexus.util.interpolation.RegexBasedInterpolator;

public class FileProfileActivator
implements ProfileActivator,
LogEnabled {
    private Logger logger;

    public boolean canDetermineActivation(Profile profile, ProfileActivationContext context) {
        return profile.getActivation() != null && profile.getActivation().getFile() != null;
    }

    public boolean isActive(Profile profile, ProfileActivationContext context) {
        Activation activation = profile.getActivation();
        ActivationFile actFile = activation.getFile();
        if (actFile != null) {
            String fileString = actFile.getExists();
            RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
            try {
                interpolator.addValueSource(new EnvarBasedValueSource());
            }
            catch (IOException iOException) {}
            interpolator.addValueSource(new MapBasedValueSource(System.getProperties()));
            if (StringUtils.isNotEmpty(fileString)) {
                fileString = StringUtils.replace(interpolator.interpolate(fileString, ""), "\\", "/");
                boolean result = FileUtils.fileExists(fileString);
                if (this.logger != null) {
                    this.logger.debug("FileProfileActivator: Checking file existence for: " + fileString + ". Result: " + result);
                }
                return result;
            }
            fileString = actFile.getMissing();
            if (StringUtils.isNotEmpty(fileString)) {
                boolean result;
                boolean bl = result = !FileUtils.fileExists(fileString = StringUtils.replace(interpolator.interpolate(fileString, ""), "\\", "/"));
                if (this.logger != null) {
                    this.logger.debug("FileProfileActivator: Checking file is missing for: " + fileString + ". Result: " + result);
                }
                return result;
            }
        } else if (this.logger != null) {
            this.logger.debug("FileProfileActivator: no file specified. Skipping activation.");
        }
        return false;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }
}

