/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.descriptor;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class PluginDescriptorBuilder {
    public PluginDescriptor build(Reader reader) throws PlexusConfigurationException {
        return this.build(reader, null);
    }

    public PluginDescriptor build(Reader reader, String source) throws PlexusConfigurationException {
        String inheritedByDefault;
        PlexusConfiguration c = this.buildConfiguration(reader);
        PluginDescriptor pluginDescriptor = new PluginDescriptor();
        pluginDescriptor.setSource(source);
        pluginDescriptor.setGroupId(c.getChild("groupId").getValue());
        pluginDescriptor.setArtifactId(c.getChild("artifactId").getValue());
        pluginDescriptor.setVersion(c.getChild("version").getValue());
        pluginDescriptor.setGoalPrefix(c.getChild("goalPrefix").getValue());
        pluginDescriptor.setName(c.getChild("name").getValue());
        pluginDescriptor.setDescription(c.getChild("description").getValue());
        String isolatedRealm = c.getChild("isolatedRealm").getValue();
        if (isolatedRealm != null) {
            pluginDescriptor.setIsolatedRealm(Boolean.valueOf(isolatedRealm));
        }
        if ((inheritedByDefault = c.getChild("inheritedByDefault").getValue()) != null) {
            pluginDescriptor.setInheritedByDefault(Boolean.valueOf(inheritedByDefault));
        }
        PlexusConfiguration[] mojoConfigurations = c.getChild("mojos").getChildren("mojo");
        for (int i = 0; i < mojoConfigurations.length; ++i) {
            PlexusConfiguration component = mojoConfigurations[i];
            MojoDescriptor mojoDescriptor = this.buildComponentDescriptor(component, pluginDescriptor);
            pluginDescriptor.addMojo(mojoDescriptor);
        }
        PlexusConfiguration[] dependencyConfigurations = c.getChild("dependencies").getChildren("dependency");
        ArrayList<ComponentDependency> dependencies = new ArrayList<ComponentDependency>();
        for (int i = 0; i < dependencyConfigurations.length; ++i) {
            PlexusConfiguration d = dependencyConfigurations[i];
            ComponentDependency cd = new ComponentDependency();
            cd.setArtifactId(d.getChild("artifactId").getValue());
            cd.setGroupId(d.getChild("groupId").getValue());
            cd.setType(d.getChild("type").getValue());
            cd.setVersion(d.getChild("version").getValue());
            dependencies.add(cd);
        }
        pluginDescriptor.setDependencies(dependencies);
        return pluginDescriptor;
    }

    public MojoDescriptor buildComponentDescriptor(PlexusConfiguration c, PluginDescriptor pluginDescriptor) throws PlexusConfigurationException {
        String inheritedByDefault;
        String requiresOnline;
        String aggregator;
        String requiresReports;
        String requiresProject;
        String directInvocationOnly;
        String executeLifecycle;
        String executeMojo;
        String executePhase;
        String phase;
        String since;
        PlexusConfiguration composerConfig;
        PlexusConfiguration configuratorConfig;
        MojoDescriptor mojo = new MojoDescriptor();
        mojo.setPluginDescriptor(pluginDescriptor);
        mojo.setGoal(c.getChild("goal").getValue());
        mojo.setImplementation(c.getChild("implementation").getValue());
        PlexusConfiguration langConfig = c.getChild("language");
        if (langConfig != null) {
            mojo.setLanguage(langConfig.getValue());
        }
        if ((configuratorConfig = c.getChild("configurator")) != null) {
            mojo.setComponentConfigurator(configuratorConfig.getValue());
        }
        if ((composerConfig = c.getChild("composer")) != null) {
            mojo.setComponentComposer(composerConfig.getValue());
        }
        if ((since = c.getChild("since").getValue()) != null) {
            mojo.setSince(since);
        }
        if ((phase = c.getChild("phase").getValue()) != null) {
            mojo.setPhase(phase);
        }
        if ((executePhase = c.getChild("executePhase").getValue()) != null) {
            mojo.setExecutePhase(executePhase);
        }
        if ((executeMojo = c.getChild("executeGoal").getValue()) != null) {
            mojo.setExecuteGoal(executeMojo);
        }
        if ((executeLifecycle = c.getChild("executeLifecycle").getValue()) != null) {
            mojo.setExecuteLifecycle(executeLifecycle);
        }
        mojo.setInstantiationStrategy(c.getChild("instantiationStrategy").getValue());
        mojo.setDescription(c.getChild("description").getValue());
        String dependencyResolution = c.getChild("requiresDependencyResolution").getValue();
        if (dependencyResolution != null) {
            mojo.setDependencyResolutionRequired(dependencyResolution);
        }
        if ((directInvocationOnly = c.getChild("requiresDirectInvocation").getValue()) != null) {
            mojo.setDirectInvocationOnly(Boolean.valueOf(directInvocationOnly));
        }
        if ((requiresProject = c.getChild("requiresProject").getValue()) != null) {
            mojo.setProjectRequired(Boolean.valueOf(requiresProject));
        }
        if ((requiresReports = c.getChild("requiresReports").getValue()) != null) {
            mojo.setRequiresReports(Boolean.valueOf(requiresReports));
        }
        if ((aggregator = c.getChild("aggregator").getValue()) != null) {
            mojo.setAggregator(Boolean.valueOf(aggregator));
        }
        if ((requiresOnline = c.getChild("requiresOnline").getValue()) != null) {
            mojo.setOnlineRequired(Boolean.valueOf(requiresOnline));
        }
        if ((inheritedByDefault = c.getChild("inheritedByDefault").getValue()) != null) {
            mojo.setInheritedByDefault(Boolean.valueOf(inheritedByDefault));
        }
        PlexusConfiguration[] parameterConfigurations = c.getChild("parameters").getChildren("parameter");
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (int i = 0; i < parameterConfigurations.length; ++i) {
            PlexusConfiguration d = parameterConfigurations[i];
            Parameter parameter = new Parameter();
            parameter.setName(d.getChild("name").getValue());
            parameter.setAlias(d.getChild("alias").getValue());
            parameter.setType(d.getChild("type").getValue());
            String required = d.getChild("required").getValue();
            parameter.setRequired(Boolean.valueOf(required));
            PlexusConfiguration editableConfig = d.getChild("editable");
            if (editableConfig != null) {
                String editable = d.getChild("editable").getValue();
                parameter.setEditable(editable == null || Boolean.valueOf(editable) != false);
            }
            parameter.setDescription(d.getChild("description").getValue());
            parameter.setDeprecated(d.getChild("deprecated").getValue());
            parameter.setImplementation(d.getChild("implementation").getValue());
            parameters.add(parameter);
        }
        mojo.setParameters(parameters);
        mojo.setMojoConfiguration(c.getChild("configuration"));
        PlexusConfiguration[] requirements = c.getChild("requirements").getChildren("requirement");
        for (int i = 0; i < requirements.length; ++i) {
            PlexusConfiguration requirement = requirements[i];
            ComponentRequirement cr = new ComponentRequirement();
            cr.setRole(requirement.getChild("role").getValue());
            cr.setRoleHint(requirement.getChild("role-hint").getValue());
            cr.setFieldName(requirement.getChild("field-name").getValue());
            mojo.addRequirement(cr);
        }
        return mojo;
    }

    public PlexusConfiguration buildConfiguration(Reader configuration) throws PlexusConfigurationException {
        try {
            return new XmlPlexusConfiguration(Xpp3DomBuilder.build(configuration));
        }
        catch (IOException e) {
            throw new PlexusConfigurationException("Error creating configuration", e);
        }
        catch (XmlPullParserException e) {
            throw new PlexusConfigurationException("Error creating configuration", e);
        }
    }
}

