/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.model.io.xpp3;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.lifecycle.model.BuildBinding;
import org.apache.maven.lifecycle.model.CleanBinding;
import org.apache.maven.lifecycle.model.LifecycleBinding;
import org.apache.maven.lifecycle.model.LifecycleBindings;
import org.apache.maven.lifecycle.model.MojoBinding;
import org.apache.maven.lifecycle.model.Phase;
import org.apache.maven.lifecycle.model.SiteBinding;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class LifecycleBindingsXpp3Writer {
    private String NAMESPACE;

    public void write(Writer writer, LifecycleBindings lifecycleBindings) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n");
        serializer.setOutput(writer);
        serializer.startDocument(lifecycleBindings.getModelEncoding(), null);
        this.writeLifecycleBindings(lifecycleBindings, "lifecycles", serializer);
        serializer.endDocument();
    }

    private void writeBuildBinding(BuildBinding buildBinding, String tagName, XmlSerializer serializer) throws IOException {
        if (buildBinding != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (buildBinding.getValidate() != null) {
                this.writePhase(buildBinding.getValidate(), "validate", serializer);
            }
            if (buildBinding.getInitialize() != null) {
                this.writePhase(buildBinding.getInitialize(), "initialize", serializer);
            }
            if (buildBinding.getGenerateSources() != null) {
                this.writePhase(buildBinding.getGenerateSources(), "generate-sources", serializer);
            }
            if (buildBinding.getProcessSources() != null) {
                this.writePhase(buildBinding.getProcessSources(), "process-sources", serializer);
            }
            if (buildBinding.getGenerateResources() != null) {
                this.writePhase(buildBinding.getGenerateResources(), "generate-resources", serializer);
            }
            if (buildBinding.getProcessResources() != null) {
                this.writePhase(buildBinding.getProcessResources(), "process-resources", serializer);
            }
            if (buildBinding.getCompile() != null) {
                this.writePhase(buildBinding.getCompile(), "compile", serializer);
            }
            if (buildBinding.getProcessClasses() != null) {
                this.writePhase(buildBinding.getProcessClasses(), "process-classes", serializer);
            }
            if (buildBinding.getGenerateTestSources() != null) {
                this.writePhase(buildBinding.getGenerateTestSources(), "generate-test-sources", serializer);
            }
            if (buildBinding.getProcessTestSources() != null) {
                this.writePhase(buildBinding.getProcessTestSources(), "process-test-sources", serializer);
            }
            if (buildBinding.getGenerateTestResources() != null) {
                this.writePhase(buildBinding.getGenerateTestResources(), "generate-test-resources", serializer);
            }
            if (buildBinding.getProcessTestResources() != null) {
                this.writePhase(buildBinding.getProcessTestResources(), "process-test-resources", serializer);
            }
            if (buildBinding.getTestCompile() != null) {
                this.writePhase(buildBinding.getTestCompile(), "test-compile", serializer);
            }
            if (buildBinding.getProcessTestClasses() != null) {
                this.writePhase(buildBinding.getProcessTestClasses(), "process-test-classes", serializer);
            }
            if (buildBinding.getTest() != null) {
                this.writePhase(buildBinding.getTest(), "test", serializer);
            }
            if (buildBinding.getPreparePackage() != null) {
                this.writePhase(buildBinding.getPreparePackage(), "prepare-package", serializer);
            }
            if (buildBinding.getCreatePackage() != null) {
                this.writePhase(buildBinding.getCreatePackage(), "package", serializer);
            }
            if (buildBinding.getPreIntegrationTest() != null) {
                this.writePhase(buildBinding.getPreIntegrationTest(), "pre-integration-test", serializer);
            }
            if (buildBinding.getIntegrationTest() != null) {
                this.writePhase(buildBinding.getIntegrationTest(), "integration-test", serializer);
            }
            if (buildBinding.getPostIntegrationTest() != null) {
                this.writePhase(buildBinding.getPostIntegrationTest(), "post-integration-test", serializer);
            }
            if (buildBinding.getVerify() != null) {
                this.writePhase(buildBinding.getVerify(), "verify", serializer);
            }
            if (buildBinding.getInstall() != null) {
                this.writePhase(buildBinding.getInstall(), "install", serializer);
            }
            if (buildBinding.getDeploy() != null) {
                this.writePhase(buildBinding.getDeploy(), "deploy", serializer);
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeCleanBinding(CleanBinding cleanBinding, String tagName, XmlSerializer serializer) throws IOException {
        if (cleanBinding != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (cleanBinding.getPreClean() != null) {
                this.writePhase(cleanBinding.getPreClean(), "pre-clean", serializer);
            }
            if (cleanBinding.getClean() != null) {
                this.writePhase(cleanBinding.getClean(), "clean", serializer);
            }
            if (cleanBinding.getPostClean() != null) {
                this.writePhase(cleanBinding.getPostClean(), "post-clean", serializer);
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeLifecycleBinding(LifecycleBinding lifecycleBinding, String tagName, XmlSerializer serializer) throws IOException {
        if (lifecycleBinding != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeLifecycleBindings(LifecycleBindings lifecycleBindings, String tagName, XmlSerializer serializer) throws IOException {
        if (lifecycleBindings != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (lifecycleBindings.getPackaging() != null) {
                serializer.startTag(this.NAMESPACE, "packaging").text(lifecycleBindings.getPackaging()).endTag(this.NAMESPACE, "packaging");
            }
            if (lifecycleBindings.getCleanBinding() != null) {
                this.writeCleanBinding(lifecycleBindings.getCleanBinding(), "clean", serializer);
            }
            if (lifecycleBindings.getBuildBinding() != null) {
                this.writeBuildBinding(lifecycleBindings.getBuildBinding(), "build", serializer);
            }
            if (lifecycleBindings.getSiteBinding() != null) {
                this.writeSiteBinding(lifecycleBindings.getSiteBinding(), "site", serializer);
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeMojoBinding(MojoBinding mojoBinding, String tagName, XmlSerializer serializer) throws IOException {
        if (mojoBinding != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (mojoBinding.getGroupId() != null) {
                serializer.startTag(this.NAMESPACE, "groupId").text(mojoBinding.getGroupId()).endTag(this.NAMESPACE, "groupId");
            }
            if (mojoBinding.getArtifactId() != null) {
                serializer.startTag(this.NAMESPACE, "artifactId").text(mojoBinding.getArtifactId()).endTag(this.NAMESPACE, "artifactId");
            }
            if (mojoBinding.getVersion() != null) {
                serializer.startTag(this.NAMESPACE, "version").text(mojoBinding.getVersion()).endTag(this.NAMESPACE, "version");
            }
            if (mojoBinding.getGoal() != null) {
                serializer.startTag(this.NAMESPACE, "goal").text(mojoBinding.getGoal()).endTag(this.NAMESPACE, "goal");
            }
            if (mojoBinding.getExecutionId() != null && !mojoBinding.getExecutionId().equals("default")) {
                serializer.startTag(this.NAMESPACE, "executionId").text(mojoBinding.getExecutionId()).endTag(this.NAMESPACE, "executionId");
            }
            if (mojoBinding.getConfiguration() != null) {
                ((Xpp3Dom)mojoBinding.getConfiguration()).writeToSerializer(this.NAMESPACE, serializer);
            }
            if (mojoBinding.isOptional()) {
                serializer.startTag(this.NAMESPACE, "optional").text(String.valueOf(mojoBinding.isOptional())).endTag(this.NAMESPACE, "optional");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writePhase(Phase phase, String tagName, XmlSerializer serializer) throws IOException {
        if (phase != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (phase.getBindings() != null && phase.getBindings().size() > 0) {
                serializer.startTag(this.NAMESPACE, "bindings");
                Iterator iter = phase.getBindings().iterator();
                while (iter.hasNext()) {
                    MojoBinding o = (MojoBinding)iter.next();
                    this.writeMojoBinding(o, "binding", serializer);
                }
                serializer.endTag(this.NAMESPACE, "bindings");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeSiteBinding(SiteBinding siteBinding, String tagName, XmlSerializer serializer) throws IOException {
        if (siteBinding != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (siteBinding.getPreSite() != null) {
                this.writePhase(siteBinding.getPreSite(), "pre-site", serializer);
            }
            if (siteBinding.getSite() != null) {
                this.writePhase(siteBinding.getSite(), "site", serializer);
            }
            if (siteBinding.getPostSite() != null) {
                this.writePhase(siteBinding.getPostSite(), "post-site", serializer);
            }
            if (siteBinding.getSiteDeploy() != null) {
                this.writePhase(siteBinding.getSiteDeploy(), "site-deploy", serializer);
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }
}

