/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.embedder.execution;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.embedder.Configuration;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.embedder.MavenEmbedderException;
import org.apache.maven.embedder.execution.MavenExecutionRequestPopulator;
import org.apache.maven.errors.DefaultCoreErrorReporter;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.model.Repository;
import org.apache.maven.monitor.event.DefaultEventMonitor;
import org.apache.maven.monitor.event.EventMonitor;
import org.apache.maven.monitor.event.MavenWorkspaceMonitor;
import org.apache.maven.monitor.event.PerCallWorkspaceMonitor;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.profiles.activation.DefaultProfileActivationContext;
import org.apache.maven.profiles.activation.ProfileActivationContext;
import org.apache.maven.realm.DefaultMavenRealmManager;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsConfigurationException;
import org.apache.maven.settings.SettingsUtils;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.apache.maven.workspace.MavenWorkspaceStore;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class DefaultMavenExecutionRequestPopulator
extends AbstractLogEnabled
implements MavenExecutionRequestPopulator,
Contextualizable {
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    private ArtifactRepositoryLayout defaultArtifactRepositoryLayout;
    private PlexusContainer container;
    private WagonManager wagonManager;
    private MavenWorkspaceStore workspaceManager;
    private MavenSettingsBuilder settingsBuilder;

    public MavenExecutionRequest populateDefaults(MavenExecutionRequest request, Configuration configuration) throws MavenEmbedderException {
        this.eventMonitors(request, configuration);
        this.workspaceMonitor(request, configuration);
        this.reporter(request, configuration);
        this.executionProperties(request, configuration);
        this.pom(request, configuration);
        this.settings(request, configuration);
        this.localRepository(request, configuration);
        this.snapshotPolicy(request, configuration);
        this.checksumPolicy(request, configuration);
        this.artifactTransferMechanism(request, configuration);
        this.eventing(request, configuration);
        this.realmManager(request, configuration);
        this.profileManager(request, configuration);
        this.processSettings(request, configuration);
        return request;
    }

    private void workspaceMonitor(MavenExecutionRequest request, Configuration configuration) {
        List requestEventMonitors;
        MavenWorkspaceMonitor workspaceMonitor = request.getWorkspaceMonitor();
        if (workspaceMonitor == null) {
            workspaceMonitor = configuration.getWorkspaceMonitor();
        }
        if ((requestEventMonitors = request.getEventMonitors()) != null && !requestEventMonitors.isEmpty()) {
            Iterator it = requestEventMonitors.iterator();
            while (it.hasNext()) {
                Object monitor = it.next();
                if (!(monitor instanceof MavenWorkspaceMonitor)) continue;
                if (workspaceMonitor == null) {
                    workspaceMonitor = (MavenWorkspaceMonitor)monitor;
                }
                it.remove();
                break;
            }
        }
        if (workspaceMonitor == null) {
            workspaceMonitor = new PerCallWorkspaceMonitor();
        }
        workspaceMonitor.setWorkspaceStore(this.workspaceManager);
        request.addEventMonitor(workspaceMonitor);
    }

    private void eventMonitors(MavenExecutionRequest request, Configuration configuration) {
        List configEventMonitors = configuration.getEventMonitors();
        if (configEventMonitors != null && !configEventMonitors.isEmpty()) {
            Iterator it = configEventMonitors.iterator();
            while (it.hasNext()) {
                EventMonitor monitor = (EventMonitor)it.next();
                request.addEventMonitor(monitor);
            }
        }
    }

    private void reporter(MavenExecutionRequest request, Configuration configuration) {
        if (request.getErrorReporter() == null) {
            if (configuration.getErrorReporter() != null) {
                request.setErrorReporter(configuration.getErrorReporter());
            } else {
                request.setErrorReporter(new DefaultCoreErrorReporter());
            }
        }
    }

    private void executionProperties(MavenExecutionRequest request, Configuration configuration) {
        if (request.getProperties() == null) {
            Properties props = configuration.getSystemProperties();
            if (props == null) {
                props = System.getProperties();
            }
            request.setProperties(props);
        }
    }

    private void realmManager(MavenExecutionRequest request, Configuration configuration) {
        if (request.getRealmManager() == null) {
            if (configuration.getRealmManager() == null) {
                request.setRealmManager(new DefaultMavenRealmManager(this.container, this.getLogger()));
            } else {
                request.setRealmManager(configuration.getRealmManager());
            }
        }
    }

    private void processSettings(MavenExecutionRequest request, Configuration configuration) {
        ProfileManager profileManager = request.getProfileManager();
        Settings settings = request.getSettings();
        List settingsProfiles = settings.getProfiles();
        if (settingsProfiles != null && !settingsProfiles.isEmpty()) {
            List settingsActiveProfileIds = settings.getActiveProfiles();
            profileManager.explicitlyActivate(settingsActiveProfileIds);
            Iterator it = settings.getProfiles().iterator();
            while (it.hasNext()) {
                Profile rawProfile = (Profile)it.next();
                org.apache.maven.model.Profile profile = SettingsUtils.convertFromSettingsProfile(rawProfile);
                profileManager.addProfile(profile);
                Iterator j = profile.getRepositories().iterator();
                while (j.hasNext()) {
                    Repository r = (Repository)j.next();
                    ArtifactRepositoryPolicy releases = new ArtifactRepositoryPolicy();
                    if (r.getReleases() != null) {
                        releases.setChecksumPolicy(r.getReleases().getChecksumPolicy());
                        releases.setUpdatePolicy(r.getReleases().getUpdatePolicy());
                    } else {
                        releases.setChecksumPolicy("daily");
                        releases.setUpdatePolicy("warn");
                    }
                    ArtifactRepositoryPolicy snapshots = new ArtifactRepositoryPolicy();
                    if (r.getSnapshots() != null) {
                        snapshots.setChecksumPolicy(r.getSnapshots().getChecksumPolicy());
                        snapshots.setUpdatePolicy(r.getSnapshots().getUpdatePolicy());
                    } else {
                        snapshots.setChecksumPolicy("daily");
                        snapshots.setUpdatePolicy("warn");
                    }
                    ArtifactRepository ar = this.artifactRepositoryFactory.createArtifactRepository(r.getId(), r.getUrl(), this.defaultArtifactRepositoryLayout, snapshots, releases);
                    request.addRemoteRepository(ar);
                }
            }
        }
    }

    private void pom(MavenExecutionRequest request, Configuration configuration) {
        if (request.getPom() != null && request.getPom().getParentFile() != null) {
            request.setBaseDirectory(request.getPom().getParentFile());
        } else if (request.getPom() == null && request.getBaseDirectory() != null) {
            File pom = new File(request.getBaseDirectory(), "release-pom.xml");
            if (!pom.exists()) {
                pom = new File(request.getBaseDirectory(), "pom.xml");
            }
            request.setPom(pom);
        } else if (request.getBaseDirectory() == null) {
            request.setBaseDirectory(new File(System.getProperty("user.dir")));
        }
    }

    private void settings(MavenExecutionRequest request, Configuration configuration) {
        if (request.getSettings() == null) {
            if (configuration.getGlobalSettingsFile() != null) {
                request.setGlobalSettingsFile(configuration.getGlobalSettingsFile());
            }
            if (configuration.getUserSettingsFile() != null) {
                request.setUserSettingsFile(configuration.getUserSettingsFile());
            }
            try {
                request.setSettings(this.settingsBuilder.buildSettings(request));
            }
            catch (Exception exception) {
                request.setSettings(new Settings());
            }
        }
    }

    private void localRepository(MavenExecutionRequest request, Configuration configuration) throws MavenEmbedderException {
        if (request.getLocalRepository() == null) {
            request.setLocalRepository(this.createLocalRepository(request, request.getSettings(), configuration));
        }
    }

    public ArtifactRepository createLocalRepository(MavenExecutionRequest request, Settings settings, Configuration configuration) throws MavenEmbedderException {
        String localRepositoryPath = null;
        if (request.getLocalRepositoryPath() != null) {
            localRepositoryPath = request.getLocalRepositoryPath().getAbsolutePath();
        }
        if (StringUtils.isEmpty(localRepositoryPath) && configuration.getLocalRepository() != null) {
            localRepositoryPath = configuration.getLocalRepository().getAbsolutePath();
        }
        if (StringUtils.isEmpty(localRepositoryPath)) {
            localRepositoryPath = settings.getLocalRepository();
        }
        if (StringUtils.isEmpty(localRepositoryPath)) {
            localRepositoryPath = MavenEmbedder.defaultUserLocalRepository.getAbsolutePath();
        }
        return this.createLocalRepository(localRepositoryPath, "local");
    }

    public ArtifactRepository createLocalRepository(String url, String repositoryId) throws MavenEmbedderException {
        try {
            return this.createRepository(this.canonicalFileUrl(url), repositoryId);
        }
        catch (IOException e) {
            throw new MavenEmbedderException("Unable to resolve canonical path for local repository " + url, e);
        }
    }

    private String canonicalFileUrl(String url) throws IOException {
        if (!url.startsWith("file:")) {
            url = "file://" + url;
        } else if (url.startsWith("file:") && !url.startsWith("file://")) {
            url = "file://" + url.substring("file:".length());
        }
        File localRepository = new File(url.substring("file://".length()));
        if (!localRepository.isAbsolute()) {
            url = "file://" + localRepository.getCanonicalPath();
        }
        return url;
    }

    public ArtifactRepository createRepository(String url, String repositoryId) {
        String updatePolicyFlag = "always";
        String checksumPolicyFlag = "warn";
        ArtifactRepositoryPolicy snapshotsPolicy = new ArtifactRepositoryPolicy(true, updatePolicyFlag, checksumPolicyFlag);
        ArtifactRepositoryPolicy releasesPolicy = new ArtifactRepositoryPolicy(true, updatePolicyFlag, checksumPolicyFlag);
        return this.artifactRepositoryFactory.createArtifactRepository(repositoryId, url, this.defaultArtifactRepositoryLayout, snapshotsPolicy, releasesPolicy);
    }

    private void snapshotPolicy(MavenExecutionRequest request, Configuration configuration) {
        boolean snapshotPolicySet = false;
        if (request.isOffline()) {
            snapshotPolicySet = true;
        }
        if (!snapshotPolicySet) {
            if (request.isUpdateSnapshots()) {
                this.artifactRepositoryFactory.setGlobalUpdatePolicy("always");
            } else if (request.isNoSnapshotUpdates()) {
                this.getLogger().info("+ Supressing SNAPSHOT updates.");
                this.artifactRepositoryFactory.setGlobalUpdatePolicy("never");
            }
        }
    }

    private void checksumPolicy(MavenExecutionRequest request, Configuration configuration) {
        this.artifactRepositoryFactory.setGlobalChecksumPolicy(request.getGlobalChecksumPolicy());
    }

    private void artifactTransferMechanism(MavenExecutionRequest request, Configuration configuration) throws MavenEmbedderException {
        if (request.isOffline()) {
            this.wagonManager.setOnline(false);
        } else if (request.getSettings() != null && request.getSettings().isOffline()) {
            this.wagonManager.setOnline(false);
        } else {
            this.wagonManager.findAndRegisterWagons(this.container);
            this.wagonManager.setInteractive(request.isInteractiveMode());
            this.wagonManager.setDownloadMonitor(request.getTransferListener());
            this.wagonManager.setOnline(true);
        }
        try {
            this.resolveParameters(request.getSettings());
        }
        catch (Exception e) {
            throw new MavenEmbedderException("Unable to configure Maven for execution", e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resolveParameters(Settings settings) throws ComponentLookupException, ComponentLifecycleException, SettingsConfigurationException {
        WagonManager wagonManager = (WagonManager)this.container.lookup(WagonManager.ROLE);
        try {
            Iterator i;
            Proxy proxy = settings.getActiveProxy();
            if (proxy != null) {
                if (proxy.getHost() == null) {
                    throw new SettingsConfigurationException("Proxy in settings.xml has no host");
                }
                wagonManager.addProxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), proxy.getUsername(), proxy.getPassword(), proxy.getNonProxyHosts());
            }
            Iterator i2 = settings.getServers().iterator();
            while (true) {
                if (!i2.hasNext()) {
                    RepositoryPermissions defaultPermissions = new RepositoryPermissions();
                    defaultPermissions.setDirectoryMode("775");
                    defaultPermissions.setFileMode("664");
                    wagonManager.setDefaultRepositoryPermissions(defaultPermissions);
                    i = settings.getMirrors().iterator();
                    break;
                }
                Server server = (Server)i2.next();
                wagonManager.addAuthenticationInfo(server.getId(), server.getUsername(), server.getPassword(), server.getPrivateKey(), server.getPassphrase());
                wagonManager.addPermissionInfo(server.getId(), server.getFilePermissions(), server.getDirectoryPermissions());
                if (server.getConfiguration() == null) continue;
                wagonManager.addConfiguration(server.getId(), (Xpp3Dom)server.getConfiguration());
            }
            while (i.hasNext()) {
                Mirror mirror = (Mirror)i.next();
                wagonManager.addMirror(mirror.getId(), mirror.getMirrorOf(), mirror.getUrl());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.container.release(wagonManager);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        this.container.release(wagonManager);
    }

    private void eventing(MavenExecutionRequest request, Configuration configuration) {
        Logger logger = this.container.getLoggerManager().getLoggerForComponent(Mojo.ROLE);
        if (request.getEventMonitors() == null) {
            request.addEventMonitor(new DefaultEventMonitor(logger));
        }
        this.container.getLoggerManager().setThreshold(request.getLoggingLevel());
    }

    private void profileManager(MavenExecutionRequest request, Configuration configuration) {
        ProfileActivationContext activationContext = request.getProfileActivationContext();
        if (activationContext == null) {
            activationContext = new DefaultProfileActivationContext(request.getRealmManager(), request.getProperties(), false);
        }
        activationContext.setExplicitlyActiveProfileIds(request.getActiveProfiles());
        activationContext.setExplicitlyInactiveProfileIds(request.getInactiveProfiles());
        DefaultProfileManager globalProfileManager = new DefaultProfileManager(this.container, activationContext);
        request.setProfileManager(globalProfileManager);
        request.setProfileActivationContext(activationContext);
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get("plexus");
    }
}

