/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.cli.CommandLine;
import org.apache.maven.cli.AbstractConsoleDownloadMonitor;
import org.apache.maven.cli.BatchModeDownloadMonitor;
import org.apache.maven.cli.ConsoleDownloadMonitor;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.codehaus.plexus.util.cli.CommandLineUtils;

public final class CLIRequestUtils {
    private CLIRequestUtils() {
    }

    public static MavenExecutionRequest buildRequest(CommandLine commandLine, boolean debug, boolean quiet, boolean showErrors) {
        boolean interactive = true;
        if (commandLine.hasOption('B')) {
            interactive = false;
        }
        boolean pluginUpdateOverride = false;
        if (commandLine.hasOption("cpu") || commandLine.hasOption("up")) {
            pluginUpdateOverride = true;
        } else if (commandLine.hasOption("npu")) {
            pluginUpdateOverride = false;
        }
        boolean noSnapshotUpdates = false;
        if (commandLine.hasOption("nsu")) {
            noSnapshotUpdates = true;
        }
        List goals = commandLine.getArgList();
        boolean recursive = true;
        String reactorFailureBehaviour = "fail-fast";
        if (commandLine.hasOption('N')) {
            recursive = false;
        }
        if (commandLine.hasOption("ff")) {
            reactorFailureBehaviour = "fail-fast";
        } else if (commandLine.hasOption("fae")) {
            reactorFailureBehaviour = "fail-at-end";
        } else if (commandLine.hasOption("fn")) {
            reactorFailureBehaviour = "fail-never";
        }
        boolean offline = false;
        if (commandLine.hasOption('o')) {
            offline = true;
        }
        boolean updateSnapshots = false;
        if (commandLine.hasOption('U')) {
            updateSnapshots = true;
        }
        String globalChecksumPolicy = null;
        if (commandLine.hasOption('C')) {
            System.out.println("+ Enabling strict checksum verification on all artifact downloads.");
            globalChecksumPolicy = "fail";
        } else if (commandLine.hasOption('c')) {
            System.out.println("+ Disabling strict checksum verification on all artifact downloads.");
            globalChecksumPolicy = "warn";
        }
        File baseDirectory = new File(System.getProperty("user.dir"));
        ArrayList<String> activeProfiles = new ArrayList<String>();
        ArrayList<String> inactiveProfiles = new ArrayList<String>();
        if (commandLine.hasOption('P')) {
            String profilesLine = commandLine.getOptionValue('P');
            StringTokenizer profileTokens = new StringTokenizer(profilesLine, ",");
            while (profileTokens.hasMoreTokens()) {
                String profileAction = profileTokens.nextToken().trim();
                if (profileAction.startsWith("-")) {
                    activeProfiles.add(profileAction.substring(1));
                    continue;
                }
                if (profileAction.startsWith("+")) {
                    inactiveProfiles.add(profileAction.substring(1));
                    continue;
                }
                activeProfiles.add(profileAction);
            }
        }
        AbstractConsoleDownloadMonitor transferListener = interactive ? new ConsoleDownloadMonitor() : new BatchModeDownloadMonitor();
        transferListener.setShowChecksumEvents(false);
        boolean useReactor = false;
        if (commandLine.hasOption('r')) {
            useReactor = true;
        }
        String alternatePomFile = null;
        if (commandLine.hasOption('f')) {
            alternatePomFile = commandLine.getOptionValue('f');
        }
        int loggingLevel = debug ? 0 : (quiet ? 3 : 1);
        Properties executionProperties = CLIRequestUtils.getExecutionProperties(commandLine);
        MavenExecutionRequest request = new DefaultMavenExecutionRequest().setBaseDirectory(baseDirectory).setGoals(goals).setProperties(executionProperties).setReactorFailureBehavior(reactorFailureBehaviour).setRecursive(recursive).setUseReactor(useReactor).setShowErrors(showErrors).setInteractiveMode(interactive).setOffline(offline).setUsePluginUpdateOverride(pluginUpdateOverride).addActiveProfiles(activeProfiles).addInactiveProfiles(inactiveProfiles).setLoggingLevel(loggingLevel).setTransferListener(transferListener).setUpdateSnapshots(updateSnapshots).setNoSnapshotUpdates(noSnapshotUpdates).setGlobalChecksumPolicy(globalChecksumPolicy);
        if (alternatePomFile != null) {
            request.setPom(new File(alternatePomFile));
            System.out.println("Request pom set to: " + request.getPom());
        }
        return request;
    }

    static Properties getExecutionProperties(CommandLine commandLine) {
        String[] defStrs;
        Properties executionProperties = new Properties();
        try {
            Properties envVars = CommandLineUtils.getSystemEnvVars();
            Iterator<Map.Entry<Object, Object>> i = envVars.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Object, Object> e = i.next();
                executionProperties.setProperty("env." + e.getKey().toString(), e.getValue().toString());
            }
        }
        catch (IOException e) {
            System.err.println("Error getting environment vars for profile activation: " + e);
        }
        if (commandLine.hasOption('D') && (defStrs = commandLine.getOptionValues('D')) != null) {
            int i = 0;
            while (i < defStrs.length) {
                CLIRequestUtils.setCliProperty(defStrs[i], executionProperties);
                ++i;
            }
        }
        executionProperties.putAll((Map<?, ?>)System.getProperties());
        return executionProperties;
    }

    private static void setCliProperty(String property, Properties executionProperties) {
        String value;
        String name;
        int i = property.indexOf("=");
        if (i <= 0) {
            name = property.trim();
            value = "true";
        } else {
            name = property.substring(0, i).trim();
            value = property.substring(i + 1).trim();
        }
        executionProperties.setProperty(name, value);
        System.setProperty(name, value);
    }
}

