/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.conflict.GraphConflictResolver;
import org.apache.maven.artifact.resolver.metadata.ArtifactMetadata;
import org.apache.maven.artifact.resolver.metadata.MetadataResolution;
import org.apache.maven.artifact.resolver.metadata.MetadataResolutionException;
import org.apache.maven.artifact.resolver.metadata.MetadataResolutionRequest;
import org.apache.maven.artifact.resolver.metadata.MetadataResolutionResult;
import org.apache.maven.artifact.resolver.metadata.MetadataResolver;
import org.apache.maven.artifact.resolver.metadata.MetadataSource;
import org.apache.maven.artifact.resolver.metadata.MetadataTreeNode;
import org.apache.maven.artifact.transform.ClasspathTransformation;
import org.codehaus.plexus.logging.AbstractLogEnabled;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMetadataResolver
extends AbstractLogEnabled
implements MetadataResolver {
    ArtifactResolver artifactResolver;
    ArtifactFactory artifactFactory;
    MetadataSource metadataSource;
    GraphConflictResolver conflictResolver;
    ClasspathTransformation classpathTransformation;

    @Override
    public MetadataResolutionResult resolveMetadata(MetadataResolutionRequest req) throws MetadataResolutionException {
        try {
            this.getLogger().debug(new StringBuffer().append("Received request for: ").append(req.getQuery()).toString());
            MetadataResolutionResult res = new MetadataResolutionResult();
            MetadataTreeNode tree = this.resolveMetadataTree(req.getQuery(), null, req.getLocalRepository(), req.getRemoteRepositories());
            res.setTree(tree);
            return res;
        }
        catch (MetadataResolutionException mrEx) {
            throw mrEx;
        }
        catch (Exception anyEx) {
            throw new MetadataResolutionException(anyEx);
        }
    }

    private MetadataTreeNode resolveMetadataTree(ArtifactMetadata query, MetadataTreeNode parent, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws MetadataResolutionException {
        try {
            Artifact pomArtifact = this.artifactFactory.createArtifact(query.getGroupId(), query.getArtifactId(), query.getVersion(), query.getScope(), query.getType() == null ? "jar" : query.getType());
            this.getLogger().debug(new StringBuffer().append("resolveMetadata request:\n> artifact   : ").append(pomArtifact.toString()).append("\n> remoteRepos: ").append(remoteRepositories).append("\n> localRepo  : ").append(localRepository).toString());
            String error = null;
            try {
                ArtifactResolutionRequest arr = new ArtifactResolutionRequest();
                arr.setArtifact(pomArtifact);
                arr.setLocalRepository(localRepository);
                arr.setRemoteRepostories(remoteRepositories);
                this.artifactResolver.resolve(pomArtifact, remoteRepositories, localRepository);
                if (!pomArtifact.isResolved()) {
                    this.getLogger().info(new StringBuffer().append("*************> Did not resolve ").append(pomArtifact.toString()).append("\nURL: ").append(pomArtifact.getDownloadUrl()).append("\nRepos: ").append(remoteRepositories).append("\nLocal: ").append(localRepository).toString());
                }
            }
            catch (ArtifactResolutionException are) {
                pomArtifact.setResolved(false);
                error = are.getMessage();
            }
            catch (ArtifactNotFoundException anfe) {
                pomArtifact.setResolved(false);
                error = anfe.getMessage();
            }
            if (error != null) {
                this.getLogger().info(new StringBuffer().append("*************> Did not resolve ").append(pomArtifact.toString()).append("\nRepos: ").append(remoteRepositories).append("\nLocal: ").append(localRepository).append("\nerror: ").append(error).toString());
            }
            if (pomArtifact.isResolved()) {
                MetadataResolution metadataResolution = this.metadataSource.retrieve(query, localRepository, remoteRepositories);
                ArtifactMetadata found = metadataResolution.getArtifactMetadata();
                if (pomArtifact.getFile() != null && pomArtifact.getFile().toURI() != null) {
                    found.setArtifactUri(pomArtifact.getFile().toURI().toString());
                }
                MetadataTreeNode node = new MetadataTreeNode(found, parent, true, found.getScopeAsEnum());
                Collection<ArtifactMetadata> dependencies = metadataResolution.getArtifactMetadata().getDependencies();
                if (dependencies != null && dependencies.size() > 0) {
                    int nKids = dependencies.size();
                    node.setNChildren(nKids);
                    int kidNo = 0;
                    for (ArtifactMetadata a : dependencies) {
                        MetadataTreeNode kidNode = this.resolveMetadataTree(a, node, localRepository, remoteRepositories);
                        node.addChild(kidNo++, kidNode);
                    }
                }
                return node;
            }
            return new MetadataTreeNode(pomArtifact, parent, false, query.getArtifactScope());
        }
        catch (Exception anyEx) {
            throw new MetadataResolutionException(anyEx);
        }
    }

    @Override
    public List<Artifact> resolveArtifact(List<ArtifactMetadata> mdCollection, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws ArtifactResolutionException {
        if (mdCollection == null || mdCollection.isEmpty()) {
            return null;
        }
        ArrayList<Artifact> res = new ArrayList<Artifact>(mdCollection.size());
        Artifact artifact = null;
        try {
            for (ArtifactMetadata md : mdCollection) {
                artifact = this.artifactFactory.createArtifact(md.getGroupId(), md.getArtifactId(), md.getVersion(), md.getScope(), md.getType() == null ? "jar" : md.getType());
                this.artifactResolver.resolve(artifact, remoteRepositories, localRepository);
                res.add(artifact);
            }
            return res;
        }
        catch (ArtifactNotFoundException e) {
            e.printStackTrace();
            throw new ArtifactResolutionException(e.getMessage(), artifact, remoteRepositories);
        }
    }
}

