/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.CyclicDependencyException;
import org.apache.maven.artifact.resolver.ResolutionNode;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;

public class ArtifactResolutionResult {
    private Artifact originatingArtifact;
    private List versionRangeViolations;
    private List metadataResolutionExceptions;
    private List missingArtifacts;
    private List circularDependencyExceptions;
    private List errorArtifactExceptions;
    private List repositories;
    private Set resolutionNodes;
    private Set artifacts;

    public Artifact getOriginatingArtifact() {
        return this.originatingArtifact;
    }

    public ArtifactResolutionResult ListOriginatingArtifact(Artifact originatingArtifact) {
        this.originatingArtifact = originatingArtifact;
        return this;
    }

    public Set getArtifacts() {
        if (this.artifacts == null) {
            this.artifacts = new LinkedHashSet();
            Iterator i = this.resolutionNodes.iterator();
            while (i.hasNext()) {
                ResolutionNode node = (ResolutionNode)i.next();
                this.artifacts.add(node.getArtifact());
            }
        }
        return this.artifacts;
    }

    public Set getArtifactResolutionNodes() {
        return this.resolutionNodes == null ? Collections.EMPTY_SET : this.resolutionNodes;
    }

    public ArtifactResolutionResult setArtifactResolutionNodes(Set resolutionNodes) {
        this.resolutionNodes = resolutionNodes;
        this.artifacts = null;
        return this;
    }

    public List getMissingArtifacts() {
        return this.missingArtifacts == null ? Collections.EMPTY_LIST : this.missingArtifacts;
    }

    public ArtifactResolutionResult addMissingArtifact(Artifact artifact) {
        this.missingArtifacts = this.initList(this.missingArtifacts);
        this.missingArtifacts.add(artifact);
        return this;
    }

    public ArtifactResolutionResult setUnresolvedArtifacts(List unresolvedArtifacts) {
        this.missingArtifacts = unresolvedArtifacts;
        return this;
    }

    public boolean hasVersionRangeViolations() {
        return this.versionRangeViolations != null;
    }

    public ArtifactResolutionResult addVersionRangeViolation(Exception e) {
        this.versionRangeViolations = this.initList(this.versionRangeViolations);
        this.versionRangeViolations.add(e);
        return this;
    }

    public OverConstrainedVersionException getVersionRangeViolation(int i) {
        return (OverConstrainedVersionException)this.versionRangeViolations.get(i);
    }

    public List getVersionRangeViolations() {
        return this.versionRangeViolations == null ? Collections.EMPTY_LIST : this.versionRangeViolations;
    }

    public boolean hasMetadataResolutionExceptions() {
        return this.metadataResolutionExceptions != null;
    }

    public ArtifactResolutionResult addMetadataResolutionException(ArtifactResolutionException e) {
        this.metadataResolutionExceptions = this.initList(this.metadataResolutionExceptions);
        this.metadataResolutionExceptions.add(e);
        return this;
    }

    public ArtifactResolutionException getMetadataResolutionException(int i) {
        return (ArtifactResolutionException)this.metadataResolutionExceptions.get(i);
    }

    public List getMetadataResolutionExceptions() {
        return this.metadataResolutionExceptions == null ? Collections.EMPTY_LIST : this.metadataResolutionExceptions;
    }

    public boolean hasErrorArtifactExceptions() {
        return this.errorArtifactExceptions != null;
    }

    public ArtifactResolutionResult addErrorArtifactException(ArtifactResolutionException e) {
        this.errorArtifactExceptions = this.initList(this.errorArtifactExceptions);
        this.errorArtifactExceptions.add(e);
        return this;
    }

    public List getErrorArtifactExceptions() {
        return this.errorArtifactExceptions == null ? Collections.EMPTY_LIST : this.errorArtifactExceptions;
    }

    public boolean hasCircularDependencyExceptions() {
        return this.circularDependencyExceptions != null;
    }

    public ArtifactResolutionResult addCircularDependencyException(CyclicDependencyException e) {
        this.circularDependencyExceptions = this.initList(this.circularDependencyExceptions);
        this.circularDependencyExceptions.add(e);
        return this;
    }

    public CyclicDependencyException getCircularDependencyException(int i) {
        return (CyclicDependencyException)this.circularDependencyExceptions.get(i);
    }

    public List getCircularDependencyExceptions() {
        return this.circularDependencyExceptions == null ? Collections.EMPTY_LIST : this.circularDependencyExceptions;
    }

    public List getRepositories() {
        return this.repositories == null ? Collections.EMPTY_LIST : this.repositories;
    }

    public ArtifactResolutionResult setRepositories(List repositories) {
        this.repositories = repositories;
        return this;
    }

    private List initList(List l) {
        if (l == null) {
            return new ArrayList();
        }
        return l;
    }
}

