/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime.impl;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

public class WeakIdentityTable {
    private final ConcurrentMap map = new ConcurrentHashMap();
    private final ReferenceQueue queue = new ReferenceQueue();

    public Object lookup(Object key) {
        return this.map.get(new StrongKey(key));
    }

    public Object obtain(Object key) {
        Object currentValue = this.map.get(new StrongKey(key));
        if (currentValue != null) {
            return currentValue;
        }
        this.cleanup();
        Object newValue = this.initialValue();
        Object previousValue = this.map.putIfAbsent(new WeakKey(key, this.queue), newValue);
        return previousValue != null ? previousValue : newValue;
    }

    public void putIfAbsent(Object key, Object value) {
        this.cleanup();
        this.map.putIfAbsent(new WeakKey(key, this.queue), value);
    }

    public int size() {
        this.cleanup();
        return this.map.size();
    }

    protected Object initialValue() {
        return null;
    }

    private void cleanup() {
        Reference reference;
        while ((reference = this.queue.poll()) != null) {
            this.map.remove(reference);
        }
    }

    private static class WeakKey
    extends WeakReference
    implements IdentityKey {
        private int hashCode;

        public WeakKey(Object referent, ReferenceQueue queue) {
            super(referent, queue);
            if (referent == null) {
                throw new NullPointerException();
            }
            this.hashCode = System.identityHashCode(referent);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof IdentityKey && ((IdentityKey)obj).get() == this.get();
        }
    }

    private static class StrongKey
    implements IdentityKey {
        private Object referent;

        public StrongKey(Object referent) {
            if (referent == null) {
                throw new NullPointerException();
            }
            this.referent = referent;
        }

        public Object get() {
            return this.referent;
        }

        public int hashCode() {
            return System.identityHashCode(this.referent);
        }

        public boolean equals(Object obj) {
            return obj instanceof IdentityKey && ((IdentityKey)obj).get() == this.referent;
        }
    }

    private static interface IdentityKey {
        public Object get();
    }
}

