/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.state.observers;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.namespace.QName;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.vremanagement.resourcemanager.impl.contexts.ServiceContext;
import org.gcube.vremanagement.resourcemanager.impl.deployment.VirtualNode;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedAnyResource;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedDeployedService;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedGHN;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResource;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedRunningInstance;
import org.gcube.vremanagement.resourcemanager.impl.resources.types.MultiKeysMap;
import org.gcube.vremanagement.resourcemanager.impl.state.RawScopeState;
import org.gcube.vremanagement.resourcemanager.impl.state.ScopeState;
import org.gcube.vremanagement.resourcemanager.impl.state.observers.ScopeObserver;

public class Serializer
extends ScopeObserver {
    public static final File persistentList = ServiceContext.getContext().getPersistentFile("ScopedResourceList.xml", new boolean[]{true});
    private static final String namespace = "http://gcube-system.org/namespaces/resourcemanager/manager/xsd/state";

    @Override
    protected synchronized void scopeChanged(ScopeState scopeState) {
        try {
            Serializer.store(scopeState);
        }
        catch (IOException e) {
            this.logger.fatal((Object)"Cannot serialize the resource's list", (Throwable)e);
        }
    }

    public static synchronized void store(ScopeState scopeState) throws IOException {
        QNameMap qmap = new QNameMap();
        qmap.registerMapping(new QName(namespace, ""), RawScopeState.class);
        StaxDriver driver = new StaxDriver(qmap);
        driver.setRepairingNamespace(false);
        XStream stream = new XStream((HierarchicalStreamDriver)driver);
        Serializer.prepareStream(stream);
        FileOutputStream fs = new FileOutputStream(persistentList);
        stream.toXML((Object)scopeState.getRawScopeState(), (OutputStream)fs);
        fs.close();
    }

    public static synchronized void load(ScopeState scopeState, GCUBEScope scope) throws IOException {
        if (!persistentList.exists()) {
            throw new IOException();
        }
        QNameMap qmap = new QNameMap();
        qmap.registerMapping(new QName(namespace, ""), RawScopeState.class);
        StaxDriver driver = new StaxDriver(qmap);
        driver.setRepairingNamespace(false);
        XStream stream = new XStream((HierarchicalStreamDriver)driver);
        Serializer.prepareStream(stream);
        RawScopeState state = (RawScopeState)stream.fromXML((InputStream)new FileInputStream(persistentList));
        if (state == null || state.getScope() == null || state.getScope().getName().compareTo(scope.getName()) != 0) {
            throw new IOException();
        }
        scopeState.setRawScopeState(state);
    }

    private static void prepareStream(XStream stream) {
        stream.processAnnotations(RawScopeState.class);
        stream.alias(RawScopeState.class.getSimpleName(), RawScopeState.class);
        stream.processAnnotations(ScopedResource.class);
        stream.alias(ScopedResource.class.getSimpleName(), ScopedResource.class);
        stream.alias(ScopedGHN.class.getSimpleName(), ScopedGHN.class);
        stream.processAnnotations(ScopedGHN.class);
        stream.alias(ScopedRunningInstance.class.getSimpleName(), ScopedRunningInstance.class);
        stream.processAnnotations(ScopedRunningInstance.class);
        stream.alias(ScopedDeployedService.class.getSimpleName(), ScopedDeployedService.class);
        stream.processAnnotations(ScopedDeployedService.class);
        stream.alias(ScopedAnyResource.class.getSimpleName(), ScopedAnyResource.class);
        stream.processAnnotations(ScopedAnyResource.class);
        stream.alias("ResourceList", MultiKeysMap.class);
        stream.alias("ResourceData", Map.class);
        stream.alias("Scope", GCUBEScope.class);
        stream.alias("ScopeType", GCUBEScope.Type.class);
        stream.alias("VirtualNode", VirtualNode.class);
    }
}

