/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.state.observers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.gcube.vremanagement.resourcemanager.impl.deployment.VirtualNode;
import org.gcube.vremanagement.resourcemanager.impl.deployment.VirtualNodeManager;
import org.gcube.vremanagement.resourcemanager.impl.operators.Operator;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedDeployedService;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResource;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResourceFactory;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedRunningInstance;
import org.gcube.vremanagement.resourcemanager.impl.state.ScopeState;
import org.gcube.vremanagement.resourcemanager.impl.state.observers.ScopeObserver;

public class Executor
extends ScopeObserver {
    @Override
    protected void scopeChanged(ScopeState scopeState) {
        if (scopeState.getLastOperationPerformed() == ScopeState.OPERATION.EXECUTED) {
            return;
        }
        boolean managed = false;
        HashMap toRemoveFromNode = new HashMap();
        HashSet<ScopedResource> toRemoveFromScope = new HashSet<ScopedResource>();
        HashSet<ScopedResource> toRemoveFromState = new HashSet<ScopedResource>();
        for (ScopedResource resource : scopeState.getResourcesByType("RunningInstance")) {
            switch (resource.getStatus()) {
                case ADDREQUESTED: {
                    this.addResourceToScope(resource);
                    managed = true;
                    break;
                }
                case REMOVEREQUESTED: {
                    try {
                        if (((ScopedRunningInstance)resource).isUndeployNeeded()) {
                            String hostedOnID = ((ScopedRunningInstance)resource).getHostedOnID();
                            try {
                                ScopedDeployedService service;
                                if (!toRemoveFromNode.containsKey(hostedOnID)) {
                                    toRemoveFromNode.put(hostedOnID, new ArrayList());
                                }
                                if ((service = ScopedResourceFactory.getRelatedService((ScopedRunningInstance)resource)).getNodes().size() > 1) {
                                    this.logger.debug((Object)("Removing " + service + " from node " + resource.getHostedOn()));
                                    service.scheduleUndeploy(VirtualNodeManager.getNode(hostedOnID, resource.getScope()));
                                    service.setCallbackID(scopeState.getLastReport().getId());
                                    scopeState.getLastReport().addResource(service);
                                    scopeState.getLastReport().addService(service);
                                    ((List)toRemoveFromNode.get(hostedOnID)).add(service);
                                } else if (service.getNodes().size() == 1) {
                                    this.logger.debug((Object)("Removing " + service + " from the scope"));
                                    scopeState.getLastReport().addResource(service);
                                    scopeState.getLastReport().addService(service);
                                    toRemoveFromScope.add(service);
                                }
                                if (service.getNodes().size() < 0) {
                                    ((ScopedRunningInstance)resource).reportFailureOnSourceService("Can't find any node where the instance is deployed", new Exception("Can't find any node where the instance is deployed"));
                                    resource.setStatus(ScopedResource.STATUS.LOST);
                                    toRemoveFromState.add(resource);
                                }
                                ((ScopedRunningInstance)resource).wasSuccessful();
                                resource.setStatus(ScopedResource.STATUS.REMOVED);
                            }
                            catch (ScopedResourceFactory.ServiceNotFoundException e) {
                                ((ScopedRunningInstance)resource).reportFailureOnSourceService("Unable to find the source service. It might not be deployed by this Resource Manager instance", e);
                                resource.setStatus(ScopedResource.STATUS.LOST);
                                toRemoveFromState.add(resource);
                            }
                            catch (VirtualNode.NoGHNFoundException e) {
                                ((ScopedRunningInstance)resource).reportFailureOnSourceService("Unable to find the hosting gHN, ID=" + hostedOnID, e);
                                resource.setStatus(ScopedResource.STATUS.LOST);
                                toRemoveFromState.add(resource);
                            }
                        } else {
                            this.removeResourceFromScope(resource);
                            toRemoveFromState.add(resource);
                        }
                    }
                    catch (ScopedResource.ResourceNotFound e) {
                        resource.setStatus(ScopedResource.STATUS.LOST);
                    }
                    managed = true;
                }
            }
        }
        for (ScopedResource resource : scopeState.getAllResources()) {
            switch (resource.getStatus()) {
                case ADDREQUESTED: {
                    this.addResourceToScope(resource);
                    managed = true;
                    break;
                }
                case REMOVEREQUESTED: {
                    this.removeResourceFromScope(resource);
                    toRemoveFromState.add(resource);
                    managed = true;
                }
            }
        }
        if (managed) {
            scopeState.setLastOperationPerformed(ScopeState.OPERATION.EXECUTED);
            scopeState.notifyObservers();
        }
        for (String ghnid : toRemoveFromNode.keySet()) {
            for (ScopedDeployedService service : (List)toRemoveFromNode.get(ghnid)) {
                try {
                    service.removeFromScope(ghnid);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Unable to undeploy " + service + " from " + ghnid), (Throwable)e);
                }
            }
        }
        if (toRemoveFromScope.size() > 0) {
            scopeState.removeResources(toRemoveFromScope);
        } else if (toRemoveFromNode.keySet().size() > 0) {
            scopeState.notifyObservers();
        }
        scopeState.forceResourceRemoval(toRemoveFromState);
    }

    private void addResourceToScope(ScopedResource resource) {
        try {
            resource.doAction(Operator.ACTION.ADD);
            resource.setStatus(ScopedResource.STATUS.ADDED);
        }
        catch (ScopedResource.ResourceNotFound e) {
            resource.setStatus(ScopedResource.STATUS.REMOVED);
        }
        catch (Exception e) {
            resource.setStatus(ScopedResource.STATUS.LOST);
        }
    }

    private void removeResourceFromScope(ScopedResource resource) {
        try {
            resource.doAction(Operator.ACTION.REMOVE);
            resource.setStatus(ScopedResource.STATUS.REMOVED);
        }
        catch (ScopedResource.ResourceNotFound e) {
            resource.setStatus(ScopedResource.STATUS.REMOVED);
        }
        catch (Exception e) {
            resource.setStatus(ScopedResource.STATUS.LOST);
        }
    }
}

