/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.state;

import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Observable;
import java.util.Set;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedDeployedService;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResource;
import org.gcube.vremanagement.resourcemanager.impl.state.ProfileDate;
import org.gcube.vremanagement.resourcemanager.impl.state.RawScopeState;
import org.gcube.vremanagement.resourcemanager.impl.state.Session;

public class ScopeState
extends Observable {
    protected GCUBELog logger = new GCUBELog((Object)this);
    protected OPERATION lastOperationPerformed;
    private RawScopeState rawState;
    private Session report;

    protected ScopeState() {
    }

    protected void initialize(GCUBEScope scope, String name, boolean securityEnabled, String ... description) {
        this.rawState = new RawScopeState();
        this.rawState.initialize(scope);
        this.rawState.data.put("NAME", name);
        this.lastOperationPerformed = OPERATION.CREATED;
        if (!this.rawState.data.containsKey("STARTTIME")) {
            this.rawState.data.put("STARTTIME", Calendar.getInstance().getTime());
        }
        this.rawState.data.put("ENDTIME", null);
        if (!this.rawState.data.containsKey("DESCRIPTION") && description.length > 0) {
            this.rawState.data.put("DESCRIPTION", description[0]);
        }
        this.rawState.data.put("SECURITYENABLED", securityEnabled);
    }

    public synchronized void setManager(String manager) {
        this.rawState.data.put("MANAGER", manager);
        this.notifyObservers();
    }

    public synchronized void setDesigner(String designer) {
        this.rawState.data.put("DESIGNER", designer);
        this.notifyObservers();
    }

    public synchronized void changeDescription(String description) {
        this.rawState.data.put("DESCRIPTION", description);
        this.notifyObservers();
    }

    public synchronized void addResources(Set<ScopedResource> newresources) {
        for (ScopedResource resource : newresources) {
            resource.setStatus(ScopedResource.STATUS.ADDREQUESTED);
            if (this.rawState.resources.primaryKeySet().contains(resource.getId())) {
                this.rawState.resources.removeValuesByPrimaryKey(resource.getId());
            }
            this.rawState.resources.put(resource.getId(), resource.getType(), resource);
        }
        this.setLastOperationPerformed(OPERATION.TOBEMANAGED);
        this.notifyObservers();
    }

    public synchronized Set<ScopedResource> getResourcesByType(String type) {
        return this.rawState.resources.getValuesBySecondaryKey(type);
    }

    public synchronized ScopedResource getResource(String id) {
        return this.rawState.resources.getValuesByPrimaryKey(id).iterator().next();
    }

    public boolean containsResource(String id) {
        return this.rawState.resources.primaryKeySet().contains(id);
    }

    public synchronized void removeAllResourcesByType(String type) {
        for (ScopedResource resource : this.rawState.resources.getValuesBySecondaryKey(type)) {
            resource.setStatus(ScopedResource.STATUS.REMOVEREQUESTED);
            this.rawState.resources.put(resource.getId(), resource.getType(), resource);
        }
        this.setLastOperationPerformed(OPERATION.TOBEMANAGED);
        this.notifyObservers();
        this.rawState.resources.removeValuesBySecondaryKey(type);
    }

    public synchronized void removeResources(Set<ScopedResource> oldresources) {
        for (ScopedResource resource : oldresources) {
            resource.setStatus(ScopedResource.STATUS.REMOVEREQUESTED);
            this.rawState.resources.put(resource.getId(), resource.getType(), resource);
            if (resource.getType().compareToIgnoreCase("Service") != 0) continue;
            ((ScopedDeployedService)resource).setCallbackID(this.getLastReport().getId());
            ((ScopedDeployedService)resource).scheduleUndeploy();
        }
        this.setLastOperationPerformed(OPERATION.TOBEMANAGED);
        this.notifyObservers();
        for (ScopedResource resource : oldresources) {
            this.logger.debug((Object)("Removing resource " + resource + " from the scope state"));
            if (resource.getStatus() == ScopedResource.STATUS.UNPUBLISHED) {
                this.rawState.resources.removeValuesByPrimaryKey(resource.getId());
                this.logger.debug((Object)"...removed");
                continue;
            }
            this.logger.warn((Object)("Resource " + resource + " is still PUBLISHED in the scope state, can't be removed"));
        }
        this.notifyObservers();
    }

    public synchronized void forceResourceRemoval(Set<ScopedResource> resources) {
        for (ScopedResource resource : resources) {
            this.logger.debug((Object)("Removing resource " + resources + " from the scope state"));
            this.rawState.resources.removeValuesByPrimaryKey(resource.getId());
        }
    }

    protected synchronized void removeAllResources() {
        for (ScopedResource resource : this.rawState.resources.values()) {
            resource.setStatus(ScopedResource.STATUS.REMOVEREQUESTED);
        }
        this.setLastOperationPerformed(OPERATION.TOBEMANAGED);
        this.notifyObservers();
        this.rawState.resources.clean();
    }

    public GCUBEScope getScope() {
        return this.rawState.getScope();
    }

    @Override
    public synchronized void notifyObservers(Object whatschanged) {
        this.setChanged();
        super.notifyObservers(whatschanged);
    }

    @Override
    public synchronized void notifyObservers() {
        this.setChanged();
        super.notifyObservers();
    }

    public synchronized Collection<ScopedResource> getAllResources() {
        return Collections.unmodifiableCollection(this.rawState.resources.values());
    }

    public String getManager() {
        return (String)this.rawState.data.get("MANAGER");
    }

    public String getDesigner() {
        return (String)this.rawState.data.get("DESIGNER");
    }

    public String getDescription() {
        return (String)this.rawState.data.get("DESCRIPTION");
    }

    public String getName() {
        return (String)this.rawState.data.get("NAME");
    }

    public Date getEndTime() {
        return (Date)this.rawState.data.get("ENDTIME");
    }

    public Date getStartTime() {
        return (Date)this.rawState.data.get("STARTTIME");
    }

    public boolean isSecurityEnabled() {
        return (Boolean)this.rawState.data.get("SECURITYENABLED");
    }

    public void setEndTime(Date endTime) {
        this.rawState.data.put("ENDTIME", endTime);
        this.notifyObservers();
    }

    public void setStartTime(Date startTime) {
        this.logger.trace((Object)("setStartTime: Start time " + ProfileDate.toXMLDateAndTime(startTime)));
        this.rawState.data.put("STARTTIME", startTime);
        this.notifyObservers();
    }

    public void setName(String name) {
        this.rawState.data.put("NAME", name);
        this.notifyObservers();
    }

    public OPERATION getLastOperationPerformed() {
        return this.lastOperationPerformed;
    }

    public synchronized void setLastOperationPerformed(OPERATION operation) {
        this.lastOperationPerformed = operation;
    }

    public RawScopeState getRawScopeState() {
        return this.rawState;
    }

    public void setRawScopeState(RawScopeState state) {
        this.rawState = state;
    }

    public void setSecurity(boolean securityEnabled) {
        this.rawState.data.put("SECURITYENABLED", securityEnabled);
    }

    public Session getLastReport() {
        return this.report;
    }

    public void setLastSession(Session report) {
        this.report = report;
    }

    public static enum OPERATION {
        CREATED,
        LOADED,
        TOBEMANAGED,
        PUBLISHED,
        SERIALIZED,
        EXECUTED;

    }
}

