/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.state;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.vremanagement.resourcemanager.impl.contexts.ServiceContext;
import org.gcube.vremanagement.resourcemanager.impl.deployment.VirtualNodeManager;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResource;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResourceFactory;
import org.gcube.vremanagement.resourcemanager.impl.state.PublishedScopeResource;
import org.gcube.vremanagement.resourcemanager.impl.state.ScopeState;
import org.gcube.vremanagement.resourcemanager.impl.state.Session;
import org.gcube.vremanagement.resourcemanager.impl.state.observers.Executor;
import org.gcube.vremanagement.resourcemanager.impl.state.observers.Publisher;
import org.gcube.vremanagement.resourcemanager.impl.state.observers.Serializer;
import org.globus.wsrf.NoSuchResourceException;

public final class InstanceState
extends GCUBEWSResource {
    protected final GCUBEScope scope = (GCUBEScope)ServiceContext.getContext().getInstance().getScopes().values().iterator().next();
    protected ScopeState scopeState;
    static Map<String, Session> id2session = Collections.synchronizedMap(new HashMap());

    protected void initialise(Object ... params) throws Exception {
        this.scopeState = new ScopeState();
        try {
            this.logger.info((Object)"Initializing the instance state from the local file system...");
            Serializer.load(this.scopeState, this.scope);
            this.getPublishedScopeResource().loadFromLocalState(this.scopeState);
        }
        catch (IOException io) {
            this.logger.warn((Object)"The local serialized scope state is not available");
            this.logger.info((Object)"Loading the instance state from the IS...");
            if (this.getPublishedScopeResource().load()) {
                this.logger.info((Object)"Instance state harvested from the IS");
                this.scopeState.initialize(this.scope, this.scope.getName(), GHNContext.getContext().isSecurityEnabled(), new String[0]);
                this.getPublishedScopeResource().to(this.scopeState);
            } else {
                this.logger.info((Object)"Empty instance state created");
                this.scopeState.initialize(this.scope, this.scope.getName(), GHNContext.getContext().isSecurityEnabled(), new String[0]);
                this.getPublishedScopeResource().loadFromLocalState(this.scopeState);
            }
            this.scopeState.getRawScopeState().data.put("NODES", new HashMap());
        }
        ScopedResourceFactory.setResourceList(this.scopeState);
        VirtualNodeManager.setNodes((Map)this.scopeState.getRawScopeState().data.get("NODES"));
        this.registerObservers();
        new Thread(){

            @Override
            public void run() {
                InstanceState.this.scopeState.notifyObservers();
            }
        }.start();
    }

    private void registerObservers() {
        this.scopeState.addObserver(new Executor());
        this.scopeState.addObserver(new Publisher());
        this.scopeState.addObserver(new Serializer());
    }

    public synchronized GCUBEScope getManagedScope() {
        return this.scope;
    }

    public Session getSession(String id) throws IOException {
        if (!id2session.containsKey(id)) {
            id2session.put(id, Session.load(id));
        }
        return id2session.get(id);
    }

    public String getSerializedSession(String id) throws IOException {
        return Session.loadAsString(id);
    }

    public void addSession(Session session) {
        this.getResourceList().setLastSession(session);
        id2session.put(session.getId(), session);
    }

    public PublishedScopeResource getPublishedScopeResource() throws NoSuchResourceException {
        try {
            return PublishedScopeResource.getResource(this.scope);
        }
        catch (Exception e) {
            this.logger.warn((Object)"Unable to get the PublishedScopeResource", (Throwable)e);
            throw new NoSuchResourceException();
        }
    }

    public ScopeState getResourceList() {
        return this.scopeState;
    }

    public void dispose() {
        HashSet<ScopedResource> allResources = new HashSet<ScopedResource>();
        for (ScopedResource resource : this.scopeState.getAllResources()) {
            allResources.add(resource);
        }
        this.scopeState.removeResources(allResources);
    }
}

