/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.resources.types;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResource;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResourceFactory;
import org.gcube.vremanagement.resourcemanager.impl.resources.types.MultiKeysMap;

public class MultiKeysMapTest
extends TestCase {
    private MultiKeysMap<String, String, ScopedResource> map = new MultiKeysMap();

    public MultiKeysMapTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testPut() throws Exception {
        System.out.println("Adding resources test");
        System.out.println("Map before the method");
        this.printMap();
        ScopedResource ghn = ScopedResourceFactory.newResource("ID1", "GHN", GCUBEScope.getScope((String)"/gcube"));
        this.map.put(ghn.getId(), ghn.getType(), ghn);
        Assert.assertEquals((int)1, (int)this.map.values().size());
        ScopedResource ghn2 = ScopedResourceFactory.newResource("ID2", "GHN", GCUBEScope.getScope((String)"/gcube"));
        this.map.put(ghn2.getId(), ghn2.getType(), ghn2);
        Assert.assertEquals((int)2, (int)this.map.values().size());
        ScopedResource ri = ScopedResourceFactory.newResource("RI1", "RunningInstance", GCUBEScope.getScope((String)"/gcube"));
        this.map.put(ri.getId(), ri.getType(), ri);
        Assert.assertEquals((int)3, (int)this.map.values().size());
        System.out.println("Map after the method");
        this.printMap();
    }

    public void testRemoveValuesByPrimaryKey() throws Exception {
        this.testPut();
        System.out.println("testRemoveValuesByPrimaryKey");
        this.map.removeValuesByPrimaryKey("ID2");
        System.out.println("Map after testRemoveValuesByPrimaryKey method");
        this.printMap();
    }

    public void testRemoveValue() throws Exception {
        ScopedResource ghn = ScopedResourceFactory.newResource("ID1", "GHN", GCUBEScope.getScope((String)"/gcube"));
        this.map.removeValue(ghn);
    }

    public void testRemoveValuesBySecondaryKey() throws Exception {
        ScopedResource ri = ScopedResourceFactory.newResource("RI1", "RunningInstance", GCUBEScope.getScope((String)"/gcube"));
        this.map.removeValuesBySecondaryKey(ri.getType());
    }

    public void testGetValuesByPrimaryKey() {
        MultiKeysMapTest.fail((String)"Not yet implemented");
    }

    public void testGetValuesBySecondaryKey() {
        MultiKeysMapTest.fail((String)"Not yet implemented");
    }

    public void testPrimaryKeySet() {
        MultiKeysMapTest.fail((String)"Not yet implemented");
    }

    public void testSecondaryKeySet() {
        MultiKeysMapTest.fail((String)"Not yet implemented");
    }

    public void testValues() {
        for (ScopedResource resource : this.map.values()) {
            System.out.println("Resource Value ID = " + resource.getId());
        }
    }

    public void testClean() {
        this.map.clean();
    }

    public void printMap() {
        System.out.println("Values by KEY1:");
        for (String key1 : this.map.primaryKeySet()) {
            for (ScopedResource resource : this.map.getValuesByPrimaryKey(key1)) {
                System.out.println(key1 + " ->" + resource.getId());
            }
        }
        System.out.println("Values by KEY2:");
        for (String key2 : this.map.secondaryKeySet()) {
            for (ScopedResource resource : this.map.getValuesBySecondaryKey(key2)) {
                System.out.println(key2 + " ->" + resource.getId());
            }
        }
        System.out.println("Values:");
        for (ScopedResource resource : this.map.values()) {
            System.out.println(resource.getId());
        }
    }
}

