/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.resources;

import java.io.Reader;
import java.io.StringReader;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.QueryParameter;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGHNQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.resources.GCUBEHostingNode;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.vremanagement.ghnmanager.stubs.GHNManagerPortType;
import org.gcube.common.vremanagement.ghnmanager.stubs.ScopeRIParams;
import org.gcube.common.vremanagement.ghnmanager.stubs.service.GHNManagerServiceAddressingLocator;
import org.gcube.vremanagement.resourcemanager.impl.contexts.ServiceContext;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResource;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResourceFactory;

public final class ScopedRunningInstance
extends ScopedResource {
    public static final String TYPE = "RunningInstance";
    private String hostingNodeName = "";
    private ServiceData sourceService = new ServiceData();
    private String hostedOnID = "";
    private List<String> scopes;
    private transient EndpointReferenceType ghnEpr;

    protected ScopedRunningInstance(String id, GCUBEScope scope, String ... hostedOn) {
        super(id, TYPE, scope);
        if (hostedOn != null && hostedOn.length > 0) {
            this.hostedOn = hostedOn[0];
        }
    }

    @Override
    protected void find() throws Exception {
        GCUBEGenericQuery query;
        ISClient client;
        try {
            client = (ISClient)GHNContext.getImplementation(ISClient.class);
            query = client.getQuery("GCUBEResourceQuery");
            query.addParameters(new QueryParameter[]{new QueryParameter("FILTER", "$result/ID/text()/string() eq \"" + this.id + "\""), new QueryParameter("RESULT", "$result")});
            List results = client.execute((ISQuery)query, ServiceContext.getContext().getScope());
            if (!(results != null && results.size() != 0 || (results = client.execute((ISQuery)query, ServiceContext.getContext().getScope().getEnclosingScope())) != null && results.size() != 0)) {
                throw new Exception("unable to find target RI " + this);
            }
            GCUBERunningInstance profile = (GCUBERunningInstance)GHNContext.getImplementation(GCUBERunningInstance.class);
            profile.load((Reader)new StringReader((String)((XMLResult)results.get(0)).evaluate("/").get(0)));
            this.sourceService = new ServiceData();
            this.sourceService.serviceID = profile.getServiceID();
            this.sourceService.serviceClass = profile.getServiceClass();
            this.sourceService.serviceName = profile.getServiceName();
            this.hostedOnID = profile.getGHNID();
            this.scopes = new ArrayList<String>();
            for (GCUBEScope scope : profile.getScopes().values()) {
                this.scopes.add(scope.getName());
            }
        }
        catch (Exception e) {
            throw new Exception("unable to find the target RI " + this, e);
        }
        try {
            client = (ISClient)GHNContext.getImplementation(ISClient.class);
            query = (GCUBEGHNQuery)client.getQuery(GCUBEGHNQuery.class);
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/ID/text()", this.hostedOnID)});
            List hostingNode = client.execute((ISQuery)query, ServiceContext.getContext().getScope());
            this.hostingNodeName = ((GCUBEHostingNode)hostingNode.get(0)).getNodeDescription().getName();
            this.ghnEpr = this.loadGHNmanager(((GCUBEHostingNode)hostingNode.get(0)).getID(), client);
            this.hostedOn = this.hostingNodeName;
        }
        catch (Exception e) {
            this.noHopeForMe("unable to find the hosting GHN (ID=" + this.hostedOnID + ")", (ScopedResource)this.new ScopedResource.ResourceNotFound(e));
        }
    }

    @Override
    protected void addToScope() throws ScopedResource.ResourceNotFound, Exception {
        if (this.hostingNodeName.compareToIgnoreCase("") == 0) {
            this.findResource();
        }
        try {
            GHNManagerServiceAddressingLocator locator = new GHNManagerServiceAddressingLocator();
            GHNManagerPortType pt = (GHNManagerPortType)GCUBERemotePortTypeContext.getProxy((Remote)locator.getGHNManagerPortTypePort(this.ghnEpr), (GCUBEScope)ServiceContext.getContext().getScope(), (GCUBESecurityManager[])new GCUBESecurityManager[]{ServiceContext.getContext()});
            ScopeRIParams params = new ScopeRIParams();
            params.setClazz(this.sourceService.serviceClass);
            params.setName(this.sourceService.serviceName);
            params.setScope(this.scope);
            pt.addRIToScope(params);
        }
        catch (Exception e) {
            this.setStatus(ScopedResource.STATUS.LOST);
            this.success = false;
            this.setErrorMessage("Failed to add RunningInstance to scope " + this.scope);
            this.getLogger().error((Object)("Failed to add RunningInstance to scope " + this.scope), (Throwable)e);
            throw new Exception("Failed to add RunningInstance to scope " + this.scope);
        }
    }

    @Override
    protected void removeFromScope() throws ScopedResource.ResourceNotFound, ScopedResourceFactory.ServiceNotFoundException, Exception {
        this.findResource();
        try {
            GHNManagerServiceAddressingLocator locator = new GHNManagerServiceAddressingLocator();
            GHNManagerPortType pt = (GHNManagerPortType)GCUBERemotePortTypeContext.getProxy((Remote)locator.getGHNManagerPortTypePort(this.ghnEpr), (GCUBEScope)ServiceContext.getContext().getScope(), (GCUBESecurityManager[])new GCUBESecurityManager[]{ServiceContext.getContext()});
            ScopeRIParams params = new ScopeRIParams();
            params.setClazz(this.sourceService.serviceClass);
            params.setName(this.sourceService.serviceName);
            params.setScope(this.scope);
            pt.removeRIFromScope(params);
        }
        catch (Exception e) {
            this.noHopeForMe("Failed to remove RunningInstance from scope " + this.scope.toString() + " " + e.getMessage(), e);
        }
    }

    protected String getSourceServiceClass() {
        return this.sourceService.serviceClass;
    }

    protected String getSourceServiceName() {
        return this.sourceService.serviceName;
    }

    public boolean isUndeployNeeded() throws ScopedResource.ResourceNotFound {
        try {
            this.findResource();
        }
        catch (ScopedResource.ResourceNotFound e) {
            this.noHopeForMe("Failed to remove RunningInstance from scope " + this.scope.toString() + ". Can't find the related service to undeploy " + e.getMessage(), e);
        }
        if (this.scopes.size() == 1) {
            this.getLogger().info((Object)(this + " joins only this scope: it's going to be undeployed"));
            return true;
        }
        return false;
    }

    public String getHostedOnID() {
        return this.hostedOnID;
    }

    public void reportFailureOnSourceService(String message, Exception e) {
        try {
            this.noHopeForMe(message, e);
        }
        catch (Exception e1) {
            this.getLogger().error((Object)(this + "An error has been reported from outside when managing the source service"), (Throwable)e1);
        }
    }

    public void wasSuccessful() {
        this.success = true;
    }

    @Override
    protected int getMaxFindAttempts() {
        return 40;
    }

    private EndpointReferenceType loadGHNmanager(String id, ISClient client) throws Exception {
        GCUBERIQuery riquery = (GCUBERIQuery)client.getQuery(GCUBERIQuery.class);
        riquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//GHN/@UniqueID", id), new AtomicCondition("//ServiceClass", "VREManagement"), new AtomicCondition("//ServiceName", "GHNManager")});
        List results = client.execute((ISQuery)riquery, ServiceContext.getContext().getScope());
        return ((GCUBERunningInstance)results.get(0)).getAccessPoint().getEndpoint("gcube/common/vremanagement/GHNManager");
    }

    class ServiceData {
        String serviceID;
        String serviceName;
        String serviceClass;

        ServiceData() {
        }
    }
}

