/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.resources;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedAnyResource;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedDeployedService;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedGHN;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResource;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedRunningInstance;
import org.gcube.vremanagement.resourcemanager.impl.state.ScopeState;

public class ScopedResourceFactory {
    protected static GCUBELog logger = new GCUBELog(ScopedResourceFactory.class);
    private static ScopeState scopeState = null;

    public static void setResourceList(ScopeState list) {
        scopeState = list;
    }

    public static ScopedResource newResource(String id, String type, GCUBEScope scope) throws Exception {
        if (scopeState != null && scopeState.containsResource(id)) {
            logger.trace((Object)("Taking resource " + id + " from the scope state"));
            scopeState.getResource(id).setScope(scope);
            return scopeState.getResource(id);
        }
        if (id == null || id.compareTo("") == 0) {
            throw new Exception("invalid resource id specified");
        }
        if (type == null || type.compareTo("") == 0) {
            throw new Exception("invalid resource type specified");
        }
        ScopedResource sresource = null;
        logger.trace((Object)("Creating a new resource " + id + ""));
        sresource = type.compareToIgnoreCase("GHN") == 0 ? new ScopedGHN(id, scope) : (type.compareToIgnoreCase("RunningInstance") == 0 ? new ScopedRunningInstance(id, scope, new String[0]) : (type.compareToIgnoreCase("Service") == 0 ? new ScopedDeployedService(id, scope) : new ScopedAnyResource(id, type, scope)));
        return sresource;
    }

    public static ScopedDeployedService getRelatedService(ScopedRunningInstance scopedRunningInstance) throws ServiceNotFoundException {
        for (ScopedResource resource : scopeState.getResourcesByType("Service")) {
            if (resource == null) continue;
            try {
                ScopedDeployedService service = (ScopedDeployedService)resource;
                if (service.getSourceService().getClazz().compareToIgnoreCase(scopedRunningInstance.getSourceServiceClass()) != 0 || service.getSourceService().getName().compareToIgnoreCase(scopedRunningInstance.getSourceServiceName()) != 0) continue;
                logger.debug((Object)("Source service found for RI " + scopedRunningInstance));
                return service;
            }
            catch (Exception e) {
                logger.warn((Object)("An error occurred when looking for the source service for RI " + scopedRunningInstance + ", error message: " + e.getMessage()));
            }
        }
        logger.error((Object)("Unable to find a source service for " + scopedRunningInstance));
        throw new ServiceNotFoundException();
    }

    public static class ServiceNotFoundException
    extends Exception {
        private static final long serialVersionUID = 3904279081090871340L;
    }
}

