/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.resources;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcemanager.impl.operators.Operator;

public abstract class ScopedResource {
    @XStreamOmitField
    protected GCUBELog logger;
    protected String id;
    protected String type;
    protected String hostedOn = "";
    protected boolean success;
    protected String errorMessage = "";
    protected String scope;
    protected Operator.ACTION action;
    protected Date lastModificationTime;
    protected Date jointTime;
    protected STATUS status;

    public ScopedResource(String id, String type, GCUBEScope scope) {
        this.id = id;
        this.type = type;
        this.scope = scope.toString();
        this.status = STATUS.CREATED;
    }

    protected abstract void find() throws Exception;

    public synchronized void findResource() throws ResourceNotFound {
        this.setErrorMessage("");
        int max_attempts = this.getMaxFindAttempts();
        int i = 0;
        while (true) {
            try {
                this.find();
                this.success = true;
            }
            catch (Exception e) {
                this.logger.warn((Object)("Can't find resource " + this + " on the IS"));
                if (i++ <= max_attempts) {
                    this.logger.warn((Object)"try again in 5 secs");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {}
                    continue;
                }
                this.noHopeForMe("Can't find resource " + this + " on the IS", new ResourceNotFound(e));
            }
            break;
        }
    }

    public synchronized void doAction(Operator.ACTION action) throws ResourceNotFound, Exception {
        this.action = action;
        switch (action) {
            case ADD: {
                this.addToScope();
                this.setJointTime(Calendar.getInstance().getTime());
                this.success = true;
                break;
            }
            case REMOVE: {
                this.removeFromScope();
                this.success = true;
                break;
            }
        }
        this.setChanged();
    }

    protected abstract void addToScope() throws ResourceNotFound, Exception;

    protected abstract void removeFromScope() throws ResourceNotFound, Exception;

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public final GCUBEScope getScope() {
        return GCUBEScope.getScope((String)this.scope);
    }

    protected final void setScope(GCUBEScope scope) {
        this.scope = scope.toString();
    }

    public Operator.ACTION getAction() {
        return this.action;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.success = false;
        this.errorMessage = errorMessage;
    }

    public void setJointTime(Date time) {
        this.jointTime = time;
    }

    private void setChanged() {
        this.setLastModificationTime(Calendar.getInstance().getTime());
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getHostedOn() {
        return this.hostedOn;
    }

    public void setHostedON(String hostedOn) {
        this.hostedOn = hostedOn;
    }

    public Date getJointTime() {
        if (this.jointTime == null) {
            this.jointTime = Calendar.getInstance().getTime();
        }
        return this.jointTime;
    }

    public Date getLastModificationTime() {
        if (this.lastModificationTime == null) {
            this.setChanged();
        }
        return this.lastModificationTime;
    }

    private void setLastModificationTime(Date lastModificationTime) {
        this.lastModificationTime = lastModificationTime;
    }

    public STATUS getStatus() {
        return this.status;
    }

    public synchronized void setStatus(STATUS status) {
        this.getLogger().trace((Object)(this.toString() + ": status set to " + (Object)((Object)status)));
        this.status = status;
    }

    protected int getMaxFindAttempts() {
        return 5;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScopedResource other = (ScopedResource)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    protected <E extends Exception> void noHopeForMe(String message, E e) throws E {
        this.getLogger().error((Object)(this.toString() + ": Unable to manage the resource " + message), e);
        this.setStatus(STATUS.LOST);
        this.success = false;
        this.setErrorMessage(message);
        throw e;
    }

    public String toString() {
        return "Resource [id=" + this.id + ", type=" + this.type + ", timestamp=" + this.lastModificationTime + ", scope=" + this.scope + ", status=" + (Object)((Object)this.status) + " hostedOn=" + this.hostedOn + "]";
    }

    protected GCUBELog getLogger() {
        if (this.logger == null) {
            this.logger = new GCUBELog((Object)this);
        }
        return this.logger;
    }

    public class ResourceNotFound
    extends Exception {
        private static final long serialVersionUID = -6111206113583291172L;

        public ResourceNotFound(String message) {
            super(message);
        }

        public ResourceNotFound(Exception e) {
            super(e);
        }
    }

    public static enum STATUS {
        CREATED{

            @Override
            public List<STATUS> previous() {
                return Collections.emptyList();
            }
        }
        ,
        ADDREQUESTED{

            @Override
            public List<STATUS> previous() {
                return Collections.unmodifiableList(Arrays.asList(CREATED));
            }
        }
        ,
        ADDED{

            @Override
            public List<STATUS> previous() {
                return Collections.unmodifiableList(Arrays.asList(ADDREQUESTED));
            }
        }
        ,
        PUBLISHED{

            @Override
            public List<STATUS> previous() {
                return Collections.unmodifiableList(Arrays.asList(ADDED));
            }
        }
        ,
        REMOVEREQUESTED{

            @Override
            public List<STATUS> previous() {
                return Collections.unmodifiableList(Arrays.asList(ADDED, PUBLISHED));
            }
        }
        ,
        REMOVED{

            @Override
            public List<STATUS> previous() {
                return Collections.unmodifiableList(Arrays.asList(REMOVEREQUESTED));
            }
        }
        ,
        UNPUBLISHED{

            @Override
            public List<STATUS> previous() {
                return Collections.unmodifiableList(Arrays.asList(REMOVED));
            }
        }
        ,
        LOST{

            @Override
            public List<STATUS> previous() {
                return Collections.unmodifiableList(Arrays.asList(REMOVED, REMOVEREQUESTED, ADDED, PUBLISHED, CREATED, UNPUBLISHED));
            }
        };


        public abstract List<STATUS> previous();
    }
}

