/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.resources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.vremanagement.deployer.stubs.common.PackageInfo;
import org.gcube.vremanagement.resourcemanager.impl.deployment.SoftwareGatewayRequest;
import org.gcube.vremanagement.resourcemanager.impl.deployment.VirtualNode;
import org.gcube.vremanagement.resourcemanager.impl.deployment.resources.Dependency;
import org.gcube.vremanagement.resourcemanager.impl.deployment.resources.Service;
import org.gcube.vremanagement.resourcemanager.impl.operators.Operator;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResource;

public final class ScopedDeployedService
extends ScopedResource {
    public static final String TYPE = "Service";
    protected static final String REPOSITORY_ENDPOINT = "gcube/vremanagement/softwarerepository/SoftwareRepository";
    protected static final String REPOSITORY_NAME = "SoftwareRepository";
    protected static final String REPOSITORY_CLASS = "VREManagement";
    protected static final int TIMEOUT = 600000;
    private List<Dependency> resolved = new ArrayList<Dependency>();
    private List<Dependency> missing = new ArrayList<Dependency>();
    private Map<String, List<Dependency>> node2packages = new HashMap<String, List<Dependency>>();
    private Map<String, List<Dependency>> node2missing = new HashMap<String, List<Dependency>>();
    private Service service;
    private String lastActivityOnGHN;
    private List<VirtualNode> virtualNodes = new ArrayList<VirtualNode>();
    private Map<String, String> node2scope = new HashMap<String, String>();
    private Map<String, String> ri2ghn = new HashMap<String, String>();

    protected ScopedDeployedService(String id, GCUBEScope scope) {
        super(id, TYPE, scope);
    }

    public void setSourceServiceName(Service service) {
        this.service = service;
    }

    public Service getSourceService() {
        return this.service;
    }

    public List<Dependency> getResolvedDependencies(String ghnid) {
        if (this.node2packages.get(ghnid) == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.node2packages.get(ghnid));
    }

    public List<Dependency> getLastResolvedDependencies() {
        return this.resolved;
    }

    public void setResolvedDependencies(List<Dependency> dependencies) {
        this.resolved = dependencies;
    }

    public List<Dependency> getMissingDependencies(String ghnid) {
        if (this.node2missing.get(ghnid) == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.node2missing.get(ghnid));
    }

    public List<Dependency> getLastMissingDependencies() {
        return this.missing;
    }

    public void setMissingDependencies(List<Dependency> dependencies) {
        this.missing = dependencies;
    }

    @Override
    protected void find() throws Exception {
        SoftwareGatewayRequest request = new SoftwareGatewayRequest();
        request.addService(this);
        this.setErrorMessage("");
        try {
            request.send();
            if (this.resolved.size() == 0) {
                this.success = false;
                this.setErrorMessage("Invalid list of dependecies retrieved from the Software Repository");
            } else if (this.missing.size() > 0) {
                this.success = false;
                this.setErrorMessage("The service cannot be deployed due to one or more missing dependencies: " + this.missing);
            } else {
                this.success = true;
            }
        }
        catch (Exception e) {
            this.success = false;
            this.setErrorMessage("Unable to resolve the list of dependencies for this service " + e.getMessage());
            this.getLogger().error((Object)("Unable to resolve the list of deps for " + this.service), (Throwable)e);
            throw new Exception("Unable to resolve the list of dependencies for " + this.service, e);
        }
    }

    @Override
    protected void addToScope() throws ScopedResource.ResourceNotFound, Exception {
        this.logger.trace((Object)("This service belongs to " + this.scope));
        if (!this.isSuccess()) {
            this.noHopeForMe(this.getErrorMessage(), new Exception());
        }
        if (this.lastActivityOnGHN == null || this.lastActivityOnGHN.compareTo("") == 0) {
            this.noHopeForMe("Unable to find a suitable target gHN where to deploy the service", new Exception());
        }
        this.action = Operator.ACTION.ADD;
        this.setErrorMessage("");
        Exception lastException = null;
        ArrayList<VirtualNode> nodesToRemove = new ArrayList<VirtualNode>();
        for (VirtualNode node : this.virtualNodes) {
            try {
                node.deploy(this.getScope());
                ArrayList<Dependency> resolvedPackages = new ArrayList<Dependency>();
                for (Dependency dep : this.resolved) {
                    resolvedPackages.add(dep);
                }
                this.node2packages.put(node.getID(), resolvedPackages);
                ArrayList<Dependency> missingPackages = new ArrayList<Dependency>();
                for (Dependency dep : this.missing) {
                    missingPackages.add(dep);
                }
                if (this.node2missing == null) {
                    this.logger.trace((Object)"node2missing is null");
                    this.node2missing = new HashMap<String, List<Dependency>>();
                }
                this.node2missing.put(node.getID(), missingPackages);
            }
            catch (Exception e) {
                nodesToRemove.add(node);
                this.logger.error((Object)("Failed to deploy on " + node.getID()), (Throwable)e);
                this.logger.info((Object)("Virtual Node " + node.toString() + " will be removed from the queue"));
                lastException = e;
            }
        }
        this.missing.clear();
        this.resolved.clear();
        if (nodesToRemove.size() > 0) {
            this.virtualNodes.removeAll(nodesToRemove);
            this.noHopeForMe("Unable to contact the target gHN (" + this.lastActivityOnGHN + ") where to deploy the service", lastException);
        }
    }

    @Override
    protected void removeFromScope() throws ScopedResource.ResourceNotFound, Exception {
        this.logger.trace((Object)("This service belongs to " + this.scope));
        if (!this.isSuccess()) {
            this.noHopeForMe(this.getErrorMessage(), new Exception());
        }
        if (this.lastActivityOnGHN == null || this.lastActivityOnGHN.compareTo("") == 0) {
            this.noHopeForMe("Unable to find a valid target gHN where to undeploy the service", new Exception());
        }
        this.setErrorMessage("");
        this.action = Operator.ACTION.REMOVE;
        try {
            for (VirtualNode node : this.virtualNodes) {
                try {
                    if (this.node2scope.containsKey(node.getID())) {
                        node.undeploy(GCUBEScope.getScope((String)this.node2scope.get(node.getID())));
                        continue;
                    }
                    node.undeploy(this.getScope());
                }
                catch (Exception e) {
                    this.noHopeForMe("Failed to undeploy from " + node, e);
                }
            }
            this.virtualNodes.clear();
        }
        catch (Exception e) {
            this.noHopeForMe("Unable to contact the target gHN (" + this.lastActivityOnGHN + ") where to undeploy the service, deployer says" + e.getMessage(), e);
        }
    }

    public void scheduleUndeploy() {
        for (VirtualNode node : this.virtualNodes) {
            this.scheduleUndeploy(node);
        }
    }

    public void scheduleUndeploy(VirtualNode node) {
        List<Dependency> deps;
        this.getLogger().info((Object)("Scheduling undeployment of service " + this.service + " from GHN " + this.lastActivityOnGHN));
        this.checkNode2Scope();
        if (this.node2scope.containsKey(node.getID())) {
            node.setWorkingScope(GCUBEScope.getScope((String)this.node2scope.get(node.getID())));
        }
        if ((deps = this.node2packages.get(node.getID())) == null) {
            return;
        }
        HashSet<PackageInfo> packages = new HashSet<PackageInfo>();
        for (int i = 0; i < deps.size(); ++i) {
            PackageInfo p = new PackageInfo();
            p.setServiceName(deps.get(i).getService().getName());
            p.setServiceClass(deps.get(i).getService().getClazz());
            p.setServiceVersion(deps.get(i).getService().getVersion());
            p.setVersion(deps.get(i).getVersion());
            p.setName(deps.get(i).getName());
            this.getLogger().trace((Object)("Adding Package to undeployment request: " + deps.get(i)));
            packages.add(p);
        }
        node.setPackagesToRemove(packages);
        this.lastActivityOnGHN = node.getID();
    }

    public void removeFromScope(String ghnID) throws VirtualNode.NoGHNFoundException, Exception {
        this.logger.trace((Object)("This service belongs to " + this.scope));
        this.action = Operator.ACTION.REMOVE;
        for (VirtualNode node : this.virtualNodes) {
            if (node.getID().compareToIgnoreCase(ghnID) != 0) continue;
            this.checkNode2Scope();
            if (this.node2scope.containsKey(ghnID)) {
                node.undeploy(GCUBEScope.getScope((String)this.node2scope.get(ghnID)));
            } else {
                node.undeploy(this.getScope());
            }
            this.virtualNodes.remove(node);
            return;
        }
        this.noHopeForMe("Unable to find the gHN with id " + this.lastActivityOnGHN + " to undeploy the instance of the " + this.service, new VirtualNode.NoGHNFoundException(""));
    }

    public void setTargetGHN(VirtualNode node) {
        this.getLogger().info((Object)("Using GHN " + node.getID() + " for " + this));
        HashSet<PackageInfo> packages = new HashSet<PackageInfo>();
        List<Dependency> deps = this.resolved;
        for (int i = 0; i < deps.size(); ++i) {
            PackageInfo p = new PackageInfo();
            p.setServiceName(deps.get(i).getService().getName());
            p.setServiceClass(deps.get(i).getService().getClazz());
            p.setServiceVersion(deps.get(i).getService().getVersion());
            p.setVersion(deps.get(i).getVersion());
            p.setName(deps.get(i).getName());
            this.getLogger().trace((Object)("Adding Package to deployment request: " + deps.get(i)));
            packages.add(p);
        }
        node.setPackagesToAdd(packages);
        this.checkNode2Scope();
        this.node2scope.put(node.getID(), node.getWorkingScope().toString());
        this.virtualNodes.add(node);
        this.lastActivityOnGHN = node.getID();
    }

    public String getTargetGHNID() {
        return this.lastActivityOnGHN;
    }

    public String getTargetGHN() {
        return this.virtualNodes.size() > 0 ? this.virtualNodes.get(0).getID() : "";
    }

    public void setRIonGHN(String ri, String ghn) {
        this.ri2ghn.put(ri, ghn);
    }

    public void setCallbackID(String id) {
        for (VirtualNode node : this.virtualNodes) {
            node.setCallbackID(id);
        }
    }

    public List<VirtualNode> getNodes() {
        return this.virtualNodes;
    }

    @Override
    protected int getMaxFindAttempts() {
        return 3;
    }

    private void checkNode2Scope() {
        if (this.node2scope == null) {
            this.node2scope = new HashMap<String, String>();
        }
    }
}

