/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.operators;

import java.util.HashSet;
import org.gcube.vremanagement.resourcemanager.impl.operators.Operator;
import org.gcube.vremanagement.resourcemanager.impl.operators.OperatorConfig;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResource;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResourceFactory;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.ResourceItem;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.ResourceList;

public class ScopedResourceManagerOperator
extends Operator {
    private ResourceList resources;

    public ScopedResourceManagerOperator(OperatorConfig configuration, ResourceList resources, Operator.ACTION action) {
        this.configuration = configuration;
        this.resources = resources;
        this.action = action;
    }

    @Override
    public void exec() throws Exception {
        HashSet<ScopedResource> toadd = new HashSet<ScopedResource>();
        HashSet<ScopedResource> toremove = new HashSet<ScopedResource>();
        ScopedResource sresource = null;
        for (ResourceItem resource : this.resources.getResource()) {
            try {
                sresource = ScopedResourceFactory.newResource(resource.getID(), resource.getType(), this.configuration.scope);
                if (this.action == Operator.ACTION.ADD) {
                    this.logger.info((Object)("Adding resource " + sresource.getId() + " (" + sresource.getType() + ") to scope " + this.configuration.scope.toString()));
                    toadd.add(sresource);
                } else if (this.action == Operator.ACTION.REMOVE) {
                    this.logger.info((Object)("Removing resource " + sresource.getId() + " (" + sresource.getType() + ") from scope " + this.configuration.scope.toString()));
                    toremove.add(sresource);
                }
                this.configuration.session.addResource(sresource);
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to manage the resource", (Throwable)e);
            }
        }
        if (toadd.size() > 0) {
            this.configuration.scopeState.addResources(toadd);
        }
        if (toremove.size() > 0) {
            this.configuration.scopeState.removeResources(toremove);
        }
        this.configuration.session.save();
    }
}

